/*
 *   (C) Copyright IBM Corp. 2004
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: LVM2 Plugin
 * File: evms2/engine/plugins/lvm2/options.h
 */

/**
 * Container-creation options and routines.
 **/

#define LVM2_OPTION_CREATE_CONTAINER_NAME_IDX		0
#define LVM2_OPTION_CREATE_CONTAINER_NAME_STR		"name"
#define LVM2_OPTION_CREATE_CONTAINER_EXTENT_SIZE_IDX	1
#define LVM2_OPTION_CREATE_CONTAINER_EXTENT_SIZE_STR	"extent_size"
#define LVM2_OPTION_CREATE_CONTAINER_COUNT		2

#define LVM2_DEFAULT_EXTENT_SIZE			(32 * 1024 * 2)	// 32MB
#define LVM2_MIN_EXTENT_SIZE				(8 * 2)		// 8kB

extern int create_container_init_task(task_context_t *context);
extern int create_container_set_objects(task_context_t *context,
					task_effect_t *effect);
extern int create_container_set_option(task_context_t *context, u_int32_t index,
				       value_t *value, task_effect_t *effect);
extern void create_container_parse_options(option_array_t *options,
					   u_int64_t *extent_size,
					   char **vg_name);
extern int create_container_validate_options(u_int64_t *extent_size,
					     char *vg_name,
					     list_anchor_t objects);

/**
 * Container-expansion routines.
 **/

extern int expand_container_init_task(task_context_t *context);
extern int expand_container_set_objects(task_context_t *context,
					task_effect_t *effect);

/**
 * Container-shrink routines.
 **/

extern int shrink_container_init_task(task_context_t *context);
extern int shrink_container_set_objects(task_context_t *context,
					task_effect_t *effect);

/**
 * Region-creation options and routines.
 **/

#define LVM2_OPTION_CREATE_REGION_NAME_IDX		0
#define LVM2_OPTION_CREATE_REGION_NAME_STR		"name"
#define LVM2_OPTION_CREATE_REGION_SIZE_IDX		1
#define LVM2_OPTION_CREATE_REGION_SIZE_STR		"size"
#define LVM2_OPTION_CREATE_REGION_STRIPES_IDX		2
#define LVM2_OPTION_CREATE_REGION_STRIPES_STR		"stripes"
#define LVM2_OPTION_CREATE_REGION_STRIPE_SIZE_IDX	3
#define LVM2_OPTION_CREATE_REGION_STRIPE_SIZE_STR	"stripe_size"
#define LVM2_OPTION_CREATE_REGION_PVS_IDX		4
#define LVM2_OPTION_CREATE_REGION_PVS_STR		"pvs"
#define LVM2_OPTION_CREATE_REGION_COUNT			5

#define LVM2_DEFAULT_STRIPES				1
#define LVM2_MIN_STRIPE_SIZE				(8 * 2)		// 8kB
#define LVM2_MAX_STRIPE_SIZE				(1 * 1024 * 2)	// 1MB
#define LVM2_DEFAULT_STRIPE_SIZE			(64 * 2)	// 64kB

extern int create_region_init_task(task_context_t *context);
extern int create_region_set_objects(task_context_t *context,
				     task_effect_t *effect);
extern int create_region_set_option(task_context_t *context, u_int32_t index,
				    value_t *value, task_effect_t *effect);
extern void create_region_parse_options(storage_container_t *container,
					option_array_t *options, char **lv_name,
					u_int64_t *size, u_int64_t *stripes,
					u_int64_t *stripe_size,
					list_anchor_t *objects);
extern int create_region_validate_options(storage_container_t *container,
					  char *lv_name, u_int64_t *size,
					  u_int64_t *stripes,
					  u_int64_t *stripe_size,
					  list_anchor_t objects);

/**
 * Region-expansion options and routines.
 **/

#define LVM2_OPTION_EXPAND_REGION_SIZE_IDX		0
#define LVM2_OPTION_EXPAND_REGION_SIZE_STR		"size"
#define LVM2_OPTION_EXPAND_REGION_STRIPES_IDX		1
#define LVM2_OPTION_EXPAND_REGION_STRIPES_STR		"stripes"
#define LVM2_OPTION_EXPAND_REGION_STRIPE_SIZE_IDX	2
#define LVM2_OPTION_EXPAND_REGION_STRIPE_SIZE_STR	"stripe_size"
#define LVM2_OPTION_EXPAND_REGION_PVS_IDX		3
#define LVM2_OPTION_EXPAND_REGION_PVS_STR		"pvs"
#define LVM2_OPTION_EXPAND_REGION_COUNT			4

extern int expand_region_init_task(task_context_t *context);
extern int expand_region_set_option(task_context_t *context, u_int32_t index,
				    value_t *value, task_effect_t *effect);
extern void expand_region_parse_options(storage_object_t *region,
					option_array_t *options,
					u_int64_t *size, u_int64_t *stripes,
					u_int64_t *stripe_size,
					list_anchor_t *objects);
extern int expand_region_validate_options(storage_object_t *region,
					  u_int64_t *size, u_int64_t *stripes,
					  u_int64_t *stripe_size,
					  list_anchor_t objects);

/**
 * Region-shrink options and routines.
 **/

#define LVM2_OPTION_SHRINK_REGION_SIZE_IDX		0
#define LVM2_OPTION_SHRINK_REGION_SIZE_STR		"size"
#define LVM2_OPTION_SHRINK_REGION_COUNT			1

extern int shrink_region_init_task(task_context_t *context);
extern int shrink_region_set_option(task_context_t *context, u_int32_t index,
				    value_t *value, task_effect_t *effect);
extern void shrink_region_parse_options(storage_object_t *region,
					option_array_t *options,
					u_int64_t *size);
extern int shrink_region_validate_options(storage_object_t *region,
					  u_int64_t *size);

/**
 * Region-rename options and routines.
 **/

#define LVM2_OPTION_SET_REGION_INFO_NAME_IDX		0
#define LVM2_OPTION_SET_REGION_INFO_NAME_STR		"name"
#define LVM2_OPTION_SET_REGION_INFO_COUNT		1

extern int set_region_info_init_task(task_context_t *context);
extern int set_region_info_set_option(task_context_t *context, u_int32_t index,
				      value_t *value, task_effect_t *effect);
extern void set_region_info_parse_options(storage_object_t *region,
					  option_array_t *options,
					  char **lv_name);
extern int set_region_info_validate_options(storage_object_t *region,
					    char *lv_name);

/**
 * Container-rename options and routines.
 **/

#define LVM2_OPTION_SET_CONTAINER_INFO_NAME_IDX		0
#define LVM2_OPTION_SET_CONTAINER_INFO_NAME_STR		"name"
#define LVM2_OPTION_SET_CONTAINER_INFO_COUNT		1

extern int set_container_info_init_task(task_context_t *context);
extern int set_container_info_set_option(task_context_t *context, u_int32_t index,
					 value_t *value, task_effect_t *effect);
extern void set_container_info_parse_options(storage_container_t *container,
					     option_array_t *options,
					     char **vg_name);
extern int set_container_info_validate_options(storage_container_t *container,
					       char *vg_name);

/**
 * LVM2 plugin-function definitions.
 **/
#define LVM2_FUNCTION_SPLIT_MAPPING	(EVMS_Task_Plugin_Function + 0)
#define LVM2_FUNCTION_MERGE_MAPPINGS	(EVMS_Task_Plugin_Function + 1)
#define LVM2_FUNCTION_MOVE_MAPPING	(EVMS_Task_Plugin_Function + 2)
#define LVM2_FUNCTION_MOVE_PV		(EVMS_Task_Plugin_Function + 3)

#define LVM2_REGION_FUNCTION_COUNT	3
#define LVM2_CONTAINER_FUNCTION_COUNT	1

/**
 * Split-region-mapping options and routines.
 **/

#define LVM2_OPTION_SPLIT_MAPPING_MAP_IDX	0
#define LVM2_OPTION_SPLIT_MAPPING_MAP_STR	"mapping"
#define LVM2_OPTION_SPLIT_MAPPING_EXTENT_IDX	1
#define LVM2_OPTION_SPLIT_MAPPING_EXTENT_STR	"extent"
#define LVM2_OPTION_SPLIT_MAPPING_COUNT		2

extern int split_region_mapping_init_task(task_context_t *context);
extern int split_region_mapping_set_option(task_context_t *context,
					   u_int32_t index, value_t *value,
					   task_effect_t *effect);
extern void split_mapping_parse_options(option_array_t *options,
					u_int32_t *r_map_index,
					u_int64_t *extent_index);
extern int split_mapping_validate_options(storage_object_t *region,
					  u_int32_t r_map_index,
					  u_int64_t *extent_index,
					  region_mapping_t **map_to_split);

/**
 * Merge-region-mappings routines.
 **/

extern int merge_region_mappings_init_task(task_context_t *context);

/**
 * Move-region-mapping routines.
 **/

#define LVM2_OPTION_MOVE_MAPPING_MAP_IDX	0
#define LVM2_OPTION_MOVE_MAPPING_MAP_STR	"mapping"
#define LVM2_OPTION_MOVE_MAPPING_STRIPE_IDX	1
#define LVM2_OPTION_MOVE_MAPPING_STRIPE_STR	"stripe"
#define LVM2_OPTION_MOVE_MAPPING_OBJECT_IDX	2
#define LVM2_OPTION_MOVE_MAPPING_OBJECT_STR	"object"
#define LVM2_OPTION_MOVE_MAPPING_EXTENT_IDX	3
#define LVM2_OPTION_MOVE_MAPPING_EXTENT_STR	"extent"
#define LVM2_OPTION_MOVE_MAPPING_COUNT		4

extern int move_region_mapping_init_task(task_context_t *context);
extern int move_region_mapping_set_option(task_context_t *context,
					  u_int32_t index, value_t *value,
					  task_effect_t *effect);
extern void move_mapping_parse_options(option_array_t *options,
				       u_int32_t *r_map_index,
				       u_int64_t *stripe_index,
				       char **object_name,
				       u_int64_t *extent_index);
extern int move_mapping_validate_options(storage_object_t *region,
					 u_int32_t r_map_index,
					 u_int64_t stripe_index,
					 char *object_name,
					 u_int64_t extent_index,
					 region_mapping_t **r_map,
					 storage_object_t **object);

