/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-cfg-global-types.h,v 1.11 2005/02/01 02:31:58 hoa Exp $
 */

#ifndef ETPAN_CFG_GLOBAL_TYPES_H

#define ETPAN_CFG_GLOBAL_TYPES_H

#include <paths.h>

#define ETPAN_DEFAULT_POLL_DELAY 300
#define ETPAN_DEFAULT_NETWORK_TIMEOUT 60
#define ETPAN_DEFAULT_REPLY_QUOTE_LIMIT -1

#define ETPAN_DEFAULT_DISPLAY_CHARSET "iso-8859-1"
#define ETPAN_DEFAULT_EDITOR_CHARSET "iso-8859-1"
#define ETPAN_DEFAULT_MESSAGE_CHARSET "iso-8859-1"
#define ETPAN_DEFAULT_EDITOR "vi"

#ifndef _PATH_SENDMAIL
/* default for Linux */
#define ETPAN_DEFAULT_SENDMAIL_PATH "/usr/sbin/sendmail"
#else
#define ETPAN_DEFAULT_SENDMAIL_PATH _PATH_SENDMAIL
#endif

enum {
  ETPAN_THREAD_TYPE_NONE,
  ETPAN_THREAD_TYPE_BY_REFERENCES,
  ETPAN_THREAD_TYPE_BY_REFERENCES_NO_SUBJECT,
};

enum {
  ETPAN_UI_STYLE_BASIC,
  ETPAN_UI_STYLE_3PANED,
};

struct etpan_global_config {
  int ui_style;
  int ui_3paned_folderlist_width;
  int ui_3paned_msglist_height;
  char * display_charset;
  char * editor_charset;
  char * message_charset;
  char * editor;
  int reply_quote_limit;
  int poll_delay;
  int network_timeout;
  char * sendmail_path;
  int thread_type;
  int across_folder;
};

#endif
