! @(#)modifyopto.prg	19.1 (ES0-DMD) 02/25/03 14:27:39
!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!.IDENTIFICATION: modifyholes.prg
!.PURPOSE:        Enable the rejection of objects falling out of the plate 
!                 area or in a wrong place (for any reason).
!.USE:            @s modifyholes [table]
!.AUTHOR:         Alessandra Gemmo, Department of Astronomy, Padova
!.VERSION: 910527 A. Gemmo     Creation
!.VERSION: 92???? AG Modification ???
!.VERSION: 920809 RHW MOdification for 0 hours area and with suggestion 
!.                    from Roland den Hartog, Leiden Observatory
!------------------------------------------------------------------------------
DEFINE/PARAM P1 opto1.tbl T "Enter table [Default=opto1.tbl]: "
DEFINE/LOCAL INDX/I/1/1 0
DEFINE/LOCAL IND1/I/1/1 0
DEFINE/LOCAL CHARKW/C/1/80 " "
DEFINE/LOCAL INPUTF1/C/1/80 "temp.tbl"
DEFINE/LOCAL CIRTAB/C/1/80 "circle.tbl"
!
COMPUTE/KEYW INDX = M$INDEX(P1,".tbl")
IF INDX .EQ. 0 THEN
 WRITE/KEYW INPUTFI 'P1'.tbl
ELSE
 WRITE/KEYW INPUTFI 'P1'
ENDIF
!
! do some checks
!
WRITE/KEYW CHARKW/C/1/7 "TABEQUI"
COMPUTE/KEYW IND1 = M$EXISTD(INPUTFI,CHARKW)
IF IND1 .EQ. 0 THEN
 WRITE/OUT "*** FATAL: Wrong input table! You must use the one with RA & DEC! "
 RETURN
ENDIF
!
! initialize plot limits
!
WRITE/KEYW RALIM/R/1/2 0.,0.
WRITE/KEYW DECLIM/R/1/2 0.,0.
WRITE/KEYW RMAX/R/1/4 0.,0.,0.,0.
WRITE/KEYW RMAX1/R/1/4 0.,0.,0.,0.
WRITE/KEYW RMAX2/R/1/2 0.,0.
WRITE/KEYW PIPPO/R/1/3 0.,0.,0.
WRITE/KEYW PLUTO/R/1/1 0.
WRITE/KEYW CIRDIM1/R/1/2 0.,0. 
WRITE/KEYW P10/R/1/1 0.
WRITE/KEYW COSDEC/R/1/1 1.
DEFINE/LOCAL STEP/R/1/1 1.
WRITE/KEYW SYMPOSX/R/1/5 0.,0.,0.,0.,0.
WRITE/KEYW SYMPOSY/R/1/5 0.,0.,0.,0.,0.
WRITE/KEYW LABPOSX/R/1/5 0.,0.,0.,0.,0.
WRITE/KEYW LABPOSY/R/1/5 0.,0.,0.,0.,0.
WRITE/KEYW CURSFLAG/I/1/1 0
!
COMPUTE/TABLE 'INPUTFI' :RA = :RA-INT((:RA-{PLATEC1(1)})/24.0)*24.0
STATISTICS/TABLE 'INPUTFI' :RA
WRITE/KEYW RMAX/R/1/2 'OUTPUTR(1)','OUTPUTR(2)'
!
STATISTICS/TABLE 'INPUTFI' :DEC
WRITE/KEYW RMAX/R/3/2 'OUTPUTR(1)','OUTPUTR(2)'
!
COMPUTE/KEYW RMAX1(1) = RMAX(2)- PLATEC1(1)
COMPUTE/KEYW RMAX1(2) = PLATEC1(1) - RMAX(1)
COMPUTE/KEYW RMAX1(3) = RMAX(4)- PLATEC1(2)
COMPUTE/KEYW RMAX1(4) = PLATEC1(2) - RMAX(3)
!
IF 'RMAX1(1)' .GE. 'RMAX1(2)' COMPUTE/KEYW PIPPO(1) = RMAX1(1)*15.  
IF 'RMAX1(1)' .LT. 'RMAX1(2)' COMPUTE/KEYW PIPPO(1) = RMAX1(2)*15.
IF 'RMAX1(3)' .GE. 'RMAX1(4)' COMPUTE/KEYW PIPPO(2) = RMAX1(3)
IF 'RMAX1(3)' .LT. 'RMAX1(4)' COMPUTE/KEYW PIPPO(2) = RMAX1(4)
!
IF 'PIPPO(1)' .GE. 'PIPPO(2)' COMPUTE/KEYW PIPPO(3) = PIPPO(1) 
IF 'PIPPO(1)' .LT. 'PIPPO(2)' COMPUTE/KEYW PIPPO(3) = PIPPO(2)
!
COMPUTE/KEYW P10 = (PIPPO(3)/100.)*10.
!
! compare with circle size
!
COMPUTE/KEYW CIRDIM1(1) = (CIRDIM(1) - PLATEC1(1))*15.
COMPUTE/KEYW CIRDIM1(2) = CIRDIM(2) - PLATEC1(2)
!
IF 'CIRDIM1(1)' .GE. 'CIRDIM1(2)' COMPUTE/KEYW PLUTO(1) = CIRDIM1(1)
IF 'CIRDIM1(1)' .LT. 'CIRDIM1(2)' COMPUTE/KEYW PLUTO(1) = CIRDIM1(2)
!
IF 'PLUTO(1)' .GE. 'PIPPO(3)' COMPUTE/KEYW PIPPO(3) = PLUTO(1)
!
! corrections to get circle indeed circular
!
COMPUTE/KEYW COSDEC(1) = M$COS(PLATEC1(2))
COMPUTE/KEYW STEP(1) = (PIPPO(3) + P10(1))/15.
COMPUTE/KEYW RALIM(1) = PLATEC1(1) + STEP(1)
COMPUTE/KEYW RALIM(2) = PLATEC1(1) - STEP(1)
COMPUTE/KEYW COSDEC(1) = M$COS(PLATEC1(2))
COMPUTE/KEYW STEP(1) = (PIPPO(3) + P10(1))*COSDEC(1)
COMPUTE/KEYW DECLIM(1) = PLATEC1(2) - STEP(1)
COMPUTE/KEYW DECLIM(2) = PLATEC1(2) + STEP(1)
!
! plot the table
!
SET/GRAP PMODE=1 FRAME=SQUARE XFORM=hums YFORM=aums
SET/GRAP XAXIS='RALIM(1)','RALIM(2)',0.0166666
SET/GRAPH  YAXIS='DECLIM(1)','DECLIM(2)',0.166666
PLOT/AXES ? ? ? "Right Ascension" "Declination" 20,20
SELECT/TABLE 'INPUTFI' ALL
SELECT/TABLE 'INPUTFI' :CHECK.NE."d"
SELECT/TABLE 'INPUTFI' SELECT.AND.:CHECK.NE."D"
COPY/TABLE 'INPUTFI' 'INPUTF1'
DELETE/TABLE 'INPUTFI' NO
RENAME/TABLE 'INPUTF1' 'INPUTFI'
!
SET/GRAP PMODE=0 SSIZE=0.5 STYPE=7
SELECT/TABLE 'INPUTFI' :TYPE.EQ."O".OR.:TYPE.EQ."o"
OVERPLOT/TABLE 'INPUTFI' :RA :DEC
SELECT/TABLE 'INPUTFI' ALL
!
SET/GRAP SSIZE=1 STYPE=2
SELECT/TABLE 'INPUTFI' :TYPE.EQ."S"
OVERPLOT/TABLE 'INPUTFI' :RA :DEC
SELECT/TABLE 'INPUTFI' ALL
!
SET/GRAP SSIZE=2 STYPE=11
SELECT/TABLE 'INPUTFI' :TYPE.EQ."B".OR.:TYPE.EQ."b"
OVERPLOT/TABLE 'INPUTFI' :RA :DEC
SELECT/TABLE 'INPUTFI' ALL
!
SET/GRAP STYPE=3
SELECT/TABLE 'INPUTFI' :CHECK.EQ."N".OR.:CHECK.EQ."n"
OVERPLOT/TABLE 'INPUTFI' :RA :DEC
SELECT/TABLE 'INPUTFI' ALL
!
SET/GRAPH STYPE=5
SELECT/TABLE 'INPUTFI' :TYPE.EQ."C".OR.:TYPE.EQ."c"
OVERPLOT/TABLE 'INPUTFI' :RA :DEC
SELECT/TABLE 'INPUTFI' ALL

! draw limits of forbidden area
!
SET/GRAPH COLOUR=2
OVERPLOT/LINE 1 'XF(1)','YF(1)' 'XF(2)','YF(2)' 
OVERPLOT/LINE 1 'XF(2)','YF(2)' 'XF(3)','YF(3)' 
OVERPLOT/LINE 1 'XF(3)','YF(3)' 'XF(4)','YF(4)'
!
! put label
!
COMPUTE/KEYW STEP(1) = PIPPO(3)*COSDEC(1)/20.
COMPUTE/KEYW RMAX2(1) = DECLIM(2) + STEP(1)
SET/GRAPH COLOUR=
LABEL/GRAPHIC "'LABEL(1:40)'" 'PLATEC1(1)','RMAX2(1)' 0 1 0
!
! put explanation of symbols
!
COMPUTE/KEYW STEP(1) = P10(1)*COSDEC(1)
COMPUTE/KEYW SYMPOSX(1) = RALIM(2) - P10(1)/15.
COMPUTE/KEYW SYMPOSY(1) = DECLIM(2) - STEP(1)
COMPUTE/KEYW SYMPOSX(2) = SYMPOSX(1)
COMPUTE/KEYW SYMPOSY(2) = DECLIM(2) - STEP(1)*3.0
COMPUTE/KEYW SYMPOSX(3) = SYMPOSX(1)
COMPUTE/KEYW SYMPOSY(3) = SYMPOSY(2) - STEP(1)*2.0
COMPUTE/KEYW SYMPOSX(4) = SYMPOSX(1)
COMPUTE/KEYW SYMPOSY(4) = SYMPOSY(3) - STEP(1)*2.0
COMPUTE/KEYW SYMPOSX(5) = SYMPOSX(1)
COMPUTE/KEYW SYMPOSY(5) = SYMPOSY(4) - STEP(1)*2.0
!
COMPUTE/KEYW LABPOSX(1) = SYMPOSX(1) - P10(1)/15.
COMPUTE/KEYW LABPOSY(1) = SYMPOSY(1)
COMPUTE/KEYW LABPOSX(2) = LABPOSX(1)
COMPUTE/KEYW LABPOSY(2) = SYMPOSY(2)
COMPUTE/KEYW LABPOSX(3) = LABPOSX(1)
COMPUTE/KEYW LABPOSY(3) = SYMPOSY(3)
COMPUTE/KEYW LABPOSX(4) = LABPOSX(1)
COMPUTE/KEYW LABPOSY(4) = SYMPOSY(4)
COMPUTE/KEYW LABPOSX(5) = LABPOSX(1)
COMPUTE/KEYW LABPOSY(5) = SYMPOSY(5)
!
OVERPLOT/SYMBOL 7  'SYMPOSX(1)','SYMPOSY(1)' 0.75
OVERPLOT/SYMBOL 2  'SYMPOSX(2)','SYMPOSY(2)' 0.75
OVERPLOT/SYMBOL 11 'SYMPOSX(3)','SYMPOSY(3)' 0.75
OVERPLOT/SYMBOL 3  'SYMPOSX(4)','SYMPOSY(4)' 0.75
OVERPLOT/SYMBOL 5  'SYMPOSX(5)','SYMPOSY(5)' 0.75
!
LABEL/GRAPHIC "objects" 'LABPOSX(1)','LABPOSY(1)' 0 1 1
LABEL/GRAPHIC "small guidestars" 'LABPOSX(2)','LABPOSY(2)' 0 1 1
LABEL/GRAPHIC "big guidestars" 'LABPOSX(3)','LABPOSY(3)' 0 1 1
LABEL/GRAPHIC "to be deleted" 'LABPOSX(4)','LABPOSY(4)' 0 1 1
LABEL/GRAPHIC "plate centre" 'LABPOSX(5)','LABPOSY(5)' 0 1 1
!
! draw circle to show plate limits
!
SET/GRAP SSIZE=1 STYPE=1
OVERPLOT/TABLE 'CIRTAB' :RAX :DECY
!
SET/GRAPH COLOUR=4 
@s holesid 'INPUTFI' :RA :DEC :IDENT
SET/GRAPH COLOUR=6
@s optident 'INPUTFI' :CHECK :IDENT :RA :DEC
SELECT/TABLE 'INPUTFI' :RA.LT.0.0                    ! back to normal coordinates
COMPUTE/TABLE 'INPUTFI' :RA = :RA+SELECT*24.0
SELECT/TABLE 'INPUTFI' :RA.GE.0.0
COMPUTE/TABLE 'INPUTFI' :RA = :RA-SELECT*24.0
SET/GRA









