# -*- coding: utf-8 -*-

# Copyright (c) 2005 - 2006 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the task properties dialog.
"""

import time

from qt import *

from TaskPropertiesForm import TaskPropertiesForm


class TaskPropertiesDialog(TaskPropertiesForm):
    """
    Class implementing the task properties dialog.
    """
    def __init__(self, task = None, parent = None, projectOpen = 0):
        """
        Constructor
        
        @param task the task object to be shown
        @param parent the parent widget (QWidget)
        @param projectOpen flag indicating status of the project (boolean)
        """
        TaskPropertiesForm.__init__(self, parent, None, 1)
        
        if not projectOpen:
            self.projectCheckBox.setEnabled(0)
        if task is not None:
            self.descriptionEdit.setText(task.description)
            self.creationLabel.setText(time.strftime("%Y-%m-%d, %H:%M:%S", 
                                                     time.localtime(task.created)))
            self.priorityCombo.setCurrentItem(task.priority)
            self.projectCheckBox.setChecked(task._isProjectTask)
            self.completedCheckBox.setChecked(task.completed)
            self.filenameEdit.setText(task.filename)
            if task.lineno:
                self.linenoEdit.setText(str(task.lineno))
        else:
            self.projectCheckBox.setChecked(projectOpen)
    
    def setReadOnly(self):
        """
        Public slot to set the dialog to read only mode.
        """
        self.descriptionEdit.setReadOnly(1)
        self.completedCheckBox.setEnabled(0)
        self.priorityCombo.setEnabled(0)
        
    def getData(self):
        """
        Public method to retrieve the dialogs data.
        
        @return tuple of description, priority, completion flag
                and project flag
        """
        return (self.descriptionEdit.text(), self.priorityCombo.currentItem(),
                self.completedCheckBox.isChecked(), self.projectCheckBox.isChecked())
