/*
 * The raw data really wnats to be big-endian, so it is a pain in Linux.
 */
#ifndef UTF_HEAD_H
#define UTF_HEAD_H
/* Two endian configurations to deal with :-( */
#ifdef LITTLE_ENDIAN
typedef struct {
  unsigned char key; /* 0xC1 */
  unsigned char PI;
  unsigned short GS;
  unsigned short IMAX;
  unsigned short JMAX;
  /* unsigned short DMY; */
  unsigned YEAR : 7; unsigned MONTH : 4; unsigned DAY : 5;
  unsigned short TIME;
} ProductDefinition;
typedef struct {
  unsigned char key; /* 0xC3 */
  unsigned :2 ; unsigned ZD:1; unsigned ZT:2 ; unsigned ZF:3;
  unsigned short STARTI;
  unsigned short STARTJ;
  unsigned short nwords;
  unsigned short data;
} RelativeVectors;
#else /* MUST BE BIG_ENDIAN THEN */
typedef struct {
  unsigned char key; /* 0xC1 */
  unsigned char PI;
  unsigned short GS;
  unsigned short IMAX;
  unsigned short JMAX;
  unsigned short DMY;
  /* unsigned DAY : 5; unsigned MONTH : 4; unsigned YEAR : 7; */
  unsigned short TIME;
} ProductDefinition;
typedef struct {
  unsigned char key; /* 0xC3 */
  unsigned :2 ; unsigned ZD:1; unsigned ZT:2 ; unsigned ZF:3;
  unsigned short STARTI;
  unsigned short STARTJ;
  unsigned short nwords;
  unsigned short data;
} RelativeVectors;
#endif /* LITTLE_ENDIAN */

/*
 * UTF Function Prototypes
 */
int utf(int argc,char*argv[]);
unsigned char *gpd1parse(unsigned char *up);
unsigned char *dc2parse(unsigned char *up);
unsigned char *rv3parse(unsigned char *up);
unsigned char *av4parse(unsigned char *up);
unsigned char *ac5parse(unsigned char *up);
unsigned char *vec6parse(unsigned char *up);
unsigned char *cpc7parse(unsigned char *up);
unsigned char *oac8parse(unsigned char *up);
unsigned char *gdf31parse(unsigned char *up);

int moveto(int x, int y);
int drawto(int x, int y);
int moverel(int x, int y);
int drawrel(int x, int y);

#endif
