import win32con, win32api
from elisa.core.utils import locale_helper

def _get_reg_value(hkey, value_name):
    val = None
    try:
        val, type = win32api.RegQueryValueEx(hkey, value_name)
        if type != win32con.REG_SZ:
            raise(TypeError, "Only strings can be asked for %s" % value_name)
    except:
        raise(TypeError, "can't retrieve the registry value : %s" % value_name)
    
    return val

   
def get_multimedia_dir():
    """
    return in a dict the multimedia directories in UTF8
    """
    multimedia_dir = {}
    system_encoding = locale_helper.system_encoding()
    
    key_name = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders"
    hkey = win32api.RegOpenKey(win32con.HKEY_CURRENT_USER, key_name)

    key = "My Music"
    try:
        val = _get_reg_value(hkey, key)
        multimedia_dir[key] = val.decode(system_encoding)
    except:
        pass
    
    key = "My Pictures"
    try:
        val = _get_reg_value(hkey, key)
        multimedia_dir[key] = val.decode(system_encoding)
    except:
        pass
    
    key = "My Video"
    try:
        val = _get_reg_value(hkey, key)
        multimedia_dir[key] = val.decode(system_encoding)
    except:
        pass
        
    win32api.RegCloseKey(hkey)

    return multimedia_dir
