# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.base_components.metadata_provider import MetadataProvider
from db import MediaDB

from twisted.internet import defer

media_type_keys = set(['uri', 'file_type', 'mime_type'])

class DbMetadata(MetadataProvider):
    def get_rank(self):
        return 0

    def able_to_handle(self, metadata):
        req_keys = set(metadata.keys())
        if req_keys.issubset(media_type_keys):
            return True

        return False

    def get_metadata(self, metadata, low_priority=False):
        uri = metadata['uri']
        infos = MediaDB.get_connection().get_media_information(uri, extended=False)
        if not infos:
            return defer.succeed(metadata)

        self.debug('returning cached media type %s', infos.typ)
        file_type = infos.format
        if infos.typ:
            mime_type = infos.typ
        else:
            mime_type = None
        
        metadata['file_type'] = file_type
        metadata['mime_type'] = mime_type

        return defer.succeed(metadata)
