# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

__maintainer__ = 'Benjamin Kampmann <benjamin@fluendo.com>'

from elisa.base_components.action import Action
from elisa.core.epm import egg_registry

from twisted.internet import defer

class ElisaPluginInstallAction(Action):

    def __init__(self):
        Action.__init__(self)
        self._registry = egg_registry.EggRegistry()
        self.uri = None
            
    def __call__(self, controller, origin):
        if not self.uri:
            return defer.failed(Exception("I need the uri to the file"))

        file = self.uri.path

        # FIXME: move out maybeDeferred when upgrade returns a real deferred
        return self._registry.easy_install_plugin(file)
