
from elisa.core.tests.elisa_test_case import BoilerPlateApp, DEFAULT_CONFIG, MAPPINGS

from elisa.core import common

from elisa.core.tests.test_media_provider import TestMediaProvider
from elisa.core.media_uri import MediaUri
import os
from twisted.internet import defer

class TestAudiocdMedia(TestMediaProvider):

    component_class = 'audiocd_media:AudiocdMedia'
    load_all_plugins = True

    def get_valid_uris(self):
        return [MediaUri(u'cdda://')]

    def test_directory(self):
        uri = MediaUri(u'cdda://')
        dfr = self.component.is_directory(uri)
        dfr.addCallback(lambda validated: self.assertEquals(validated, True))

        uri = MediaUri(u'cdda://1?label=Track2')
        dfr2 = self.component.is_directory(uri)
        dfr2.addCallback(lambda validated: self.assertEquals(validated, False))

        return defer.DeferredList([dfr, dfr2])
