# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


from elisa.core import common
from elisa.base_components.activity import Activity

class ElisaActivity(Activity):
    """
    DOCME
    """

    def get_model(self):
        registry = common.application.plugin_registry
        
        # startup model
        elisa_model = registry.create_component('base:elisa_model')
        elisa_model.activity = self
        #FIXME : it's not the right way to add new property to a model
        #I have to create a new model or change the component
        #The value of these properties are not correclty set everywhere...
        elisa_model.menu_visible = True
        elisa_model.stop_player = True

        # player
        player_activity = registry.create_component('base:player_activity')
        player_model = player_activity.get_model()
        
        # menu
        menu_activity = registry.create_component('xmlmenu:xmltreemenu_activity')
        menu_activity.player_model = player_model
        menu_model = menu_activity.get_model()

        menu_activity.elisa_model = elisa_model

        elisa_model.player = player_model
        elisa_model.menu = menu_model

        manager_model = registry.create_component('raval:manager_model')
        manager_model.activity = self

        # bind manager model to the elisa_model
        elisa_model.manager = manager_model

        # select the root elisa menu in the manager model
        manager_model.current = elisa_model.menu

        location_model = registry.create_component('raval:location_model')
        manager_model.location = location_model

        context_model = registry.create_component('raval:context_model')
        manager_model.context = context_model
        
        model = registry.create_component('base:menu_node_model')
        model.theme_icon = 'mini_player_play_icon'
        action = registry.create_component('raval:show_player_action')
        action.elisa_model = elisa_model
        action.play_when_visible = True
        action.player_model = player_model
        model.activate_action = action
        context_model.append(model)
        
        model = registry.create_component('base:menu_node_model')
        model.theme_icon = 'mini_player_stop_icon'
        action = registry.create_component('raval:stop_playing_action')
        action.elisa_model = elisa_model
        model.activate_action = action
        context_model.append(model)
        
        #separator
        model = registry.create_component('base:menu_node_model')
        model.theme_icon = None
        model.activate_action = None
        context_model.append(model)
        
        model = registry.create_component('base:menu_node_model')
        model.theme_icon = 'list_button'
        action = registry.create_component('raval:list_view_mode_action')
        action.manager_model = manager_model
        model.activate_action = action
        context_model.append(model)
        
        model = registry.create_component('base:menu_node_model')
        model.theme_icon = 'coverflow_button'
        action = registry.create_component('raval:coverflow_view_mode_action')
        action.manager_model = manager_model
        model.activate_action = action
        context_model.append(model)
        
        model = registry.create_component('base:menu_node_model')
        model.theme_icon = 'grid_button'
        action = registry.create_component('raval:grid_view_mode_action')
        action.manager_model = manager_model
        model.activate_action = action
        context_model.append(model)
        
        return elisa_model
