# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2007-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.base_components.service_provider import ServiceProvider
from elisa.core.component import InitializeFailure 
from elisa.core import common
from elisa.core.log import Loggable
from elisa.core.utils.misc import is_hildon_desktop_running
import dbus
import dbus.glib
import dbus.service

class OssoDbusService(dbus.service.Object, Loggable):
    def __init__(self):
        self.name = 'com.fluendo.elisa'
        self.path = '/com/fluendo/elisa'
        bus_name = dbus.service.BusName(self.name, bus=dbus.SessionBus())
        dbus.service.Object.__init__(self, bus_name, self.path)

    @dbus.service.method(dbus_interface='com.fluendo.elisa',
            in_signature='', out_signature='')
    def top_application(self):
        # FIXME: implement this properly without hardcoding pigment stuff
        self.debug('top application')
        interface_controller = common.application.interface_controller
        for frontend in interface_controller._frontends.values():
            self.debug('update frontend %s' % frontend)
            if frontend.context.gtk_window is not None:
                frontend.context.gtk_window.present()
            else:
                frontend.context.viewport_handle.visible = False
                frontend.context.viewport_handle.visible = True
            self.debug('updated frontend %s' % frontend)

class OssoService(ServiceProvider):
    def initialize(self):
        self.debug('service initialize')
        if not is_hildon_desktop_running():
            raise InitializeFailure(self.name, 'hildon not running')

        self._osso_service = OssoDbusService()

    def clean(self):
        self._osso_service = None

    def start(self):
        pass

    def stop(self):
        pass
