/*
Copyright (C) 1991 Geoffrey M. Clemm

This file is part of the Odin system.

The Odin system is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public License
as published by the Free Software Foundation (see the file COPYING).

The Odin system is distributed WITHOUT ANY WARRANTY, without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

geoff@boulder.colorado.edu
*/

#include "inc/GMC.h"
#include "inc/AttTyp_.h"


typedef tp_Att tps_AttArr [MAX_ATP];
typedef tp_Att * tp_AttArr;

#define MAX_AttS	4000
tps_AttArr AttS [MAX_AttS];
int iAttS = 0;


void
Reset_Att(AttTyp)
   tp_AttTyp AttTyp;
{
   int i;

   for (i=0; i<iAttS; i++) AttS[i][AttTyp-1] = 0;
   }/*Reset_Att*/


tp_Att
Get_Att(AttTyp, Sym)
   tp_AttTyp AttTyp;
   tp_Sym Sym;
{
   tp_AttArr AttArr;

   if (AttTyp < 1 || AttTyp > MAX_ATP) fatal_err("bad AttTyp");
   AttArr = (tp_AttArr)Sym_Att(Sym);
   if (AttArr == 0) {
      return 0; }/*if*/;
   return AttArr[AttTyp-1];
   }/*Get_Att*/


void
Set_Att(AttTyp, Sym, Att)
   tp_AttTyp AttTyp;
   tp_Sym Sym;
   tp_Att Att;
{
   tp_AttArr AttArr;

   if (AttTyp < 1 || AttTyp > MAX_ATP) fatal_err("bad AttTyp");
   AttArr = (tp_AttArr)Sym_Att(Sym);
   if (AttArr == 0) {
      if (iAttS == MAX_AttS) fatal_err("no room for more AttS");
      AttArr = AttS[iAttS];
      Set_Sym_Att(Sym, (tp_Att)AttArr);
      iAttS += 1; }/*if*/;
   AttArr[AttTyp-1] = Att;
   }/*Set_Att*/

