
#ifndef PatternFUNCTIONTYPES_H
#define PatternFUNCTIONTYPES_H

#include "eliproto.h"

/* include header file defining Pattern if ptg_chk is set: */
#define EMPTYptg_chkHDR
#ifndef EMPTYHDR
#include "ptg_chk.h"
#endif
#undef EMPTYptg_chkHDR

typedef int (*PatternCmpFctType) ELI_ARG((Pattern, Pattern));
/* Functions that compare two Pattern values
 *   If the left argument is less than the right then on exit-
 *     PatternCmpFctType = -1
 *   Else if the arguments are equal then on exit-
 *     PatternCmpFctType = 0
 *   Else on exit-
 *     PatternCmpFctType = 1
 ***/

typedef Pattern (*PatternMapFct) ELI_ARG((Pattern));
/* Functions that map one Pattern value into another
 *   On exit-
 *     PatternMapFct = image of the argument under the map
 ***/

typedef Pattern (*PatternSumFct) ELI_ARG((Pattern, Pattern));
/* Functions that combine two Pattern values
 *   On exit-
 *     PatternSumFct = combination of the two arguments
 ***/

#endif
