/* $Id: SymComp.c,v 1.3 1997/07/18 11:09:24 uwe Exp $ */
/* Copyright, 1992, AG-Kastens, University Of Paderborn */

#include "SymComp.h"
#include "Bool.h"
#include "LIGA.h"
#include "LIGAMacros.h"
#include "liga_func.h"
#include "lookup_idl.h"
#include "ligaconsts.h"
#include "Consts.h"
#include "AttrDefs.h"
#include "Syntax.h"
#include "msgtxt.h"

#define LOWER(p)	(p == 0)
#define UPPER(p)	(p > 0)

/* global variables for substitution: */

DefTableKey tosymkey, torulekey;
static Environment toscope;
int tosympos, prodlhsdid, isterm, isroot, isgentreepos;
POSITION *tocoord, fromcoord;
POSITION NullPos = {0,0};
SEQAttrrule allcomps;

static
Expr TransExpr();

static
SEQExpr 
TransSEQExpr(src)
   SEQExpr src;
{
   Expr ex;

   if (src)
   {
      retrievefirstSEQExpr(src, ex);
      return (AppFrontSEQExpr(
			      TransExpr(ex),
			      TransSEQExpr(tailSEQExpr(src)))
	 );
   } else
      return (nullSEQExpr());
}/* TransSEQExp */

static
Expr TransExpr(src)
   Expr src;
{
   switch (typeof(src))
   {

   case KCall:
      {
	 Call ca;
	 SEQExpr seq;

	 ca = ExprToCall(src);
	 if (strcmp(TERMFCT, nameOfCall(ca)) == 0) {
		/* terminal access in symbol computation: */
		TList rhs; 
		ProdElem el;
		POSITION pos;
		int cntterm;
		Expr valex;

		if (UPPER (tosympos)) {
			pos.line = rowOfCall(ca); pos.col = colOfCall(ca);
			message (ERROR,MSGTXT( "TERM not allowed in upper computation",
					      (lidoref)Terminal Access),
				0, &pos);
			return (src);
		}
		retrievefirstSEQExpr(paramsOfCall(ca), valex);
		cntterm = vOfVal (ExprToVal (valex));
		rhs = TailList (GetRuleProd (torulekey, NullList));
		el = (ProdElem)0;
		while (rhs != NullList && cntterm) {
			el = (ProdElem) HeadList (rhs);
			if (el->IsSymbol &&
			    SYMBTERM == GetSymClass (el->Key, SYMBTERM))
				cntterm--;
			rhs = TailList (rhs);
		}
		if (cntterm == 0 && el &&
			GetOldTerm (el->Key, 0)) {
			pos.line = rowOfCall(ca); pos.col = colOfCall(ca);
			message (ERROR,MSGTXT( "Old style terminal accessed by TERM",
					      (lidoref)Outdated Constructs),
				 0, tocoord);
			message (ERROR,MSGTXT("TERM accesses old style terminal",
					      (lidoref)Outdated Constructs),
				 0, &pos);
		}
		if (cntterm > 0) {
			pos.line = rowOfCall(ca); pos.col = colOfCall(ca);
			message (ERROR,MSGTXT( "Access to missing terminal", 
					      (lidoref)Terminal Access),
					0, tocoord);
			message (ERROR,MSGTXT( "Terminal missing in target context",
					      (lidoref)Terminal Access),
					0, &pos);
			return (src);
		}
		/* terminal access is copied unchanged */
	 }/* end of terminal access */

	 seq = TransSEQExpr(paramsOfCall(ca));
	 ca = MkCall(nameOfCall(ca), seq, rowOfCall(ca), colOfCall(ca));
	 src = CallToExpr(ca);
	 return (src);
      }

   case KAttracc:
      {
	 Attracc ac;
	 int atid;
	 DefTableKey tokey;
	 int todid;

	 ac = ExprToAttracc(src);
	 atid = attridOfAttracc(ac);
	 tokey = KeyInScope(toscope, atid);

	 if (tokey == NoKey)
	    tokey = DeclareImplAttr(tosymkey, atid, ATCLUNKN, &NullPos);

	 todid = GetDid(tokey, DIDNON);
	 ac = MkAttracc(tosympos, todid,
			rowOfAttracc(ac), colOfAttracc(ac));
	 src = AttraccToExpr(ac);
	 return (src);
      };

   case KChainacc:
      {
	 Chainacc ca;
	 int syntpos;
	 ca = ExprToChainacc(src);

	 if (isterm) {
		message(ERROR,MSGTXT( "CHAIN can not go through a terminal",
				     (lidoref)CHAIN),
			0, &fromcoord);
		message(ERROR,MSGTXT( "CHAIN can not go through a terminal",
				     (lidoref)CHAIN), 0, tocoord);
	 }

	 if (symbnoOfChainacc(ca) == HEADCode)
	 {
	    syntpos = GetHEADpos(torulekey, 0);
	    return
	      ChainaccToExpr
	        (MkChainacc
		   (syntpos,
		    chainidOfChainacc (ca),
		    rowOfChainacc(ca),
		    colOfChainacc(ca)));
	 } else if (symbnoOfChainacc(ca) == TAILCode)
	 {
	    syntpos = GetTAILpos(torulekey, 0);
	    if (syntpos == 0)
	    /* TAIL is inherited to production
	       without right hand side nonterminal.
	       It will be substituted later.
	       No message is given.
	    */
	       syntpos = TAILCode;

	    return
	      ChainaccToExpr
	        (MkChainacc
		    (syntpos,
		     chainidOfChainacc(ca),
		     rowOfChainacc(ca),
		     colOfChainacc(ca)));
	 } else
	    return (CpExpr(src));
      }

   case KConstit:
/* now handled in VoidChk.c:
      if (constattrsOfConstit(ExprToConstit(src)) == nullSEQSymbattr())
      {
	 POSITION co;
	 co.line = rowOfConstit(ExprToConstit(src));
	 co.col = colOfConstit(ExprToConstit(src));
	 message(ERROR,
		MSGTXT( "CONSTITUENT(S) yields empty remote list in some context",
		       (lidoref)CONSTITUENT(S)), 0, &co);
	 message(ERROR,
		MSGTXT( "Inherits CONSTITUENT(S) computation with empty remote list",
		       (lidoref)CONSTITUENT(S)), 0, tocoord);
      }
*/
      if (UPPER(tosympos))
      {
	 Constit c;

	 c = CpConstit(ExprToConstit(src));
	 subtreeOfConstit(c) = tosympos;
	 return (ConstitToExpr(c));
      } else
	 return (CpExpr(src));

   case KIncluding:
      if (inclattrsOfIncluding(ExprToIncluding(src)) == nullSEQSymbattr())
      {
	 POSITION co;
	 co.line = rowOfIncluding(ExprToIncluding(src));
	 co.col = colOfIncluding(ExprToIncluding(src));
	 message(ERROR,
		 MSGTXT("INCLUDING yields empty remote list in some context",
			(lidoref)INCLUDING)
		 , 0, &co);
	 message(ERROR,
		 MSGTXT("Inherits INCLUDING computation with empty remote list",
			(lidoref)INCLUDING)
			, 0, tocoord);
      }
      if (UPPER(tosympos))
      {
	 SEQSymbattr symats;
	 Symbattr symat;
	 Attracc ac;

	 foreachinSEQSymbattr
	    (inclattrsOfIncluding(ExprToIncluding(src)), symats, symat)
	 {
	    if (prodlhsdid == symbdefOfSymbattr(symat))
	    {
	       ac = MkAttracc(0,
			      attrdefOfSymbattr(symat),
			      rowOfIncluding(ExprToIncluding(src)), 
			      colOfIncluding(ExprToIncluding(src)));
	       src = AttraccToExpr(ac);
	       return (src);
	    }
	 }	/* foreach */
      }
      return (CpExpr(src));

   default:
      return (CpExpr(src));
   }

}/* TransExpr */

static int CmpAttrruleCoord (new) Attrrule new;
/* returns true iff the Attrrule new is not yet in the computation list */
{ Call ca;
  SEQAttrrule cmps; Attrrule cmp;
  int row, col;

  if (typeof(new) != KCall) return 1;
  ca = AttrruleToCall (new);
  row = rowOfCall (ca); col = colOfCall (ca);
  foreachinSEQAttrrule(allcomps, cmps, cmp)
	if (typeof(cmp) == KCall) {
		ca = AttrruleToCall (cmp);
		if (row == rowOfCall (ca) && col == colOfCall (ca))
			return 0;
	}
  return 1;
}

static
void KeepCHAINSTART (rulekey, chaindid, comp)
  DefTableKey rulekey; int chaindid; Attrrule comp;
/* 
   rulekey is a rule with empty rhs.
   Insert a ChainStart into a list for rulekey
   if the list does not have one for chaindid yet.

   When we have seen all CHAINSTARTs and HEAD computations,
   a computation
      Chainacc(0, chaindid) = Attracc(0, new attr);
   will be added to rulekey if it has a HEAD computation
   but no CHAINSTART.
*/
{ SEQAttrrule ChainStarts, ars; Attrrule ar;

  ChainStarts = GetChainStarts(rulekey, nullSEQAttrrule());
  foreachinSEQAttrrule (ChainStarts, ars, ar)
  { ChainStart cst = AttrruleToChainStart (ar);
    if (chainidOfChainStart (cst) == chaindid)
       /* overriding ChainStart is already kept */
      return;
  }

  ChainStarts = AppFrontSEQAttrrule (comp, ChainStarts);
  ResetChainStarts (rulekey, ChainStarts);
}/* KeepCHAINSTART */

static
POSITION *CreateCoord (line, col) int line, col;
{ POSITION *res;
  res = (POSITION*)malloc (sizeof(POSITION));
  if (!res)
    message (DEADLY,MSGTXT("CreateCoord: no space",
                           (help)system), 0, NoPosition);
  res->line = line; res->col = col;
  return res;
}

static
DefTableKey GenerateRuleAttr (rulekey, prefix, typedid, line, col)
   DefTableKey rulekey; char* prefix; int typedid, line, col;
{ TList ruleprod; ProdElem lhselem;
  DefTableKey symkey, k; Environment scope;
  int ruledid;

  ruleprod = GetRuleProd (rulekey, NullList);
  lhselem = (ProdElem) HeadList (ruleprod);
  symkey = lhselem->Key;
  scope = GetAttrScope (symkey, NoEnv);
  k = DeclareExplAttr
        (scope, NewCntId (prefix),
	 typedid, ATCLSYNT,
	 CreateCoord (line, col));

  ruledid = GetDid (rulekey, DIDNON);
  ResetAttrProdDid (k, ruledid);
  return k;
}/* GenerateRuleAttr */

static
DefTableKey SearchKeyOfDid (did, env)
	int did; Environment env;
{ Scope scdefs = DefinitionsOf (env);

  while (scdefs != NoScope)
  { DefTableKey k = KeyOf (scdefs);
    if (did == GetDid (k, DIDNON))
       return k;
    scdefs = NextDefinition (scdefs);
  }
  return NoKey;
}/* SearchKeyOfDid */

static
void KeepHEADComp (rulekey, chaindid, comp)
  DefTableKey rulekey; int chaindid; Attrrule comp;
/* comp has the form
	Chainacc(HEAD, chaindid) = expression
   rulekey is a rule with empty rhs.
   If a computation for HEAD.chaindid is not yet been processed

   a new rule attr with type of chaindid is created,
   instead of the HEAD computation
	Attracc(0, new attr) = expression;
	IDFCT (Attracc(0, new attr));
   are added to the computations of rulekey.
   
   The pair (chaindid, new attr) is kept in the HEAD list.

   If no CHAINSTART shows up for chaindid a computation
   Chainacc (0, chaindid) = (0, new attr)
   will be created later.

   A reference to TAIL.chaindid will be substituted by
   (0, new attr) if a pair (chaindid, new attr) is in the HEAD list;
   otherwise by (0, chaindid).
*/
{ SEQExpr emptyHEADs, exprs; Expr expr;

  /* check for overriding: */
  emptyHEADs = GetemptyHEADs (rulekey, nullSEQExpr());
  foreachinSEQExpr (emptyHEADs, exprs, expr)
  { Chainacc chn = ExprToChainacc (expr);
    if (chaindid == chainidOfChainacc (chn))
       return; /* overriding HEAD computation is already kept */
  }

  /* process a new HEAD computation: */
  { DefTableKey chainkey, newattrkey; int newattrdid;
    int typedid, line, col;
    Call ca; Chainacc headacc; Expr lhs, rhs, headexpr;

    ca = AttrruleToCall (comp);
    retrievefirstSEQExpr (paramsOfCall (ca), lhs);
    retrievefirstSEQExpr (tailSEQExpr (paramsOfCall (ca)), rhs);
    headacc = ExprToChainacc (lhs);
    line = rowOfChainacc (headacc);
    col = colOfChainacc (headacc);

    /* get chain type: */
    chainkey = SearchKeyOfDid (chaindid, AttrNameEnv);
    typedid = GetAttrType (chainkey, DIDVOID); 

    /* create new rule attr of chain type: */
    newattrkey =
      GenerateRuleAttr
        (rulekey, "_emptyHEAD_", typedid, line, col);
    newattrdid = GetDid (newattrkey, DIDNON);

    /* keep the pair (chaindid, new attr) in the HEAD list: */
    headacc = MkChainacc (newattrdid, chaindid, line, col);
    headexpr = ChainaccToExpr (headacc);
    emptyHEADs = AppFrontSEQExpr (headexpr, emptyHEADs);
    ResetemptyHEADs (rulekey, emptyHEADs);

    /* make computations:
	Attracc(0, new attr) = expression;
	IDFCT (Attracc(0, new attr));
    */

    lhs = AttraccToExpr (MkAttracc (0, newattrdid, line, col));
    rhs = TransExpr (rhs);
    ca = MkCall
           (ASSIGNFCT,
	    AppFrontSEQExpr (lhs, creatSEQExpr (rhs)),
	    line, col);
    comp = CallToAttrrule (ca);
    allcomps = AppFrontSEQAttrrule (comp, allcomps);

    rhs = AttraccToExpr (MkAttracc (0, newattrdid, line, col));
    ca = MkCall (IDFCT, creatSEQExpr (rhs), line, col);
    comp = CallToAttrrule (ca);
    allcomps = AppFrontSEQAttrrule (comp, allcomps);
  }
}/* KeepHEADComp */

static
int ToBeAdded(new) Attrrule new;
/* yields true if new is a plain computation that is not yet in the list OR 
 * new is a ChainStart and the production has a nonterminal OR
 * new is a HEAD chain computation or an attribute computation and the
 * production has a nonterminal and there is no computation for that chain
 * in the list OR
 * new is an attribute computation and there is no computation for the 
 * attribute in the list of computations collected so far
 */
{
   SEQAttrrule cmps;
   Attrrule cmp;
   Call ca, newcall;
   Expr lhsex, newlhsex;
   ChainStart newchst, chst;
   int newid, newdid, did, gotpos, newpos;
   DefTableKey newkey;

   switch (typeof(new))
   {

   case KCall:
      newcall = AttrruleToCall(new);
      if (strcmp(ASSIGNFCT, nameOfCall(newcall)) != 0)
	 return CmpAttrruleCoord (new);	/* plain computation */
      else
      {
	 retrievefirstSEQExpr(paramsOfCall(newcall), newlhsex);
	 if (typeof(newlhsex) == KAttracc)
	 {
	    newid = attridOfAttracc(ExprToAttracc(newlhsex));
	    newkey = KeyInScope(toscope, newid);
            if (newid == GenAttrId && !isgentreepos) {
		POSITION messpos;
		messpos.line = rowOfAttracc(ExprToAttracc(newlhsex));
		messpos.col = colOfAttracc(ExprToAttracc(newlhsex));
		message(ERROR,
			MSGTXT("GENTREE computation must not be inherited to here",
			       (lidoref)Computed Subtrees),
			0, &messpos);
		message(ERROR,
			MSGTXT("GENTREE computation is inherited to wrong position",
			       (lidoref)Computed Subtrees),
			0, tocoord);
		return false;
            }
	    if (newkey == NoKey)
	    { POSITION messpos;
              messpos.line = rowOfAttracc(ExprToAttracc(newlhsex));
              messpos.col = colOfAttracc(ExprToAttracc(newlhsex));
	       message(ERROR,
		MSGTXT("Inherited to a symbol that does not define this attribute",
		       (lidoref)Inheritance of Computations),
		       0, &messpos);
	       message(ERROR,
		       MSGTXT("Inherits an undefined attribute use",
			      (lidoref)Inheritance of Computations)
		       , 0, tocoord);
	       return (false);
	    }
	    newdid = GetDid(newkey, DIDNON);
	    newpos = tosympos;
	 } else if (typeof(newlhsex) == KChainacc)
	 {
	    newdid = chainidOfChainacc(ExprToChainacc(newlhsex));
	    newpos = tosympos;
	    if (HEADCode == symbnoOfChainacc(ExprToChainacc(newlhsex)))
	    {
	       newpos = GetHEADpos(torulekey, 0);
	       /* HEAD is not inherited to production without nonterminal: */
	       if (0 == newpos)
	       { /* keep HEAD computation to be used for TAIL */
		 KeepHEADComp (torulekey, newdid, new);
		 return (false);
	       }
               /* newpos > 0; has to be substituted for HEADCode */
	    }
	 } else /* would be a system error */
	    return (false);
      }

      /* inspect the already found computations: */
      foreachinSEQAttrrule(allcomps, cmps, cmp)
      if (typeof(cmp) == KCall)
      {
	 ca = AttrruleToCall(cmp);
	 if (strcmp(ASSIGNFCT, nameOfCall(ca)) == 0)
	 {
	    retrievefirstSEQExpr(paramsOfCall(ca), lhsex);
	    if (typeof(lhsex) == KAttracc)
	    {
	       gotpos = symbnoOfAttracc(ExprToAttracc(lhsex));
	       did = attridOfAttracc(ExprToAttracc(lhsex));
	    } else if (typeof(lhsex) == KChainacc)
	    {
	       gotpos = symbnoOfChainacc(ExprToChainacc(lhsex));
	       did = chainidOfChainacc(ExprToChainacc(lhsex));
	    } else /* would be a system error */
	       return (false);

	    if ((newdid == did) && (gotpos == newpos))
	    /* there is already an overriding computation */
	       return (false);
	 }
      }
      break;

   case KChainStart:
      newchst = AttrruleToChainStart(new);
      newdid = chainidOfChainStart(newchst);

      if (0 == GetHEADpos(torulekey, 0))
      {  KeepCHAINSTART (torulekey, newdid, new); 
	 /* CHAINSTART is not inherited to production with empty rhs */
	 return (false);
      }

      foreachinSEQAttrrule(allcomps, cmps, cmp)
      {
	 if (typeof(cmp) == KChainStart)
	 {
	    chst = AttrruleToChainStart(cmp);
	    if (chainidOfChainStart(chst) == newdid)
	       return (false);
	 }
      }	/* foreachinSEQAttrrule */
      break;

   default:
      return (false);

   }	/* switch */
   return (true);
}/* ToBeAdded */


/* static */
void 
AddSymComps(symcomps)
   SEQAttrrule symcomps;
{
   SEQAttrrule ars;
   Attrrule symcomp, ar;
   Call symcall;
   Expr ex;
   ChainStart symcst;

   foreachinSEQAttrrule(symcomps, ars, symcomp)
      switch (typeof(symcomp))
   {

   case KCall:
      symcall = AttrruleToCall(symcomp);
      fromcoord.line = rowOfCall(symcall);
      fromcoord.col = colOfCall(symcall);
      if (ToBeAdded(symcomp))
      {
	 ex = CallToExpr(symcall);
	 ex = TransExpr(ex);
	 ar = CallToAttrrule(ExprToCall(ex));
	 allcomps = AppFrontSEQAttrrule(ar, allcomps);
      }
      break;

   case KChainStart:
      symcst = AttrruleToChainStart(symcomp);
      fromcoord.line = rowOfChainStart(symcst);
      fromcoord.col = colOfChainStart(symcst);
      if (ToBeAdded(symcomp))
	 allcomps =
	    AppFrontSEQAttrrule(CpAttrrule(symcomp), allcomps);
      break;

   default:;

   }	/* switch, for each comp */
}/* AddSymComps */

static
void 
AllSymInhComps(fromkey)
   DefTableKey fromkey;
{
   SEQAttrrule symcomps;
   TList inhsyms;

   if (isterm || isroot)
   {
      symcomps = GetLowAttrib(fromkey, nullSEQAttrrule());
      AddSymComps(symcomps);
      symcomps = GetUpAttrib(fromkey, nullSEQAttrrule());
      AddSymComps(symcomps);
   } else if (LOWER(tosympos))
   {	/* target is on lhs of production */
      symcomps = GetLowAttrib(fromkey, nullSEQAttrrule());
      AddSymComps(symcomps);
   } else
   {	/* target is on rhs of production */
      symcomps = GetUpAttrib(fromkey, nullSEQAttrrule());
      AddSymComps(symcomps);
   }

   inhsyms = GetInhFrom(fromkey, NullList);
   while (inhsyms != NullList)
   {
      AllSymInhComps((DefTableKey) HeadList(inhsyms));
      inhsyms = TailList(inhsyms);
   }
}/* AllSymInhComps */

void 
MakeInhComps(rulekey, symkey, topos, lhsdid, isgen, coord)
   DefTableKey rulekey, symkey;
   int topos, lhsdid, isgen;
   POSITION *coord;
{
   TList prodlist;
   ProdElem pel;

   isgentreepos = isgen;
   tosymkey = symkey;
   toscope = GetAttrScope (symkey, NoEnv);
   if (toscope == NoEnv)
      return;

   prodlhsdid = lhsdid;
   tosympos = topos;
   tocoord = coord;
   fromcoord.line = coord->line;
   fromcoord.col = coord->col;
   isterm = (GetSymClass (symkey, SYMBNONT) == SYMBTERM);
   isroot = GetIsRoot (symkey, false);
   allcomps = GetAttrib (rulekey, nullSEQAttrrule());
   torulekey = rulekey;

   AllSymInhComps (symkey);

   ResetAttrib (rulekey, allcomps);
}/* MakeInhComps */

void ChnSymbCompChk (symbkey) DefTableKey symbkey;
/* symbol computations are checked for multiple
   computations of the same chain
*/
{ SEQAttrrule comps1, comps2; 
  Attrrule comp1, comp2;
  Call ca1, ca2;
  Expr lhsex1, lhsex2;
  Chainacc chn1, chn2;
  int symbno, chainid;
  POSITION coord;

if (GetChnChk (symbkey, 0)) return;

ResetChnChk (symbkey, 1);
foreachinSEQAttrrule
  (GetLowAttrib(symbkey, nullSEQAttrrule()), comps1, comp1)
if (typeof (comp1) == KCall)
{
  ca1 = AttrruleToCall (comp1);
  if (strcmp (ASSIGNFCT, nameOfCall (ca1)) != 0)
	continue;

  retrievefirstSEQExpr(paramsOfCall (ca1), lhsex1);
  if (typeof (lhsex1) != KChainacc)
	continue;

  chn1 = ExprToChainacc (lhsex1);
  symbno = symbnoOfChainacc (chn1);
  chainid = chainidOfChainacc (chn1);

  foreachinSEQAttrrule (tailSEQAttrrule(comps1), comps2, comp2)
  if (typeof (comp2) == KCall)
  {
    ca2 = AttrruleToCall (comp2);
    if (strcmp (ASSIGNFCT, nameOfCall (ca2)) != 0)
	continue;

    retrievefirstSEQExpr(paramsOfCall(ca2), lhsex2);
    if (typeof (lhsex2) != KChainacc)
	continue;

    chn2 = ExprToChainacc (lhsex2);
    if (symbno != symbnoOfChainacc (chn2) ||
	chainid != chainidOfChainacc (chn2))
	continue;

    coord.line = rowOfChainacc (chn1);
    coord.col = colOfChainacc (chn1);
    message (ERROR,
	     MSGTXT("Multiple symbol computations for this CHAIN",
		    (lidoref)Computations),
	     0, &coord);
    coord.line = rowOfChainacc (chn2);
    coord.col = colOfChainacc (chn2);
    message (ERROR,
	     MSGTXT("Multiple symbol computations for this CHAIN",
		    (lidoref)Computations),
	     0, &coord);
    break;
  }
}
}/* ChnSymbCompChk */
