/* $Id: Pragma.c,v 1.7 1999/08/06 09:26:29 cogito Exp $ */
/* Copyright, 1993, AG-Kastens, University Of Paderborn */

/* Central function of this module is
	void ChkPragma (env)
   It performs postprocessing on the final set of computations.
   It affects both 
	ITERATE constructs by ChkLoop (ca, atrules);
	old style LIGAPragmas by ChkPragmaCall (ca);
*/

#include "Pragma.h"

#include "err.h"
#include "idn.h"
#include "Strings.h"
#include "envmod.h"
#include "LIGA.h"
#include "LIGAMacros.h"
#include "ligaconsts.h"
#include "liga_func.h"
#include "Bool.h"
#include "pdl_gen.h"
#include "Syntax.h"
#include "GlobDef.h"
#include "AttrDefs.h"
#include "Consts.h"
#include "Names.h"
#include "msgtxt.h"
#include "liga_To_func.h"

/* to be removed with outdated LIGAPragma: */
#define PRAGMAFCT       "LIGAPragma"

/* access to csm module */
#define GetStringRef(s) (strng[s])

#define IdlSEQElem(l) ((l)->value)
#define IdlSEQNext(l) ((l)->next)

static Call ChkPragmaCall ();
static SEQExpr ChkPragmaSEQExpr ();

typedef SEQExpr	*SEQExprP;

/* variables to be used in substitution functions: */

static DefTableKey	rulekey;	/* key of current rule */
static int		ruleid;		/* id of current rule */
static int		ruledid;	/* did of current rule */

static int		isTermFct;	/* who created outermost $$ call */

#define ERRCALL(line,col) (MkCall ("$ERRCALL", nullSEQExpr(), line, col))
#define ERREXPR(line,col) (CallToExpr(ERRCALL(line,col)))

int IsOldBottomUp (fctid, argid) int fctid, argid;
{ Expr param;
  if (strcmp (PRAGMAFCT, StringTable (fctid)) != 0) return 0;
  if (strcmp ("BottomUp", StringTable (argid)) != 0) return 0;
  return 1;
}

/* SubstLIGAPragma is called
   in *.lido on initial creation of computations
*/

Expr SubstLIGAPragma (ca) Call ca;
/* substitutes old style calls LIGAPragma ("Name", ...) by
   a call "Name" (...)
*/
{ SEQExpr params; Expr pragmaex;
  POSITION currpos;

  if (strcmp (PRAGMAFCT, nameOfCall (ca)) != 0) 
	return CallToExpr (ca);

  currpos.line = rowOfCall (ca);
  currpos.col  = colOfCall (ca);
  message (WARNING, MSGTXT("LIGAPragma is outdated, see manual",
			   (lidoref)Outdated Constructs), 0, &currpos);

  params = paramsOfCall(ca);
  if (emptySEQExpr(params)) 
  { message (ERROR,MSGTXT("Missing name of LIGAPragma",
			  (lidoref)Outdated Constructs), 0, &currpos);
    return ERREXPR(currpos.line, currpos.col);
  }
  retrievefirstSEQExpr(params, pragmaex);
  if (typeof (pragmaex) != KName)
  { message (ERROR,MSGTXT("Missing name of LIGAPragma",
			  (lidoref)Outdated Constructs), 0, &currpos);
    return ERREXPR(currpos.line, currpos.col);
  }
  if (strcmp (nOfName (ExprToName(pragmaex)), "RuleFct") == 0)
  { nameOfCall(ca) = "RuleFct";
    paramsOfCall(ca) = tailSEQExpr (params);
    return CallToExpr (ca);
  }
  if (strcmp (nOfName (ExprToName(pragmaex)), "RhsAttrs") == 0)
  { Expr ex;
    if (emptySEQExpr(tailSEQExpr (params)))
    { message (ERROR,MSGTXT("Missing attribute name of LIGAPragma RhsAttrs",
			    (lidoref)Outdated Constructs),
	       0, &currpos);
      return ERREXPR(currpos.line, currpos.col);
    } else
    if (!emptySEQExpr(tailSEQExpr (tailSEQExpr(params))))
    { message (ERROR,MSGTXT("Too many arguments of LIGAPragma RhsAttrs",
			    (lidoref)Outdated Constructs),
	       0, &currpos);
      return ERREXPR(currpos.line, currpos.col);
    }
    retrievefirstSEQExpr(tailSEQExpr (params), ex);
    if (typeof (ex) != KName)
    { message (ERROR,MSGTXT("Missing attribute name of LIGAPragma RhsAttrs",
			    (lidoref)Outdated Constructs),
	       0, &currpos);
      return ERREXPR(currpos.line, currpos.col);
    }
    nameOfCall(ca) = "$RhsAttrs";
    paramsOfCall(ca) = tailSEQExpr (params);
    return CallToExpr (ca);
  } else
  if (strcmp (nOfName (ExprToName(pragmaex)), "BottomUp") == 0)
  { if (emptySEQExpr(tailSEQExpr(params)))
    { message (ERROR,MSGTXT("missing arguments of LIGAPragma BottomUp",
			    (lidoref)Outdated Constructs),
	       0, &currpos);
      return ERREXPR(currpos.line, currpos.col);
    }
    nameOfCall(ca) = ORDERFCT;
    paramsOfCall(ca) = tailSEQExpr (params);
    return CallToExpr (ca);
  } else
  { message (ERROR,MSGTXT("unknown LIGAPragma",
			  (lidoref)Outdated Constructs),
	     0, &currpos);
    return ERREXPR(currpos.line, currpos.col);
  }
}/* SubstLIGAPragma */


/* insert new substitution function here:
   interface:
   Call TransPragmaName (args, pos)
	args are non substituted arguments following the pragma name string
	pos is the pragma coordinate address
        the result must be a call with all arguments substituted
*/

static
Call TransRuleFct (args, pos) SEQExpr args; POSITION *pos;
{	Expr arg;
	Call litparam;
	char *fctname;

	if (emptySEQExpr(args)) {
		message (ERROR,MSGTXT( "Missing argument of RuleFct",
				      (lidoref)Predefined Entities), 0, pos);
		return ERRCALL(pos->line, pos->col);
	}
	/* process argument controlling RuleFct: */
	retrievefirstSEQExpr (args, arg);
	if (typeof (arg) != KCall) {
		message (ERROR,MSGTXT( "First argument of RuleFct must be a string",
				       (lidoref)Predefined Entities), 
			 0, pos);
		return ERRCALL(pos->line, pos->col);
	}
	litparam = ExprToCall (arg);
	retrievefirstSEQExpr (paramsOfCall (litparam), arg);
	if (typeof (arg) != KLiteral) {
		message (ERROR,MSGTXT( "First argument of RuleFct must be a string",
				       (lidoref)Predefined Entities), 
			 0, pos);
		return ERRCALL(pos->line, pos->col);
	}
	fctname = CatStrStr (strOfLiteral (ExprToLiteral (arg)),
			     GetStringRef (ruleid));

	/* substitute pragmas in tail of arguments: */
	args = ChkPragmaSEQExpr (tailSEQExpr (args));

	/* return substituted call: */
	return (MkCall (fctname, args, pos->line, pos->col));
}/* TransRuleFct */

static Call TransRhsAttrs (args, pos) SEQExpr args; POSITION *pos;
{	Expr		arg, newarg;
	char		*attrname;
	TList		rhs;
	ProdElem	elem;
	DefTableKey	attrkey;
	int		attrid, dummy;

/* arguments are correct by construction */

/* process argument controlling RhsAttrs: */
retrievefirstSEQExpr (args, arg);
if (typeof (arg) == KName) {
	attrname = nOfName (ExprToName (arg));
	mkidn (attrname, strlen (attrname), &dummy, &attrid);
}
else {  /* arguments are correct by construction */
}

args = nullSEQExpr();

rhs = TailList (GetRuleProd (rulekey, NullList));
while (rhs != NullList) {
	elem = (ProdElem) HeadList (rhs);
	if (elem->IsSymbol &&
	    (GetSymClass (elem->Key, SYMBNONT) == SYMBNONT ||
	     GetOldTerm (elem->Key, 0)))
	{
		attrkey = DeclareImplAttr (
				elem->Key,
				attrid,
				ATCLUNKN,
				pos);
		newarg = AttraccToExpr (MkAttracc (
			elem->SyntPos, GetDid (attrkey, DIDNON),
			pos->line, pos->col));
		appendrearSEQExpr (args, newarg);
	}/* is nonterm */
	rhs = TailList (rhs);
}/* while rhs */

/* return substituted call: */
/* pragma yields an argument sequence to be inserted in the
   surrounding argument sequence:
*/
isTermFct = 0;
return (MkCall ("$$", args, pos->line, pos->col));
}/* TransRhsAttrs */

static
Call TransRhsFct (args, pos) SEQExpr args; POSITION *pos;
/*
Let args be the arguments of a call 
	RhsFct ("Pre", a1,...,an)
Let	rulename: X ::= U Ta V Tb W 
be the rule containing that call, where Ta and Tb are the only
new style terminals, and U, V, W are nonterminals
Then the result is a call
	PreRhs_3_2 (a1,...,an)
where a1,...,an are recursively substituted.
I. e. the function name is created from the prefix string, "Rhs",
and the numbers of nonterminals and terminals (new style)
on the right-hand side of the rule.
*/
{ Expr arg;
  char *fctname, *prefix;
  char ntnumstr[32], tnumstr[32];
  Call litparam;
  TList rhs;
  int nontermcnt, termcnt;

  /* process string argument: */
  if (emptySEQExpr(args))
  { message (ERROR, MSGTXT("Missing argument of RhsFct",
                           (lidoref)Predefined Entities), 0, pos);
    return ERRCALL(pos->line, pos->col);
  }
  retrievefirstSEQExpr (args, arg);
  if (typeof (arg) != KCall) 
  { message (ERROR, MSGTXT("First argument of RhsFct must be a string",
                           (lidoref)Predefined Entities), 0, pos);
    return ERRCALL(pos->line, pos->col);
  }
  litparam = ExprToCall (arg);
  retrievefirstSEQExpr (paramsOfCall (litparam), arg);
  if (typeof (arg) != KLiteral) 
  { message (ERROR,MSGTXT("First argument of TermFct must be a string",
                          (lidoref)Predefined Entities), 0, pos);
    return ERRCALL(pos->line, pos->col);
  }
  prefix = strOfLiteral (ExprToLiteral (arg));

  /* count rhs symbols for function name: */
  nontermcnt = 0; termcnt = 0;
  rhs = TailList (GetRuleProd (rulekey, NullList));
  while (rhs != NullList) 
  { ProdElem elem;
    elem = (ProdElem) HeadList (rhs);
    if (elem->IsSymbol)
    {  if (GetSymClass (elem->Key, SYMBNONT) == SYMBTERM &&
           !(GetOldTerm (elem->Key, 0)))
            termcnt++;
       else nontermcnt++;
    }
    rhs = TailList (rhs);
  }/* while rhs */

  sprintf (ntnumstr, "_%d", nontermcnt);
  sprintf (tnumstr, "_%d", termcnt);
  fctname =
     CatStrStr (prefix,
     CatStrStr ("Rhs",
     CatStrStr (ntnumstr, tnumstr)));

  /* substitute pragmas in tail of arguments: */
  args = ChkPragmaSEQExpr (tailSEQExpr (args));

  /* return substituted call: */
  return (MkCall (fctname, args, pos->line, pos->col));
}/* TransRhsFct */

static
Call TransTermFct (args, pos) SEQExpr args; POSITION *pos;
/*
Let args be the arguments of a call 
	TermFct ("Pre", a1,...,an)
Let	X ::= ... Ta ... Tb ... 
be the rule containing that call, where Ta and Tb are the only
new style terminals.
Then the result is an argument sequence
	$$ (PreTa (Ta, a1,...,an), PreTb (Tb, a1,...,an))
where a1,...,an are recursively substituted.
*/
{	Expr		arg, newarg, termacc;
	SEQExpr		newargs;
	char		*fctname;
	Call		litparam;
	TList		rhs;
	ProdElem	elem;

if (emptySEQExpr(args))
{ message (ERROR, MSGTXT("Missing argument of TermFct",
			 (lidoref)Predefined Entities), 0, pos);
  return ERRCALL(pos->line, pos->col);
}

/* process string argument: */
retrievefirstSEQExpr (args, arg);
if (typeof (arg) != KCall) 
{ message (ERROR, MSGTXT( "First argument of TermFct must be a string",
		          (lidoref)Predefined Entities), 
			  0, pos);
  return ERRCALL(pos->line, pos->col);
}
litparam = ExprToCall (arg);
retrievefirstSEQExpr (paramsOfCall (litparam), arg);
if (typeof (arg) != KLiteral) 
{ message (ERROR,MSGTXT( "First argument of TermFct must be a string",
			 (lidoref)Predefined Entities), 
			 0, pos);
  return ERRCALL(pos->line, pos->col);
}

/* substitute pragmas in tail of arguments: */
args = ChkPragmaSEQExpr (tailSEQExpr (args));

newargs = nullSEQExpr();
rhs = TailList (GetRuleProd (rulekey, NullList));
while (rhs != NullList) 
{
  elem = (ProdElem) HeadList (rhs);
  if (elem->IsSymbol &&
      (GetSymClass (elem->Key, SYMBNONT) == SYMBTERM &&
       !(GetOldTerm (elem->Key, 0))))
  {
    fctname = CatStrStr (strOfLiteral (ExprToLiteral (arg)),
			 GetStringRef (GetIdent (elem->Key, 0)));

    termacc = CallToExpr
		(MkCall
		   (TERMFCT, 
		    creatSEQExpr 
		      (FcValToExpr
		         (MkVal (elem->SyntPos, pos->line, pos->col))),
		    pos->line, pos->col));

    newarg = CallToExpr 
		(MkCall
		   (fctname,
		    AppFrontSEQExpr (termacc, CpSEQExpr (args)),
		    pos->line, pos->col));

    appendrearSEQExpr (newargs, newarg);
  }/* is term */
  rhs = TailList (rhs);
}/* while rhs */

/* return substituted call: */
/* pragma yields an argument sequence to be inserted in the
   surrounding argument sequence:
*/
isTermFct = 1;
return (MkCall ("$$", newargs, pos->line, pos->col));
}/* TransTermFct */

static
SEQExpr ChkPragmaSEQExpr (exprs) SEQExpr exprs;
/* For each element in exprs that is a Call of a pragma substitution is
   applied. The so substituted list is returned.
   Pragma substitution transforms a Call into a deep substituted Call.
   In case of RhsAttrs or TermFct the substituted Call is an 
   artificial one ("$$").
   Its argument list (a list of attrs) is inserted in the exprs list
   instead of the "$$" Call.
*/
{ SEQExpr res = nullSEQExpr(), prev = nullSEQExpr();

  while (!emptySEQExpr (exprs))
  { Expr head;
    retrievefirstSEQExpr (exprs, head);
    if (typeof (head) == KCall)
    {  Call ca = ExprToCall (head);
       ca = ChkPragmaCall (ca);
       IdlSEQElem(exprs) = CallToExpr(ca);
       if (strcmp ("$$", nameOfCall (ca)) == 0)
       { /* insert its params: */
	 if (emptySEQExpr(paramsOfCall(ca)))
	 { if (!emptySEQExpr(prev))
	      IdlSEQNext(prev) = nullSEQExpr();
	 } else
	 { if (emptySEQExpr(prev))
           { res = paramsOfCall(ca);
	     prev = res;
	   } else IdlSEQNext(prev) = paramsOfCall(ca);
           while (!emptySEQExpr(tailSEQExpr(prev)))
		prev = tailSEQExpr(prev);
	   /* prev is the last param of $$ */
	 }
       } else /* not a "$$" Call: */
       { if (emptySEQExpr(prev))
	       res = exprs;
         else  IdlSEQNext(prev) = exprs;
         prev = exprs;
       }
    } else /* not a Call: */
    { if (emptySEQExpr(prev))
	    res = exprs;
      else  IdlSEQNext(prev) = exprs;
      prev = exprs;
    }
    exprs = tailSEQExpr(exprs);
  }/* while exprs */
  return res;
}/* ChkPragmaSEQExpr */

static Call ChkPragmaCall (ca) Call ca;
{ POSITION currpos;

  if (strcmp ("RuleFct", nameOfCall (ca)) == 0) 
  { currpos.line = rowOfCall (ca);
    currpos.col  = colOfCall (ca);
    return TransRuleFct (paramsOfCall (ca), &currpos);
  }

  if (strcmp ("$RhsAttrs", nameOfCall (ca)) == 0) 
  { currpos.line = rowOfCall (ca);
    currpos.col  = colOfCall (ca);
    return TransRhsAttrs (paramsOfCall (ca), &currpos);
  }

  if (strcmp ("TermFct", nameOfCall (ca)) == 0) 
  { currpos.line = rowOfCall (ca);
    currpos.col  = colOfCall (ca);
    return TransTermFct (paramsOfCall (ca), &currpos);
  }

  if (strcmp ("RhsFct", nameOfCall (ca)) == 0) 
  { currpos.line = rowOfCall (ca);
    currpos.col  = colOfCall (ca);
    return TransRhsFct (paramsOfCall (ca), &currpos);
  }

  if (strcmp (ASSIGNFCT, nameOfCall (ca)) == 0)
  { 
    int lg = lengthSEQExpr (paramsOfCall (ca));
    paramsOfCall (ca) = ChkPragmaSEQExpr (paramsOfCall (ca));

    if (lg != lengthSEQExpr (paramsOfCall (ca)))
    { /* rhs of assign has been distorted by TermFct or RHS.attr */
	  currpos.line = rowOfCall (ca);
	  currpos.col  = colOfCall (ca);
	  if (isTermFct)
	    message 
	      (ERROR,
	       MSGTXT("TermFct in assign must stand for exactly one terminal",
		      (lidoref)Predefined Entities),
	       0, &currpos);
	  else
	    message 
	      (ERROR,
	       MSGTXT("RHS.attr in assign must stand for exactly one attribute",
		      (lidoref)Attributes),
	       0, &currpos);
    }
    return ca;
  }

  /* call of other function; substitute its arguments: */
  paramsOfCall (ca) = ChkPragmaSEQExpr (paramsOfCall (ca));

  return (ca);
}/* ChkPragmaCall */

static POSITION looppos;

static
void InsertInitCycle (compseq, attr)
	SEQAttrrule	compseq;
	Attracc		attr;
{	SEQAttrrule	atrs;
	Attrrule	atrule;
	Call		ca, rhsca;
	Expr		ex, rhs;
	Attracc		lhsattr;

foreachinSEQAttrrule (compseq, atrs, atrule) {
if (typeof (atrule) == KCall) {
	ca = AttrruleToCall (atrule);
	if (strcmp (ASSIGNFCT, nameOfCall (ca)) == 0) {
		retrievefirstSEQExpr(paramsOfCall (ca), ex);
		if (typeof (ex) == KAttracc) {
			lhsattr = ExprToAttracc (ex);
			if ((symbnoOfAttracc(lhsattr) == symbnoOfAttracc(attr)) &&
			    (attridOfAttracc(lhsattr) == attridOfAttracc(attr))) {
				/* insert INITCYCLE to rhs: */
				retrievefirstSEQExpr(tailSEQExpr(paramsOfCall (ca)), rhs);
				if (typeof (rhs) == KCall) {
					rhsca = ExprToCall (rhs);
					if (strcmp (INITCYCLEFCT, nameOfCall (rhsca)) == 0)
						return;
				}/* rhs Call */

				rhsca = MkCall (INITCYCLEFCT,
						creatSEQExpr (rhs),
						rowOfAttracc (lhsattr),
						colOfAttracc (lhsattr));
				rhs = CallToExpr (rhsca);
				IdlSEQElem(IdlSEQNext(paramsOfCall (ca))) = rhs;
				return;
			}
		}/* KAttracc */
	}/* ASSIGNFCT */
}/* KCall */
}/* foreachinSEQAttrrule */

message (ERROR,MSGTXT( "Missing computation of iteration attribute in this context",
		      (lidoref)Iterations),
	 0, &looppos);
}/* InsertInitCycle */

static
void ChkLoop (ca, compseq)
	Call		ca;
	SEQAttrrule	compseq;
{	Expr		ex;
	Attracc		attr;

if (strcmp (ASSIGNFCT, nameOfCall (ca)) == 0) {
	retrievefirstSEQExpr(tailSEQExpr(paramsOfCall (ca)), ex);
	if (typeof (ex) == KCall)
		ca = ExprToCall (ex);
	else	return;
}

if (strcmp (LOOPFCT, nameOfCall (ca)) == 0) {
	retrievefirstSEQExpr(tailSEQExpr(paramsOfCall (ca)), ex);
	looppos.line = rowOfCall (ca);
	looppos.col  = colOfCall (ca);
	if (typeof (ex) == KAttracc) {
		attr = ExprToAttracc (ex);
		InsertInitCycle (compseq, attr);
	} else	message (DEADLY,MSGTXT( "Internal error: loop attribute expected",
				       (help)system), 
				0, &looppos);
}
}/* ChkLoop */

void ChkPragma (env)
	Environment	env;
{	SEQAttrrule	atrules;
	SEQAttrrule	atrs;
	Attrrule	atrule, newatrule;
	Call		ca;
	POSITION	currpos;
	Scope		alldefs;

alldefs = DefinitionsOf (env);
while (alldefs != NoScope) {
rulekey = KeyOf (alldefs);
if (RuleDef == GetDefKind (rulekey, TypeDef)) {
	ruledid = GetDid (rulekey, DIDNON);
	ruleid = IdnOf (alldefs);
	atrules = GetAttrib (rulekey, nullSEQAttrrule ());
	foreachinSEQAttrrule (atrules, atrs, atrule) {
		if (typeof (atrule) == KCall) {
			ca = AttrruleToCall (atrule);

			ChkLoop (ca, atrules);

			ca = ChkPragmaCall (ca);
			if (strcmp ("$$", nameOfCall (ca)) == 0) 
			{
			  currpos.line = rowOfCall (ca);
			  currpos.col  = colOfCall (ca);
			  if (isTermFct)
			    message 
			      (ERROR,
			       MSGTXT("misused TermFct",
				      (lidoref)Predefined Entities),
			       0, &currpos);
			  else
			    message 
			      (ERROR,
			       MSGTXT("misused RHS.attr",
				      (lidoref)Attributes),
			       0, &currpos);
			}
			newatrule = CallToAttrrule (ca);
			IdlSEQElem (atrs) = newatrule;
		}/* KCall */
	}/* foreachinSEQAttrrule */
}/* RuleDef */
alldefs = NextDefinition (alldefs);
}/* while */
}/* ChkPragma */
