
/* implementation of tree construction functions */

#include "node.h"

#include "nodecode.h"

#include "attrpredef.h"

#include "visitmap.h"

#include "treeact.h"

#ifdef MONITOR
#include "attr_mon_dapto.h"
#endif

#include <stdlib.h>

#define _USE_OBSTACK 1

/* use of obstack: */

#if _USE_OBSTACK

#include "obstack.h"
static struct obstack TreeSpace;
static void *_TreeBase;

#ifdef __cplusplus
void* NODEPTR_struct::operator new(size_t size)
{
	return obstack_alloc(&TreeSpace, size);
}
#else
#if defined(__STDC__) || defined(__cplusplus)
char* TreeNodeAlloc(int size)
#else
char* TreeNodeAlloc(size) int size;
#endif
{
	return (char *)(obstack_alloc(&TreeSpace, size));
}
#endif

void InitTree()
{
	obstack_init(&TreeSpace);
	_TreeBase=obstack_alloc(&TreeSpace,0);
}

void FreeTree()
{
	obstack_free(&TreeSpace, _TreeBase);
	_TreeBase=obstack_alloc(&TreeSpace,0);
}

#else

#include <stdio.h>

#ifdef __cplusplus
void* NODEPTR_struct::operator new(size_t size)
{
	void *retval = malloc(size);
	if (retval) return retval;
	fprintf(stderr, "*** DEADLY: No more memory.\n");
	exit(1);
}
#else
#if defined(__STDC__) || defined(__cplusplus)
char* TreeNodeAlloc(int size)
#else
char* TreeNodeAlloc(size) int size;
#endif
{
	char *retval = (char *) malloc(size);
	if (retval) return retval;
	fprintf(stderr, "*** DEADLY: No more memory.\n");
	exit(1);
}
#endif

void InitTree() { }

void FreeTree() { }

#endif

#ifdef MONITOR
#define _SETCOORD(node) \
        node->_coord = _coordref ? *_coordref : NoCoord;
#define _COPYCOORD(node) \
        node->_coord = _currn->_desc1->_coord;
#else
#define _SETCOORD(node)
#define _COPYCOORD(node)
#endif
#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkspec (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR Mkspec (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBspec)) return (_currn);
if (IsSymb (_currn, SYMBparams)) return (Mkrule_1(_coordref, _currn));
return(NULLNODEPTR);
}/* Mkspec */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkparams (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR Mkparams (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBparams)) return (_currn);
return(NULLNODEPTR);
}/* Mkparams */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkparam (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR Mkparam (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBparam)) return (_currn);
if (IsSymb (_currn, SYMBtparam)) return (Mkrule_002(_coordref, _currn));
return(NULLNODEPTR);
}/* Mkparam */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mktparam (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR Mktparam (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBtparam)) return (_currn);
return(NULLNODEPTR);
}/* Mktparam */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkname (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR Mkname (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBname)) return (_currn);
return(NULLNODEPTR);
}/* Mkname */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkliterals (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR Mkliterals (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBliterals)) return (_currn);
if (IsSymb (_currn, SYMBliteral)) return (Mkrule_003(_coordref, _currn));
return(NULLNODEPTR);
}/* Mkliterals */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkjoin (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR Mkjoin (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBjoin)) return (_currn);
return(NULLNODEPTR);
}/* Mkjoin */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mktype (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR Mktype (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBtype)) return (_currn);
return(NULLNODEPTR);
}/* Mktype */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkdoc (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR Mkdoc (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBdoc)) return (_currn);
return(NULLNODEPTR);
}/* Mkdoc */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkliteral (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR Mkliteral (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBliteral)) return (_currn);
return(NULLNODEPTR);
}/* Mkliteral */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_000 (POSITION *_coordref)
#else
NODEPTR Mkrule_000 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_000 _currn;
#ifdef __cplusplus
_currn = new _TPrule_000;
#else
_currn = (_TPPrule_000) TreeNodeAlloc (sizeof (struct _TPrule_000));
#endif
_currn->_prod = RULErule_000;
_SETCOORD(_currn)
_TERMACT_rule_000;
return ( (NODEPTR) _currn);
}/* Mkrule_000 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_001 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_001 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_001 _currn;
#ifdef __cplusplus
_currn = new _TPrule_001;
#else
_currn = (_TPPrule_001) TreeNodeAlloc (sizeof (struct _TPrule_001));
#endif
_currn->_prod = RULErule_001;
_currn->_desc1 = (_TSPparams) Mkparams (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_001: root of subtree no. 1 can not be made a params node ", 0, _coordref);
_currn->_desc2 = (_TSPparam) Mkparam (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_001: root of subtree no. 2 can not be made a param node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_001;
return ( (NODEPTR) _currn);
}/* Mkrule_001 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_002 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_002 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_002 _currn;
#ifdef __cplusplus
_currn = new _TPrule_002;
#else
_currn = (_TPPrule_002) TreeNodeAlloc (sizeof (struct _TPrule_002));
#endif
_currn->_prod = RULErule_002;
_currn->_desc1 = (_TSPtparam) Mktparam (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_002: root of subtree no. 1 can not be made a tparam node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_002;
return ( (NODEPTR) _currn);
}/* Mkrule_002 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_003 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_003 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_003 _currn;
#ifdef __cplusplus
_currn = new _TPrule_003;
#else
_currn = (_TPPrule_003) TreeNodeAlloc (sizeof (struct _TPrule_003));
#endif
_currn->_prod = RULErule_003;
_currn->_desc1 = (_TSPliteral) Mkliteral (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_003: root of subtree no. 1 can not be made a literal node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_003;
return ( (NODEPTR) _currn);
}/* Mkrule_003 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_004 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_004 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_004 _currn;
#ifdef __cplusplus
_currn = new _TPrule_004;
#else
_currn = (_TPPrule_004) TreeNodeAlloc (sizeof (struct _TPrule_004));
#endif
_currn->_prod = RULErule_004;
_currn->_desc1 = (_TSPliterals) Mkliterals (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_004: root of subtree no. 1 can not be made a literals node ", 0, _coordref);
_currn->_desc2 = (_TSPliteral) Mkliteral (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_004: root of subtree no. 2 can not be made a literal node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_004;
return ( (NODEPTR) _currn);
}/* Mkrule_004 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_005 (POSITION *_coordref, int _TERM1)
#else
NODEPTR Mkrule_005 (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPrule_005 _currn;
#ifdef __cplusplus
_currn = new _TPrule_005;
#else
_currn = (_TPPrule_005) TreeNodeAlloc (sizeof (struct _TPrule_005));
#endif
_currn->_prod = RULErule_005;
_SETCOORD(_currn)
_TERMACT_rule_005;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "lit", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_005 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_1 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_1 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_1 _currn;
#ifdef __cplusplus
_currn = new _TPrule_1;
#else
_currn = (_TPPrule_1) TreeNodeAlloc (sizeof (struct _TPrule_1));
#endif
_currn->_prod = RULErule_1;
_currn->_desc1 = (_TSPparams) Mkparams (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_1: root of subtree no. 1 can not be made a params node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_1;
return ( (NODEPTR) _currn);
}/* Mkrule_1 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_2 (POSITION *_coordref, int _TERM1)
#else
NODEPTR Mkrule_2 (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPrule_2 _currn;
#ifdef __cplusplus
_currn = new _TPrule_2;
#else
_currn = (_TPPrule_2) TreeNodeAlloc (sizeof (struct _TPrule_2));
#endif
_currn->_prod = RULErule_2;
_SETCOORD(_currn)
_TERMACT_rule_2;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "lit", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_2 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_3 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2, NODEPTR _desc3, NODEPTR _desc4, NODEPTR _desc5)
#else
NODEPTR Mkrule_3 (_coordref,_desc1,_desc2,_desc3,_desc4,_desc5)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
	NODEPTR _desc3;
	NODEPTR _desc4;
	NODEPTR _desc5;
#endif
{	_TPPrule_3 _currn;
#ifdef __cplusplus
_currn = new _TPrule_3;
#else
_currn = (_TPPrule_3) TreeNodeAlloc (sizeof (struct _TPrule_3));
#endif
_currn->_prod = RULErule_3;
_currn->_desc1 = (_TSPname) Mkname (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_3: root of subtree no. 1 can not be made a name node ", 0, _coordref);
_currn->_desc2 = (_TSPliterals) Mkliterals (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_3: root of subtree no. 2 can not be made a literals node ", 0, _coordref);
_currn->_desc3 = (_TSPjoin) Mkjoin (_coordref, _desc3);	
if (((NODEPTR)_currn->_desc3) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_3: root of subtree no. 3 can not be made a join node ", 0, _coordref);
_currn->_desc4 = (_TSPtype) Mktype (_coordref, _desc4);	
if (((NODEPTR)_currn->_desc4) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_3: root of subtree no. 4 can not be made a type node ", 0, _coordref);
_currn->_desc5 = (_TSPdoc) Mkdoc (_coordref, _desc5);	
if (((NODEPTR)_currn->_desc5) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_3: root of subtree no. 5 can not be made a doc node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_3;
return ( (NODEPTR) _currn);
}/* Mkrule_3 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_4 (POSITION *_coordref)
#else
NODEPTR Mkrule_4 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_4 _currn;
#ifdef __cplusplus
_currn = new _TPrule_4;
#else
_currn = (_TPPrule_4) TreeNodeAlloc (sizeof (struct _TPrule_4));
#endif
_currn->_prod = RULErule_4;
_SETCOORD(_currn)
_TERMACT_rule_4;
return ( (NODEPTR) _currn);
}/* Mkrule_4 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_5 (POSITION *_coordref)
#else
NODEPTR Mkrule_5 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_5 _currn;
#ifdef __cplusplus
_currn = new _TPrule_5;
#else
_currn = (_TPPrule_5) TreeNodeAlloc (sizeof (struct _TPrule_5));
#endif
_currn->_prod = RULErule_5;
_SETCOORD(_currn)
_TERMACT_rule_5;
return ( (NODEPTR) _currn);
}/* Mkrule_5 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_6 (POSITION *_coordref)
#else
NODEPTR Mkrule_6 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_6 _currn;
#ifdef __cplusplus
_currn = new _TPrule_6;
#else
_currn = (_TPPrule_6) TreeNodeAlloc (sizeof (struct _TPrule_6));
#endif
_currn->_prod = RULErule_6;
_SETCOORD(_currn)
_TERMACT_rule_6;
return ( (NODEPTR) _currn);
}/* Mkrule_6 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_7 (POSITION *_coordref)
#else
NODEPTR Mkrule_7 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_7 _currn;
#ifdef __cplusplus
_currn = new _TPrule_7;
#else
_currn = (_TPPrule_7) TreeNodeAlloc (sizeof (struct _TPrule_7));
#endif
_currn->_prod = RULErule_7;
_SETCOORD(_currn)
_TERMACT_rule_7;
return ( (NODEPTR) _currn);
}/* Mkrule_7 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_8 (POSITION *_coordref)
#else
NODEPTR Mkrule_8 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_8 _currn;
#ifdef __cplusplus
_currn = new _TPrule_8;
#else
_currn = (_TPPrule_8) TreeNodeAlloc (sizeof (struct _TPrule_8));
#endif
_currn->_prod = RULErule_8;
_SETCOORD(_currn)
_TERMACT_rule_8;
return ( (NODEPTR) _currn);
}/* Mkrule_8 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_9 (POSITION *_coordref)
#else
NODEPTR Mkrule_9 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_9 _currn;
#ifdef __cplusplus
_currn = new _TPrule_9;
#else
_currn = (_TPPrule_9) TreeNodeAlloc (sizeof (struct _TPrule_9));
#endif
_currn->_prod = RULErule_9;
_SETCOORD(_currn)
_TERMACT_rule_9;
return ( (NODEPTR) _currn);
}/* Mkrule_9 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_10 (POSITION *_coordref)
#else
NODEPTR Mkrule_10 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_10 _currn;
#ifdef __cplusplus
_currn = new _TPrule_10;
#else
_currn = (_TPPrule_10) TreeNodeAlloc (sizeof (struct _TPrule_10));
#endif
_currn->_prod = RULErule_10;
_SETCOORD(_currn)
_TERMACT_rule_10;
return ( (NODEPTR) _currn);
}/* Mkrule_10 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_11 (POSITION *_coordref)
#else
NODEPTR Mkrule_11 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_11 _currn;
#ifdef __cplusplus
_currn = new _TPrule_11;
#else
_currn = (_TPPrule_11) TreeNodeAlloc (sizeof (struct _TPrule_11));
#endif
_currn->_prod = RULErule_11;
_SETCOORD(_currn)
_TERMACT_rule_11;
return ( (NODEPTR) _currn);
}/* Mkrule_11 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_12 (POSITION *_coordref)
#else
NODEPTR Mkrule_12 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_12 _currn;
#ifdef __cplusplus
_currn = new _TPrule_12;
#else
_currn = (_TPPrule_12) TreeNodeAlloc (sizeof (struct _TPrule_12));
#endif
_currn->_prod = RULErule_12;
_SETCOORD(_currn)
_TERMACT_rule_12;
return ( (NODEPTR) _currn);
}/* Mkrule_12 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_13 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_13 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_13 _currn;
#ifdef __cplusplus
_currn = new _TPrule_13;
#else
_currn = (_TPPrule_13) TreeNodeAlloc (sizeof (struct _TPrule_13));
#endif
_currn->_prod = RULErule_13;
_currn->_desc1 = (_TSPname) Mkname (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_13: root of subtree no. 1 can not be made a name node ", 0, _coordref);
_currn->_desc2 = (_TSPdoc) Mkdoc (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_13: root of subtree no. 2 can not be made a doc node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_13;
return ( (NODEPTR) _currn);
}/* Mkrule_13 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_14 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_14 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_14 _currn;
#ifdef __cplusplus
_currn = new _TPrule_14;
#else
_currn = (_TPPrule_14) TreeNodeAlloc (sizeof (struct _TPrule_14));
#endif
_currn->_prod = RULErule_14;
_currn->_desc1 = (_TSPname) Mkname (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_14: root of subtree no. 1 can not be made a name node ", 0, _coordref);
_currn->_desc2 = (_TSPdoc) Mkdoc (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_14: root of subtree no. 2 can not be made a doc node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_14;
return ( (NODEPTR) _currn);
}/* Mkrule_14 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_15 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_15 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_15 _currn;
#ifdef __cplusplus
_currn = new _TPrule_15;
#else
_currn = (_TPPrule_15) TreeNodeAlloc (sizeof (struct _TPrule_15));
#endif
_currn->_prod = RULErule_15;
_currn->_desc1 = (_TSPname) Mkname (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_15: root of subtree no. 1 can not be made a name node ", 0, _coordref);
_currn->_desc2 = (_TSPdoc) Mkdoc (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_15: root of subtree no. 2 can not be made a doc node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_15;
return ( (NODEPTR) _currn);
}/* Mkrule_15 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_16 (POSITION *_coordref, int _TERM1)
#else
NODEPTR Mkrule_16 (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPrule_16 _currn;
#ifdef __cplusplus
_currn = new _TPrule_16;
#else
_currn = (_TPPrule_16) TreeNodeAlloc (sizeof (struct _TPrule_16));
#endif
_currn->_prod = RULErule_16;
_SETCOORD(_currn)
_TERMACT_rule_16;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "lit", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_16 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_17 (POSITION *_coordref, int _TERM1)
#else
NODEPTR Mkrule_17 (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPrule_17 _currn;
#ifdef __cplusplus
_currn = new _TPrule_17;
#else
_currn = (_TPPrule_17) TreeNodeAlloc (sizeof (struct _TPrule_17));
#endif
_currn->_prod = RULErule_17;
_SETCOORD(_currn)
_TERMACT_rule_17;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "lit", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_17 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_18 (POSITION *_coordref)
#else
NODEPTR Mkrule_18 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_18 _currn;
#ifdef __cplusplus
_currn = new _TPrule_18;
#else
_currn = (_TPPrule_18) TreeNodeAlloc (sizeof (struct _TPrule_18));
#endif
_currn->_prod = RULErule_18;
_SETCOORD(_currn)
_TERMACT_rule_18;
return ( (NODEPTR) _currn);
}/* Mkrule_18 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_19 (POSITION *_coordref, int _TERM1)
#else
NODEPTR Mkrule_19 (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPrule_19 _currn;
#ifdef __cplusplus
_currn = new _TPrule_19;
#else
_currn = (_TPPrule_19) TreeNodeAlloc (sizeof (struct _TPrule_19));
#endif
_currn->_prod = RULErule_19;
_SETCOORD(_currn)
_TERMACT_rule_19;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "ident", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_19 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_20 (POSITION *_coordref)
#else
NODEPTR Mkrule_20 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_20 _currn;
#ifdef __cplusplus
_currn = new _TPrule_20;
#else
_currn = (_TPPrule_20) TreeNodeAlloc (sizeof (struct _TPrule_20));
#endif
_currn->_prod = RULErule_20;
_SETCOORD(_currn)
_TERMACT_rule_20;
return ( (NODEPTR) _currn);
}/* Mkrule_20 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_21 (POSITION *_coordref, int _TERM1)
#else
NODEPTR Mkrule_21 (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPrule_21 _currn;
#ifdef __cplusplus
_currn = new _TPrule_21;
#else
_currn = (_TPPrule_21) TreeNodeAlloc (sizeof (struct _TPrule_21));
#endif
_currn->_prod = RULErule_21;
_SETCOORD(_currn)
_TERMACT_rule_21;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "lit", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_21 */
