-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkRadioButton objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_radio_button_writer.e,v 1.8 2000/07/10 11:31:12 elphick Exp $"

class GTK_RADIO_BUTTON_WRITER

inherit

	GTK_ATTRIBUTE_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation
		end

	CHILD

creation

	make

feature

	type: STRING is "GTK_RADIO_BUTTON"
	
	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		local
			radio_writer_list: ARRAY[GTK_RADIO_BUTTON_WRITER]
		do
			make_attribute(attr_name, tree, src)
			label := widget_tree.get_string_from_field("label")
			active := widget_tree.get_boolean_from_field("active", False)
			draw_indicator := widget_tree.get_boolean_string_from_field("draw_indicator")
			if draw_indicator = "" then
				draw_indicator := "True"
			end
			-- See if this is the first widget in the group
			group := widget_tree.get_string_from_field("group")
			if groups_list.has(group) then
				radio_writer_list := groups_list.at(group)
				radio_writer_list.add_last(Current)
			else
				!!radio_writer_list.make(0,0)
				radio_writer_list.put(Current,0)
			end
			-- Write the new list of widgets in the group
			groups_list.put(radio_writer_list, group)

		end
			
	label: STRING
	active: BOOLEAN
	draw_indicator: STRING
	group: STRING

	append_parent_creation(code: ARRAY[STRING]) is
		do
			-- If this is the first in the group
			if groups_list.at(group) @ 0 = Current then
				code.add_last("!!" + name + ".make_with_label(%""+label+"%")")
			else
				code.add_last("!!" + name + ".make_in_group_with_label(" + (groups_list.at(group) @ 0).name + ", %"" + label + "%")")
			end
			if active then
				code.add_last(name + ".set_state_down")
			else
				code.add_last(name + ".set_state_up")
			end
			add_widget_code(code)
			-- How to implement draw_indicator?
		end

	-- This is used to store the lists of radio buttons in which groups
	groups_list: DICTIONARY[ARRAY[GTK_RADIO_BUTTON_WRITER], STRING] is
		once
			!!Result.make
		end

end
