-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkCombo objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_combo_writer.e,v 1.14 2001/03/16 06:06:35 elphick Exp $"

class GTK_COMBO_WRITER

inherit

	GTK_ATTRIBUTE_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_declaration, append_parent_creation,
			add_widget_code
		end
	
	--CONTAINER -- Needed because it's possible to set the initial entry text

	CHILD

creation

	make

feature

		
	type: STRING is "GTK_COMBO"

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		local
			s: ARRAY[SIGNAL_WRITER]
		do
			make_attribute(attr_name, tree, src)
			case_sensitive := widget_tree.get_boolean_string_from_field("case_sensitive")
			use_arrows := widget_tree.get_boolean_string_from_field("use_arrows")
			use_arrows_always := widget_tree.get_boolean_string_from_field("use_arrows_always")
				
			items := widget_tree.get_string_from_field("items")
			value_in_list := widget_tree.get_string_from_field("value_in_list")
			ok_if_empty := widget_tree.get_string_from_field("ok_if_empty")
			entry := widget_tree.find_child("widget")
			if entry /= Void then
				-- save signals while we create a separate set of signals 
				-- for the combo's entry field...
				s := signals
				make_signals(entry.find_children("signal"))
				entry_signals := signals
				-- ...now restore signals
				signals := s
			end
		end
			
	entry: TAG_TREE
	case_sensitive: STRING
	use_arrows: STRING
	use_arrows_always: STRING
	items: STRING
	value_in_list: STRING
	ok_if_empty: STRING
	entry_signals: ARRAY[SIGNAL_WRITER]

	append_parent_declaration(strings: ARRAY[STRING]) is
		local
			s: ARRAY[SIGNAL_WRITER]
		do
			Precursor(strings)
			-- save signals while we deal with the signals 
			-- for the combo's entry field...
			s := signals
			signals := entry_signals
			append_signal_declarations(strings)
			-- ...now restore signals
			signals := s
		end

	append_parent_creation(code: ARRAY[STRING]) is
		local
			i, j: INTEGER
			strings: STRING
		do
			if not items.is_empty then
				!!strings.make(0)
				from
					i := 0
				until
					items.is_empty
				loop
					j := items.substring_index("%%N", 1)
					if j > 0 then
						strings.append("%""+items.substring(1, j - 1)+"%"")
						items.remove_first(j + 1)
					else
						strings.append(items)
						items.remove_last(items.count)
					end
					if not items.is_empty then
						strings.append(", ")
					end
					i := i + 1
				end
			end
			code.add_last("!!" + name + ".make")
			code.add_last(name + ".set_case_sensitive(" + case_sensitive + ")")
			code.add_last(name + ".set_use_arrows(" + use_arrows + ")")
			code.add_last(name + ".set_use_arrows_always(" + use_arrows_always + ")")
			code.add_last(name + ".set_value_in_list(" + value_in_list + 
							  ", " + ok_if_empty + ")")
			if i > 0 then
				code.add_last(name + ".set_popdown_strings(<<" + strings + ">>)")
			end
			if entry /= Void then
				code.add_last(name + ".entry.set_text(%""+
					entry.get_string_from_field("text") + "%")")
			end
			add_widget_code(code)
		end

	add_widget_code(strings: ARRAY[STRING]) is
		local
			s: ARRAY[SIGNAL_WRITER]
			t: STRING
		do
			Precursor(strings)
			s := signals
			signals := entry_signals
			t := clone(name)
			t.append(".entry")
			append_signal_code(strings, t)
			-- ...now restore signals
			signals := s
		end

end
