/* Copyright (C) 2001 2002 2003 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#ifndef FILE_LIST_H
#define FILE_LIST_H

#include "prog_defs.h"

#include <utility>

#include <gtkmm/window.h>
#include <gtkmm/table.h>
#include <gtkmm/button.h>
#include <gtkmm/buttonbox.h>
#include <gtkmm/treeview.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/treemodelcolumn.h>
#include <gtkmm/liststore.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/entry.h>
#include <gtkmm/toolbar.h>
#include <gtkmm/box.h>
#include <glibmm/ustring.h>

#if GTKMM_VERSION >= 24
#include <gtkmm/toolbutton.h>
#endif


class FileListModelColumn: public Gtk::TreeModel::ColumnRecord {
  Gtk::TreeModelColumn<Glib::ustring> file_name;
  // private constructor - only FileListDialog can create objects of this class
  FileListModelColumn(void) {add(file_name);}
public:
  friend class FileListDialog;
};

class FileListDialog: public Gtk::Window {
  static int is_file_list;
  const int standard_size;
  Gtk::Window& parent;
  bool in_exec_loop;
  Gtk::VBox file_list_box;
  Gtk::Table table;
  Gtk::Toolbar tool_bar;
  Gtk::ScrolledWindow file_list_scroll_window;
  Gtk::Button up_button;
  Gtk::Button down_button;
  Gtk::Button ok_button;
  Gtk::Button cancel_button;
  Gtk::HButtonBox button_box;
  FileListModelColumn model_column;
  Gtk::TreeView tree_view;
  Glib::RefPtr<Gtk::ListStore> list_store_r;

#if GTKMM_VERSION >= 24
  Gtk::ToolButton* view_button_p;
  Gtk::ToolButton* remove_button_p;
#else
  Gtk::Button add_button;
  Gtk::Button* view_button_p;
  Gtk::Button* remove_button_p;
#endif

  void ok_slot(void);
  void finish(void);
  Glib::ustring get_files(void);
  void set_buttons_slot(void);
  void add_file(void);
  void view_file(void);
  void remove_file_prompt(void);
  void remove_file(void);
  void move_up(void);
  void move_down(void);
  std::pair<const char*, char* const*> get_view_file_parms(const string&);
  void delete_parms(std::pair<const char*, char* const*>);

protected:
  virtual bool on_delete_event(GdkEventAny*);
public:
  sigc::signal1<void, const Glib::ustring&> accepted;

  static int get_is_file_list(void) {return is_file_list;}
  void exec(void);

  FileListDialog(const int standard_size_, Gtk::Window& window);
  ~FileListDialog(void);
};

#endif
