/* Copyright (C) 2001 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#include <gtk--/main.h>

#include "settings_help.h"

string SettingsMessagesBase::get_caption(std::vector<std::string>::size_type index) {
  if (index > captions.size()) {
    write_error("Yikes, the message index is too large in SettingsMessagesBase::get_caption.\n"
		"Please report the bug to the author.\n");
    return string(); // return empty string
  }
  else return captions[index];
}

string SettingsMessagesBase::get_message(std::vector<std::string>::size_type index) {
  if (index > messages.size()) {
    write_error("Yikes, the message index is too large in SettingsMessagesBase::get_message.\n"
		"Please report the bug to the author.\n");
    return string(); // return empty string
  }
  else return messages[index];
}

IdentityMessages::IdentityMessages(void): SettingsMessagesBase(number + 1) {

  messages[name] = "Put the name to appear on the fax top header on sent faxes here";
  captions[name] = "efax-gtk help: Name";

  messages[number] = "Put the number to appear on the fax top header on sent faxes here.  "
                     "This will also comprise the fax station ID reported to the sending "
                     "fax machine when receiving faxes";
  captions[number] = "efax-gtk help: Number";
}

ModemMessages::ModemMessages(void): SettingsMessagesBase(rings + 1) {

  messages[device] = "Put the serial device to which the modem is connected "
                     "here (if none is given, the program defaults to "
                     "/dev/modem).  Do not include the `/dev/' part of "
                     "the device name -- ie state it as `ttyS1' or `cua2', etc.  "
                     "With Linux, ttyS0 equates to COM 1, ttyS1 to COM 2, and so on";
  captions[device] = "efax-gtk help: Device";

  messages[lock] = "Put the lock file directory here.  If none is specified, the program "
                   "defaults to /var/lock";
  captions[lock] = "efax-gtk help: Lock File";

  messages[modem_class] = "With efax-0.9 you don't usually need to specify this, as "
                          "efax will work out the class of the modem.  You should "
                          "therefore usually leave this blank.  However, with "
                          "efax-0.8 the program defaults to Class 2, so if you are using "
                          "a Class 1 modem with old versions of efax specify the Class here.  "
                          "Valid values are 1 for Class 1 modems and 2.0 for Class 2.0 modems.  "
                          "With efax-0.9 you can also use the value 2 to explicitly force "
                          "the use of the Class 2 protocol";
  captions[modem_class] = "efax-gtk help: Modem Class";

  messages[dialmode] = "Valid values are `tone' and `pulse'.  If none is specified, "
                       "the program defaults to tone dialling";
  captions[dialmode] = "efax-gtk help: Dial Mode";

  messages[capabilities] = "This specifies the capabilities of the modem.  To see what "
                           "these mean do `man efax', and look at the operation of the "
                           "`-c' flag.  With efax-0.9 and a Class 2 modem, you usually "
                           "won't need to specify this and should leave it blank, as the "
                           "program will interrogate the modem.  If using an older version "
                           "of efax or a different class of modem, values which will work with "
                           "practically any 14,400 bps modem are 1,5,0,2,0,0,0,0, or "
                           "1,3,0,2,0,0,0,0 for slower ones";
  captions[capabilities] = "efax-gtk help: Capabilities";

  messages[rings] = "This defines the number of rings the modem allows to pass before "
                    "answering the telephone when in Standby mode.  Acceptable values "
                    "are 1 to 9.  If none is specified, the program defaults to 1";
  captions[rings] = "efax-gtk help: Rings";
}

ParmsMessages::ParmsMessages(void): SettingsMessagesBase(extra_parms + 1) {

  messages[init] = "This specifies the initialising `AT' commands to place the modem "
                   "in fax mode.  Specify as many of these as are needed, separated by "
                   "spaces for commands which need to be separated, but without a prepended "
                   "`AT'.  If none is specified, the program will default to "
                   "`Z &FE&D2S7=120 &C0 M1L0', which will be correct for practically all "
                   "modems";
  captions[init] = "efax-gtk help: Initialisation Parameters";

  messages[reset] = "This specifies the `AT' commands that will reset the modem.  Specify "
                    "as many commands as are needed, separated by spaces for commands "
                    "which need to be separated, but without a prepended `AT'.  If none is "
                    "specified, the program will default to `Z', which will be correct "
                    "for practically all modems";
  captions[reset] = "efax-gtk help: Reset Parameters";

  messages[extra_parms] = "This can be used to pass any other parameter to efax (do "
                          "`man efax' to see what is available).  Specify as many of these as "
                          "are needed, separated by spaces for different parameters -- eg "
                          "include `-or' to do a bit reversal during receive for Multitech "
                          "modems which require it.  Unless you have an unusual modem, leave "
                          "this blank";
  captions[extra_parms] = "efax-gtk help: Other Parameters";
}

PrintMessages::PrintMessages(void): SettingsMessagesBase(shrink + 1) {

  messages[command] = "This is the command which prints and takes postscript input "
                      "on standard input.  If none is specified, the program will default "
                      "to `lpr'";
  captions[command] = "efax-gtk help: Print Program";

  messages[shrink] = "This will determine the extent to which a printed page will "
                     "be reduced to fit within a printer's print area.  It is a percentage "
                     "-- eg 98 will shrink the page to 98% of its size.  If none is "
                     "specified no shrink will take place (ie, you can, but there is no need "
                     "to, specify 100)";
  captions[shrink] = "efax-gtk help: Print Shrink";
}

ViewMessages::ViewMessages(void): SettingsMessagesBase(res + 1) {

  messages[command] = "This is the command which views PGM (portable grey map) files.  "
                      "If the `Program takes multiple files' checkbox is not checked, then "
                      "the fax will be shown serially page by page by the viewing program's "
                      "standard input (thus, do not check the box if using xloadimage "
                      "(`xloadimage stdin') or xv (`xv -')).  Check the checkbox if the fax "
                      "viewing program can take multiple file names as its starting arguments, "
                      "in which case all the pages of the fax to be viewed will be passed as file "
                      "names to the viewing program when first invoked (thus, if using the KDE "
                      "image viewer kview, enter `kview' in the edit box and check the checkbox --  "
                      "do not prepend a '$' as you would do if editing efax-gtkrc by hand, just "
                      "check the box).   If no program is specified, the program will default to "
                      "`xloadimage stdin'";
  captions[command] = "efax-gtk help: View Program";

  messages[res] = "This will specify the resolution to which faxes to be viewed will be rendered "
                  "(in dots per inch).  If none is specified, the default is 200.  This will "
                  "affect the viewing area occupied by xloadimage or xv";
  captions[res] = "efax-gtk help: View Resolution";

}

LoggingMessages::LoggingMessages(void): SettingsMessagesBase(logfile + 1) {

  messages[logfile] = "This parameter specifies a log file to which progress on negotiations "
                      "and fax status, and errors and warnings, are logged.  If none is specified, "
                      "then no log file will be maintained.  (A log file can also be kept by "
                      "redirecting stdout and stderr -- see the README file for further details)";
  captions[logfile] = "efax-gtk help: Log File";
}

PageMessages::PageMessages(void): SettingsMessagesBase(res + 1) {

  messages[page] = "Specify the page size here.  Values accepted are a4, letter or legal.  "
                   "If none is specified the program defaults to a4";
  captions[page] = "efax-gtk help: Page Size";

  messages[res] = "This specifies the resolution to which faxes are sent.  Values "
                  "accepted are `standard' (giving 204x98) and `fine' (giving 204x196).  "
                  "If none is specified, the program defaults to fine";
  captions[res] = "efax-gtk help: Sent Fax Resolution";
}

SettingsHelpDialog::SettingsHelpDialog(const int standard_size, const string& text,
				       const string& caption, Gtk::Window& window):
                                            Gtk::Window(GTK_WINDOW_DIALOG), in_run_loop(false),
					    ok_button("OK"), label(text),
			                    table(2, 1, false), parent(window) {


  label.set_line_wrap(true);
  table.attach(label, 0, 1, 0, 1, GTK_FILL | GTK_EXPAND,
	 GTK_FILL | GTK_EXPAND, standard_size/2, standard_size/4);

  table.attach(ok_button, 0, 1, 1, 2, GTK_EXPAND,
	 GTK_EXPAND, standard_size/2, standard_size/4);

  ok_button.clicked.connect(SigC::slot(this, &SettingsHelpDialog::kill_dialog));

  add(table);

  set_title(caption);
  set_transient_for(parent);
  parent.set_sensitive(false);
  set_modal(true);

  ok_button.set_usize(standard_size * 3, standard_size);
  set_border_width(standard_size/2);

  set_position(GTK_WIN_POS_CENTER);
  set_policy(false, false, false);

  show_all();
}

void SettingsHelpDialog::run(void) {
  in_run_loop = true;
  Gtk::Main::run();
}

void SettingsHelpDialog::kill_dialog(void) {
  parent.set_sensitive(true);
  hide_all();
  if (in_run_loop) Gtk::Main::quit();
  // if we have not called run(), then this dialog is self-owning and it is safe to call `delete this'
  else delete this;
}

gint SettingsHelpDialog::delete_event_impl(GdkEventAny*) {
  kill_dialog();
  return true; // returning true prevents destroy sig being emitted
}
