/* Copyright (C) 2001 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef EFAX_CONTROLLER_H
#define EFAX_CONTROLLER_H

#ifndef CONFIG_H
#define CONFIG_H
#include "config.h"
#endif

#include <string>
#include <vector>

#include <unistd.h>

#include <gtk--/main.h>
#include <sigc++/object.h>
#include <sigc++/signal_system.h>

#include "pipes.h"
#include "prog_defs.h"


bool efax_controller_childexit_handler(pid_t, int); // returns true if the pid matches that of an
                                                    // EfaxController child process, in which
                                                    // case this function will deal with it

class EfaxController: public SigC::Object {

  Pipe_fifo stdout_pipe;
  SigC::Connection stdout_connection;
  string last_file_sent;
  void join_child(void);
  void unjoin_child(void);
  void kill_child(void);
  void save_sent_fax(void);
  string sentfax_number;
  std::vector<std::string> state_messages;
  std::vector<std::string> make_fax(std::string);
public:
  enum {inactive, sending, receive_answer, receive_takeover, receive_standby, close_child_connections, restart_standby, send_success, closedown};

  SigC::Signal1<void, const char*> stdout_message;
  SigC::Signal1<void, const char*> write_state;

  void timer_event(void);
  void display_state(void);
  static int get_state(void);

  void read_pipe_slot(gint, GdkInputCondition);
  void stop_slot(void);

  void efax_closedown(void);
  void sendfax(std::string& file, std::string& number);
  void receive(int);
  EfaxController(void);
};

#endif
