#ifndef _QEOPERATORCONFIGURATION_H
#define _QEOPERATORCONFIGURATION_H

#include <vector>

#include <qwidget.h>
#include <qhbox.h>
#include <qlineedit.h>

#include <ecasound/eca-operator.h>

#include "qeinput.h"

class QLabel;
class QLineEdit;
class QGroupBox;
class QGrid;

/**
 * Input widget for configuring ecasound operators
 */
class QEOperatorConfiguration : public QEInput {
  Q_OBJECT
 public:

  QEOperatorConfiguration (OPERATOR* op, QWidget *parent = 0, const char *name = 0);

  /**
   * Returns the resulting operator object instance
   */
  OPERATOR* result(void) const { return(operator_repp); }

  bool eventFilter(QObject *, QEvent *e);

public slots:

  virtual void update_results(void);
  void change_operator(OPERATOR* op);

private slots:

  void parameter_change_event(void);

signals:

  void parameters_changed(void);

 private:

  OPERATOR* operator_repp;
  vector<QLabel*> paramlist_rep;
  vector<QLineEdit*> inputlist_rep;
  vector<QLabel*> suggestlist_rep;

  QGrid* paramgrid_repp;
  QLabel* obj_desc_repp;
  QLabel* obj_name_repp;

  /**
   * Creates and initializes widget layout
   */
  void init_layout(void);

 public:

  virtual bool class_invariant(void) const { return(operator_repp != 0); }
};

#endif
