// ------------------------------------------------------------------------
// qeobjectmap.cpp: Object map input widget
// Copyright (C) 2000,2001 Kai Vehmanen (kaiv@wakkanet.fi)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
// ------------------------------------------------------------------------

#include <qaccel.h>
#include <qlayout.h>
#include <qlistbox.h>
#include <qlabel.h>
#include <qvgroupbox.h>
#include <qhgroupbox.h>
#include <qhbox.h>
#include <qgrid.h>

#include <string>

#include <ecasound/eca-object.h>
#include <ecasound/eca-object-map.h>

#include "qeobjectmap.h"

QEObjectMap::QEObjectMap (ECA_OBJECT_MAP* omap, QWidget *parent, const char *name) 
  : QEInput(parent, name),
    omap_rep(omap) {
  init_layout();
}

QEObjectMap::~QEObjectMap(void) { }

void QEObjectMap::init_layout(void) {
  QBoxLayout* top = new QVBoxLayout(this);

  QGroupBox* objgroup = new QVGroupBox(this, "objgroup");
  QListBox* objlist = new QListBox(objgroup, "objlist");

  empty_rep = false;
  objlist->insertItem("<none>");
  const map<string,string>& omap = omap_rep->registered_objects();
  map<string,string>::const_iterator p = omap.begin();
  while(p != omap.end()) {
    objlist->insertItem(p->second.c_str());
    ++p;
  }
  if (omap.size() == 0) empty_rep = true;
  top->addWidget(objgroup);

  objlist->setSelected(0, true);
  update_object(0);

  QObject::connect(objlist, SIGNAL(highlighted(int)), this, SLOT(update_object(int)));
}

void QEObjectMap::update_results(void) {}
void QEObjectMap::update_object(int index) {
  // --------
  REQUIRE(index >= 0);
  // --------

  object_rep = 0;
  const map<string,string>& omap = omap_rep->registered_objects();

  if (index > 0) { /* the first object is always null */
    int counter = 1;
    map<string,string>::const_iterator p = omap.begin();
    while(p != omap.end()) {
      if (counter == index) {
	object_rep = dynamic_cast<ECA_OBJECT*>(omap_rep->object(p->first));
	emit changed();
      }
      ++p;
      ++counter;
    }
  }
  else {
    object_rep = 0;
    emit changed();
  }

  // --------
  ENSURE(object_rep != 0 || empty_rep == true);
  // --------
}
