/* config.h - 2000/06/21 */
/*
 *  EasyTAG - Tag editor for MP3 and OGG files
 *  Copyright (C) 2000  Jerome Couderc <j.couderc@ifrance.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __CONFIG_H__
#define __CONFIG_H__


/***************
 * Declaration *
 ***************/

typedef enum
{
    CV_TYPE_STRING=0,
    CV_TYPE_INT,
    CV_TYPE_BOOL
} Config_Variable_Type;


typedef struct _tConfigVariable tConfigVariable;
struct _tConfigVariable
{
    char *name;                 /* Variable name written in config file */
    Config_Variable_Type type; /* Variable type: Integer, Alphabetic cf:CONFIG_VARIABLE_TYPES */
    void *var;                  /* Pointer to our variable */
};


/* 
 * Config varariables
 */
/* Common */
gint     LOAD_ON_STARTUP;
gchar    *DEFAULT_PATH_TO_MP3;
gint     SORTING_FILE_MODE;
gint     WRITE_ID3V1_TAG;
gint     WRITE_ID3V2_TAG;
gint     STRIP_TAG_WHEN_EMPTY_FIELDS;
gint     BROWSE_SUBDIR;
gint     OPEN_SELECTED_BROWSER_NODE;
gint     KEEP_TREE_BROWSER_IN_MEMORY;
gint     SAVE_CONFIG_BEFORE_EXIT;

/* User Interface */
gint     SET_MAIN_WINDOW_SIZE;
gint     MAIN_WINDOW_HEIGHT;
gint     MAIN_WINDOW_WIDTH;
gint     SET_PANE_HANDLE_POSITION1;
gint     PANE_HANDLE_POSITION1;
gint     SET_PANE_HANDLE_POSITION2;
gint     PANE_HANDLE_POSITION2;
gint     SHOW_HEADER_INFO;
gint     SHOW_COMMAND_BUTTONS;

gint     SHOW_SPIN_BUTTON;
gint     SHOW_GO_BUTTON;
gint     SHOW_FIRST_BUTTON;
gint     SHOW_PREV_BUTTON;
gint     SHOW_NEXT_BUTTON;
gint     SHOW_LAST_BUTTON;
gint     SHOW_SCAN_BUTTON;
gint     SHOW_SCAN_ALL_BUTTON;
gint     SHOW_REMOVE_BUTTON;
gint     SHOW_REMOVE_ALL_BUTTON;
gint     SHOW_UNDO_BUTTON;
gint     SHOW_UNDO_ALL_BUTTON;
gint     SHOW_REDO_BUTTON;
gint     SHOW_REDO_ALL_BUTTON;
gint     SHOW_SAVE_BUTTON;
gint     SHOW_SAVE_ALL_BUTTON;
gint     SHOW_QUIT_BUTTON;

gint     USE_COLORED_TOOLTIPS;

/* Scanner */
gint    CONVERT_UNDERSCORE_AND_P20_INTO_SPACE;
gint    CONVERT_SPACE_INTO_UNDERSCORE;
gint    OVERWRITE_TAG_FIELD;
gint    SET_DEFAULT_COMMENT;
gchar   *DEFAULT_COMMENT;
gint    SCAN_WINDOW_ON_TOP;
gint    SET_SCANNER_WINDOW_POSITION;
gint    SCANNER_WINDOW_X;
gint    SCANNER_WINDOW_Y;

/* Misc */
gint     REPLACE_ILLEGAL_CHARACTERS_IN_FILENAME;
gint     DATE_AUTO_COMPLETION;
gint     NUMBER_TRACK_FORMATED;
gint     USE_CHARACTER_SET_TRANSLATION;
gchar   *FILE_CHARACTER_SET;
gchar   *USER_CHARACTER_SET;

gint     MESSAGE_BOX_POSITION_NONE;
gint     MESSAGE_BOX_POSITION_CENTER;
gint     MESSAGE_BOX_POSITION_MOUSE;

/* Confirmation */
gint     CONFIRM_BEFORE_EXIT;
gint     CONFIRM_WRITE_TAG;
gint     CONFIRM_RENAME_FILE;
gint     CONFIRM_WRITE_PLAYLIST;

/* Scanner window */
gint     PROCESS_FILENAME_FIELD;
gint     PROCESS_TITLE_FIELD;
gint     PROCESS_ARTIST_FIELD;
gint     PROCESS_ALBUM_FIELD;
gint     PROCESS_COMMENT_FIELD;
gint     PF_CONVERT_INTO_SPACE;
gint     PF_CONVERT_SPACE;
gint     PF_CONVERT_ALL_UPPERCASE;
gint     PF_CONVERT_ALL_DOWNCASE;
gint     PF_CONVERT_FIRST_LETTER_UPPERCASE;
gint     PF_CONVERT_FIRST_LETTERS_UPPERCASE;
gint     PF_REMOVE_SPACE;
gint     PF_INSERT_SPACE;
gint     PF_ONLY_ONE_SPACE;

/* Playlist */
gchar   *PLAYLIST_NAME;
gint     PLAYLIST_USE_NAME;
gint     PLAYLIST_USE_DIR_NAME;
gint     PLAYLIST_FULL_PATH;
gint     PLAYLIST_RELATIVE_PATH;

/* Other parameters */
gint     OPTIONS_NOTEBOOK_PAGE;



/**************
 * Prototypes *
 **************/

void Init_Config_Variables (void);
void Read_Config (void);
void Display_Config (void);
void Apply_Changes (void);
void Save_Changes (void);
void Save_Config_To_File (void);
void Save_Config_Now (void);

gboolean Create_Easytag_Directory (void);

void   Save_Glist_To_File (GList *list, gchar *file);
GList *Create_Glist_From_File (gchar *file);


/* MasksList */
void   Save_Scan_Tag_Masks_List (GList *list);
GList *Load_Scan_Tag_Masks_List (void);

/* RenameFileMasksList */
void   Save_Rename_File_Masks_List (GList *list);
GList *Load_Rename_File_Masks_List (void);

/* 'DefaultPathToMp3' combobox */
GList *Load_Default_Path_To_MP3_List (void);
void   Save_Default_Path_To_MP3_List (GList *list);

/* 'DefaultComment' combobox */
GList *Load_Default_Tag_Comment_Text_List (void);
void   Save_Default_Tag_Comment_Text_List (GList *list);

/* 'TranslationTablePath' combobox */
GList *Load_Translation_Table_Path_List (void);
void   Save_Translation_Table_Path_List (GList *list);

/* 'BrowserEntry' combobox */
GList *Load_Path_Entry_List (void);
void   Save_Path_Entry_List (GList *list);

/* 'PlayListNameEntry' combobox */
GList *Load_Play_List_Name_List (void);
void Save_Play_List_Name_List (GList *list);

/* Run Program combobox */
GList *Load_Run_Program_List (void);
void Save_Run_Program_List (GList *list);


#endif /* __CONFIG_H__ */
