/* bar.h - 2000/05/05 */
/*
 *  EasyTAG - Tag editor for MP3 and OGG files
 *  Copyright (C) 2000  Jerome Couderc <j.couderc@ifrance.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __BAR_H__
#define __BAR_H__


/***************
 * Declaration *
 ***************/
GtkWidget      *MenuBar;
GtkWidget      *ProgressBar;
GtkWidget      *ToolBar;
GtkItemFactory *ItemFactory;
guint           StatusBarContext;

GtkWidget *CheckMenuItemBrowseSubdirMainMenu;

/* Tool Bar */
GtkWidget *TBFirstButton;
GtkWidget *TBPrevButton;
GtkWidget *TBNextButton;
GtkWidget *TBLastButton;
GtkWidget *TBScanButton;
GtkWidget *TBRemoveButton;
GtkWidget *TBUndoButton;
GtkWidget *TBRedoButton;
GtkWidget *TBApplyButton;
GtkWidget *TBScanAllButton;
GtkWidget *TBRemoveAllButton;
GtkWidget *TBUndoAllButton;
GtkWidget *TBRedoAllButton;
GtkWidget *TBApplyAllButton;
GtkWidget *TBStopButton;
GtkWidget *TBQuitButton;


/*
 * This values are set to find the entry into the itemfactory
 * and (un)sensitive the item. (Value 0 = not define)
 */
enum Action_Menu 
{     
    PREV = 1,
    NEXT,
    FIRST,
    LAST,
    SCAN,
    REMOVE,
    UNDO,
    REDO,
    SAVE,
    SCAN_ALL,
    REMOVE_ALL,
    UNDO_ALL,
    REDO_ALL,
    SAVE_ALL,
    LOAD_HOME_DIR,
    LOAD_DEFAULT_DIR,
    SET_PATH_AS_DEFAULT,
    RENAME_DIR,
    RECURSE,
    COLLAPSE_TREE,
    INITIALIZE_TREE,
    RELOAD_DIRECTORY,
    BROWSE_DIRECTORY_WITH,
    OPEN_OPTIONS_WINDOW,
    SAVE_CONFIG,
    OPEN_SCANNER_WINDOW,
    WRITE_PLAYLIST,
    RUN_MP3_PLAYER,
    OPEN_ABOUT_WINDOW,
    QUIT,
    SORT_ASCENDING_FILENAME,
    SORT_DESCENDING_FILENAME,
    SORT_ASCENDING_CREATION_DATE,
    SORT_DESCENDING_CREATION_DATE,
    SORT_ASCENDING_TRACK_NUMBER,
    SORT_DESCENDING_TRACK_NUMBER
};


/**************
 * Prototypes *
 **************/

GtkWidget *Create_Menu_Bar (void);
GtkWidget *Create_Status_Bar (void);
void       Statusbar_Message (gchar *message, gint with_timer);
GtkWidget *Create_Progress_Bar (void);
GtkWidget *Create_Tool_Bar (void);

void Check_Menu_Item_Toggled_Browse_Subdir (GtkWidget *checkmenuitem);
void Check_Menu_Item_Update_Browse_Subdir (void);


#endif /* __BAR_H__ */

