/* bar.c - 2000/05/05 */
/*
 *  EasyTAG - Tag editor for MP3 and OGG files
 *  Copyright (C) 2000  Jerome Couderc <j.couderc@ifrance.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <gtk/gtk.h>

#include "bar.h"
#include "easytag.h"
#include "about.h"
#include "prefs.h"
#include "setting.h"
#include "browser.h"
#include "scan.h"
#include "misc.h"
#include "mylocale.h"


/***************
 * Declaration *
 ***************/


/**************
 * Prototypes *
 **************/
void Init_Menu_Bar (void);
void Start_Timer (void);
void Menu_Item_Action (GtkWidget *widget, guint action);

GtkWidget *StatusBar = NULL;


/*************
 * Functions *
 *************/

/*
 * Menu bar
 */
void Menu_Item_Action (GtkWidget *widget, guint action)
{
    switch (action)
    {
        case SORT_ASCENDING_FILENAME:       Sort_File_list_By_Ascending_Filename();       break;
        case SORT_DESCENDING_FILENAME:      Sort_File_list_By_Descending_Filename();      break;
        case SORT_ASCENDING_CREATION_DATE:  Sort_File_List_By_Ascending_Creation_Date();  break;
        case SORT_DESCENDING_CREATION_DATE: Sort_File_List_By_Descending_Creation_Date(); break;
        case SORT_ASCENDING_TRACK_NUMBER:   Sort_File_List_By_Ascending_Track_Number();   break;
        case SORT_DESCENDING_TRACK_NUMBER:  Sort_File_List_By_Descending_Track_Number();  break;
        case FIRST:            Action_Select_First_File();   break;
        case PREV:             Action_Select_Prev_File();    break;
        case NEXT:             Action_Select_Next_File();    break;
        case LAST:             Action_Select_Last_File();    break;
        case SCAN:             Action_Scan_File();           break;
        case REMOVE:           Action_Remove_Tag();          break;
        case UNDO:             Action_Undo_File();           break;
        case REDO:             Action_Redo_File();           break;
        case SAVE:             Action_Save_File();           break;
        case SCAN_ALL:         Action_Scan_All_Files();      break;
        case REMOVE_ALL:       Action_Remove_All_Tags();     break;
        case UNDO_ALL:         Action_Undo_All_Files();      break;
        case REDO_ALL:         Action_Redo_All_Files();      break;
        case SAVE_ALL:         Action_Save_All_Files();      break;
        case LOAD_HOME_DIR:          Browser_Load_Home_Directory();    break;
        case LOAD_DEFAULT_DIR:       Browser_Load_Default_Directory(); break;
        case SET_PATH_AS_DEFAULT:    Set_Current_Path_As_Default();    break;
        case RENAME_DIR:             Browser_Open_Rename_Directory_Window();   break;
        case COLLAPSE_TREE:          Browser_Tree_Collapse();          break;
        case INITIALIZE_TREE:        Browser_Tree_Rebuild(NULL);       break;
        case RELOAD_DIRECTORY:       Browser_Reload_Directory();       break;
        case BROWSE_DIRECTORY_WITH:  Browser_Open_Run_Program_Window(); break;
        case OPEN_OPTIONS_WINDOW:    Open_OptionsWindow();             break;
        case SAVE_CONFIG:            Save_Config_Now();                break;
        case OPEN_SCANNER_WINDOW:    Open_ScannerWindow();             break;
        case WRITE_PLAYLIST:         Open_Write_Playlist_Window();     break;
        case RUN_MP3_PLAYER:         Run_Xmms();                       break;
        case OPEN_ABOUT_WINDOW:      Show_About_Window();              break;
        case QUIT:                   Quit_MainWindow();                break;
        default: g_warning("No menu action defined for this item!");   break;
    }
}

GtkWidget *Create_Menu_Bar (void)
{
    // This can be defined out of the function, but '_(' must be replaced by 'N_('
    GtkItemFactoryEntry MenuItems[] = 
    {
      {_("/_File"),                  NULL,             NULL,                 0,        "<Branch>"},
      {_("/File/tearoff"),           NULL,             NULL,                 0,        "<Tearoff>"},
      {_("/File/Sort List..."),      NULL,             NULL,                 0,        "<Branch>"},
      {_("/File/Sort List.../tearoff"),      NULL,     NULL,                 0,        "<Tearoff>"},
      {_("/File/Sort List.../Ascending by filename..."),      NULL,     Menu_Item_Action, SORT_ASCENDING_FILENAME,  "<Item>"},
      {_("/File/Sort List.../Descending by filename..."),     NULL,     Menu_Item_Action, SORT_DESCENDING_FILENAME, "<Item>"},
      {_("/File/Sort List.../sep"),                           NULL,     NULL,             0,                        "<Separator>"},
      {_("/File/Sort List.../Ascending by creation date..."), NULL,     Menu_Item_Action, SORT_ASCENDING_CREATION_DATE,  "<Item>"},
      {_("/File/Sort List.../Descending by creation date..."),NULL,     Menu_Item_Action, SORT_DESCENDING_CREATION_DATE, "<Item>"},
      {_("/File/Sort List.../sep"),                           NULL,     NULL,             0,                            "<Separator>"},
      {_("/File/Sort List.../Ascending by track number..."),  NULL,     Menu_Item_Action, SORT_ASCENDING_TRACK_NUMBER,  "<Item>"},
      {_("/File/Sort List.../Descending by track number..."), NULL,     Menu_Item_Action, SORT_DESCENDING_TRACK_NUMBER, "<Item>"},
      {_("/File/sep"),               NULL,             NULL,                 0,        "<Separator>"},
      {_("/File/_First File"),       "<control>F",     Menu_Item_Action,     FIRST,    "<Item>"},
      {_("/File/_Previous File"),    "<control>P",     Menu_Item_Action,     PREV,     "<Item>"},
      {_("/File/_Next File"),        "<control>N",     Menu_Item_Action,     NEXT,     "<Item>"},
      {_("/File/_Last File"),        "<control>L",     Menu_Item_Action,     LAST,     "<Item>"},
      {_("/File/sep"),               NULL,             NULL,                 0,        "<Separator>"},
      {_("/File/_Scan File"),        "<control>S",     Menu_Item_Action,     SCAN,     "<Item>"},
      {_("/File/_Remove Tag"),       "<control>R",     Menu_Item_Action,     REMOVE,   "<Item>"},
      {_("/File/_Undo Last File Changes"),"<control>U",Menu_Item_Action,     UNDO,     "<Item>"},
      {_("/File/R_edo Last File Changes"),"<control>E",Menu_Item_Action,     REDO,     "<Item>"},
      {_("/File/S_ave File"),        "<control>A",     Menu_Item_Action,     SAVE,     "<Item>"},
      {_("/File/sep"),               NULL,             NULL,                 0,        "<Separator>"},
      {_("/File/Scan All Files"),    "<control><alt>S",Menu_Item_Action,     SCAN_ALL, "<Item>"},
      {_("/File/Remove All Tags"),   "<control><alt>R",Menu_Item_Action,     REMOVE_ALL,"<Item>"},
      {_("/File/Undo Last Changes"), "<control><alt>U",Menu_Item_Action,     UNDO_ALL,  "<Item>"},
      {_("/File/Redo Last Changes"), "<control><alt>E",Menu_Item_Action,     REDO_ALL,  "<Item>"},
      {_("/File/Save All Files"),    "<control><alt>A",Menu_Item_Action,     SAVE_ALL, "<Item>"},
      {_("/File/sep"),               NULL,             NULL,                 0,         "<Separator>"},
      {_("/File/_Quit"),             "<control>Q",     Menu_Item_Action,     QUIT,      "<Item>"},

      {_("/_Browser"),                            NULL,            NULL,     0,         "<Branch>"},
      {_("/Browser/tearoff"),                     NULL,            NULL,     0,         "<Tearoff>"},
      {_("/Browser/Go to _Home Directory"),       "<control>H",    Menu_Item_Action,LOAD_HOME_DIR,      "<Item>"},
      {_("/Browser/Go to _Default Directory"),    "<control>D",    Menu_Item_Action,LOAD_DEFAULT_DIR,   "<Item>"},
      {_("/Browser/Set _Current Path as Default"),NULL,            Menu_Item_Action,SET_PATH_AS_DEFAULT,"<Item>"},
      {_("/Browser/sep"),                         NULL,            NULL,      0,         "<Separator>"},
      {_("/Browser/Rename Directory"),            "<control><shift>D",Menu_Item_Action,RENAME_DIR,"<Item>"},
      {_("/Browser/Reload Directory"),            NULL,            Menu_Item_Action,RELOAD_DIRECTORY,"<Item>"},
//      {_("/Browser/Browse Directory with..."),    NULL,            Menu_Item_Action,BROWSE_DIRECTORY_WITH,"<Item>"},
      {_("/Browser/sep"),                         NULL,            NULL,      0,         "<Separator>"},
      {_("/Browser/Browse _Sub-directories"),     "<control><shift>S",NULL,   RECURSE,   "<CheckItem>"},
      {_("/Browser/sep"),                         NULL,            NULL,      0,         "<Separator>"},
      {_("/Browser/_Collapse Tree"),              "<control><shift>C",Menu_Item_Action,COLLAPSE_TREE,  "<Item>"},
      {_("/Browser/_Refresh Tree"),               "<control><shift>R",Menu_Item_Action,INITIALIZE_TREE,"<Item>"},
   
      {_("/_Settings"),                        NULL,        NULL,             0,                  "<Branch>"},
      {_("/Settings/tearoff"),                 NULL,        NULL,             0,                  "<Tearoff>"},
      {_("/Settings/_Preferences"),            "<alt>P",    Menu_Item_Action, OPEN_OPTIONS_WINDOW,"<Item>"},
      {_("/Settings/sep"),                     NULL,        NULL,             0,                  "<Separator>"},
      {_("/Settings/Save _Configuration Now"), "<alt>C",    Menu_Item_Action, SAVE_CONFIG,        "<Item>"},
    
      {_("/_Misc"),                            NULL,        NULL,             0,                  "<Branch>"},
      {_("/Misc/tearoff"),                     NULL,        NULL,             0,                  "<Tearoff>"},
      {_("/Misc/_Open Scanner Window"),        "<alt>O",    Menu_Item_Action, OPEN_SCANNER_WINDOW,"<Item>"},
      {_("/Misc/sep"),                         NULL,        NULL,             0,                  "<Separator>"},
      {_("/Misc/Write Playlist"),              NULL,        Menu_Item_Action, WRITE_PLAYLIST,     "<Item>"},
      {_("/Misc/Run _XMMS"),                   "<alt>X",    Menu_Item_Action, RUN_MP3_PLAYER,     "<Item>"},
    
      {_("/_Help"),                   NULL,        NULL,             0,                  "<LastBranch>"},
      {_("/Help/tearoff"),            NULL,        NULL,             0,                  "<Tearoff>"},
      {_("/Help/_About..."),          "<alt>A",    Menu_Item_Action, OPEN_ABOUT_WINDOW,  "<Item>"}
    };

    GtkWidget *HandleBar;
    GtkAccelGroup *accel_group;


    /* Calculate number of items into the menu */
    gint NbrMenuItems = sizeof(MenuItems) / sizeof(MenuItems[0]); 
    
    /* Accelerator group */
    accel_group = gtk_accel_group_new();

    /* Factory creation */
    ItemFactory = gtk_item_factory_new(GTK_TYPE_MENU_BAR,"<Main>",accel_group);

    /* Menu item creation */
    gtk_item_factory_create_items(ItemFactory,NbrMenuItems,MenuItems,NULL);
    gtk_accel_group_attach (accel_group,GTK_OBJECT(MainWindow));

    /* Get menu bar from factory */
    MenuBar = gtk_item_factory_get_widget (ItemFactory,"<Main>");

    /* Menu is into a handlebar */
    HandleBar = gtk_handle_box_new();
    gtk_container_add(GTK_CONTAINER(HandleBar),MenuBar);

    Init_Menu_Bar();

    gtk_widget_show_all(HandleBar);
    return HandleBar;
}


/*
 * Initialize some items of the main menu
 */
void Init_Menu_Bar (void)
{
    CheckMenuItemBrowseSubdirMainMenu = gtk_item_factory_get_widget_by_action(ItemFactory,RECURSE);
    if (CheckMenuItemBrowseSubdirMainMenu)
    {
        gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(CheckMenuItemBrowseSubdirMainMenu),BROWSE_SUBDIR);
        gtk_signal_connect(GTK_OBJECT(CheckMenuItemBrowseSubdirMainMenu),"toggled",
            (GtkSignalFunc)Check_Menu_Item_Toggled_Browse_Subdir,NULL);
    }

    /* If entry not implemented */
/*    widget = gtk_item_factory_get_widget_by_action(ItemFactory,UNDO);
    if (widget) gtk_widget_set_sensitive (widget,FALSE);
 */
}

/*
 * Callback to update state of check button to browse subdir into menu
 */
void Check_Menu_Item_Toggled_Browse_Subdir (GtkWidget *checkmenuitem)
{
    BROWSE_SUBDIR = GTK_CHECK_MENU_ITEM(checkmenuitem)->active;
    Check_Menu_Item_Update_Browse_Subdir();
}
void Check_Menu_Item_Update_Browse_Subdir (void)
{
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(CheckMenuItemBrowseSubdirMainMenu),BROWSE_SUBDIR);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(CheckMenuItemBrowseSubdirPopupMenu),BROWSE_SUBDIR);
}









/*
 * Status bar
 */
GtkWidget *Create_Status_Bar (void)
{
    StatusBar = gtk_statusbar_new();
    /* Specify a size to avoid statubar resizing if the message is too long */
    gtk_widget_set_usize(StatusBar,200,-1);
    /* Create serie */
    StatusBarContext = gtk_statusbar_get_context_id(GTK_STATUSBAR(StatusBar),"Messages");

    Statusbar_Message(_("Ready to start..."),TRUE);

    gtk_widget_show(StatusBar);
    return StatusBar;
}

gboolean Stop_Timer (void)
{
    gtk_statusbar_pop(GTK_STATUSBAR(StatusBar),StatusBarContext);
    return FALSE;    /* Stop the timer */
}

void Start_Timer (void)
{
    static guint TimerId = 0;

    if (TimerId)
    {
        gtk_timeout_remove(TimerId);
        TimerId = 0;
    }
    TimerId = gtk_timeout_add(4000,(GtkFunction)Stop_Timer,NULL);
}

/*
 * Send a message to the status bar
 *  - with_timer: if TRUE, the message will be displayed during 4s
 *                if FALSE, the message will be displayed up to the next posted message
 */
void Statusbar_Message (gchar *message, gint with_timer)
{
    if (!StatusBar) return;

    /* Pop last message */
    gtk_statusbar_pop(GTK_STATUSBAR(StatusBar),StatusBarContext);

    /* Push the given message */
    gtk_statusbar_push(GTK_STATUSBAR(StatusBar),StatusBarContext,message);
    while (gtk_events_pending())
        gtk_main_iteration();

    if (with_timer)
        Start_Timer();
}







/*
 * Progress bar
 */
GtkWidget *Create_Progress_Bar (void)
{
    ProgressBar = gtk_progress_bar_new();

    gtk_widget_show(ProgressBar);
    return ProgressBar;
}







/*
 * Tools bar
 */
#include "../pixmaps/first.xpm"
#include "../pixmaps/previous.xpm"
#include "../pixmaps/next.xpm"
#include "../pixmaps/last.xpm"
#include "../pixmaps/scan.xpm"
#include "../pixmaps/scan_all.xpm"
#include "../pixmaps/delete.xpm"
#include "../pixmaps/delete_all.xpm"
#include "../pixmaps/undo.xpm"
#include "../pixmaps/undo_all.xpm"
#include "../pixmaps/redo.xpm"
#include "../pixmaps/redo_all.xpm"
#include "../pixmaps/save.xpm"
#include "../pixmaps/save_all.xpm"
#include "../pixmaps/stop.xpm"
#include "../pixmaps/exit.xpm"
GtkWidget *Create_Tool_Bar (void)
{
    GtkWidget *HandleBar;
    GtkWidget *Icon;

    ToolBar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL,GTK_TOOLBAR_ICONS);
    gtk_container_set_border_width(GTK_CONTAINER(ToolBar),2);
    gtk_toolbar_set_space_size(GTK_TOOLBAR(ToolBar),15);
    gtk_toolbar_set_space_style(GTK_TOOLBAR(ToolBar),GTK_TOOLBAR_SPACE_LINE);
    gtk_toolbar_set_button_relief(GTK_TOOLBAR(ToolBar),GTK_RELIEF_NONE);

    Set_Tips_Color(GTK_TOOLBAR(ToolBar)->tooltips);

    /* Toolbar is into a handlebar */
    HandleBar = gtk_handle_box_new();
    gtk_container_add(GTK_CONTAINER(HandleBar),ToolBar);

    /*
     * Buttons: First, Prev, Next, Last.
     */
    Icon = Create_Pixmap_Icon(first_xpm);
    TBFirstButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Select first file"),NULL,
                                            Icon,GTK_SIGNAL_FUNC(Action_Select_First_File),NULL);
    Icon = Create_Pixmap_Icon(previous_xpm);
    TBPrevButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Select previous file"),NULL,
                                           Icon,GTK_SIGNAL_FUNC(Action_Select_Prev_File),NULL);
    Icon = Create_Pixmap_Icon(next_xpm);
    TBNextButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Select next file"),NULL,
                                           Icon,GTK_SIGNAL_FUNC(Action_Select_Next_File),NULL);
    Icon = Create_Pixmap_Icon(last_xpm);
    TBLastButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Select last file"),NULL,
                                           Icon,GTK_SIGNAL_FUNC(Action_Select_Last_File),NULL);

    /* Separator */    
    gtk_toolbar_append_space(GTK_TOOLBAR(ToolBar));

    /*
     * Buttons for actions for only ONE file.
     */
    Icon = Create_Pixmap_Icon(scan_xpm);
    TBScanButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Scan this file"),
                                           NULL,Icon,GTK_SIGNAL_FUNC(Action_Scan_File),NULL);
    Icon = Create_Pixmap_Icon(delete_xpm);
    TBRemoveButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Remove tag of this file"),
                                             NULL,Icon,GTK_SIGNAL_FUNC(Action_Remove_Tag),NULL);
    Icon = Create_Pixmap_Icon(undo_xpm);
    TBUndoButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Undo last changes of this file"),
                                           NULL,Icon,GTK_SIGNAL_FUNC(Action_Undo_File),NULL);
////    gtk_signal_connect(GTK_OBJECT(TBUndoButton),"enter",GTK_SIGNAL_FUNC(Undo_Display_Last_Info),NULL);

    Icon = Create_Pixmap_Icon(redo_xpm);
    TBRedoButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Redo last changes of this file"),
                                           NULL,Icon,GTK_SIGNAL_FUNC(Action_Redo_File),NULL);
////    gtk_signal_connect(GTK_OBJECT(TBUndoButton),"enter",GTK_SIGNAL_FUNC(Undo_Display_Last_Info),NULL);

    Icon = Create_Pixmap_Icon(save_xpm);
    TBApplyButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Save this file"),
                                            NULL,Icon,GTK_SIGNAL_FUNC(Action_Save_File),NULL);

    /* Separator */    
    gtk_toolbar_append_space(GTK_TOOLBAR(ToolBar));

    /*
     * Buttons for actions for ALL files.
     */
    Icon = Create_Pixmap_Icon(scan_all_xpm);
    TBScanAllButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Scan all files"),NULL,
                                              Icon,GTK_SIGNAL_FUNC(Action_Scan_All_Files),NULL);
    Icon = Create_Pixmap_Icon(delete_all_xpm);
    TBRemoveAllButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Remove all tags"),NULL,
                                                Icon,GTK_SIGNAL_FUNC(Action_Remove_All_Tags),NULL);
    Icon = Create_Pixmap_Icon(undo_all_xpm);
    TBUndoAllButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Undo last changes"),NULL,
                                              Icon,GTK_SIGNAL_FUNC(Action_Undo_All_Files),NULL);
    Icon = Create_Pixmap_Icon(redo_all_xpm);
    TBRedoAllButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Redo last changes"),NULL,
                                              Icon,GTK_SIGNAL_FUNC(Action_Redo_All_Files),NULL);
    Icon = Create_Pixmap_Icon(save_all_xpm);
    TBApplyAllButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Save all files"),NULL,
                                               Icon,GTK_SIGNAL_FUNC(Action_Save_All_Files),NULL);

    /* Separator */    
    gtk_toolbar_append_space(GTK_TOOLBAR(ToolBar));

    /*
     * Button to stop (for example: stop the subdirectories search).
     */
    Icon = Create_Pixmap_Icon(stop_xpm);
    TBStopButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Stop the search"),NULL,
                                           Icon,GTK_SIGNAL_FUNC(Action_Stop_Recursive_File_Search),NULL);

    /* Separator */    
    gtk_toolbar_append_space(GTK_TOOLBAR(ToolBar));

    /*
     * Button to quit.
     */
    Icon = Create_Pixmap_Icon(exit_xpm);
    TBQuitButton = gtk_toolbar_append_item(GTK_TOOLBAR(ToolBar),NULL,_("Exit EasyTAG!"),NULL,
                                           Icon,GTK_SIGNAL_FUNC(Quit_MainWindow),NULL);

    gtk_widget_show_all(HandleBar);
    return HandleBar;
}

