/*
 * DEVICE dependent, type1 font
 */

#include	"defs.h"
#include	"emit.h"
#include	"global.h"
#include	"bifont.h"
#include	"ps.h"

dev_t1_initfontdict(fe, t1path)
struct font_entry *fe;
char *t1path;
{
    char t1font[BUFSIZ];
    struct psbiops po;

    fe->k = dev_newdevfont();
    read_type1_file(t1path, t1font);
    t1tobi(tfmfinfo(fe)->tfm_bf, t1font);
    get_tfm_psbiops(fe, &po);
    psfindfontop(psfname(fe->k), &po);
    fe->ncdl = 0;
}

read_type1_file(fn, t1f)
char *fn, *t1f;
{
    FILE *fp;
    char buffer[BUFSIZ], *b;
    char *type1id1 = "%!FontType1-";
    char *type1id2 = "%!PS-AdobeFont-";
    BOOLEAN istype1;
    int idlen, i;
    int len, n, c;

    if ((fp = fopen(fn, "r")) == NULL)
	Fatal("Unable to open type1font file %s", fn);
    if (getc(fp) == 0x80) {
	if (getc(fp) == 1) {
	    (void)fseek(fp, (long)6, 0);
	} else
	    Fatal("%s is not type1font file", fn);
    }
    for (b = buffer; (c = getc(fp)) != '\r' && c != '\n'; b++)
	*b = c;
    *b = '\0';
    if (!strncmp(buffer, type1id1, strlen(type1id1))) {
	idlen = strlen(type1id1);
	istype1 = TRUE;
    } else if (!strncmp(buffer, type1id2, strlen(type1id2))) {
	idlen = strlen(type1id2);
	istype1 = TRUE;
    } else
	istype1 = FALSE;
    if (!istype1) {
	(void)fclose(fp);
	Fatal("%s is not type1font file", fn);
    }

    for (i = idlen; buffer[i] != ':'; i++)
	;
    for (i++; buffer[i] == ' '; i++)
	;
    for (; buffer[i] != ' '; t1f++, i++)
	*t1f = buffer[i];
    *t1f = '\0';
    
    (void)fseek(fp, (long)1, 0);
    EMIT(outfp, "%%%%BeginFont: %s\n", t1f);
    copy_type1(fp, fn);
    EMIT(outfp, "%%%%EndnFont\n");
    (void)fclose(fp);
}

#define	BINLEN	32
static char *hexdig = "0123456789ABCDEF";

/* TODO: select only marked chars */
copy_type1(fp, fn)
FILE *fp;
char *fn;
{
    int len, i, n, c;

    for (;;) {
	switch (c = getc(fp)) {
	case 1:
	    for (len = 0, n = 1, i = 1; i <= 4; n = n*256, i++)
		len += n*getc(fp);
	    for (; len > 0; --len) {
		if ((c = getc(fp)) == EOF)
		    Fatal("premature EOF in type1 font file %s", fn);
		if (c == '\r')
		    EMITC('\n');
		else
		    EMITC(c);
	    }
	    break;
	case 2:
	    for (len = 0, n = 1, i = 1; i <= 4; n = n*256, i++)
		len += n*getc(fp);
	    for (i = 0; len > 0; --len) {
		if ((c = getc(fp)) == EOF)
		    Fatal("premature EOF in type1 font file %s", fn);
		EMITC(hexdig[c>>4]);
		EMITC(hexdig[c&0xf]);
		i++;
		if (i == BINLEN) {
		    EMITC('\n');
		    i = 0;
		}
	    }
	    if (i > 0)
		EMITC('\n');
	    break;
	case 3:
	    return;
	}
    }
}
