/* 
    Copyright (C) 2000 Marcus Metzler (mocm@convergence.de)
    for convergence integrated media

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef PICS_H
#define PICS_H

static const gchar *xpm_cap[] = {
	"16 16 4 1",
	"  c None",
	". c #000000",
	"R c #FF0000",
	"W c #FFFFFF",
	"................",
	"................",
	"................",
	".......WWW......",
	".....WRRRRRW....",
	"....WRRRRRRRW...",
	"...WRRRRRRRRRW..",
	"...WRRRRRRRRRW..",
	"...WRRRRRRRRRW..",
	"...WRRRRRRRRRW..",
	"....WRRRRRRRW...",
	".....WRRRRRW....",
	".......WWW......",
	"................",
	"................",
	"................",
};

static const gchar *xpm_over[] = {
	"16 16 4 1",
	"  c None",
	". c #000000",
	"R c #FF0000",
	"W c #FFFFFF",
	"................",
	".......  .......",
	".......  .......",
	".......  .......",
	"...R...  ...R...",
	"..RWR..  ..RWR..",
	"...RWR.  .RWR...",
	"....RWR  RWR....",
	".....RWRRWR.....",
	"......RWWR......",
	"......RWWR......",
	".....RWRRWR.....",
	"....RWR..RWR....",
	"...RWR....RWR...",
	"..RWR......RWR..",
	"...R........R...",
};

static const gchar *xpm_tv[] = {
	"16 16 4 1",
	"  c None",
	". c #888888",
	"R c #FF0000",
	"W c #FFFFFF",
	"..............W.",
	".............W..",
	".....W......W...",
	"......W....W....",
	".......W..W.....",
	"........WW......",
	"...WWWWWWWWWWW..",
	"..W.RRRRR.....W.",
	"..W...R.......W.",
	"..W...RR.....RW.",
	"..W...R.R...R.W.",
	"..W...R..R.R..W.",
	"..W.......R...W.",
	"...WWWWWWWWWW...",
	"................",
	"................",
};

static const gchar *xpm_vid0[] = {
	"16 16 4 1",
	"  c None",
	". c #888888",
	"R c #FF0000",
	"W c #FFFFFF",
	"................",
	"................",
	"....WWWWWWWW..R.",
	"...WWWW.....WR..",
	"...WW.......RW..",
	"...WW......RW...",
	"...WW.....R.W...",
	".RRRRRRRRR..W...",
	".RRRRRRRRR..W...",
	"...WW.....R.W...",
	"...WW......RW...",
	"...WW.......RR..",
	"...WW.......W.R.",
	"...WWWWWWWWWW...",
	"....WWWWWWWW....",
	"................",
};

static const gchar *xpm_vid1[] = {
	"16 16 4 1",
	"  c None",
	". c #888888",
	"R c #FF0000",
	"W c #FFFFFF",
	"................",
	"................",
	"......WWWW....R.",
	"......WWWW...R..",
	"......WWWW..R...",
	"......WWWW.R....",
	"......WWWWR.....",
	".RRRRRWWWW......",
	".RRRRRWWWW......",
	"......WWWWR.....",
	"......WWWW.R....",
	"......WWWW..RR..",
	"......WWWW....R.",
	"......WWWW......",
	"................",
	"................",
};

static const gchar *xpm_vid2[] = {
	"16 16 4 1",
	"  c None",
	". c #888888",
	"R c #FF0000",
	"W c #FFFFFF",
	"................",
	"................",
	"...WWWWWWW....R.",
	"..W.....WWW..R..",
	".........WWWR...",
	"..........WW....",
	"..........WW....",
	".RRRRR..WWW.....",
	".RRRRR.WWW......",
	"......WWW.R.....",
	"....WWWw...R....",
	"...WWw......RR..",
	"..WWWWWWWWWWW.R.",
	"..WWWWWWWWWW....",
	"................",
	"................",
};

static const gchar *xpm_vid3[] = {
	"16 16 4 1",
	"  c None",
	". c #888888",
	"R c #FF0000",
	"W c #FFFFFF",
	"................",
	"................",
	"...WWWWW......R.",
	"..W.....W....R..",
	"........W...R...",
	"........W..R....",
	"........W.R.....",
	".RRRRWWW........",
	".RRRRWWWWW......",
	".......WWWR.....",
	".........W.R....",
	".........WW.RR..",
	"...WW.....W...R.",
	"...WWWWWWW......",
	"................",
	"................",
};

static const gchar *xpm_vid4[] = {
	"16 16 4 1",
	"  c None",
	". c #888888",
	"R c #FF0000",
	"W c #FFFFFF",
	"................",
	"................",
	"...........WW.R.",
	"..........WWWR..",
	"........WWWWW...",
	".......WW.WWW...",
	"......WW..WWW...",
	".RRRRWW...WWW...",
	".RRRWW....WWW...",
	"....WWWWWWWWWW..",
	"....WWWWWWWWWW..",
	"..........WWWR..",
	"..........WWW.R.",
	"..........WWW...",
	"................",
	"................",
};

static const gchar *xpm_up[] = {
	"16 16 4 1",
	"  c None",
	". c #888888",
	"R c #FF0000",
	"W c #000000",
	"........R.......",
	"......WWWWW.....",
	"....WWWWWWWW....",
	"...WWWWWWWWWW...",
	"..W..WWWWWW..W..",
	".....WWWWWW.....",
	".....WWWWWW.....",
	".....WWWWWW.....",
	".....WWWWWW.....",
	".....WWWWWW.....",
	".....WWWWWW.....",
	".....WWWWWW.....",
	".....WWWWWW.....",
	".....WWWWWW.....",
	".....RRRRRR.....",
	"................",
};

static const gchar *xpm_down[] = {
	"16 16 4 1",
	"  c None",
	". c #888888",
	"R c #FF0000",
	"W c #000000",
	"................",
	".....RRRRRR.....",
	".....WWWWWW.....",
	".....WWWWWW.....",
	".....WWWWWW.....",
	".....WWWWWW.....",
	".....WWWWWW.....",
	".....WWWWWW.....",
	".....WWWWWW.....",
	".....WWWWWW.....",
	".....WWWWWW.....",
	"..W..WWWWWW..W..",
	"...WWWWWWWWWW...",
	"....WWWWWWWW....",
	"......WWWWW.....",
	"........R.......",
};


static const gchar *xpm_full[] = {
	"16 16 4 1",
	"  c None",
	". c #000000",
	"R c #FF0000",
	"W c #FFFFFF",
	"........W.......",
	".......WWW......",
	".WW.....W.....WW",
	".WW....WWW...,WW",
	"...W...RRR...W..",
	"....WR.....RW...",
	"...WR.......RW..",
	".WWWR.......RWWW",
	"..WWR.......RWW.",
	"...WR.......RW..",
	"....WR.....RW...",
	"...W...RRR...W..",
	".WW....WWW....WW",
	".WW.....W.....WW",
	".......WWW......",
	"........W.......",
};

static char * tux_xpm[] = {
"64 64 4 1",
" 	c None",
".	c #F8FCF8",
"+	c #000000",
"@	c #EFE51C",
"............................++++++++............................",
".........................+++++++++++++..........................",
"........................++++++++++++++++........................",
".......................++++++++++++++++++.......................",
"......................++++++++++++++.+++++......................",
"......................++++++++++++++++++++......................",
"......................+++++++++++++++++++++.....................",
".....................+++++++++++++++++++++++....................",
".....................+++++++++++++++++++++++....................",
".....................+++++++++++++..++++++++....................",
".....................+++...+++++......++++++....................",
".....................++.....++++......++++++....................",
".....................++.+++.++++.++++..+++++....................",
".....................++.++++++++.++++..+++++....................",
"......................+.++++@@@+++++++.+++++....................",
"......................++.+@@@@@++@++++++++++....................",
"......................+++@@@@@@@@@@@@@+++++++...................",
"......................++@@@@@@@@@@@@@@@++++++...................",
"......................++@@@@@@@@@@@@+++++++++...................",
"......................+++@+@@@@@+@@@+++++++++...................",
"......................+++@@+++++@@@+...+++.+++..................",
"......................++.+@@@@@@@@+....++++++++.................",
".....................+++..+@@@@@++......+++++++.................",
".....................++....+++++........++++++++................",
"....................+++..................++++++++...............",
"...................+++...................+++++++++..............",
"..................+++.....................++++++++..............",
".................++++.....................+++++++++.............",
"................++++.......................+++++++++............",
"...............+++++.......................++++++++++...........",
"...............+++++........................++++++++++..........",
"..............+++++.........................++++++++++..........",
"..............+++++..........................++++++++++.........",
".............+++++............................+++++++++.........",
".............++++.............................++++++++++........",
"............+++++.............................++++++++++........",
"............++++..............................+++++++++++.......",
"............++++..............................+++++++++++.......",
"...........+++++...............................++++++++++.......",
"..........+++++................................+++++++++++......",
".........++++++................................+++++++++++......",
".........++++++................................+++++++++++......",
".........++++++................................+++++++++++......",
".........++++++................................+++++++++++......",
".........++@@++................................+++++++++++......",
".........+@@@@++.............................++++++++++++.......",
"........++@@@@@+++..........................+@@+++++++++++......",
".......++@@@@@@@+++........................+@@@++++++++@@+......",
"......++@@@@@@@@@+++.......................+@@@+++++++@@@++.....",
"..++++@@@@@@@@@@@@++++.....................+@@@@+++++@@@@@+.....",
".+@++@@@@@@@@@@@@@++++++...................+@@@@@@@@@@@@@@++....",
"+@@@@@@@@@@@@@@@@@@+++++...................+@@@@@@@@@@@@@@@@+...",
"+@@@@@@@+@@@@@@@@@@@+++++..................+@@@@@@@@+@@@@@@@@+..",
"+@@@@@@@@++@@@@@@@@@@+++..................++@@@@@@@+@@@@@@@@@@+.",
"+@@@@@@@@@@+@@@@@@@@@+..................++++@@@@@@@+@@@@@@@@@@@+",
"+@@@@@@@@@@@++@@@@@@@@+................+++++@@@@@@+@@@@@@@@@@@@+",
"+@@@@@@@@@@@@@+@@@@@@@+..............+++++++@@@@@+@@@@@@@@@@@++.",
"+@@@@@@@@@@@@@@++@@@@@@++.........+++++++++@@@@@@+@@@@@@@@@++...",
"+@@@@@@@@@@@@@@@@+@@@@@++++++++++++++++++++@@@@@+@@@@@@@@++.....",
".+++@@@@@@@@@@@@@@@@@@@+++++++++++++++++++++@@@@@@@@@@@++.......",
"..++++++++@@@@@@@@@@@@++++++++++++++++++++++@@@@@@@@@++.........",
"........++++++@@@@@@++++++................++++@@@@@++...........",
".............++++++++++...................++++++++++............",
"................++++++......................+++++++............."};


static char * xpm_tux2[] = {
"16 16 47 1",
" 	c None",
".	c #F8FCF8",
"+	c #E8ECE8",
"@	c #4E4F4E",
"#	c #000000",
"$	c #5D5E5D",
"%	c #6C6E6C",
"&	c #101010",
"*	c #9B9E9B",
"=	c #3E3F3E",
"-	c #8C8E8C",
";	c #3D3C22",
">	c #5A560A",
",	c #2E2E21",
"'	c #7C7E7C",
")	c #C2BA17",
"!	c #EFE51C",
"~	c #E0D71A",
"{	c #4B4809",
"]	c #BABDBA",
"^	c #A8A666",
"/	c #78720E",
"(	c #B7B675",
"_	c #D9DCD9",
":	c #AAADAA",
"<	c #1F201F",
"[	c #CACDCA",
"}	c #96922D",
"|	c #A59F21",
"1	c #898747",
"2	c #0F0E02",
"3	c #9A9C8D",
"4	c #A8A874",
"5	c #A5A02F",
"6	c #B3AC15",
"7	c #D1C818",
"8	c #6A6836",
"9	c #B5B03E",
"0	c #96911F",
"a	c #B4AD23",
"b	c #1E1D04",
"c	c #B6B24C",
"d	c #C9CBBC",
"e	c #9A9B80",
"f	c #A7A558",
"g	c #4C4C32",
"h	c #78741C",
".....+@##$+.....",
".....%###&@.....",
".....@%#*=#.....",
".....-;>,@#.....",
".....')!~{#]....",
".....%^/(_&=....",
"....*-....$#'...",
"...]&....._##:..",
"...=-......%#<..",
"..[&.......*##:.",
"..==.......]##'.",
".+}|:.....+1#23.",
"45!!/$....]~/)5+",
"6!67!8+..+@!)~!9",
"0!!77a%'$&b!)~cd",
"_]ef/g*]]]'>hd.."};


static char *xpm_bigdown[] = {
"    64    64        2            1",
"+ c #EFE51C",
". c #000000",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................+..............+........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................+..............+........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................+..............+........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................+..............+........................",
"........................++++++++++++++++........................",
"........................+..............+........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
".................++++++++++++++++++++++++++++++.................",
"..................++++++++++++++++++++++++++++..................",
"...................++++++++++++++++++++++++++...................",
"....................++++++++++++++++++++++++....................",
".....................++++++++++++++++++++++.....................",
"......................++++++++++++++++++++......................",
".......................++++++++++++++++++.......................",
"........................++++++++++++++++........................",
".........................++++++++++++++.........................",
"..........................++++++++++++..........................",
"...........................++++++++++...........................",
"............................++++++++............................",
".............................++++++.............................",
"..............................++++..............................",
"...............................++...............................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
};


/* XPM */
static char *xpm_bigup[] = {
"    64    64        2            1",
"+ c #EFE51C",
". c #000000",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"...............................++...............................",
"..............................++++..............................",
".............................++++++.............................",
"............................++++++++............................",
"...........................++++++++++...........................",
"..........................++++++++++++..........................",
".........................++++++++++++++.........................",
"........................++++++++++++++++........................",
".......................++++++++++++++++++.......................",
"......................++++++++++++++++++++......................",
".....................++++++++++++++++++++++.....................",
"....................++++++++++++++++++++++++....................",
"...................++++++++++++++++++++++++++...................",
"..................++++++++++++++++++++++++++++..................",
".................++++++++++++++++++++++++++++++.................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................+..............+........................",
"........................++++++++++++++++........................",
"........................+..............+........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................+..............+........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................+..............+........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................+..............+........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"........................++++++++++++++++........................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
};



static char * dvb_xpm[] = {
"64 69 1198 2",
"  	c None",
". 	c #FFFFFF",
"+ 	c #A5A5A5",
"@ 	c #464646",
"# 	c #575757",
"$ 	c #A6A6A6",
"% 	c #F6F6F6",
"& 	c #D9D9D9",
"* 	c #474747",
"= 	c #B1B1B1",
"- 	c #D2D2D2",
"; 	c #454545",
"> 	c #AAAAAA",
", 	c #B9B9B9",
"' 	c #4A4A4A",
") 	c #686868",
"! 	c #E8E8E8",
"~ 	c #828282",
"{ 	c #0C0C0C",
"] 	c #3A3A3A",
"^ 	c #313131",
"/ 	c #0B0B0B",
"( 	c #9B9B9B",
"_ 	c #F4F4F4",
": 	c #343434",
"< 	c #484848",
"[ 	c #FCFCFC",
"} 	c #8B8B8B",
"| 	c #1A1A1A",
"1 	c #CDCDCD",
"2 	c #9E9E9E",
"3 	c #101010",
"4 	c #3B3B3B",
"5 	c #414141",
"6 	c #909090",
"7 	c #838383",
"8 	c #202020",
"9 	c #BCBCBC",
"0 	c #DCDCDC",
"a 	c #555555",
"b 	c #3E3E3E",
"c 	c #E3E3E3",
"d 	c #808080",
"e 	c #141414",
"f 	c #CFCFCF",
"g 	c #434343",
"h 	c #535353",
"i 	c #EFEFEF",
"j 	c #9C9C9C",
"k 	c #131313",
"l 	c #585858",
"m 	c #616161",
"n 	c #232323",
"o 	c #CBCBCB",
"p 	c #FBFBFB",
"q 	c #7D7D7D",
"r 	c #2F2F2F",
"s 	c #DADADA",
"t 	c #C6C6C6",
"u 	c #666666",
"v 	c #252525",
"w 	c #FDFDFD",
"x 	c #0F0F0F",
"y 	c #363636",
"z 	c #3F3F3F",
"A 	c #111111",
"B 	c #8E8E8E",
"C 	c #191919",
"D 	c #939393",
"E 	c #878787",
"F 	c #1E1E1E",
"G 	c #656565",
"H 	c #4B4B4B",
"I 	c #080808",
"J 	c #2A2A2A",
"K 	c #E9E9E9",
"L 	c #FEFEFE",
"M 	c #181818",
"N 	c #858585",
"O 	c #9D9D9D",
"P 	c #090909",
"Q 	c #444444",
"R 	c #D8D8D8",
"S 	c #A0A0A0",
"T 	c #050505",
"U 	c #676767",
"V 	c #0E0E0E",
"W 	c #070707",
"X 	c #151515",
"Y 	c #9F9F9F",
"Z 	c #F2F2F2",
"` 	c #E5E5E5",
" .	c #F0F0F0",
"..	c #F8F8F8",
"+.	c #F1F1F1",
"@.	c #E4E4E4",
"#.	c #E6E6E6",
"$.	c #F9F9F9",
"%.	c #F5F4F5",
"&.	c #FEFEFF",
"*.	c #FEFFFE",
"=.	c #FEFFFD",
"-.	c #FEFEFD",
";.	c #FFFFFE",
">.	c #FFFEFF",
",.	c #FCFDFD",
"'.	c #BFBFC2",
").	c #B7BCBE",
"!.	c #C8C9CA",
"~.	c #E3E2E1",
"{.	c #FCFCFB",
"].	c #EDEDED",
"^.	c #C3C9CA",
"/.	c #A1A9AC",
"(.	c #334853",
"_.	c #284957",
":.	c #2B4A57",
"<.	c #BFC3C5",
"[.	c #FFFFFD",
"}.	c #FFFEFE",
"|.	c #FEFFFF",
"1.	c #F8F6F6",
"2.	c #A8B1B4",
"3.	c #536D7E",
"4.	c #164A64",
"5.	c #0A4562",
"6.	c #0A4663",
"7.	c #094A6C",
"8.	c #0C4C6A",
"9.	c #3C5A68",
"0.	c #C7CACA",
"a.	c #FDFFFF",
"b.	c #FEFDFD",
"c.	c #C3C7C5",
"d.	c #4B6672",
"e.	c #0A4665",
"f.	c #084E6E",
"g.	c #0D5171",
"h.	c #105374",
"i.	c #115573",
"j.	c #125675",
"k.	c #165978",
"l.	c #1D5C7A",
"m.	c #375C6C",
"n.	c #CFD2D2",
"o.	c #FDFEFD",
"p.	c #C9C9C9",
"q.	c #28495B",
"r.	c #054968",
"s.	c #0B5171",
"t.	c #115373",
"u.	c #1A5B7A",
"v.	c #1C5D7B",
"w.	c #1E5D7C",
"x.	c #205F7D",
"y.	c #256280",
"z.	c #215C77",
"A.	c #5E6E74",
"B.	c #F6F3F3",
"C.	c #BDBFC0",
"D.	c #274A5C",
"E.	c #064564",
"F.	c #114159",
"G.	c #154F6A",
"H.	c #23607D",
"I.	c #256380",
"J.	c #266481",
"K.	c #266581",
"L.	c #286683",
"M.	c #286581",
"N.	c #2A6684",
"O.	c #2D5B72",
"P.	c #C0C2C4",
"Q.	c #E4E4E2",
"R.	c #354753",
"S.	c #023D59",
"T.	c #45555E",
"U.	c #9EA1A1",
"V.	c #8A959A",
"W.	c #325B71",
"X.	c #286582",
"Y.	c #1E536D",
"Z.	c #1A475D",
"`.	c #24607C",
" +	c #285F7C",
".+	c #8D989F",
"++	c #F4F4F3",
"@+	c #71777A",
"#+	c #083E5B",
"$+	c #475B66",
"%+	c #E3E2E3",
"&+	c #F3F3F3",
"*+	c #FCFDFC",
"=+	c #B3B7B8",
"-+	c #225974",
";+	c #286481",
">+	c #416271",
",+	c #969A9B",
"'+	c #AFADAC",
")+	c #55666E",
"!+	c #265B76",
"~+	c #5E7885",
"{+	c #CBCCCC",
"]+	c #1C3F51",
"^+	c #15445B",
"/+	c #A4A6A7",
"(+	c #F1F1F0",
"_+	c #949493",
":+	c #4D4D4B",
"<+	c #204B60",
"[+	c #1D475A",
"}+	c #9B9B9C",
"|+	c #EFF0EF",
"1+	c #C8C9C8",
"2+	c #395967",
"3+	c #25617E",
"4+	c #496777",
"5+	c #EDEEEF",
"6+	c #F8F9F9",
"7+	c #5D686F",
"8+	c #054563",
"9+	c #334F5C",
"0+	c #D0D0CE",
"a+	c #F4F4F5",
"b+	c #B1B2B2",
"c+	c #58585A",
"d+	c #464545",
"e+	c #132D3B",
"f+	c #60676A",
"g+	c #4E4E4D",
"h+	c #DDDDDC",
"i+	c #F7F7F6",
"j+	c #DBDCDC",
"k+	c #47616F",
"l+	c #24617D",
"m+	c #365768",
"n+	c #E7E8E7",
"o+	c #CACAC9",
"p+	c #1E3D4F",
"q+	c #094F6F",
"r+	c #475862",
"s+	c #DEDEDD",
"t+	c #E8E9EB",
"u+	c #8B8B88",
"v+	c #28241E",
"w+	c #33281B",
"x+	c #3A2912",
"y+	c #524E4A",
"z+	c #414243",
"A+	c #DBDBDB",
"B+	c #F7F8F6",
"C+	c #C3C4C3",
"D+	c #2D5367",
"E+	c #276381",
"F+	c #2C4A5A",
"G+	c #E0E0E1",
"H+	c #898F95",
"I+	c #0A4462",
"J+	c #105576",
"K+	c #345361",
"L+	c #A08D75",
"M+	c #97682D",
"N+	c #7C4D0C",
"O+	c #B56805",
"P+	c #AC6304",
"Q+	c #E08406",
"R+	c #B26A05",
"S+	c #6C5E4C",
"T+	c #E9E9EA",
"U+	c #E4E4E3",
"V+	c #5B676D",
"W+	c #225B77",
"X+	c #26637F",
"Y+	c #28424E",
"Z+	c #E2E2E2",
"`+	c #EAEAEA",
" @	c #425B67",
".@	c #094E6E",
"+@	c #15506C",
"@@	c #6A5021",
"#@	c #BD6D07",
"$@	c #D67B05",
"%@	c #C17106",
"&@	c #EE8B07",
"*@	c #AB6405",
"=@	c #F08D09",
"-@	c #FD9506",
";@	c #BB7412",
">@	c #8E8477",
",@	c #80878C",
"'@	c #254F65",
")@	c #296682",
"!@	c #25607C",
"~@	c #2A3D46",
"{@	c #E7E7E7",
"]@	c #0F465F",
"^@	c #0E5375",
"/@	c #244B5A",
"(@	c #B66908",
"_@	c #E08207",
":@	c #FB9209",
"<@	c #FF9608",
"[@	c #FF9408",
"}@	c #FF9607",
"|@	c #FF9508",
"1@	c #FF9407",
"2@	c #F89406",
"3@	c #864F07",
"4@	c #183B4C",
"5@	c #2A6583",
"6@	c #245D77",
"7@	c #2F3B41",
"8@	c #EAE9E9",
"9@	c #CBCDCE",
"0@	c #3D5661",
"a@	c #084C6D",
"b@	c #145777",
"c@	c #1A5775",
"d@	c #6D4D19",
"e@	c #E08006",
"f@	c #FD9308",
"g@	c #FE9508",
"h@	c #FE9407",
"i@	c #FB9407",
"j@	c #F39008",
"k@	c #DB8107",
"l@	c #704205",
"m@	c #153A48",
"n@	c #24627F",
"o@	c #235972",
"p@	c #3F464B",
"q@	c #EEEEED",
"r@	c #B7C0C4",
"s@	c #28404B",
"t@	c #06415F",
"u@	c #216281",
"v@	c #223F48",
"w@	c #8D5206",
"x@	c #EA8707",
"y@	c #F89108",
"z@	c #EE8C08",
"A@	c #D37E08",
"B@	c #C97606",
"C@	c #BB6D05",
"D@	c #C07104",
"E@	c #694F1E",
"F@	c #144F6C",
"G@	c #266381",
"H@	c #296583",
"I@	c #225773",
"J@	c #474D51",
"K@	c #FFFEFD",
"L@	c #A6B3B9",
"M@	c #23485B",
"N@	c #04354B",
"O@	c #0B5071",
"P@	c #155675",
"Q@	c #205F7E",
"R@	c #236180",
"S@	c #13506E",
"T@	c #303123",
"U@	c #874F04",
"V@	c #9E5B03",
"W@	c #BF6F06",
"X@	c #C97607",
"Y@	c #CE7D0A",
"Z@	c #996415",
"`@	c #404D3F",
" #	c #1E546D",
".#	c #25627F",
"+#	c #235B77",
"@#	c #434F53",
"##	c #EFEEEE",
"$#	c #F5F6F6",
"%#	c #90A1A9",
"&#	c #104259",
"*#	c #042F42",
"=#	c #0F5474",
"-#	c #1C5C7A",
";#	c #25637F",
">#	c #175878",
",#	c #0B4966",
"'#	c #303F38",
")#	c #574A27",
"!#	c #66552A",
"~#	c #474A38",
"{#	c #1E4853",
"]#	c #0C4B6B",
"^#	c #195C7C",
"/#	c #296483",
"(#	c #296582",
"_#	c #296581",
":#	c #25617C",
"<#	c #2E404A",
"[#	c #F6F6F5",
"}#	c #849197",
"|#	c #174960",
"1#	c #042D40",
"2#	c #084764",
"3#	c #0E5273",
"4#	c #185978",
"5#	c #225F7D",
"6#	c #205D7A",
"7#	c #115374",
"8#	c #054B6D",
"9#	c #074B6C",
"0#	c #0A4E6E",
"a#	c #0D5071",
"b#	c #155777",
"c#	c #1F5E7C",
"d#	c #256480",
"e#	c #286482",
"f#	c #2E6885",
"g#	c #2F6885",
"h#	c #1E4556",
"i#	c #AAABAB",
"j#	c #F8F8F7",
"k#	c #969A9C",
"l#	c #0E3E56",
"m#	c #073146",
"n#	c #063F5A",
"o#	c #0C5173",
"p#	c #1E5D7A",
"q#	c #22617E",
"r#	c #24607D",
"s#	c #22607E",
"t#	c #1B5A7B",
"u#	c #125573",
"v#	c #145776",
"w#	c #1A5B78",
"x#	c #1E5B79",
"y#	c #21607C",
"z#	c #26627F",
"A#	c #276382",
"B#	c #3B718D",
"C#	c #4F798C",
"D#	c #59727C",
"E#	c #4F636B",
"F#	c #546C78",
"G#	c #7B8183",
"H#	c #90989B",
"I#	c #1A4357",
"J#	c #073449",
"K#	c #073951",
"L#	c #125473",
"M#	c #1B5B79",
"N#	c #215F7C",
"O#	c #215D79",
"P#	c #235C77",
"Q#	c #29566E",
"R#	c #426372",
"S#	c #526E7B",
"T#	c #4D666F",
"U#	c #4A6673",
"V#	c #27566E",
"W#	c #205C79",
"X#	c #225F7E",
"Y#	c #276481",
"Z#	c #3E728B",
"`#	c #59798A",
" $	c #636C73",
".$	c #616363",
"+$	c #7C7B7C",
"@$	c #929293",
"#$	c #979796",
"$$	c #767777",
"%$	c #6D6D6D",
"&$	c #EFEFEE",
"*$	c #FDFDFB",
"=$	c #B8BBBF",
"-$	c #143F53",
";$	c #0A445E",
">$	c #063248",
",$	c #105373",
"'$	c #175877",
")$	c #1D5D7B",
"!$	c #1D5670",
"~$	c #456372",
"{$	c #839298",
"]$	c #A8ADAE",
"^$	c #CFCECD",
"/$	c #D8D6D4",
"($	c #D7D7D6",
"_$	c #D6D3D3",
":$	c #A5A8A9",
"<$	c #536B78",
"[$	c #31677F",
"}$	c #577C8F",
"|$	c #61686D",
"1$	c #747374",
"2$	c #A09F9F",
"3$	c #C1C1C1",
"4$	c #C8C8C8",
"5$	c #C5C5C5",
"6$	c #C4C4C4",
"7$	c #BFBFBF",
"8$	c #A3A3A3",
"9$	c #B9BFC1",
"0$	c #2C4C5D",
"a$	c #0C4A66",
"b$	c #073349",
"c$	c #175775",
"d$	c #1B5976",
"e$	c #315B6F",
"f$	c #879398",
"g$	c #D0D0D0",
"h$	c #DBDAD9",
"i$	c #D9DADA",
"j$	c #DADADB",
"k$	c #DBDADB",
"l$	c #DADBDA",
"m$	c #E2E1E1",
"n$	c #CFCECF",
"o$	c #6A6F72",
"p$	c #696C6D",
"q$	c #AEAFAE",
"r$	c #D3D3D3",
"s$	c #D1D1D1",
"t$	c #4E4E4E",
"u$	c #545454",
"v$	c #F7F7F7",
"w$	c #D9DCDC",
"x$	c #2E4E5C",
"y$	c #0C4D69",
"z$	c #07374F",
"A$	c #074663",
"B$	c #0B5172",
"C$	c #145574",
"D$	c #195775",
"E$	c #3C5F71",
"F$	c #AFB1B4",
"G$	c #D2D2D3",
"H$	c #7B7B7B",
"I$	c #7B7C7C",
"J$	c #8C8C8D",
"K$	c #DCDBDC",
"L$	c #DEDEDE",
"M$	c #E3E2E2",
"N$	c #ECECEB",
"O$	c #747474",
"P$	c #959495",
"Q$	c #C0C0C0",
"R$	c #CACACA",
"S$	c #DFDFDF",
"T$	c #6A6A6A",
"U$	c #DCDEDF",
"V$	c #4B626D",
"W$	c #104965",
"X$	c #0C425B",
"Y$	c #074260",
"Z$	c #0A4F71",
"`$	c #115472",
" %	c #185875",
".%	c #3D6172",
"+%	c #B9BBBD",
"@%	c #E1E1E0",
"#%	c #727172",
"$%	c #616061",
"%%	c #E7E6E6",
"&%	c #D9D9DA",
"*%	c #F1F0F0",
"=%	c #A2A3A2",
"-%	c #6B6C6C",
";%	c #AEAFAD",
">%	c #CBC9CA",
",%	c #D1D2D1",
"'%	c #DEDFDF",
")%	c #FAFAFA",
"!%	c #E0E0E0",
"~%	c #6F6F6F",
"{%	c #687981",
"]%	c #10425A",
"^%	c #0E4C6A",
"/%	c #063950",
"(%	c #074F70",
"_%	c #0D5270",
":%	c #165876",
"<%	c #23546D",
"[%	c #A6ABAC",
"}%	c #DFDFDE",
"|%	c #777677",
"1%	c #2B2B2B",
"2%	c #A7A7A7",
"3%	c #5B5C5B",
"4%	c #A5A5A6",
"5%	c #EAE9EA",
"6%	c #7D7E7D",
"7%	c #C3C3C3",
"8%	c #CCCBCB",
"9%	c #F2F1F2",
"0%	c #949494",
"a%	c #F6F7F7",
"b%	c #909BA0",
"c%	c #14455D",
"d%	c #073147",
"e%	c #084866",
"f%	c #0D5172",
"g%	c #145575",
"h%	c #1B5571",
"i%	c #7D8D94",
"j%	c #DEDCDC",
"k%	c #D4D4D4",
"l%	c #5E5E5E",
"m%	c #4D4D4D",
"n%	c #626262",
"o%	c #EEEEEE",
"p%	c #C8C7C8",
"q%	c #B3B3B3",
"r%	c #646464",
"s%	c #AFB5B7",
"t%	c #214858",
"u%	c #145674",
"v%	c #0A3F58",
"w%	c #07364C",
"x%	c #0C5072",
"y%	c #135474",
"z%	c #195978",
"A%	c #3F6473",
"B%	c #C5C7C6",
"C%	c #E1E1E1",
"D%	c #494949",
"E%	c #6E6E6E",
"F%	c #8C8C8C",
"G%	c #9C9C9E",
"H%	c #4F5051",
"I%	c #BABDC0",
"J%	c #D4D6D7",
"K%	c #2D4C5C",
"L%	c #185474",
"M%	c #0E506E",
"N%	c #052636",
"O%	c #0A4D6D",
"P%	c #115375",
"Q%	c #195A77",
"R%	c #1C5672",
"S%	c #98A0A3",
"T%	c #DBDBDA",
"U%	c #DAD9D8",
"V%	c #777777",
"W%	c #919191",
"X%	c #797979",
"Y%	c #888888",
"Z%	c #ABABAB",
"`%	c #D6D6D6",
" &	c #B2B1B2",
".&	c #454C51",
"+&	c #9DABB1",
"@&	c #F1F2F3",
"#&	c #697B84",
"$&	c #174A62",
"%&	c #165878",
"&&	c #09435D",
"*&	c #062C40",
"=&	c #0D5273",
"-&	c #1D5B79",
";&	c #2C576A",
">&	c #CDCBCA",
",&	c #DBDADA",
"'&	c #F5F5F5",
")&	c #CCCCCC",
"!&	c #787878",
"~&	c #9A9A9A",
"{&	c #A1A1A1",
"]&	c #B1B0B1",
"^&	c #B6B6B5",
"/&	c #56676F",
"(&	c #7C949F",
"_&	c #ADB4B8",
":&	c #1A4458",
"<&	c #1A5978",
"[&	c #0D4D6D",
"}&	c #0B3141",
"|&	c #08374C",
"1&	c #125474",
"2&	c #1B5A78",
"3&	c #1D5A78",
"4&	c #6D818C",
"5&	c #E0E0DD",
"6&	c #D8D9DA",
"7&	c #DDDDDD",
"8&	c #ECECEC",
"9&	c #A8A8A8",
"0&	c #404040",
"a&	c #C7C7C7",
"b&	c #D5D5D5",
"c&	c #CECECE",
"d&	c #587584",
"e&	c #4C7081",
"f&	c #F1F2F1",
"g&	c #546872",
"h&	c #1A526D",
"i&	c #205167",
"j&	c #748791",
"k&	c #596062",
"l&	c #093D58",
"m&	c #1C5D79",
"n&	c #225872",
"o&	c #939DA2",
"p&	c #DCDCDB",
"q&	c #B8B8B8",
"r&	c #717171",
"s&	c #353535",
"t&	c #7F7F7F",
"u&	c #5B5B5B",
"v&	c #B3B3B2",
"w&	c #979699",
"x&	c #2F2F2E",
"y&	c #527C94",
"z&	c #2E596D",
"A&	c #F0EFEE",
"B&	c #B7BCBF",
"C&	c #275368",
"D&	c #55717E",
"E&	c #CCCECE",
"F&	c #4F5659",
"G&	c #0B4360",
"H&	c #1A5A78",
"I&	c #205E7C",
"J&	c #2D5C74",
"K&	c #B6B9BA",
"L&	c #D9DAD9",
"M&	c #E3E3E2",
"N&	c #707070",
"O&	c #BEBEBE",
"P&	c #565656",
"Q&	c #B6B6B6",
"R&	c #556268",
"S&	c #346E8A",
"T&	c #255369",
"U&	c #E2E2E0",
"V&	c #ACB1B2",
"W&	c #8C979E",
"X&	c #E4E5E5",
"Y&	c #FEFDFE",
"Z&	c #3D464C",
"`&	c #0B4763",
" *	c #215E7B",
".*	c #3D6579",
"+*	c #C5C9CA",
"@*	c #D9D9D8",
"#*	c #E5E4E5",
"$*	c #BABABA",
"%*	c #898989",
"&*	c #252527",
"**	c #4F6F7E",
"=*	c #25546C",
"-*	c #DCDDDE",
";*	c #FAFBFC",
">*	c #FCFDFE",
",*	c #F7F9FB",
"'*	c #D1D0CE",
")*	c #4F412E",
"!*	c #353A2B",
"~*	c #274B55",
"{*	c #1C5873",
"]*	c #516B79",
"^*	c #DADBD9",
"/*	c #E5E5E6",
"(*	c #BBBBBB",
"_*	c #8F8F8F",
":*	c #BDBDBD",
"<*	c #171716",
"[*	c #56666F",
"}*	c #1D3F4E",
"|*	c #25607E",
"1*	c #24536B",
"2*	c #B2ABA2",
"3*	c #84735C",
"4*	c #8E7F6A",
"5*	c #A58A63",
"6*	c #A86F29",
"7*	c #C37208",
"8*	c #804E0A",
"9*	c #5D4821",
"0*	c #5C6665",
"a*	c #D6D4D5",
"b*	c #C2C2C2",
"c*	c #ADADAD",
"d*	c #292828",
"e*	c #474E52",
"f*	c #315D75",
"g*	c #364347",
"h*	c #2D5F78",
"i*	c #24546C",
"j*	c #BDB0A1",
"k*	c #B86B0A",
"l*	c #D87C04",
"m*	c #B56605",
"n*	c #CD7404",
"o*	c #F89107",
"p*	c #FB9208",
"q*	c #F68E07",
"r*	c #DB8007",
"s*	c #A96103",
"t*	c #805926",
"u*	c #BEBBB6",
"v*	c #DAD9DA",
"w*	c #A4A4A4",
"x*	c #ECEAEB",
"y*	c #929291",
"z*	c #B1B1B2",
"A*	c #B2B3B2",
"B*	c #222222",
"C*	c #191818",
"D*	c #656E72",
"E*	c #435761",
"F*	c #BDBBB9",
"G*	c #4C7285",
"H*	c #22536B",
"I*	c #DEDCDD",
"J*	c #E9EBEF",
"K*	c #967342",
"L*	c #FB9406",
"M*	c #F58F07",
"N*	c #F99307",
"O*	c #EB8908",
"P*	c #EA8A07",
"Q*	c #FF9509",
"R*	c #F99108",
"S*	c #E58505",
"T*	c #955605",
"U*	c #896C4A",
"V*	c #D6D7D9",
"W*	c #5A5A5A",
"X*	c #E0DFDE",
"Y*	c #878786",
"Z*	c #BAB9B9",
"`*	c #A9A9A9",
" =	c #252626",
".=	c #131413",
"+=	c #545455",
"@=	c #323333",
"#=	c #677C87",
"$=	c #265469",
"%=	c #D7DBDD",
"&=	c #825B29",
"*=	c #FF9707",
"==	c #EB8C07",
"-=	c #D88007",
";=	c #F19007",
">=	c #CF7A06",
",=	c #FB9408",
"'=	c #FE9409",
")=	c #FB9107",
"!=	c #CF7805",
"~=	c #824B07",
"{=	c #B3ACA3",
"]=	c #DBDBDC",
"^=	c #DBDCDB",
"/=	c #EBEBEB",
"(=	c #F9FAFA",
"_=	c #B1B1B0",
":=	c #858485",
"<=	c #CECECD",
"[=	c #312E2D",
"}=	c #403F3D",
"|=	c #767677",
"1=	c #B2B2B1",
"2=	c #B3B1B2",
"3=	c #484C4F",
"4=	c #536C78",
"5=	c #EDEDEC",
"6=	c #EBEDEF",
"7=	c #836337",
"8=	c #EA8906",
"9=	c #EC8C07",
"0=	c #DD8307",
"a=	c #DA8207",
"b=	c #D98307",
"c=	c #DE8308",
"d=	c #FF9307",
"e=	c #EE8A07",
"f=	c #A55F05",
"g=	c #857053",
"h=	c #DAD9DB",
"i=	c #D4D3D4",
"j=	c #403D37",
"k=	c #AF8752",
"l=	c #B99669",
"m=	c #626567",
"n=	c #BEBFBE",
"o=	c #898889",
"p=	c #808284",
"q=	c #FAFAF9",
"r=	c #EEF1F5",
"s=	c #9E753E",
"t=	c #F79206",
"u=	c #D87F07",
"v=	c #D98108",
"w=	c #D67F07",
"x=	c #D57F06",
"y=	c #C57406",
"z=	c #ED8D07",
"A=	c #FF9409",
"B=	c #FE9408",
"C=	c #FA9107",
"D=	c #D57C06",
"E=	c #7A5325",
"F=	c #C3C0BE",
"G=	c #969696",
"H=	c #262626",
"I=	c #B2B2B2",
"J=	c #9F9E9E",
"K=	c #7B7D7F",
"L=	c #4B4B4A",
"M=	c #8C714B",
"N=	c #E29F41",
"O=	c #DD840B",
"P=	c #C29253",
"Q=	c #92959A",
"R=	c #7C7C7C",
"S=	c #888886",
"T=	c #7F7F80",
"U=	c #333333",
"V=	c #BAB9BA",
"W=	c #DADCDD",
"X=	c #AF7628",
"Y=	c #FE9707",
"Z=	c #FC9308",
"`=	c #E68707",
" -	c #C87706",
".-	c #C77507",
"+-	c #EE8C09",
"@-	c #F89007",
"#-	c #FD9206",
"$-	c #E78707",
"%-	c #8A5107",
"&-	c #A1988E",
"*-	c #303030",
"=-	c #6D6D6C",
"--	c #464648",
";-	c #44413E",
">-	c #987B53",
",-	c #DD993B",
"'-	c #F59814",
")-	c #D67F06",
"!-	c #E98804",
"~-	c #CB9247",
"{-	c #555557",
"]-	c #929393",
"^-	c #D0CFCC",
"/-	c #CC801E",
"(-	c #FE9609",
"_-	c #F18E07",
":-	c #E78909",
"<-	c #F48D07",
"[-	c #AE6403",
"}-	c #806F5D",
"|-	c #E0E1E1",
"1-	c #DFE0DF",
"2-	c #D8D8D9",
"3-	c #888887",
"4-	c #525151",
"5-	c #343333",
"6-	c #343433",
"7-	c #484034",
"8-	c #8A6E49",
"9-	c #DA9C45",
"0-	c #FF9C14",
"a-	c #FE9307",
"b-	c #D98006",
"c-	c #DD8306",
"d-	c #CF7905",
"e-	c #D8932F",
"f-	c #423D36",
"g-	c #07090A",
"h-	c #685F51",
"i-	c #D9D6D0",
"j-	c #B97721",
"k-	c #FE9608",
"l-	c #FD9408",
"m-	c #D37A05",
"n-	c #554222",
"o-	c #6F838F",
"p-	c #B7BBBE",
"q-	c #CCCDCE",
"r-	c #805D31",
"s-	c #BC761B",
"t-	c #F69211",
"u-	c #FE950A",
"v-	c #FF9308",
"w-	c #F69208",
"x-	c #E28608",
"y-	c #E78B0A",
"z-	c #B99157",
"A-	c #383A3B",
"B-	c #282727",
"C-	c #484847",
"D-	c #7F7D7A",
"E-	c #BA8946",
"F-	c #CEC5B7",
"G-	c #E9EAEE",
"H-	c #82663E",
"I-	c #F08E06",
"J-	c #FE9308",
"K-	c #FF9309",
"L-	c #FF940A",
"M-	c #FE9406",
"N-	c #E98605",
"O-	c #584C29",
"P-	c #074D6D",
"Q-	c #26576F",
"R-	c #5F7A86",
"S-	c #8B949B",
"T-	c #A9AAAD",
"U-	c #C2C4C3",
"V-	c #ACB2B5",
"W-	c #6F7979",
"X-	c #895108",
"Y-	c #D47B05",
"Z-	c #FD9208",
"`-	c #E8992E",
" ;	c #5C5348",
".;	c #B3B3B4",
"+;	c #BBBCBA",
"@;	c #978B7B",
"#;	c #BE8334",
"$;	c #E1DFDC",
"%;	c #B4B1AE",
"&;	c #9B6014",
"*;	c #F79106",
"=;	c #FE9507",
"-;	c #E88606",
";;	c #453B22",
">;	c #074768",
",;	c #0B4F70",
"';	c #0E5371",
");	c #154D66",
"!;	c #1F5169",
"~;	c #205269",
"{;	c #19516D",
"];	c #264248",
"^;	c #9E5B04",
"/;	c #BE8B42",
"(;	c #323233",
"_;	c #CFD1D3",
":;	c #A88C67",
"<;	c #C2A376",
"[;	c #F8F9F8",
"};	c #AEA8A0",
"|;	c #B47420",
"1;	c #F38D05",
"2;	c #FE9708",
"3;	c #BA6D07",
"4;	c #30281C",
"5;	c #1A2930",
"6;	c #0C3549",
"7;	c #074867",
"8;	c #084F71",
"9;	c #085070",
"0;	c #084D6E",
"a;	c #094D6E",
"b;	c #094C6C",
"c;	c #333B30",
"d;	c #CD7705",
"e;	c #E49A38",
"f;	c #92734A",
"g;	c #7B7367",
"h;	c #7C7D81",
"i;	c #727677",
"j;	c #9B8566",
"k;	c #CAC5BE",
"l;	c #F5F5F4",
"m;	c #D6D5D2",
"n;	c #AF946D",
"o;	c #CD8320",
"p;	c #E48907",
"q;	c #F99208",
"r;	c #FD9406",
"s;	c #FD9407",
"t;	c #FB9507",
"u;	c #E48908",
"v;	c #AA670B",
"w;	c #3C2E1E",
"x;	c #2B2C2D",
"y;	c #2B2A2B",
"z;	c #282829",
"A;	c #1E272C",
"B;	c #112D39",
"C;	c #09374C",
"D;	c #063D57",
"E;	c #053D58",
"F;	c #043851",
"G;	c #393320",
"H;	c #D67C06",
"I;	c #F78F07",
"J;	c #FC960B",
"K;	c #F59E22",
"L;	c #DC973C",
"M;	c #897B66",
"N;	c #787879",
"O;	c #F5F6F8",
"P;	c #C3BDB7",
"Q;	c #847052",
"R;	c #895B1D",
"S;	c #8E580F",
"T;	c #8E570D",
"U;	c #885410",
"V;	c #4E3519",
"W;	c #2B2924",
"X;	c #2A2B2C",
"Y;	c #2D2D2C",
"Z;	c #2A2B29",
"`;	c #2B2C2B",
" >	c #2B2A29",
".>	c #272928",
"+>	c #25292A",
"@>	c #212629",
"#>	c #212628",
"$>	c #2B261F",
"%>	c #AD6505",
"&>	c #EF8B07",
"*>	c #F89306",
"=>	c #985C0D",
"->	c #373129",
";>	c #313132",
">>	c #3D3D3D",
",>	c #6C6C6C",
"'>	c #E7E9E8",
")>	c #A8A6A8",
"!>	c #626365",
"~>	c #454649",
"{>	c #363837",
"]>	c #2F3333",
"^>	c #2D2D2D",
"/>	c #2C2D2D",
"(>	c #2C2C2B",
"_>	c #2B2B2C",
":>	c #2C2C2D",
"<>	c #2D2C2C",
"[>	c #2B2B29",
"}>	c #292A2B",
"|>	c #3C2F19",
"1>	c #A76308",
"2>	c #F18F07",
"3>	c #FD9405",
"4>	c #F59006",
"5>	c #DD8507",
"6>	c #B76E0B",
"7>	c #5D3F16",
"8>	c #2E2E2E",
"9>	c #323232",
"0>	c #BBBCBB",
"a>	c #818082",
"b>	c #6E6D6E",
"c>	c #515151",
"d>	c #464445",
"e>	c #353736",
"f>	c #312F30",
"g>	c #313030",
"h>	c #333131",
"i>	c #323131",
"j>	c #2F3031",
"k>	c #342F28",
"l>	c #6F4A19",
"m>	c #995E10",
"n>	c #A5650A",
"o>	c #A6660C",
"p>	c #965E12",
"q>	c #754E1A",
"r>	c #523E27",
"s>	c #3F3B37",
"t>	c #3E4042",
"u>	c #494849",
"v>	c #525153",
"w>	c #E7E8E8",
"x>	c #DDDCDC",
"y>	c #C2C2C4",
"z>	c #B5B5B4",
"A>	c #989798",
"B>	c #858584",
"C>	c #828281",
"D>	c #818181",
"E>	c #807F81",
"F>	c #7D7E7E",
"G>	c #7B7C79",
"H>	c #7A7A7A",
"I>	c #7A7A7B",
"J>	c #7A7B7D",
"K>	c #797B7E",
"L>	c #767B7F",
"M>	c #7D7E84",
"N>	c #86888B",
"O>	c #8F9192",
"P>	c #98989A",
"Q>	c #A2A2A1",
"R>	c #ACACAD",
"S>	c #B7B7B6",
"T>	c #C3C3C2",
"U>	c #FBFBFA",
"V>	c #F8F8F9",
"W>	c #E9E8E8",
"X>	c #E1E1E2",
"Y>	c #DADBDB",
"Z>	c #DEDFDE",
"`>	c #E7E7E6",
" ,	c #F3F2F3",
".,	c #F6F5F5",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . . + @ @ # $ % & * = . - ; > , ' @ @ ) ! . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . . ~ { ] ^ / ( _ : < [ } | 1 2 3 4 5 / 6 . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . . 7 8 9 0 a b c d e f g h i j k l m 3 > . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . . 7 n o p q r s t n u v j w j x y z A B . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . . 7 C D E F G _ i H I J K L j M N O n # . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . . E P I 3 Q R . . S T U . L S V I W X Y L . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . . Z c c `  .. . . ..c +.. . _ @.c c #.$.. . . . . . . . . . . . . . . . . . . . L %.L &.. . . . . . . . . . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . *.=.-.. ;.. >.,.'.).!.~.{.;.. . . . . . . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . *.. ;.. ;.w ].^./.(._.:.<.-.*.[.. . . . . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ;.}.|.. 1.2.3.4.5.6.7.8.9.0.w . . . . . . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . a.b.c.d.e.f.g.h.i.j.k.l.m.n.;.. . . . . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . o.p.q.r.s.t.k.u.v.w.x.y.z.A.B.. . . . . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . |.|.. . . *.C.D.E.F.G.u.H.I.J.K.L.M.N.O.P.*.. . >.. . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . Q.R.S.T.U.V.W.J.X.L.Y.Z.`.L. +.+p ;.>.|.. . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ++@+#+$+%+&+*+=+-+;+>+,+'+)+!+I.~+&+. . . . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . [.{+]+^+/+(+[ _+:+<+[+}+$.|+1+2+3+4+5+|.. . >.. ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . >.6+7+8+9+0+a+b+c+d+e+f+g+h+i+j+k+l+m+n+>.;.. . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ;.*.>.;.o+p+q+r+s+t+u+v+w+x+y+z+A+B+C+D+E+F+G+*.. . . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . >.*.*.p H+I+J+K+L+M+N+O+P+Q+R+S+T+U+V+W+X+Y+Z+;.. . . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ;.-.}.`+ @.@+@@@#@$@%@&@*@=@-@;@>@,@'@)@!@~@{@. . . . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . |.<.]@^@/@(@_@:@<@[@}@|@1@2@3@4@K.5@6@7@8@. . . . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ;.*+9@0@a@b@c@d@e@f@1@g@h@i@j@k@l@m@n@5@o@p@q@>.. . . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . }.}.w r@s@t@h.u.u@v@w@x@y@z@A@B@C@D@E@F@G@H@I@J@i |.;.>.. . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . K@*.[.i+L@M@N@O@P@Q@R@S@T@U@V@W@X@Y@Z@`@ #.#X.H@+#@###;.. >.;.. ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ;.&.;.$#%#&#*#.@=#-#n@;#>#,#'#)#!#~#{#]#^#;#/#(#_#:#<#c . L *.. . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ;.;.[#}#|#1#2#3#4#5#;#X+6#7#8#9#0#a#b#c#d#X.e#(#f#g#h#i#L K@. >.. ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ;.j#k#l#m#n#o#b#p#q#r#l+s#t#u#v#w#x#y#z#G@A#B#C#D#E#F#G#|+*.. ;.. ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . [ H#I#J#K#O@L#M#N#O#P#Q#R#S#T#U#V#W#X#Y#Z#`# $.$+$@$#$$$%$&$*.. . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . L >.. *$=$-$;$>$.@,$'$)$!$~${$]$^$/$($_$:$<$[$}$|$1$2$3$4$5$6$7$@ 8$. . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . ;.;.L 9$0$a$b$0#3#c$d$e$f$^$g$h$i$j$k$l$m$n$o$p$q$6$o g$r$s$1 5$t$u$v$. . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . ;.;.. w$x$y$z$A$B$C$D$E$F$G$H$I$J$K$L$M$N$7$O$P$Q$R$r$S${@`+K c f T$' ! . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . ;.;.U$V$W$X$Y$Z$`$ %.%+%@%#%$%%%B &%*%K =%-%;%>%,%'%`+&+..)%)%% !%E ~%Z+. . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . j#{%]%^%/%(%_%:%<%[%A+}%|%1%2%3%4%5%d 6%7%8%&%#.9%..[ L L . L L$0%O$c . . ",
". . . . . . . . . . . . . . . . . . . . . |.}.. ;.. a%b%c%L#d%e%f%g%h%i%j%& A+k%l%m%~ 5 y n%9 s$L$o%v$[ L . . . . . p%q%r%&%[.. ",
". . . . . . . . . . . . . . . . . . . . . -.. . . ;.s%t%u%v%w%x%y%z%A%B%s s C%i  . .! D%* E%F%$ ].)%w . . . . L . . G%1+H%I%o.. ",
". . . . . . . . . . . . . . . . . . . . . *.;.;.L J%K%L%M%N%O%P%Q%R%S%T%U%S$].$.L &+V%W%7%X%Y%Z%W%`%)%. . L L . . K F% &.&+&,.. ",
". . . . . . . . . . . . . . . . . . . . . &.|.;.@&#&$&%&&&*&=&P@-&;&>&,&j$` '&[ . 7%l%3$)&A+2 !&)&~&{&v$. . . . . ]&^&H$/&(&p . ",
". . . . . . . . . . . . . . . . . . . . . ;.;.;._&:&<&[&}&|&1&2&3&4&5&6&7&8&)%L &+U 9&4$& i [ Y 0&a&Q$a b&. . . #.E c&^ d&e&... ",
". . . . . . . . . . . . . . . . . . . . . . ;.f&g&h&i&j&k&l&:%m&n&o&p&&%!% .[ L q&r&5$c&c % w v$2%s&t&u&R . . L 8$v&w&x&y&z&A&. ",
". . . . . . . . . . . . . . . . . . . . . ;.L B&C&D&E&-.F&G&H&I&J&K&L&s M&&+w &+N&8$5$b&8&p L . . O&P&Q&[ . L s$0%& 1%R&S&T&U&. ",
". . . . . . . . . . . . . . . . . . . . . . *$V&W&X&Y&-.Z&`&M# *.*+*@*,&#*'&L c m $*5$s +.w . . . [ i w . . o%%*1 ~%&***e#=*-*. ",
". . . . . . . . . . . . . . . . . . . . . >.;.}.;*>*,*'*)*!*~*{*]*s$& ^*/*'&L (*U Q$a&L$&+L . . . . . . . Z _*:*S <*[*}*|*1*h+. ",
". . . . . . . . . . . . . . . . . . . . . *.'&2*3*4*5*6*7*P+8*9*0*a*& s M&&+w } 7 b*a&L$_ w . . . L . . _ 2 c*q&d*e*f*g*h*i*h+. ",
". . . . . . . . . . . . . . . . . . . . . |.j*k*l*m*n*o*p*q*r*s*t*u*T%v*@%+.p T$w*b*t s i p L . ;.|.;.x*y*z*A*B*C*D*E*F*G*H*I*. ",
". . . . . . . . . . . . . . . . . . . . . J*K*L*M*N*O*P*Q*h@R*S*T*U*V*j$L$].+.W*$*3$7%s$` '&p -.>.[ X*Y*Z*`* =.=+=m%@=T$#=$=S$. ",
". . . . . . . . . . . . . . . . . . . . . %=&=*===-=;=>=,='=1@)=!=~={=]=^=#./=t$q&7%Q$t k%#.+.(=$._=:=<=( [=}=|=G 1=2=D 3=4=5=. ",
". . . . . . . . . . . . . . . . . . . . . 6=7=8=9=0=a=b=c=g@d='=e=f=g=k%h=!%o%l d a&3$3$a&r$0 i=y*$ 4$u j=k=l=m=n=( !&o=* p=q=. ",
". . . . . . . . . . . . . . . . . . . . . r=s=t=u=v=w=x=y=z=A=B=C=D=E=F=&%A+K G=H=I=4$t , 2%Y%~ J=K=L=M=N=O=P=Q=R=h S=T=U=V=&.. ",
". . . . . . . . . . . . . . . . . . . . . W=X=Y=Z=`= -.-+-@-B='=#-$-%-&-0 & 7&& h *-P&N&=-# # --;->-,-'-)-!-~-{-]-+ N U==%$.. . ",
". . . . . . . . . . . . . . . . . . . . . ^-/-(-A=g@_-:-B=[@[@Q*A=<-[-}-|-T%s 1-2-3-4-5-] 6-7-8-9-0-a-b-c-d-e-f-T I g-h-i-;.;.. ",
". . . . . . . . . . . . . . . . . . . . . ,%j-k-1@A=A=[@[@l-1@A=B=p*m-n-o-p-`%,&M& . .{@q-r-s-t-u-v-h@w-x-y-z-A-B-C-D-E-F-[.. . ",
". . . . . . . . . . . . . . . . . . . . . G-H-I-|@B=B=J-K-A=h@L-M-J-N-O-P-Q-R-S-T-U-1 V-W-X-Y-Z-1@J-1@B=h@`- ;.;+;q%@;#;$;&.;.. ",
". . . . . . . . . . . . . . . . . . . . . o.%;&;*;g@h@B==;A=g@h@[@1@-;;;>;,;';S@);!;~;{;];^;e=B=[@L-[@1@}@/;(;a&a+_;:;<;[;[.;.. ",
". . . . . . . . . . . . . . . . . . . . . ;.v$};|;1;|@1@[@[@h@[@Q*2;3;4;5;6;7;8;9;0;a;b;c;d;R*A==;v-h@A='=e;f;g;h;i;j;k;].l;p L ",
". . . . . . . . . . . . . . . . . . . . . ;.*.{.m;n;o;p;q;r;s;t;u;v;w;x;y;z;A;B;C;D;E;F;G;H;I;[@[@[@g@[@1@v-J;K;L;M;%$N;_*$ a&` ",
". . . . . . . . . . . . . . . . . . . . . }.. >.*.O;P;Q;R;S;T;U;V;W;X;Y;Z;1%`; >.>+>@>#>$>%>&>[@A=[@|@[@A=[@}@*>=>->;>s&>>H ,>2%",
". . . . . . . . . . . . . . . . . . . . . . L ;.;.*.'>)>!>~>{>]>r ^>/>(>_>:><>^>(>[>1%1%}>|>1>2>s;g@|@3>4>5>6>7>[>8>r 9>] @ u 8$",
". . . . . . . . . . . . . . . . . . . . . ;.;.*.>.|.j#G+0>O a>b>3%c>d>>>e>9>f>g>^ 9>^ h>i>j>k>l>m>n>o>p>q>r>s>t>u>v>l%%$~ ( O&S$",
". . . . . . . . . . . . . . . . . . . . . . ;.=.;.>.}.L $.&+w>x>1 y>z>2%A>F%B>C>D>E>F>G>H$H>I>J>K>L>M>N>O>P>Q>R>S>T>f A+! Z p L ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . L w U>V>'&Z ].W>#*X>!%s+0 Y>&%&%& A+0 Z>X>U+`>`+q@ ,.,..p w L . . . "};






#endif


