/* 
    channel for Bt848 frame grabber driver

    Copyright (C) 1996,97 Marcus Metzler (mocm@metzlerbros.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * channel.cc 
 */

#include "channel.hh"
#include <string.h>

gChannel::gChannel(const Channel & chan, const Transponder & trans,
		   const Lnb & ln)
{
	strncpy(name, chan.name, mnamelen);
	name[mnamelen] = '\0';
	num = -1;
	dvb_num = 0;
	dvb_num |= ((uint64_t)chan.onid  << 48) & 0xFFFF000000000000ULL;
	dvb_num |= ((uint64_t)chan.satid << 32) & 0x0000FFFF00000000ULL;
	dvb_num |= ((uint64_t)chan.tpid  << 16) & 0x00000000FFFF0000ULL;
	dvb_num |=           (uint64_t)chan.pnr & 0x000000000000FFFFULL;
}

ChannelList::ChannelList()
{
	channels = new gChannel[channelinc];
	numchan = 0;
	maxnumc = channelinc;
}

ChannelList::ChannelList(char *filen)
{
	init(filen);
}

void ChannelList::init(char *filen)
{
	channels = new gChannel[channelinc];
	numchan = 0;
	maxnumc = channelinc;
	ifstream fin(filen);
	char dummy[128];

	if (numchan > 0)
		delete[]channels;

	while (fin.peek() == '#') {
		fin.getline(dummy, 128);
	}
	while (fin.ignore(1000, '*') != NULL) {
		gChannel ch;
		fin >> ch;
		AddChannel(ch);
	}
}

void ChannelList::AddChannel(gChannel & chan)
{
	numchan++;
	if (numchan > maxnumc) {
		maxnumc += channelinc;
		gChannel *ch = new gChannel[maxnumc];
		for (int i = 0; i < numchan - 1; i++) {
			ch[i] = channels[i];
		}
		delete[]channels;
		channels = ch;
	}
	channels[numchan - 1] = chan;
	channels[numchan - 1].Num() = numchan - 1;
}

void ChannelList::DelChannel(char *name)
{
	int i;
	for (i = 0; strcmp(channels[i].Name(), name)!=0 && i < numchan; i++);
	DelChannel(i);
}

void ChannelList::DelChannel(char *name, int freq)
{
}

void ChannelList::DelChannel(int nb)
{
	for (int i = nb; i < numchan - 1; i++)
		channels[i] = channels[i + 1];
	numchan--;
}


ostream & operator << (ostream & stream, gChannel & x) {
	stream << "*" << endl;
	stream << "Channel: " << x.name << endl;
	stream << hex << setw(16)  
	       << setfill(int('0')) << x.dvb_num << dec << endl;
	return stream;
}

istream & operator >> (istream & stream, gChannel & x) {
	char cdummy[mnamelen + 2];
	stream >> cdummy;
	stream.get(cdummy, mnamelen + 2);	// get full channel name
	x.SetName(cdummy + 1);

	stream >> hex >> x.dvb_num;
	return stream;
}

ostream & operator << (ostream & stream, ChannelList & x) {
	for (int i = 0; i < x.numchan; i++) {
		stream << x.channels[i] << endl;
	}
	return stream;
}
