/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * symb_convert.c
 * 
 * contains routines to convert symbol types from DsTool 2
 * to DsTool 3 format, and vice versa.  
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <constants.h>
#include <symbols.h>
#include <sys/param.h>
#include <sys/types.h>
#include <math_utils.h>
#include <math.h>
#include "dscolor.h"
#include "saveload_local.h"


/* 
 * symb_convert_2to3() converts symbol and color information from DsTool 2
 * to DsTool 3 formats. 
 * NOTE: This procedure guarantees only that the symbol information will
 * be accurate, and that the colors will be valid.   It does not guarantee
 * that the colors displayed when saved will be those displayed when reloaded.
 * 
 * Converts symbol data in ivector idata, and returns it in idata
 */

void symb_convert_2to3(idata)
int *idata;
{
     
 /*   printf ("%d %d %d\n", idata[0], idata[1], idata[2]); */
 
    if (idata[0]<0) {		/* System color desired */
        switch(idata[1]) {
            case OLD_SYS_RED:
	 	idata[1] = SYS_RED;	
		break;
	    case OLD_SYS_GREEN:
		idata[1] = SYS_GREEN;
		break;
	    case OLD_SYS_BLUE:
		idata[1] = SYS_BLUE;
		break;
	    default:
		break;
	    }
    } else {		/* Make sure values are in colortable */
        idata[1] = (idata[1] % MAX_DSCOLOR);
        idata[0] = (idata[0] % MAX_DSCOLOR);
        }

    switch (idata[2]) {
	case OLD_SMALL_POINT:
	    idata[2] = SMALL_POINT;
	    break;
	case OLD_MED_POINT:
	    idata[2] = MED_POINT;
	    break;
	case OLD_LARGE_POINT:
        case OLD_HUGE_POINT:
	    idata[2] = LARGE_POINT;
	    break;
	case OLD_SMALL_TRI:
	    idata[2] = SMALL_TRI;
	    break;
	case OLD_MED_TRI:
            idata[2] = MED_TRI;        
            break;
        case OLD_LARGE_TRI:
        case OLD_HUGE_TRI:
            idata[2] = LARGE_TRI;
            break;
	case OLD_SMALL_CROSS:
        case OLD_MED_CROSS:
	    idata[2] = SMALL_CROSS;
	    break;
        case OLD_LARGE_CROSS:  
            idata[2] = MED_CROSS;        
            break;
        case OLD_HUGE_CROSS:
            idata[2] = LARGE_CROSS;
            break;
	case OLD_SMALL_BOX:
	    idata[2] = SMALL_BOX;
	    break;
        case OLD_MED_BOX:  
            idata[2] = MED_BOX;        
            break;
        case OLD_LARGE_BOX:
        case OLD_HUGE_BOX:
            idata[2] = LARGE_BOX;
            break;
        default:
	    break;
        }

}



/*
 * symb_convert_3to2() converts symbol and color information from DsTool 3
 * to DsTool 2 formats.
 * NOTE: This procedure guarantees only that the symbol information will
 * be accurate, and that the colors will be valid.   It does not guarantee
 * that the colors displayed when saved will be those displayed when reloaded.
 * 
 * Converts vales in ivector idata, and returns them in ivector newidata 
 */

void symb_convert_3to2(idata, newidata)
int *idata, *newidata;
{

 /*   printf ("%d %d %d\n", idata[0], idata[1], idata[2]); */
    newidata[0] = idata[0];

    if (idata[0]<0) {           /* System color desired */
        switch(idata[1]) {
            case SYS_RED:
                newidata[1] = OLD_SYS_RED;     
                break;
            case SYS_GREEN:
                newidata[1] = OLD_SYS_GREEN;
                break;
            case SYS_BLUE:
                newidata[1] = OLD_SYS_BLUE;
                break;
            default:
		newidata[1] = idata[1];
                break;
            }
    } else {		/* not a system color */
        newidata[1] = idata[1];
        }
 
    switch (idata[2]) {
        case SMALL_POINT:
            newidata[2] = OLD_SMALL_POINT;
            break;
        case MED_POINT:
            newidata[2] = OLD_MED_POINT;
            break;
        case LARGE_POINT:
            newidata[2] = OLD_LARGE_POINT;
            break;
        case SMALL_TRI:
            newidata[2] = OLD_SMALL_TRI;        
            break;
        case MED_TRI:
            newidata[2] = OLD_MED_TRI;
            break;
        case LARGE_TRI:
            newidata[2] = OLD_LARGE_TRI;
            break;
        case SMALL_CROSS:  
            newidata[2] = OLD_SMALL_CROSS;        
            break;
        case MED_CROSS:
            newidata[2] = OLD_MED_CROSS;
            break;
        case LARGE_CROSS:
            newidata[2] = OLD_LARGE_CROSS;
            break;
        case SMALL_BOX:  
            newidata[2] = OLD_SMALL_BOX;        
            break;
        case MED_BOX:
            newidata[2] = OLD_MED_BOX;
            break;
        case LARGE_BOX:
            newidata[2] = OLD_LARGE_BOX;
            break;
        default:
            break;
        }

  /*  printf ("%d %d %d\n", idata[0], idata[1], idata[2]); */

}


