/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * saveload_local.h
 */

#ifndef SAVELOAD_LOCAL_h
#define SAVELOAD_LOCAL_h

#include <stdio.h>
#include "memory.h"
#include "../postmaster/pm_hash.h"

/* write_mem.c */
int write_mem( FILE* fp, memory ptr, char* label);
int write_double_point( FILE* fp, int dim, int format, double* pt);
int write_double_point_1p1( FILE* fp, int dim, int format, double* pt);
int write_integer_point( FILE* fp, int dim, int* pt);
int write_integer_point_1p1( FILE* fp, int dim, int* pt);

/* save_procs.c */
void save_go(void);

/* load.c */
void load_reset(void);

/* unform.c */
int load_unform_data( FILE* fp);
int read_unform_header( FILE* fp, int v_dim, int p_dim, char* mem_type,
                        int* len, int* p_index, int* v_index);

/* load_procs.c */
void load_go(void);
int load_go_force( int* force_varb,  int* force_param);
int load_form_data( FILE* fp, int* force_varb, int* force_param);
int keyword( char* word);
int load_pm( FILE* fp);
int load_set( FILE* fp);
int skip_function_obj( FILE* fp);
int load_oldform_data( FILE* fp, int* force_varb, int* force_param);
int fill_memory_obj( FILE* fp, char* ptr_type, int length, int mtype);
int read_data_obj( FILE* fp, memory ptr, int length, int mtype);
int fill_memory_obj_1p1( FILE* fp, char* ptr_type, int length);
int read_data_obj_1p1( FILE* fp, memory ptr, int length);
int read_sys_name( FILE* fp);
int get_integer_list( FILE* fp, int data_dim, int* p);
int get_double_list( FILE* fp, int data_dim, double* p);
int get_integer_list_1p1( FILE* fp, int data_dim, int* p);
int get_double_list_1p1( FILE* fp, int data_dim, double* p);
void set_pm_dvalue( FILE* fp, int data_dim, int cur_dim, char* pm_label);
void set_pm_ivalue( FILE* fp, int data_dim, int cur_dim, char* pm_label);
int old_keyword( char* w);
char* allupper( char* w);
char* alllower( char* w);
int load_model_if_new(void);
int load_config_wingeom(FILE* fp, char* str);
int stopcond_convert_2to3(int* int_data);


/* save_procs.c */
void save_go(void);
int save_go_force(int force);
int save_to_file( FILE* fp);
int save_to_file_1p1( FILE* fp);
int save_settings( FILE* fp);
int write_pm_obj( FILE* fp, struct pm_list* elem_ptr);
void save_settings_1p1( FILE* fp);
int save_func( FILE* fp);
int write_func( FILE* fp, memory mem, char* label, 
                int v_dim, int p_dim, int f_dim, double* pt);
int write_func_1p1( FILE* fp, memory mem, char* label,
                    int v_dim, int p_dim, int f_dim, double* pt);
int write_data_obj( FILE* fp, memory ptr, char* label, int mtype);
int write_data_obj_1p1( FILE* fp, memory ptr, char* label);
int tcl_save_config(FILE* fp);
int stopcond_convert_3to2(struct pm_list* elem_ptr, int* idata);
int save_twod_settings(FILE* fp, int winnum);


/* symb_convert.c */
void symb_convert_2to3(int* idata);
void symb_convert_3to2(int* idata, int* idata2);

#endif /* !SAVELOAD_LOCAL_h */
