#!/bin/sh
# Run this to generate all the initial makefiles, etc.

srcdir=`dirname $0`
test -z "$srcdir" && srcdir=.

PKG_NAME="the package."

# Nicked from GStreamer
version_check ()
# check the version of a package
# first argument : package name (executable)
# second argument : optional path where to look for it instead
# third argument : source download url
# rest of arguments : major, minor, micro version
{
  PACKAGE=$1
  PKG_PATH=$2
  URL=$3
  MAJOR=$4
  MINOR=$5
  MICRO=$6

  WRONG=

  if test ! -z "$PKG_PATH"
  then
    COMMAND="$PKG_PATH/$PACKAGE"
  else
    COMMAND="$PACKAGE"  
  fi
#  debug "major $MAJOR minor $MINOR micro $MICRO"
  VERSION=$MAJOR
  if test ! -z "$MINOR"; then VERSION=$VERSION.$MINOR; else MINOR=0; fi
  if test ! -z "$MICRO"; then VERSION=$VERSION.$MICRO; else MICRO=0; fi

#  debug "major $MAJOR minor $MINOR micro $MICRO"
  
  test -z "$NOCHECK" && {
      echo -n "  checking for $1 >= $VERSION"
      if test ! -z "$PKG_PATH"; then echo -n " (in $PKG_PATH)"; fi
      echo -n "... "
  } || {
    # we set a var with the same name as the package, but stripped of
    # unwanted chars
    VAR=`echo $PACKAGE | sed 's/-//g'`
#    debug "setting $VAR"
    eval $VAR="$COMMAND"
      return 0
  }

#  debug "checking version with $COMMAND"
  ($COMMAND --version) < /dev/null > /dev/null 2>&1 || 
  {
	echo "not found !"
	echo "You must have $PACKAGE installed to compile $package."
	echo "Download the appropriate package for your distribution,"
	echo "or get the source tarball at $URL"
	return 1
  }
  # the following line is carefully crafted sed magic
  pkg_version=`$COMMAND --version|head -n 1|sed 's/^[a-zA-z\.\ ()]*//;s/ .*$//'`
#  debug "pkg_version $pkg_version"
  # remove any non-digit characters from the version numbers to permit numeric
  # comparison
  pkg_major=`echo $pkg_version | cut -d. -f1 | sed s/[a-zA-Z\-].*//g`
  pkg_minor=`echo $pkg_version | cut -d. -f2 | sed s/[a-zA-Z\-].*//g`
  pkg_micro=`echo $pkg_version | cut -d. -f3 | sed s/[a-zA-Z\-].*//g`
  test -z "$pkg_minor" && pkg_minor=0
  test -z "$pkg_micro" && pkg_micro=0

#  debug "found major $pkg_major minor $pkg_minor micro $pkg_micro"

  #start checking the version
#  debug "version check"

  if [ ! "$pkg_major" -gt "$MAJOR" ]; then
#    debug "$pkg_major <= $MAJOR"
    if [ "$pkg_major" -lt "$MAJOR" ]; then
      WRONG=1
    elif [ ! "$pkg_minor" -gt "$MINOR" ]; then
      if [ "$pkg_minor" -lt "$MINOR" ]; then
        WRONG=1
      elif [ "$pkg_micro" -lt "$MICRO" ]; then
	WRONG=1
      fi
    fi
  fi

  if test ! -z "$WRONG"; then
    echo "found $pkg_version, not ok !"
    echo
    echo "You must have $PACKAGE $VERSION or greater to compile $package."
    echo "Get the latest version from $URL"
    echo
    return 1
  else
    echo "found $pkg_version, ok."
    # we set a var with the same name as the package, but stripped of
    # unwanted chars
    VAR=`echo $PACKAGE | sed 's/-//g'`
#    debug "setting $VAR"
    eval $VAR="$COMMAND"
  fi
}

# version_check "automake" "$AUTOMAKE" "ftp://ftp.gnu.org/pub/gnu/automake/" 1 5 || exit 1

(test -f $srcdir/configure.in) || {
    echo -n "**Error**: Directory "\`$srcdir\'" does not look like the"
    echo " top-level directory"
    exit 1
}

. $srcdir/macros/autogen.sh --enable-maintainer-mode --enable-compile-warnings --without-pic
