require 'drb/drb'
require 'timerholder'

class TimerIdConv < DRb::DRbIdConv
  def initialize(timeout=600)
    @holder = TimerHolder.new(timeout)
  end

  def to_obj(ref)
    begin
      @holder.fetch(ref)
    rescue TimerHolder::InvalidIndexError
      super(ref)
    end
  end

  def to_id(obj)
    return @holder.add(obj)
  end
end

# DRb.install_id_conv(TimerIdConv.new)
