=begin
 Tiny Ruby Linda
 	Copyright (c) 1999-2001 Masatoshi SEKI 
	$Id: rinda.rb,v 1.2 2001/05/05 01:46:49 seki Exp $ 
=end

require 'drb/drb'
require 'tuplespace'
require 'thread'

class TupleSpaceProxy
  def initialize(remote)
    @remote = remote
    @local = TupleSpace.new
  end

  def out(*tuples)
    @remote.out(*tuples)
  end

  def in(template, non_block=false)
    @remote.move(DRbObject.new(@local), template, non_block)
    @local.in(template, non_block)
  end
end


if __FILE__ == $0
  uri = ARGV.shift
  DRb.start_service(uri, TupleSpace.new)
  puts DRb.uri
  puts '[return] to exit'
  gets
end


