/******************************************************************************
 *
 * 
 *
 * Copyright (C) 1997-2002 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby 
 * granted. No representations are made about the suitability of this software 
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * Documents produced by Doxygen are derivative works derived from the
 * input used in their production; they are not affected by this license.
 *
 */

#ifndef TRANSLATOR_CZ_H
#define TRANSLATOR_CZ_H


// The first translation from English to Czech was started by
// Vlastimil Havran. He wrote:
// 
//   "In the cases where are more translations possible I hope
//    that I have selected the most reasonable text. If not, please,
//    mail the comments and text proposals to
//
//    havran@fel.cvut.cz, 1999/04/11"
//    
// The prototype version of Czech strings with diacritics was
// implemented by Petr Prikryl (prikrylp@skil.cz), 2000/06/20. As
// Vlastimil was quite busy at the time, he agreed that Petr be the
// maintainer for a while (from 2000/06/20).
//
// Updates:
// --------
// 2000/06/20
//  - The prototype version of Czech strings with diacritics. The
//    translation was based on translator.h of Doxygen version
//    1.1.4 (from scratch).
//
// 2000/07/10
//  - Updated version based on 1.1.5 sources (including important updates
//    of the up-to-1.1.4 strings). Czech strings in this file were written
//    in windows-1250 encoding. On-line decoding into iso-8859-2 ensured
//    via conditional compilation if the sources are compiled under UNIX.
//
// 2000/07/19
//  - Encoding conversion tables moved to the methods that use them.
//  - Updates for "new since 1.1.5".
//
// 2000/08/02 (Petr Prikryl)
//  - Updated for 1.2.0
//
// 2000/08/24
//  - Changed trTodo() text from "Udelat" to "Planovane upravy"
//    which seems more appropriate in the document context.
//  - Typo corrected in trMemberTypedefDocumentation().
//
// 2000/08/30
//  - Macro DECODE replaced by the inline Decode() (proposed by
//    Boris Bralo <boris.bralo@zg.tel.hr> in translator_hr.h).
//
// 2000/08/31
//  - Methods ISOToWin() and WinToISO() renamed and moved to the
//    base class (in translator.h) to be shared with the Croatian
//    translator.
//
// 2000/09/06
//  - Reimplementation of the method trInheritsList() which takes 
//    into account quantity of base classes.
//
// 2000/09/11
//  - Update for "new since 1.2.1" version. The text of trDCOPMethods()
//    was translated rather blindly (not knowing what exactly
//    the DCOP means).
//    
// 2000/10/17
//  - Update for "new since 1.2.2" version. 
//
// 2001/01/09
//  - Update for "new since 1.2.4" version. As I do not use Java,
//    I tried my best to guess the Czech terminology for the Java.
//    Let me know if some wording should be changed/improved.
//         
// 2001/02/15
//  - trMore() now returns only "..." (ellipsis).  The Czech replacement
//    of "(more)" was too much visible.  The previous "(...)" did not 
//    look well.
//    
// 2001/02/26
//  - Update for "new since 1.2.5" version (trBug(), trBugList()).
//         
// 2001/03/12
//  - Minor correction of comments which copied the same
//    corrections in translator.h (doubled backslash) just after 
//    1.2.6 release.
//    
// 2001/04/10
//  - Update for OPTIMIZE_OUTPUT_FOR_C (1.2.6-20010408).
//  - Removed implementation of latexBabelPackage().
//  - Removed implementation of trVerbatimText().
//  
// 2001/04/20
//  - Update for "new since 1.2.6-20010422". Experimental version
//    introducing TranslatorAdapter class and the abstract base
//    class Translator.  The English translator is now on the same
//    level as other translators.
//
// 2001/05/02
//  - The Decode() inline identifier changed to decode (i.e. lower
//    case) to be consistent with HR and RU translator, which also
//    use the approach.
//  - Removed the obsolete method trFiles().
//         
// 2001/05/18
//  - The trRelatedPagesDescription() content updated to fit 
//    the context better.
//  - Implemented new method trAuthor(params).
//  - Removed obsolete methods trAuthor() and trAuthors().
//
// 2001/05/25
//  - Updated misleading information in trLegendDocs().
//  - The trReimplementedInList() updated to fit the context better.
//  - The trReimplementedFromList() updated to fit the context better.
//
// 2001/07/16
//  - trClassDocumentation() updated as in the English translator.
//    
// 2001/11/06
//  - trReferences() implemented.
//    
// 2002/01/23
//  - trImplementedFromList() and trImplementedInList() implemented
//    (new since 1.2.13)
//  
// 2002/03/05
//  - ... forgot to replace TranslatorAdapter... base class by Translator.
//
// Todo
// ----
//  - The trReimplementedFromList() should pass the kind of the 
//    reimplemented element.  It can be method, typedef or possibly 
//    something else.  It is difficult to find the general translation
//    for all kinds in the Czech language.
// 
// Notices:
// -------- 
// The conditional compilation ensures or the neutral functionality
// of the private inline decode(), or calling the WinToISO() method
// for on-line encoding conversion. If you want to maintain the
// source in the iso-8859-2, do convert the encoding of the source,
// change the conditional definition of the inline decode() using the
// method ISO88592ToWin1250() -- for conversion of strings for the
// Windows version. The version which does not call the function is
// probably slightly faster.


class TranslatorCzech : public Translator
{
  private:
    /*! The decode() inline assumes the source written in the 
        Windows encoding (maintainer only dependent). 
     */
    inline QCString decode(const QCString & sInput)
    { 
#ifdef _WIN32
      return sInput;
#else
      return Win1250ToISO88592(sInput);
#endif
    }
    
  public:
    // --- Language control methods -------------------

    virtual QCString idLanguage()
    { return "czech"; }

    virtual QCString latexLanguageSupportCommand()
    { return "\\usepackage{czech}\n"; }
    
    /*! return the language charset. This will be used for the HTML output */
    virtual QCString idLanguageCharset()
    {
#ifdef _WIN32
        return "windows-1250";
#else
        return "iso-8859-2";
#endif
    }

    // --- Language translation methods -------------------

    /*! used in the compound documentation before a list of related functions. */
    virtual QCString trRelatedFunctions()
    { return decode("Souvisejc funkce"); }

    /*! subscript for the related functions. */
    virtual QCString trRelatedSubscript()
    { return decode("(Uveden funkce nejsou lenskmi funkcemi.)"); }

    /*! header that is put before the detailed description of files, classes and namespaces. */
    virtual QCString trDetailedDescription()
    { return decode("Detailn popis"); }

    /*! header that is put before the list of typedefs. */
    virtual QCString trMemberTypedefDocumentation()
    { return decode("Dokumentace k lenskm typm"); }
    
    /*! header that is put before the list of enumerations. */
    virtual QCString trMemberEnumerationDocumentation()
    { return decode("Dokumentace k lenskm vtm"); }
    
    /*! header that is put before the list of member functions. */
    virtual QCString trMemberFunctionDocumentation()
    { return decode("Dokumentace k metodm"); }
    
    /*! header that is put before the list of member attributes. */
    virtual QCString trMemberDataDocumentation()
    {       
      if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
      {
        return decode("Dokumentace k polokm"); 
      }
      else
      {
        return decode("Dokumentace k datovm lenm");
      }
    }

    /*! this is the text of a link put after brief descriptions. */
    virtual QCString trMore() 
    { return decode("..."); }

    /*! put in the class documentation */
    virtual QCString trListOfAllMembers()
    { return decode("Seznam vech len."); }

    /*! used as the title of the "list of all members" page of a class */
    virtual QCString trMemberList()
    { return decode("Seznam len tdy"); }

    /*! this is the first part of a sentence that is followed by a class name */
    virtual QCString trThisIsTheListOfAllMembers()
    { return decode("Zde naleznete pln seznam len tdy "); }

    /*! this is the remainder of the sentence after the class name */
    virtual QCString trIncludingInheritedMembers()
    { return decode(", vetn vech zddnch len."); }
    
    /*! this is put at the author sections at the bottom of man pages.
     *  parameter s is name of the project name.
     */
    virtual QCString trGeneratedAutomatically(const char *s)
    { QCString result="Generovno automaticky programem Doxygen "
                      "ze zdrojovch text";
      if (s) result+=(QCString)" projektu "+s;
      result+="."; 
      return decode(result);
    }

    /*! put after an enum name in the list of all members */
    virtual QCString trEnumName()
    { return decode("jmno vtu"); }
    
    /*! put after an enum value in the list of all members */
    virtual QCString trEnumValue()
    { return decode("hodnota vtu"); }
    
    /*! put after an undocumented member in the list of all members */
    virtual QCString trDefinedIn()
    { return decode("definovn v"); }

    // quick reference sections

    /*! This is put above each page as a link to the list of all groups of 
     *  compounds or files (see the \\group command).
     */
    virtual QCString trModules()
    { return decode("Moduly"); }
    
    /*! This is put above each page as a link to the class hierarchy */
    virtual QCString trClassHierarchy()
    { return decode("Hierarchie td"); }
    
    /*! This is put above each page as a link to the list of annotated classes */
    virtual QCString trCompoundList()
    {  
      if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
      {
        return decode("Datov struktury");
      }
      else
      { 
        return decode("Seznam td"); 
      }
    }
   
    /*! This is put above each page as a link to the list of documented files */
    virtual QCString trFileList()
    { return decode("Seznam soubor"); }

    /*! This is put above each page as a link to the list of all verbatim headers */
    virtual QCString trHeaderFiles()
    { return decode("Seznam hlavikovch soubor"); }

    /*! This is put above each page as a link to all members of compounds. */
    virtual QCString trCompoundMembers()
    { 
      if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
      {
        return decode("Datov poloky"); 
      }
      else
      {
        return decode("Seznam len td"); 
      }
    }
   
    /*! This is put above each page as a link to all members of files. */
    virtual QCString trFileMembers()
    { 
      if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
      {
        return decode("Globln symboly"); 
      }
      else
      {
        return decode("Symboly v souborech"); 
      }
    }

    /*! This is put above each page as a link to all related pages. */
    virtual QCString trRelatedPages()
    { return decode("Ostatn strnky"); }

    /*! This is put above each page as a link to all examples. */
    virtual QCString trExamples()
    { return decode("Pklady"); }

    /*! This is put above each page as a link to the search engine. */
    virtual QCString trSearch()
    { return decode("Hledat"); }

    /*! This is an introduction to the class hierarchy. */
    virtual QCString trClassHierarchyDescription()
    { return decode("Zde naleznete seznam, vyjadujc vztah ddinosti td. "
             "Je seazen piblin (ale ne pln) podle abecedy:");
    }

    /*! This is an introduction to the list with all files. */
    virtual QCString trFileListDescription(bool extractAll)
    {
      QCString result="Zde naleznete seznam vech ";
      if (!extractAll) result+="dokumentovanch ";
      result+="soubor se strunmi popisy:";
      return decode(result);
    }

    /*! This is an introduction to the annotated compound list. */
    virtual QCString trCompoundListDescription()
    {       
      if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
      {
        return decode("Nsledujc seznam obsahuje identifikace datovch "
                      "struktur a jejich strun popisy:"); 
      }
      else
      {
        return decode("Nsledujc seznam obsahuje pedevm identifikace "
                      "td, ale nachzej se zde i dal netriviln prvky, "
                      "jako jsou struktury (struct), unie (union) a rozhran "
                      "(interface). V seznamu jsou uvedeny jejich strun "
                      "popisy:");
      }
    }

    /*! This is an introduction to the page with all class members. */
    virtual QCString trCompoundMembersDescription(bool extractAll)
    {
      QCString result= "Zde naleznete seznam vech ";
      if (!extractAll) 
      {
        result += "dokumentovanch ";
      }
            
      if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
      {
        result += "poloek struktur (struct) a uni (union) ";
      }
      else
      {
        result += "len td ";
      }
      
      result += "s odkazy na ";  
      
      if (extractAll)
      {
        if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
        {
          result += "dokumentaci struktur/uni, ke kterm psluej:";
        }
        else
        {
          result += "dokumentaci td, ke kterm psluej:";
        }
      }
      else
      {
        if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
        {
          result+="struktury/unie, ke kterm psluej:";
        }
        else
        {
          result+="tdy, ke kterm psluej:";
        }
      }
        
      return decode(result);
    }

    /*! This is an introduction to the page with all file members. */
    virtual QCString trFileMembersDescription(bool extractAll)
    {
      QCString result="Zde naleznete seznam vech ";
      if (!extractAll) result+="dokumentovanch ";

      if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
      {
        result+="funkc, promnnch, maker, vt a definic typ (typedef) "
                "s odkazy na ";
      }
      else
      {
        result+="symbol, kter jsou definovny na rovni svch soubor. "
                "Pro kad symbol je uveden odkaz na ";
      }
        
      if (extractAll) 
        result+="soubory, ke kterm psluej:";
      else 
        result+="dokumentaci:";
        
      return decode(result);
    }

    /*! This is an introduction to the page with the list of all header files. */
    virtual QCString trHeaderFilesDescription()
    { return decode("Zde naleznete hlavikov soubory, kter tvo "
             "aplikan programtorsk rozhran (API):"); }

    /*! This is an introduction to the page with the list of all examples */
    virtual QCString trExamplesDescription()
    { return decode("Zde naleznete seznam vech pklad:"); }

    /*! This is an introduction to the page with the list of related pages */
    virtual QCString trRelatedPagesDescription()
    { return decode("Nsledujc seznam odkazuje na dal strnky projektu:"); }

    /*! This is an introduction to the page with the list of class/file groups */
    virtual QCString trModulesDescription()
    { return decode("Zde naleznete seznam vech modul:"); }

    /*! This sentences is used in the annotated class/file lists if no brief
     * description is given. 
     */
    virtual QCString trNoDescriptionAvailable()
    { return decode("Popis nen k dispozici"); }
    
    // index titles (the project name is prepended for these) 


    /*! This is used in HTML as the title of index.html. */
    virtual QCString trDocumentation()
    { return decode("Dokumentace"); }

    /*! This is used in LaTeX as the title of the chapter with the 
     * index of all groups.
     */
    virtual QCString trModuleIndex()
    { return decode("Rejstk modul"); }

    /*! This is used in LaTeX as the title of the chapter with the 
     * class hierarchy.
     */
    virtual QCString trHierarchicalIndex()
    { return decode("Rejstk hierarchie td"); }

    /*! This is used in LaTeX as the title of the chapter with the 
     * annotated compound index.
     */
    virtual QCString trCompoundIndex()
    { 
      if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
      { 
        return decode("Rejstk datovch struktur");
      }
      else
      {
        return decode("Rejstk td"); 
      }
    }
   
    /*! This is used in LaTeX as the title of the chapter with the
     * list of all files.
     */
    virtual QCString trFileIndex() 
    { return decode("Rejstk soubor"); }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all groups.
     */
    virtual QCString trModuleDocumentation()
    { return decode("Dokumentace modul"); }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all classes, structs and unions.
     */
    virtual QCString trClassDocumentation()
    { 
      if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
      {
        return decode("Dokumentace datovch struktur"); 
      }
      else
      {
        return decode("Dokumentace td"); 
      }      
    }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all files.
     */
    virtual QCString trFileDocumentation()
    { return decode("Dokumentace soubor"); }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all examples.
     */
    virtual QCString trExampleDocumentation()
    { return decode("Dokumentace pklad"); }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all related pages.
     */
    virtual QCString trPageDocumentation()
    { return decode("Dokumentace souvisejcch strnek"); }

    /*! This is used in LaTeX as the title of the document */
    virtual QCString trReferenceManual()
    { return decode("Referenn pruka"); }
    
    /*! This is used in the documentation of a file as a header before the 
     *  list of defines
     */
    virtual QCString trDefines()
    { return decode("Definice maker"); }

    /*! This is used in the documentation of a file as a header before the 
     *  list of function prototypes
     */
    virtual QCString trFuncProtos()
    { return decode("Prototypy"); }

    /*! This is used in the documentation of a file as a header before the 
     *  list of typedefs
     */
    virtual QCString trTypedefs()
    { return decode("Definice typ"); }

    /*! This is used in the documentation of a file as a header before the 
     *  list of enumerations
     */
    virtual QCString trEnumerations()
    { return decode("Vty"); }

    /*! This is used in the documentation of a file as a header before the 
     *  list of (global) functions
     */
    virtual QCString trFunctions()
    { return decode("Funkce"); }

    /*! This is used in the documentation of a file as a header before the 
     *  list of (global) variables
     */
    virtual QCString trVariables()
    { return decode("Promnn"); }

    /*! This is used in the documentation of a file as a header before the 
     *  list of (global) variables
     */
    virtual QCString trEnumerationValues()
    { return decode("Hodnoty vtu"); }
    
    /*! This is used in the documentation of a file before the list of
     *  documentation blocks for defines
     */
    virtual QCString trDefineDocumentation()
    { return decode("Dokumentace k definicm maker"); }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for function prototypes
     */
    virtual QCString trFunctionPrototypeDocumentation()
    { return decode("Dokumentace prototyp"); }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for typedefs
     */
    virtual QCString trTypedefDocumentation()
    { return decode("Dokumentace definic typ"); }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for enumeration types
     */
    virtual QCString trEnumerationTypeDocumentation()
    { return decode("Dokumentace vtovch typ"); }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for enumeration values
     */
    virtual QCString trEnumerationValueDocumentation()
    { return decode("Dokumentace vtovch hodnot"); }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for functions
     */
    virtual QCString trFunctionDocumentation()
    { return decode("Dokumentace funkc"); }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for variables
     */
    virtual QCString trVariableDocumentation()
    { return decode("Dokumentace promnnch"); }

    /*! This is used in the documentation of a file/namespace/group before 
     *  the list of links to documented compounds
     */
    virtual QCString trCompounds()
    { 
      if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
      { 
        return decode("Datov struktry");
      }
      else
      {
        return decode("Tdy"); 
      }
    }
   
    /*! This is used in the standard footer of each page and indicates when 
     *  the page was generated 
     */
    virtual QCString trGeneratedAt(const char *date,const char *projName)
    { 
      QCString result=(QCString)"Generovno "+date;
      if (projName) result+=(QCString)" pro projekt "+projName;
      result+=(QCString)" programem";
      return decode(result);
    }
    /*! This is part of the sentence used in the standard footer of each page.
     */
    virtual QCString trWrittenBy()
    {
      return decode(" -- autor ");
    }

    /*! this text is put before a class diagram */
    virtual QCString trClassDiagram(const char *clName)
    {
      return decode((QCString)"Diagram ddinosti pro tdu "+clName);
    }
    
    /*! this text is generated when the \\internal command is used. */
    virtual QCString trForInternalUseOnly()
    { return decode("Pouze pro vnitn pouit."); }

    /*! this text is generated when the \\reimp command is used. */
    virtual QCString trReimplementedForInternalReasons()
    { return decode("Reimplementovno z internch dvod; "
                    "aplikan rozhran zachovno."); }

    /*! this text is generated when the \\warning command is used. */
    virtual QCString trWarning()
    { return decode("Pozor"); }

    /*! this text is generated when the \\bug command is used. */
    virtual QCString trBugsAndLimitations()
    { return decode("Chyby a omezen"); }

    /*! this text is generated when the \\version command is used. */
    virtual QCString trVersion()
    { return decode("Verze"); }

    /*! this text is generated when the \\date command is used. */
    virtual QCString trDate()
    { return decode("Datum"); }

    /*! this text is generated when the \\return command is used. */
    virtual QCString trReturns()
    { return decode("Nvratov hodnota"); }

    /*! this text is generated when the \\sa command is used. */
    virtual QCString trSeeAlso()
    { return decode("Viz tak"); }

    /*! this text is generated when the \\param command is used. */
    virtual QCString trParameters()
    { return decode("Parametry"); }

    /*! this text is generated when the \\exception command is used. */
    virtual QCString trExceptions()
    { return decode("Vjimky"); }
    
    /*! this text is used in the title page of a LaTeX document. */
    virtual QCString trGeneratedBy()
    { return decode("Generovno programem"); }

    // new since 0.49-990307
    
    /*! used as the title of page containing all the index of all namespaces. */
    virtual QCString trNamespaceList()
    { return decode("Seznam prostor jmen"); }

    /*! used as an introduction to the namespace list */
    virtual QCString trNamespaceListDescription(bool extractAll)
    {
      QCString result="Zde naleznete seznam vech ";
      if (!extractAll) result+="dokumentovanch ";
      result+="prostor jmen se strunm popisem:";
      return decode(result);
    }

    /*! used in the class documentation as a header before the list of all
     *  friends of a class
     */
    virtual QCString trFriends()
    { return decode("Friends"); }
    
//////////////////////////////////////////////////////////////////////////
// new since 0.49-990405
//////////////////////////////////////////////////////////////////////////
    
    /*! used in the class documentation as a header before the list of all
     * related classes 
     */
    virtual QCString trRelatedFunctionDocumentation()
    { return decode("Dokumentace k friends"); }
    
//////////////////////////////////////////////////////////////////////////
// new since 0.49-990425
//////////////////////////////////////////////////////////////////////////

    /*! used as the title of the HTML page of a class/struct/union */
    virtual QCString trCompoundReference(const char *clName,
                                    ClassDef::CompoundType compType,
                                    bool isTemplate)
    {
      QCString result("Dokumentace ");
      if (isTemplate) result+="ablony ";
      switch(compType)
      {
        case ClassDef::Class:      result+="tdy "; break;
        case ClassDef::Struct:     result+="struktury "; break;
        case ClassDef::Union:      result+="unie "; break;
        case ClassDef::Interface:  result+="rozhran "; break;
        case ClassDef::Exception:  result+="vjimky "; break;
      }
      result+=clName;
      return decode(result);
    }

    /*! used as the title of the HTML page of a file */
    virtual QCString trFileReference(const char *fileName)
    {
      QCString result("Dokumentace souboru ");
      result+=fileName; 
      return decode(result);
    }

    /*! used as the title of the HTML page of a namespace */
    virtual QCString trNamespaceReference(const char *namespaceName)
    {
      QCString result("Dokumentace prostoru jmen ");
      result+=namespaceName;
      return decode(result);
    }
    
    /* 
     *  these are for the member sections of a class, struct or union 
     */
    virtual QCString trPublicMembers()
    { return decode("Veejn metody"); }
    virtual QCString trPublicSlots()
    { return decode("Veejn sloty"); }
    virtual QCString trSignals()
    { return decode("Signly"); }
    virtual QCString trStaticPublicMembers()
    { return decode("Statick veejn metody"); }
    virtual QCString trProtectedMembers()
    { return decode("Chrnn metody"); }
    virtual QCString trProtectedSlots()
    { return decode("Chrnn sloty"); }
    virtual QCString trStaticProtectedMembers()
    { return decode("Statick chrnn metody"); }
    virtual QCString trPrivateMembers()
    { return decode("Privtn metody"); }
    virtual QCString trPrivateSlots()
    { return decode("Privtn sloty"); }
    virtual QCString trStaticPrivateMembers()
    { return decode("Statick privtn metody"); }
    
    /*! this function is used to produce a comma-separated list of items.
     *  use generateMarker(i) to indicate where item i should be put.
     */
    virtual QCString trWriteList(int numEntries)
    {
      QCString result;
      int i;
      // the inherits list contain `numEntries' classes
      for (i=0;i<numEntries;i++) 
      {
        // use generateMarker to generate placeholders for the class links!
        result+=generateMarker(i); // generate marker for entry i in the list 
                                   // (order is left to right)
        
        if (i!=numEntries-1)  // not the last entry, so we need a separator
        {
          if (i<numEntries-2) // not the fore last entry 
            result+=", ";
          else                // the fore last entry
            result+=" a ";
        }
      }
      return decode(result); 
    }
    
    /*! used in class documentation to produce a list of base classes,
     *  if class diagrams are disabled.
     */
    virtual QCString trInheritsList(int numEntries)
    {
      QCString result("Dd z ");
      result += (numEntries == 1) ? "bzov tdy " : "bzovch td ";
      result += trWriteList(numEntries)+".";
      return decode(result);
    }

    /*! used in class documentation to produce a list of super classes,
     *  if class diagrams are disabled.
     */
    virtual QCString trInheritedByList(int numEntries)
    {
      QCString result("Zddna ");
      result += (numEntries == 1) ? "tdou " : "tdami ";
      result += trWriteList(numEntries)+".";
      return decode(result);
    }

    /*! used in member documentation blocks to produce a list of 
     *  members that are hidden by this one.
     */
    virtual QCString trReimplementedFromList(int numEntries)
    {
      QCString result("Reimplementuje stejnojmenn prvek z ");
      result += trWriteList(numEntries)+".";
      return decode(result);
    }

    /*! used in member documentation blocks to produce a list of
     *  all member that overwrite the implementation of this member.
     */
    virtual QCString trReimplementedInList(int numEntries)
    {
      QCString result("Reimplementovno v ");
      result += trWriteList(numEntries)+".";
      return decode(result);
    }

    /*! This is put above each page as a link to all members of namespaces. */
    virtual QCString trNamespaceMembers()
    { return decode("Symboly v prostorech jmen"); }

    /*! This is an introduction to the page with all namespace members */
    virtual QCString trNamespaceMemberDescription(bool extractAll)
    { 
      QCString result="Zde naleznete seznam vech ";
      if (!extractAll) result+="dokumentovanch ";
      result+="symbol, kter jsou definovny ve svch prostorech jmen. "
              "U kadho je uveden odkaz na ";
      if (extractAll) 
        result+="dokumentaci pslunho prostoru jmen:";
      else 
        result+="pslun prostor jmen:";
      return decode(result);
    }
    /*! This is used in LaTeX as the title of the chapter with the 
     *  index of all namespaces.
     */
    virtual QCString trNamespaceIndex()
    { return decode("Rejstk prostor jmen"); }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all namespaces.
     */
    virtual QCString trNamespaceDocumentation()
    { return decode("Dokumentace prostor jmen"); }

//////////////////////////////////////////////////////////////////////////
// new since 0.49-990522
//////////////////////////////////////////////////////////////////////////

    /*! This is used in the documentation before the list of all
     *  namespaces in a file.
     */
    virtual QCString trNamespaces()
    { return decode("Prostory jmen"); }

//////////////////////////////////////////////////////////////////////////
// new since 0.49-990728
//////////////////////////////////////////////////////////////////////////

    /*! This is put at the bottom of a class documentation page and is
     *  followed by a list of files that were used to generate the page.
     */
    virtual QCString trGeneratedFromFiles(ClassDef::CompoundType compType,
        bool single)
    { // here s is one of " Class", " Struct" or " Union"
      // single is true implies a single file
      QCString result=(QCString)"Dokumentace pro ";
      switch(compType)
      {
        case ClassDef::Class:      result+="tuto tdu"; break;
        case ClassDef::Struct:     result+="tuto strukturu (struct)"; break;
        case ClassDef::Union:      result+="tuto unii (union)"; break;
        case ClassDef::Interface:  result+="toto rozhran"; break;
        case ClassDef::Exception:  result+="tuto vjimku"; break;
      }
      result+=" byla generovna z ";
      if (single) result+="nsledujcho souboru:"; 
      else        result+="nsledujcch soubor:";
      return decode(result);
    }

    /*! This is in the (quick) index as a link to the alphabetical compound
     * list.
     */
    virtual QCString trAlphabeticalList()
    { return decode("Rejstk td"); }

//////////////////////////////////////////////////////////////////////////
// new since 0.49-990901
//////////////////////////////////////////////////////////////////////////

    /*! This is used as the heading text for the retval command. */
    virtual QCString trReturnValues()
    { return decode("Vracen hodnoty"); }

    /*! This is in the (quick) index as a link to the main page (index.html)
     */
    virtual QCString trMainPage()
    { return decode("Hlavn strnka"); }

    /*! This is used in references to page that are put in the LaTeX 
     *  documentation. It should be an abbreviation of the word page.
     */
    virtual QCString trPageAbbreviation()
    { return decode("s."); }

//////////////////////////////////////////////////////////////////////////
// new since 0.49-991003
//////////////////////////////////////////////////////////////////////////

    virtual QCString trSources()
    {
      return decode("Zdroje");
    }
    virtual QCString trDefinedAtLineInSourceFile()
    {
      return decode("Definice je uvedena na dku @0 v souboru @1.");
    }
    virtual QCString trDefinedInSourceFile()
    {
      return decode("Definice v souboru @0.");
    }

//////////////////////////////////////////////////////////////////////////
// new since 0.49-991205
//////////////////////////////////////////////////////////////////////////

    virtual QCString trDeprecated()
    {
      return decode("Zastaral");
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.0.0
//////////////////////////////////////////////////////////////////////////

    /*! this text is put before a collaboration diagram */
    virtual QCString trCollaborationDiagram(const char *clName)
    {
      return decode((QCString)"Diagram td pro "+clName+":");
    }
    /*! this text is put before an include dependency graph */
    virtual QCString trInclDepGraph(const char *fName)
    {
      return decode((QCString)"Graf zvislost na vkldanch souborech "
                    "pro "+fName+":");
    }
    /*! header that is put before the list of constructor/destructors. */
    virtual QCString trConstructorDocumentation()
    {
      return decode("Dokumentace konstruktoru a destruktoru"); 
    }
    /*! Used in the file documentation to point to the corresponding sources. */
    virtual QCString trGotoSourceCode()
    {
      return decode("Zobrazit zdrojov text tohoto souboru.");
    }
    /*! Used in the file sources to point to the corresponding documentation. */
    virtual QCString trGotoDocumentation()
    {
      return decode("Zobrazit dokumentaci tohoto souboru.");
    }
    /*! Text for the \\pre command */
    virtual QCString trPrecondition()
    {
      return decode("Precondition");
    }
    /*! Text for the \\post command */
    virtual QCString trPostcondition()
    {
      return decode("Postcondition");
    }
    /*! Text for the \\invariant command */
    virtual QCString trInvariant()
    {
      return decode("Invariant");
    }
    /*! Text shown before a multi-line variable/enum initialization */
    virtual QCString trInitialValue()
    {
      return decode("Initializer:");
    }
    /*! Text used the source code in the file index */
    virtual QCString trCode()
    {
      return decode("zdrojov text");
    }
    virtual QCString trGraphicalHierarchy()
    {
      return decode("Grafick zobrazen hierarchie td");
    }
    virtual QCString trGotoGraphicalHierarchy()
    {
      return decode("Zobrazit grafickou podobu hierarchie td");
    }
    virtual QCString trGotoTextualHierarchy()
    {
      return decode("Zobrazit textovou podobu hierarchie td");
    }
    virtual QCString trPageIndex()
    {
      return decode("Rejstk strnek");
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.1.0
//////////////////////////////////////////////////////////////////////////
    
    virtual QCString trNote()
    {
      return decode("Poznmka");
    }
    virtual QCString trPublicTypes()
    {
      return decode("Veejn typy");
    }
    virtual QCString trPublicAttribs()
    {
      if (Config_getBool("OPTIMIZE_OUTPUT_FOR_C"))
      {
        return decode("Datov poloky");
      }
      else
      {
        return decode("Veejn atributy");
      }
    }
    virtual QCString trStaticPublicAttribs()
    {
      return decode("Statick veejn atributy");
    }
    virtual QCString trProtectedTypes()
    {
      return decode("Chrnn typy");
    }
    virtual QCString trProtectedAttribs()
    {
      return decode("Chrnn atributy");
    }
    virtual QCString trStaticProtectedAttribs()
    {
      return decode("Statick chrnn atributy");
    }
    virtual QCString trPrivateTypes()
    {
      return decode("Privtn typy");
    }
    virtual QCString trPrivateAttribs()
    {
      return decode("Privtn atributy");
    }
    virtual QCString trStaticPrivateAttribs()
    {
      return decode("Statick privtn atributy");
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.1.3
//////////////////////////////////////////////////////////////////////////

    /*! Used as a marker that is put before a todo item */
    virtual QCString trTodo()
    {
      return decode("Plnovan pravy");
    }
    /*! Used as the header of the todo list */
    virtual QCString trTodoList()
    {
      return decode("Seznam plnovanch prav");
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.1.4
//////////////////////////////////////////////////////////////////////////

    virtual QCString trReferencedBy()
    {
      return decode("Pouv se v");
    }
    virtual QCString trRemarks()
    {
      return decode("Poznmky"); // ??? not checked in a context
    }
    virtual QCString trAttention()
    {
      return decode("Upozornn"); // ??? not checked in a context
    }
    virtual QCString trInclByDepGraph()
    {
      return decode("Nsledujc graf ukazuje, kter soubory pmo nebo "
             "nepmo vkldaj tento soubor:");
    }
    virtual QCString trSince()
    {
      return decode("Od"); // ??? not checked in a context
    }

////////////////////////////////////////////////////////////////////////////
// new since 1.1.5
//////////////////////////////////////////////////////////////////////////

    /*! title of the graph legend page */
    virtual QCString trLegendTitle()
    {
      return decode("Vysvtlivky ke grafu");
    }
    /*! page explaining how the dot graph's should be interpreted */
    virtual QCString trLegendDocs()
    {
      QCString result(  
        "Zde naleznete vysvtlen, jak maj bt interpretovny grafy, "
        "kter byly generovny programem doxygen.<p>\n"
        "Uvaujte nsledujc pklad:\n"
        "\\code\n"
        "/*! Neviditeln tda, kter se v grafu nezobrazuje, protoe "
        "dolo k oezn grafu. */\n"
        "class Invisible { };\n\n"
        "/*! Tda, u kter dolo k oezn grafu. Vztah ddinosti "
        "je skryt. */\n"
        "class Truncated : public Invisible { };\n\n"
        "/* Tda, kter nen dokumentovna komenti programu doxygen. */\n"
        "class Undocumented { };\n\n"
        "/*! Bzov tda ddn veejn (public inheritance). */\n"
        "class PublicBase : public Truncated { };\n\n"
        "/*! Bzov tda, pouit pro chrnn ddn "
        "(protected inheritance). */\n"
        "class ProtectedBase { };\n\n"
        "/*! Bzov tda, vyuit pro privtn ddn "
        "(private inheritance). */\n"
        "class PrivateBase { };\n\n"
        "/*! Tda, kter je vyuvna tdou Inherited. */\n"
        "class Used { };\n\n"
        "/*! Odvozen tda, kter rznm zpsobem dd z vce bzovch "
        "td. */\n"
        "class Inherited : public PublicBase,\n"
        "                  protected ProtectedBase,\n"
        "                  private PrivateBase,\n"
        "                  public Undocumented\n"
        "{\n"
        "  private:\n"
        "    Used *m_usedClass;\n"
        "};\n"
        "\\endcode\n"
        "Pokud je poloka \\c MAX_DOT_GRAPH_HEIGHT konfiguranho souboru "
        "nastavena na hodnotu 200, bude vygenerovn nsledujc graf:"
        "<p><center><img src=\"graph_legend."+Config_getEnum("DOT_IMAGE_FORMAT")+"\"></center>\n"
        "<p>\n"
        "Bloky (tj. uzly) v uvedenm grafu maj nsledujc vznam:\n"
        "<ul>\n"
        "<li>ern vyplnn obdlnk reprezentuje strukturu nebo tdu, "
            "pro kterou byl graf generovn.\n"
        "<li>Obdlnk s ernm obrysem oznauje dokumentovanou "
            "strukturu nebo tdu.\n"
        "<li>Obdlnk s edm obrysem oznauje nedokumentovanou "
            "strukturu nebo tdu.\n"
        "<li>Obdlnk s ervenm obrysem oznauje dokumentovanou "
            "strukturu nebo tdu, pro kterou\n"
            "nejsou zobrazeny vechny vztahy ddinosti nebo obsaen. "
            "Graf je oezn v ppad, kdy jej\n"
            "nen mon umstit do vymezench hranic.\n"
        "</ul>\n"
        "ipky (tj. hrany grafu) maj nsledujc vznam:\n"
        "<ul>\n"
        "<li>Tmav modr ipka se pouv pro oznaen vztahu veejn "
            "ddinosti (public) mezi dvma tdami.\n"
        "<li>Tmav zelen ipka oznauje vztah chrnn ddinosti "
            "(protected).\n"
        "<li>Tmav erven ipka oznauje vztah privtn ddinosti "
            "(private).\n"
        "<li>Purpurov ipka kreslen rkovan se pouv v ppad, "
            "kdy je tda obsaena v jin td,\n"
            "nebo kdy je pouvna jinou tdou. Je oznaena identifiktorem "
            "jedn nebo vce promnch, pes kter\n"
            "je tda nebo struktura zpstupnna.\n"
        "</ul>\n");
        
        return decode(result);
    }
    /*! text for the link to the legend page */
    virtual QCString trLegend()
    {
      return decode("vysvtlivky");
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.2.0
//////////////////////////////////////////////////////////////////////////
    
    /*! Used as a marker that is put before a test item */
    virtual QCString trTest()
    {
      return decode("Test");
    }
   
    /*! Used as the header of the test list */
    virtual QCString trTestList()
    {
      return decode("Seznam test");
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.2.1
//////////////////////////////////////////////////////////////////////////

    /*! Used as a section header for KDE-2 IDL methods */
    virtual QCString trDCOPMethods()
    {
      return decode("Metody DCOP");
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.2.2
//////////////////////////////////////////////////////////////////////////

    /*! Used as a section header for IDL properties */
    virtual QCString trProperties()
    {
      return decode("Vlastnosti");
    }
    /*! Used as a section header for IDL property documentation */
    virtual QCString trPropertyDocumentation()
    {
      return decode("Dokumentace k vlastnosti");
    }
//////////////////////////////////////////////////////////////////////////
// new since 1.2.4
//////////////////////////////////////////////////////////////////////////

    /*! Used for Java interfaces in the summary section of Java packages */
    virtual QCString trInterfaces()
    {
      return decode("Rozhran");
    }
    /*! Used for Java classes in the summary section of Java packages */
    virtual QCString trClasses()
    {
      return decode("Tdy");
    }
    /*! Used as the title of a Java package */
    virtual QCString trPackage(const char *name)
    {
      return decode((QCString)"Balk "+name);
    }
    /*! Title of the package index page */
    virtual QCString trPackageList()
    {
      return decode("Seznam balk");
    }
    /*! The description of the package index page */
    virtual QCString trPackageListDescription()
    {
      return decode("Zde naleznete seznam balk se strunm popisem "
                    "(pokud byl uveden):");
    }
    /*! The link name in the Quick links header for each page */
    virtual QCString trPackages()
    {
      return decode("Balky");
    }
    /*! Used as a chapter title for Latex & RTF output */
    virtual QCString trPackageDocumentation()
    {
      return decode("Dokumentace balku");
    }
    /*! Text shown before a multi-line define */
    virtual QCString trDefineValue()
    {
      return decode("Hodnota:");
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.2.5
//////////////////////////////////////////////////////////////////////////
    
    /*! Used as a marker that is put before a \\bug item */
    virtual QCString trBug()
    {
      return decode("Chyba");
    }
    /*! Used as the header of the bug list */
    virtual QCString trBugList()
    {
      return decode("Seznam chyb");
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.2.6-20010422
//////////////////////////////////////////////////////////////////////////

    /*! Used as ansicpg for RTF file */
    virtual QCString trRTFansicp()
    {
      return "1250";
    }
    
    /*! Used as ansicpg for RTF fcharset */
    virtual QCString trRTFCharSet()
    {
      return "238";
    }

    /*! Used as header RTF general index */
    virtual QCString trRTFGeneralIndex()
    {
      return decode("Rejstk");
    }
                                                                          
    /*! This is used for translation of the word that will possibly
     *  be followed by a single name or by a list of names 
     *  of the category.
     */
    virtual QCString trClass(bool first_capital, bool singular)
    { 
      QCString result((first_capital ? "Td" : "td"));
      result+=(singular ? "a" : "y");
      return decode(result); 
    }

    /*! This is used for translation of the word that will possibly
     *  be followed by a single name or by a list of names 
     *  of the category.
     */
    virtual QCString trFile(bool first_capital, bool singular)
    { 
      QCString result((first_capital ? "Soubor" : "soubor"));
      if (!singular)  result+="y";
      return decode(result); 
    }

    /*! This is used for translation of the word that will possibly
     *  be followed by a single name or by a list of names 
     *  of the category.
     */
    virtual QCString trNamespace(bool first_capital, bool singular)
    { 
      QCString result((first_capital ? "Prostor" : "prostor"));
      if (!singular)  result+="y";
      result+=" jmen";
      return decode(result); 
    }

    /*! This is used for translation of the word that will possibly
     *  be followed by a single name or by a list of names 
     *  of the category.
     */
    virtual QCString trGroup(bool first_capital, bool singular)
    { 
      QCString result((first_capital ? "Skupin" : "skupin"));
      result+=(singular ? "a" : "y");
      return decode(result); 
    }

    /*! This is used for translation of the word that will possibly
     *  be followed by a single name or by a list of names 
     *  of the category.
     */
    virtual QCString trPage(bool first_capital, bool singular)
    { 
      QCString result((first_capital ? "Strnk" : "strnk"));
      result+=(singular ? "a" : "y");
      return decode(result); 
    }

    /*! This is used for translation of the word that will possibly
     *  be followed by a single name or by a list of names 
     *  of the category.
     */
    virtual QCString trMember(bool first_capital, bool singular)
    { 
      QCString result((first_capital ? "len" : "len"));
      if (!singular)  result+="y";
      return decode(result); 
    }
   
    /*! This is used for translation of the word that will possibly
     *  be followed by a single name or by a list of names 
     *  of the category.
     */
    virtual QCString trField(bool first_capital, bool singular)
    { 
      QCString result((first_capital ? "Polok" : "polok"));
      result+=(singular ? "a" : "y");
      return decode(result); 
    }

    /*! ??? Jak to prelozit? Bylo by dobre, kdyby se ozval nekdo,
     * kdo to pouziva.
     */
    virtual QCString trGlobal(bool first_capital, bool singular)
    { 
      QCString result((first_capital ? "Global" : "global"));
      if (!singular)  result+="s";  
      return result; 
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.2.7
//////////////////////////////////////////////////////////////////////////

    /*! This text is generated when the \\author command is used and
     *  for the author section in man pages. */
    virtual QCString trAuthor(bool first_capital, bool singular)
    {                                                                         
      QCString result((first_capital ? "Auto" : "auto"));
      result += (singular) ? "r" : "i";
      return decode(result); 
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.2.11
//////////////////////////////////////////////////////////////////////////

    /*! This text is put before the list of members referenced by a member
     */
    virtual QCString trReferences()
    {
      return decode("Odkazuje se na");
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.2.13
//////////////////////////////////////////////////////////////////////////

    /*! used in member documentation blocks to produce a list of 
     *  members that are implemented by this one.
     */
    virtual QCString trImplementedFromList(int numEntries)
    {
      return "Implementuje "+trWriteList(numEntries)+".";
    }

    /*! used in member documentation blocks to produce a list of
     *  all members that implement this member.
     */
    virtual QCString trImplementedInList(int numEntries)
    {
      return "Implementovno v "+trWriteList(numEntries)+".";
    }

};

#endif // TRANSLATOR_CZ_H
