/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import java.io.Serializable;
import org.adl.datamodels.Element;
import org.adl.datamodels.cmi.CMICategory;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.samplerte.client.APIAdapterApplet;
import org.adl.util.debug.DebugIndicator;

public class CMICommentsFromLms
extends CMICategory
implements Serializable {
    public Element comments_from_lms;

    public CMICommentsFromLms(String comments) {
        super(true);
        this.comments_from_lms = new Element(comments, "checkString4096", "NULL", false, true, false);
    }

    public CMICommentsFromLms() {
        super(true);
        this.comments_from_lms = new Element("", "checkString4096", "NULL", false, true, false);
    }

    public Element getCommentsFromLms() {
        return this.comments_from_lms;
    }

    public void setCommentsFromLms(String inCommentsFromLMS) {
        this.comments_from_lms.setValue(inCommentsFromLMS);
    }

    public String performGet(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        String result = new String("");
        if (theRequest.hasMoreTokensToProcess()) {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented\n");
                System.out.println("Element being processed: " + theRequest.getRequest() + "element of the CMI Suspend Data " + "Data Model Category");
            }
            if (theRequest.isAKeywordRequest()) {
                dmErrorMgr.recGetKeyWordError(theRequest.getElement());
            } else {
                dmErrorMgr.recNotImplementedError(theRequest);
            }
        } else {
            result = this.comments_from_lms.getValue();
        }
        theRequest.done();
        return result;
    }

    public void performSet(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        if (APIAdapterApplet.areweloading) {
            if (!theRequest.hasMoreTokensToProcess()) {
                String content = theRequest.getValue();
                if (content.length() <= 4096) {
                    String currentLMSComments = this.comments_from_lms.getValue();
                    currentLMSComments = currentLMSComments + content;
                    this.comments_from_lms.setValue(currentLMSComments);
                } else {
                    if (DebugIndicator.ON) {
                        System.out.println("***** INVALID DURING LOADING LMSSetValue() CALL *****");
                        System.out.println("             Invalid Type             ");
                        System.out.println("         Element was not set!         ");
                    }
                    dmErrorMgr.SetCurrentErrorCode("405");
                }
            } else {
                if (DebugIndicator.ON) {
                    System.out.println("Error - Data Model Element not implemented");
                    System.out.println("Element being processed: " + theRequest.getElement() + "is not a valid data model element.\n");
                }
                dmErrorMgr.recNotImplementedError(theRequest);
            }
            theRequest.done();
        } else {
            if (DebugIndicator.ON) {
                System.out.println("Invalid LMSSetValue() request: " + theRequest.getRequest());
                System.out.println("Assignable Unit is not permitted to call LMSSetValue() for cmi.comments_from_lms");
            }
            dmErrorMgr.SetCurrentErrorCode("403");
        }
    }
}

