/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels;

import java.util.StringTokenizer;
import org.adl.datamodels.SCODataManager;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.util.debug.DebugIndicator;

public class DataModelInterface {
    public String processGet(String theRequest, SCODataManager scoData, DMErrorManager dmErrMgr) {
        if (DebugIndicator.ON) {
            System.out.println("");
            System.out.println("**********************************");
            System.out.println("In DataModelInterface::processGet()");
            System.out.println("**********************************");
            System.out.println("");
        }
        String result = new String("");
        if (DebugIndicator.ON) {
            System.out.println("In DataModelInterface::processGet");
        }
        if (this.isValidRequest(theRequest)) {
            CMIRequest request = new CMIRequest(theRequest, true);
            result = scoData.getValue(request, dmErrMgr);
        } else {
            if (DebugIndicator.ON) {
                System.out.println("Data model not supported by SCORM");
            }
            dmErrMgr.SetCurrentErrorCode("201");
        }
        if (DebugIndicator.ON) {
            System.out.println("");
            System.out.println("**********************************");
            System.out.println("Returning to API: [" + result + "]");
            System.out.println("**********************************");
            System.out.println("");
        }
        return result;
    }

    public void processSet(String theRequest, SCODataManager scoData, DMErrorManager dmErrMgr) {
        StringTokenizer stk;
        String tmpRequest;
        if (DebugIndicator.ON) {
            System.out.println("");
            System.out.println("***********************************");
            System.out.println("In DataModelInterface::processSet()");
            System.out.println("***********************************");
            System.out.println("");
        }
        if (this.isValidRequest(tmpRequest = (stk = new StringTokenizer(theRequest, ",", false)).nextToken())) {
            CMIRequest request = new CMIRequest(theRequest, false);
            scoData.setValue(request, dmErrMgr);
        } else {
            if (DebugIndicator.ON) {
                System.out.println("Data model not supported by SCORM");
            }
            dmErrMgr.SetCurrentErrorCode("201");
        }
    }

    private boolean isValidRequest(String theRequest) {
        String token;
        boolean rtrnFlag = true;
        StringTokenizer stk = new StringTokenizer(theRequest, ".", false);
        int totalNumOfTok = stk.countTokens();
        if (totalNumOfTok < 2) {
            rtrnFlag = false;
        }
        rtrnFlag = (token = stk.nextToken()).equals("cmi");
        return rtrnFlag;
    }
}

