from re import compile, IGNORECASE

from dosage.helpers import BasicScraper

class VGCats(BasicScraper):
    latestUrl = 'http://www.vgcats.com/comics/'
    imageUrl = 'http://www.vgcats.com/comics/?strip_id=%s'
    imageSearch = compile(r'<img src="(images/\d{6}\..+?)"')
    prevSearch = compile(r'<a href="(\?strip_id=\d+)"><img src="back.gif" border="0"')
    help = 'Index format: n (unpadded)'


class ViiviJaWagner(BasicScraper):
    latestUrl = 'http://www.hs.fi/viivijawagner/'
    imageUrl = 'http://www.hs.fi/viivijawagner/%s'
    imageSearch = compile(r'<img src="(/kuvat/iso_webkuva/\d+\.gif)" align="center" BORDER="0" ALT="" TITLE="">', IGNORECASE)
    prevSearch = compile(r'<a href="(/viivijawagner/\d+)" class="pro85"><img src="http://www\.hs\.fi/static/hs/img/viivitaakse\.gif" width="60" height="56" border="0" alt="edellinen" title="edellinen">EDELLINEN</a>', IGNORECASE)
