import java.io.*;
import java.util.*;
import junit.framework.*;


/**
 * Unit test for the Project class
 *
 * @author Ben Secrest &lt;blsecres@users.sourceforge.net&gt;
 * @version $Id: ProjectTest.java,v 1.2 2002/09/29 05:42:20 blsecres Exp $
 */
public class ProjectTest extends TestCase {
    /** Project object for English */
    private Project project_en;

    /** Project object for Spanish */
    private Project project_es;

    /** Project object for French */
    private Project project_fr;


    /**
     * Initialize object for testing
     */
    protected void setUp() throws IOException, FileNotFoundException,
	    IllegalVariableException {
	ResourceBundle rb = ResourceBundle.getBundle("MainStrings",
		Locale.ENGLISH);
	UserInterface ui = new TextInterface(rb, false);
	IGLog log = new IGLog("tests/results/ProjectTest.log", rb, ui);
	project_en = new Project(log);
	project_es = new Project(log);
	project_fr = new Project(log);

	project_en.load("tests/data/config.en.ig");
	project_es.load("tests/data/config.es.ig");
	project_fr.load("tests/data/config.fr.ig");
    }


    public void testGetBooleanSetting() throws IllegalVariableException {
	Assert.assertTrue(project_en.getBooleanSetting("LOAD_AS_THEME"));
	Assert.assertTrue(project_es.getBooleanSetting("LOAD_AS_THEME"));
	Assert.assertTrue(project_fr.getBooleanSetting("LOAD_AS_THEME"));
    }


    public void testGetIntegerSetting() throws IllegalVariableException {
	Assert.assertEquals(project_en.getIntegerSetting("CREATED"), 1234);
    }


    public void testGetStringSetting() throws IllegalVariableException {
	Assert.assertEquals(project_en.getStringSetting("OUTPUT_FILENAME"),
		"english.html");
	Assert.assertEquals(project_es.getStringSetting("OUTPUT_FILENAME"),
		"spanish.html");
	Assert.assertEquals(project_fr.getStringSetting("OUTPUT_FILENAME"),
		"french.html");
    }


    public void testGetEnumSetting() throws IllegalVariableException {
	Assert.assertEquals(project_en.getEnumSetting("GET_METHOD"),
		"GET_METHOD_FILESYSTEM");
	Assert.assertEquals(project_es.getEnumSetting("GET_METHOD"),
		"GET_METHOD_FILESYSTEM");
	Assert.assertEquals(project_fr.getEnumSetting("GET_METHOD"),
		"GET_METHOD_FILESYSTEM");
    }


    public void testGetArraySetting() throws IllegalVariableException {
	Assert.assertTrue(arraysEqualHelper(project_en,
		    new String[]{"one", "two", "three"}));

	Assert.assertTrue(arraysEqualHelper(project_es,
		new String[]{"uno", "dos", "tres"}));

	Assert.assertTrue(arraysEqualHelper(project_fr,
		new String[]{"un", "deux", "trois"}));
    }


    private static boolean arraysEqualHelper(Project project,
	    String[] expected) throws IllegalVariableException {
	String[] result = project.getArraySetting("FILES_TO_COPY");
	return Arrays.equals(expected, result);
    }


    /*
     * testGetPlaceHolder is unnecessary, it is simply a wrapper for String
     * Settings.getPlaceHolder which has already been tested
     */


    /**
     * Test save()
     */
    public void testSave() {
	try {
	    project_en.save("tests/results/project_en.ig");
//	    project_es.save("tests/results/project_es.ig");
//	    project_fr.save("tests/results/project_fr.ig");
	} catch (Exception e) {
	    Assert.fail();
	}
    }
}
