/**
 * Class for parsing comment strings out of JPEG images.
 *
 * @version $Id: JPEGParser.java,v 1.4 2002/08/26 02:35:29 blsecres Exp $
 * @author Ben Secrest &lt;blsecres@users.sourceforge.net&gt;
 */
public class JPEGParser extends ImageParser implements FileParser {
    /** Search values for comment segment */
    private static byte[] findSegment = {(byte) 0xff, (byte) 0xfe};

    /** Number of bytes in length field */
    private static int lengthSize = 2;

    /** JPEG length headers count themselves in comment length */
    private static boolean sizeInLen = true;

    /** File extensions for JPEG files */
    private final static String[] extensions = {"jpg", "jpeg", "jfif", "jpe"};

    /** Mime types for JPEG files */
    private final static String[] mimeTypes = {"image/jpeg"};

    /** JPEG file magic signature */
    private final static byte[][] magic = {{(byte) 0xff, (byte) 0xd8,
	(byte) 0xff, (byte) 0xe0}};

    /** JPEG headers are always at the beginning of the file */
    private final static boolean magicOffset = false;

    /** JPEG headers are case sensitive */
    private final static boolean magicCase = true;

    /** JPEG FileMagic structure */
    private final static FileMagic jpegMagic = new FileMagic(magic, magicOffset,
	    magicCase);

    /**
     * Construct a new JPEGParser object with the given parsing options.
     * @param logObj The object to use for logging data
     * @param extract The set of desired fields to extract
     */
    public JPEGParser() {
	super(findSegment, lengthSize, sizeInLen);
    }


    /**
     * Supply extensions this parser can handle
     * @return String array of file extensions
     */
    public String[] getExtensions() {
	return extensions;
    }


    /**
     * Supply mime types this parser can handle
     * @return String array of mime types
     */
    public String[] getMimeTypes() {
	return mimeTypes;
    }


    /**
     * Supply file magic for files this parser can handle
     * @return Array of byte arrays containing magic signature
     */
    public FileMagic getMagic() {
	return jpegMagic;
    }
}
