/***************************************************************************
 *   Copyright (C) 2006 by Cvetoslav Ludmiloff <ludmiloff@gmail.com>       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "widgetselector.h"
#include "urlbutton.h"
#include <qpainter.h>
#include <kglobalsettings.h>

WidgetSelector::WidgetSelector(Sidebar* parent) :
    QToolButton(parent),
	m_mouseOver(false)
{
	setFocusPolicy(QWidget::NoFocus);
    m_widgetsMenu = new QPopupMenu(this);
	setAutoRaise(true);

	setUsesTextLabel(true);
	QFont adjustedFont(font());
	adjustedFont.setBold(true);
	setFont(adjustedFont);

/*
	const QDict<SidebarWidgetBase>& widgets = parent->widgets();
	QDictIterator<SidebarWidgetBase> it(widgets);
	for (it; it.current(); ++it)
	{
		qDebug(it.current()->title());
        m_widgetsMenu->insertItem(it.current()->title());
	}
*/
	//setText("My places");

    connect(m_widgetsMenu, SIGNAL(activated(int)),
            this, SLOT(slotWidgetActivated(int)));

	// TODO: the delay value should be configured through the DolphinSettings
	setPopupDelay(10);
	setPopup(m_widgetsMenu);
}


WidgetSelector::~WidgetSelector()
{
}

void WidgetSelector::slotSetCurrentWidget(const QString& widgetName, uint /*wtype*/)
{
	setText(widgetName);
}

void WidgetSelector::slotWidgetActivated(int indx)
{
	QString widgetName = m_widgetsMenu->text(indx);
	// the title should be set after successful processing of signal at parent level
	//setText(widgetName);
	update();
	emit widgetChangeRequest(widgetName);
}

void WidgetSelector::newWidgetRegistered(const QString& widgetName)
{
	// TODO: construct more eye candy menu (icons, additional text indicating
	// current widget etc
	m_widgetsMenu->insertItem(widgetName);
}

void WidgetSelector::drawButtonLabel(QPainter* painter)
{
    QColor backgroundColor;
    QColor foregroundColor;

    if (m_mouseOver) {
        foregroundColor = KGlobalSettings::buttonTextColor();
		painter->setPen(foregroundColor);
    }
    else {
        backgroundColor = colorGroup().background();
        foregroundColor = KGlobalSettings::buttonTextColor();
        foregroundColor = mixColors(foregroundColor, backgroundColor);
        painter->setPen(foregroundColor);
    }

    const int align = Qt::AlignVCenter | Qt::AlignCenter;
    painter->drawText(QRect(0, 0, width(), height()), align, text());
	//QToolButton::drawButtonLabel(painter);
}

/*void WidgetSelector::drawButton(QPainter* painter)
{
    const int buttonWidth  = width()-2;
    const int buttonHeight = height()-2;

    QColor backgroundColor;
    QColor foregroundColor;
    if (m_mouseOver) {
        backgroundColor = KGlobalSettings::highlightColor();
        foregroundColor = KGlobalSettings::highlightedTextColor();
    }
    else {
        backgroundColor = colorGroup().background();
        foregroundColor = KGlobalSettings::buttonTextColor();
    }

    // draw button backround
    if (m_mouseOver) {
        painter->setPen(foregroundColor);
    }
    else {
        // dimm the foreground color by mixing it with the background
        foregroundColor = mixColors(foregroundColor, backgroundColor);
        painter->setPen(foregroundColor);
    }

	painter->setPen(NoPen);
	painter->setBrush(backgroundColor);
	painter->drawRect( 1, 1, buttonWidth, buttonHeight);

	// round the corners
	painter->setPen( foregroundColor );
	painter->drawPoint( 1, 1 );
	painter->drawPoint( 1, buttonHeight );
	painter->drawPoint( buttonWidth, 1 );
	painter->drawPoint( buttonWidth, buttonHeight);

	drawButtonLabel(painter);

    // draw arrow
	const int startTopY = 8;
    const int awidth = height() - 16;
    const int middleX = awidth / 2;
    const int startX = (width() - awidth) - 4;
	const int endX = width() - 5;

    const int startLeftX = startX - (awidth - 1);
    const int startRightX = startX + (awidth - 1);

    for (int i = 0; i < middleX; ++i) {
        painter->drawLine(startX + i, startTopY, startX + i, startTopY + i*2);
        painter->drawLine(endX - i, startTopY, endX - i, startTopY + i*2);
    }

	// TODO: draw icon
    // draw icon
    //const QPixmap* icon = pixmap();
    //if (icon != 0) {
    //    const int x = (buttonWidth - icon->width()) / 2;
    //    const int y = (buttonHeight - icon->height()) / 2;
    //    painter->drawPixmap(x, y, *icon);
    //}
}

*/


void WidgetSelector::enterEvent(QEvent* event)
{
    QToolButton::enterEvent(event);
    m_mouseOver = true;
    update();
}

void WidgetSelector::leaveEvent(QEvent* event)
{
    QToolButton::leaveEvent(event);
    m_mouseOver = false;
    update();
}


QColor WidgetSelector::mixColors(const QColor& c1,
                            const QColor& c2) const
{
    const int red   = (c1.red()   + c2.red())   / 2;
    const int green = (c1.green() + c2.green()) / 2;
    const int blue  = (c1.blue()  + c2.blue())  / 2;
    return QColor(red, green, blue);
}
