/***************************************************************************
 *   Copyright (C) 2006 by Cvetoslav Ludmiloff <ludmiloff@gmail.com>       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "sidebarwidget.h"
#include <qwidget.h>

SidebarWidgetBase::SidebarWidgetBase(QWidget* parent, const char* name) :
	QWidget(parent, name)
{
}

SidebarWidgetBase::~SidebarWidgetBase()
{
}

const QString& SidebarWidgetBase::title() const
{
	return m_title;
}

const uint SidebarWidgetBase::wtype() const
{
	return m_wtype;
}

void SidebarWidgetBase::ContentViewTypeChanged() {}
void SidebarWidgetBase::ContentSelectedItemChanged() {}
void SidebarWidgetBase::URLChanged() {}

void SidebarWidgetBase::ItemSelected(const KURL& url)
{
	emit urlChangeRequest(url);
}
