/***************************************************************************
 *   Copyright (C) 2006 by Cvetoslav Ludmiloff <ludmiloff@gmail.com>       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _SIDEBAR_H_
#define _SIDEBAR_H_

#include <qlayout.h>
#include <kurl.h>
#include <qdict.h>
#include "sidebarwidget.h"

class WidgetSelector;
class SidebarWidgetBase;

class Sidebar : public QWidget {
	Q_OBJECT
public:
    enum Mode
    {
        IconsOnly = 0,
        IconsListView = 1
    };

    Sidebar(QWidget* parent, Mode mode = IconsListView);
    virtual ~Sidebar();

	const QDict<SidebarWidgetBase>& widgets() const { return m_widgetCollection; }

public slots:
	// for internal use only
	void urlRequest(const KURL& url);
	void changeWidget(const QString&);	

signals:
	/**
	 * The user selected an item on sidebar widget and item has
	 * URL property, so inform the parent togo to this URL;
	 * WARNING: there is no check about URL validity, so
	 * parent must show an appropriate message if URL is invalid or
	 * for some reason unavailable
	 */	
	void urlChanged(const KURL& url);

	/**
	 * If for some reason parent view should be changed when
	 * new widget is selected, just catch this signal
	 */
	void widgetChanged(const QString& key, uint wtype);
	
	/**
	 * Emits every time new widget is registered/unregistered;
	 * not so useful for the parent, but for widget selector
	 */	
	void widgetRegistered(const QString& key);
	void widgetUnregistered(const QString& key);

	/**
	 * When the user click on close button to inform the parent for
	 * remove sidebar and repaint the view
	 */
	void sidebarClosed();


protected:
	// not realy used for now, should be responsible for 
	// external (plugin) widget loading and creation
	bool registerWidget(const QString& library);
	bool createPluginWidgets();
	
private:
	/**
	 * creates and initailize all builtin widgets
	 */
	bool createBuiltinWidgets();

    Mode m_mode;
    QVBoxLayout* m_layout;
	QHBoxLayout* m_toplayout;

    WidgetSelector* m_selector;
	QDict<SidebarWidgetBase> m_widgetCollection;	
    SidebarWidgetBase* m_currentWidget;

	//virtual QSize sizeHint() const;

};

#endif // _SIDEBAR_H_
