// This code conforms with the UFC specification version 2016.2.0
// and was automatically generated by FFC version 2016.2.0.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   True
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   max_signature_length:           0
//   optimize:                       True
//   precision:                      15
//   quadrature_degree:              -1
//   quadrature_rule:                'auto'
//   representation:                 'uflacs'
//   split:                          True

#ifndef __CAHNHILLIARD2D_H
#define __CAHNHILLIARD2D_H
#include <cmath>
#include <cstring>
#include <stdexcept>
#include <ufc.h>

class cahnhilliard2d_finite_element_0: public ufc::finite_element
{
public:

  cahnhilliard2d_finite_element_0();

  ~cahnhilliard2d_finite_element_0() override;

  const char * signature() const final override;

  ufc::shape cell_shape() const final override;

  std::size_t topological_dimension() const final override;

  std::size_t geometric_dimension() const final override;

  std::size_t space_dimension() const final override;

  std::size_t value_rank() const final override;

  std::size_t value_dimension(std::size_t i) const final override;

  std::size_t value_size() const final override;

  std::size_t reference_value_rank() const final override;

  std::size_t reference_value_dimension(std::size_t i) const final override;

  std::size_t reference_value_size() const final override;

  std::size_t degree() const final override;

  const char * family() const final override;

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation);

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation);

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation);

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation);

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override;

  void evaluate_dofs(double * values,
                     const ufc::function& f,
                     const double * coordinate_dofs,
                     int cell_orientation,
                     const ufc::cell& c) const final override;

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override;

  void tabulate_dof_coordinates(double * coordinates,
                                const double * coordinate_dofs) const final override;

  std::size_t num_sub_elements() const final override;

  ufc::finite_element * create_sub_element(std::size_t i) const final override;

  ufc::finite_element * create() const final override;

};


class cahnhilliard2d_finite_element_1: public ufc::finite_element
{
public:

  cahnhilliard2d_finite_element_1();

  ~cahnhilliard2d_finite_element_1() override;

  const char * signature() const final override;

  ufc::shape cell_shape() const final override;

  std::size_t topological_dimension() const final override;

  std::size_t geometric_dimension() const final override;

  std::size_t space_dimension() const final override;

  std::size_t value_rank() const final override;

  std::size_t value_dimension(std::size_t i) const final override;

  std::size_t value_size() const final override;

  std::size_t reference_value_rank() const final override;

  std::size_t reference_value_dimension(std::size_t i) const final override;

  std::size_t reference_value_size() const final override;

  std::size_t degree() const final override;

  const char * family() const final override;

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation);

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation);

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation);

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation);

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override;

  void evaluate_dofs(double * values,
                     const ufc::function& f,
                     const double * coordinate_dofs,
                     int cell_orientation,
                     const ufc::cell& c) const final override;

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override;

  void tabulate_dof_coordinates(double * coordinates,
                                const double * coordinate_dofs) const final override;

  std::size_t num_sub_elements() const final override;

  ufc::finite_element * create_sub_element(std::size_t i) const final override;

  ufc::finite_element * create() const final override;

};


class cahnhilliard2d_finite_element_2: public ufc::finite_element
{
public:

  cahnhilliard2d_finite_element_2();

  ~cahnhilliard2d_finite_element_2() override;

  const char * signature() const final override;

  ufc::shape cell_shape() const final override;

  std::size_t topological_dimension() const final override;

  std::size_t geometric_dimension() const final override;

  std::size_t space_dimension() const final override;

  std::size_t value_rank() const final override;

  std::size_t value_dimension(std::size_t i) const final override;

  std::size_t value_size() const final override;

  std::size_t reference_value_rank() const final override;

  std::size_t reference_value_dimension(std::size_t i) const final override;

  std::size_t reference_value_size() const final override;

  std::size_t degree() const final override;

  const char * family() const final override;

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation);

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation);

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation);

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation);

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override;

  void evaluate_dofs(double * values,
                     const ufc::function& f,
                     const double * coordinate_dofs,
                     int cell_orientation,
                     const ufc::cell& c) const final override;

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override;

  void tabulate_dof_coordinates(double * coordinates,
                                const double * coordinate_dofs) const final override;

  std::size_t num_sub_elements() const final override;

  ufc::finite_element * create_sub_element(std::size_t i) const final override;

  ufc::finite_element * create() const final override;

};


class cahnhilliard2d_finite_element_3: public ufc::finite_element
{
public:

  cahnhilliard2d_finite_element_3();

  ~cahnhilliard2d_finite_element_3() override;

  const char * signature() const final override;

  ufc::shape cell_shape() const final override;

  std::size_t topological_dimension() const final override;

  std::size_t geometric_dimension() const final override;

  std::size_t space_dimension() const final override;

  std::size_t value_rank() const final override;

  std::size_t value_dimension(std::size_t i) const final override;

  std::size_t value_size() const final override;

  std::size_t reference_value_rank() const final override;

  std::size_t reference_value_dimension(std::size_t i) const final override;

  std::size_t reference_value_size() const final override;

  std::size_t degree() const final override;

  const char * family() const final override;

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation);

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation);

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation);

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation);

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override;

  void evaluate_dofs(double * values,
                     const ufc::function& f,
                     const double * coordinate_dofs,
                     int cell_orientation,
                     const ufc::cell& c) const final override;

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override;

  void tabulate_dof_coordinates(double * coordinates,
                                const double * coordinate_dofs) const final override;

  std::size_t num_sub_elements() const final override;

  ufc::finite_element * create_sub_element(std::size_t i) const final override;

  ufc::finite_element * create() const final override;

};


class cahnhilliard2d_dofmap_0: public ufc::dofmap
{
public:

  cahnhilliard2d_dofmap_0();

  ~cahnhilliard2d_dofmap_0() override;

  const char * signature() const final override;

  bool needs_mesh_entities(std::size_t d) const final override;

  std::size_t topological_dimension() const final override;

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override;

  std::size_t num_element_dofs() const final override;

  std::size_t num_facet_dofs() const final override;

  std::size_t num_entity_dofs(std::size_t d) const final override;

  std::size_t num_entity_closure_dofs(std::size_t d) const final override;

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override;

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override;

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override;

  void tabulate_entity_closure_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override;

  std::size_t num_sub_dofmaps() const final override;

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override;

  ufc::dofmap * create() const final override;

};


class cahnhilliard2d_dofmap_1: public ufc::dofmap
{
public:

  cahnhilliard2d_dofmap_1();

  ~cahnhilliard2d_dofmap_1() override;

  const char * signature() const final override;

  bool needs_mesh_entities(std::size_t d) const final override;

  std::size_t topological_dimension() const final override;

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override;

  std::size_t num_element_dofs() const final override;

  std::size_t num_facet_dofs() const final override;

  std::size_t num_entity_dofs(std::size_t d) const final override;

  std::size_t num_entity_closure_dofs(std::size_t d) const final override;

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override;

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override;

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override;

  void tabulate_entity_closure_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override;

  std::size_t num_sub_dofmaps() const final override;

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override;

  ufc::dofmap * create() const final override;

};


class cahnhilliard2d_dofmap_2: public ufc::dofmap
{
public:

  cahnhilliard2d_dofmap_2();

  ~cahnhilliard2d_dofmap_2() override;

  const char * signature() const final override;

  bool needs_mesh_entities(std::size_t d) const final override;

  std::size_t topological_dimension() const final override;

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override;

  std::size_t num_element_dofs() const final override;

  std::size_t num_facet_dofs() const final override;

  std::size_t num_entity_dofs(std::size_t d) const final override;

  std::size_t num_entity_closure_dofs(std::size_t d) const final override;

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override;

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override;

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override;

  void tabulate_entity_closure_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override;

  std::size_t num_sub_dofmaps() const final override;

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override;

  ufc::dofmap * create() const final override;

};


class cahnhilliard2d_dofmap_3: public ufc::dofmap
{
public:

  cahnhilliard2d_dofmap_3();

  ~cahnhilliard2d_dofmap_3() override;

  const char * signature() const final override;

  bool needs_mesh_entities(std::size_t d) const final override;

  std::size_t topological_dimension() const final override;

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override;

  std::size_t num_element_dofs() const final override;

  std::size_t num_facet_dofs() const final override;

  std::size_t num_entity_dofs(std::size_t d) const final override;

  std::size_t num_entity_closure_dofs(std::size_t d) const final override;

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override;

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override;

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override;

  void tabulate_entity_closure_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override;

  std::size_t num_sub_dofmaps() const final override;

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override;

  ufc::dofmap * create() const final override;

};


class cahnhilliard2d_cell_integral_0_otherwise: public ufc::cell_integral
{
public:

  cahnhilliard2d_cell_integral_0_otherwise();

  ~cahnhilliard2d_cell_integral_0_otherwise() override;

  const std::vector<bool> & enabled_coefficients() const final override;

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override;

};


class cahnhilliard2d_cell_integral_1_otherwise: public ufc::cell_integral
{
public:

  cahnhilliard2d_cell_integral_1_otherwise();

  ~cahnhilliard2d_cell_integral_1_otherwise() override;

  const std::vector<bool> & enabled_coefficients() const final override;

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override;

};


class cahnhilliard2d_form_0: public ufc::form
{
public:

  cahnhilliard2d_form_0();

  ~cahnhilliard2d_form_0() override;

  const char * signature() const final override;

  std::size_t rank() const final override;

  std::size_t num_coefficients() const final override;

  std::size_t original_coefficient_position(std::size_t i) const final override;

  ufc::finite_element * create_coordinate_finite_element() const final override;

  ufc::dofmap * create_coordinate_dofmap() const final override;

  ufc::coordinate_mapping * create_coordinate_mapping() const final override;

  ufc::finite_element * create_finite_element(std::size_t i) const final override;

  ufc::dofmap * create_dofmap(std::size_t i) const final override;

  std::size_t max_cell_subdomain_id() const final override;

  std::size_t max_exterior_facet_subdomain_id() const final override;

  std::size_t max_interior_facet_subdomain_id() const final override;

  std::size_t max_vertex_subdomain_id() const final override;

  std::size_t max_custom_subdomain_id() const final override;

  std::size_t max_cutcell_subdomain_id() const final override;

  std::size_t max_interface_subdomain_id() const final override;

  std::size_t max_overlap_subdomain_id() const final override;

  bool has_cell_integrals() const final override;

  bool has_exterior_facet_integrals() const final override;

  bool has_interior_facet_integrals() const final override;

  bool has_vertex_integrals() const final override;

  bool has_custom_integrals() const final override;

  bool has_cutcell_integrals() const final override;

  bool has_interface_integrals() const final override;

  bool has_overlap_integrals() const final override;

  ufc::cell_integral * create_cell_integral(std::size_t i) const final override;

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t i) const final override;

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t i) const final override;

  ufc::vertex_integral * create_vertex_integral(std::size_t i) const final override;

  ufc::custom_integral * create_custom_integral(std::size_t i) const final override;

  ufc::cutcell_integral * create_cutcell_integral(std::size_t i) const final override;

  ufc::interface_integral * create_interface_integral(std::size_t i) const final override;

  ufc::overlap_integral * create_overlap_integral(std::size_t i) const final override;

  ufc::cell_integral * create_default_cell_integral() const final override;

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override;

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override;

  ufc::vertex_integral * create_default_vertex_integral() const final override;

  ufc::custom_integral * create_default_custom_integral() const final override;

  ufc::cutcell_integral * create_default_cutcell_integral() const final override;

  ufc::interface_integral * create_default_interface_integral() const final override;

  ufc::overlap_integral * create_default_overlap_integral() const final override;

};


class cahnhilliard2d_form_1: public ufc::form
{
public:

  cahnhilliard2d_form_1();

  ~cahnhilliard2d_form_1() override;

  const char * signature() const final override;

  std::size_t rank() const final override;

  std::size_t num_coefficients() const final override;

  std::size_t original_coefficient_position(std::size_t i) const final override;

  ufc::finite_element * create_coordinate_finite_element() const final override;

  ufc::dofmap * create_coordinate_dofmap() const final override;

  ufc::coordinate_mapping * create_coordinate_mapping() const final override;

  ufc::finite_element * create_finite_element(std::size_t i) const final override;

  ufc::dofmap * create_dofmap(std::size_t i) const final override;

  std::size_t max_cell_subdomain_id() const final override;

  std::size_t max_exterior_facet_subdomain_id() const final override;

  std::size_t max_interior_facet_subdomain_id() const final override;

  std::size_t max_vertex_subdomain_id() const final override;

  std::size_t max_custom_subdomain_id() const final override;

  std::size_t max_cutcell_subdomain_id() const final override;

  std::size_t max_interface_subdomain_id() const final override;

  std::size_t max_overlap_subdomain_id() const final override;

  bool has_cell_integrals() const final override;

  bool has_exterior_facet_integrals() const final override;

  bool has_interior_facet_integrals() const final override;

  bool has_vertex_integrals() const final override;

  bool has_custom_integrals() const final override;

  bool has_cutcell_integrals() const final override;

  bool has_interface_integrals() const final override;

  bool has_overlap_integrals() const final override;

  ufc::cell_integral * create_cell_integral(std::size_t i) const final override;

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t i) const final override;

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t i) const final override;

  ufc::vertex_integral * create_vertex_integral(std::size_t i) const final override;

  ufc::custom_integral * create_custom_integral(std::size_t i) const final override;

  ufc::cutcell_integral * create_cutcell_integral(std::size_t i) const final override;

  ufc::interface_integral * create_interface_integral(std::size_t i) const final override;

  ufc::overlap_integral * create_overlap_integral(std::size_t i) const final override;

  ufc::cell_integral * create_default_cell_integral() const final override;

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override;

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override;

  ufc::vertex_integral * create_default_vertex_integral() const final override;

  ufc::custom_integral * create_default_custom_integral() const final override;

  ufc::cutcell_integral * create_default_cutcell_integral() const final override;

  ufc::interface_integral * create_default_interface_integral() const final override;

  ufc::overlap_integral * create_default_overlap_integral() const final override;

};

// DOLFIN wrappers

// Standard library includes
#include <string>

// DOLFIN includes
#include <dolfin/common/NoDeleter.h>
#include <dolfin/mesh/Mesh.h>
#include <dolfin/mesh/MultiMesh.h>
#include <dolfin/fem/FiniteElement.h>
#include <dolfin/fem/DofMap.h>
#include <dolfin/fem/Form.h>
#include <dolfin/fem/MultiMeshForm.h>
#include <dolfin/function/FunctionSpace.h>
#include <dolfin/function/MultiMeshFunctionSpace.h>
#include <dolfin/function/GenericFunction.h>
#include <dolfin/function/CoefficientAssigner.h>
#include <dolfin/function/MultiMeshCoefficientAssigner.h>
#include <dolfin/adaptivity/ErrorControl.h>
#include <dolfin/adaptivity/GoalFunctional.h>
#include <dolfin/la/GenericVector.h>

namespace CahnHilliard2D
{

class CoefficientSpace_dt: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_dt(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<cahnhilliard2d_finite_element_3>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<cahnhilliard2d_dofmap_3>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_dt(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<cahnhilliard2d_finite_element_3>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<cahnhilliard2d_dofmap_3>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_lmbda: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_lmbda(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<cahnhilliard2d_finite_element_3>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<cahnhilliard2d_dofmap_3>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_lmbda(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<cahnhilliard2d_finite_element_3>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<cahnhilliard2d_dofmap_3>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_theta: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_theta(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<cahnhilliard2d_finite_element_3>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<cahnhilliard2d_dofmap_3>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_theta(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<cahnhilliard2d_finite_element_3>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<cahnhilliard2d_dofmap_3>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_u: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_u(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<cahnhilliard2d_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<cahnhilliard2d_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_u(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<cahnhilliard2d_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<cahnhilliard2d_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_u0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_u0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<cahnhilliard2d_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<cahnhilliard2d_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_u0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<cahnhilliard2d_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<cahnhilliard2d_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_F_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_F_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<cahnhilliard2d_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<cahnhilliard2d_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_F_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<cahnhilliard2d_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<cahnhilliard2d_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_F_MultiMeshFunctionSpace_0: public dolfin::MultiMeshFunctionSpace
{
public:

  // Constructor for multimesh function space
  Form_F_MultiMeshFunctionSpace_0(std::shared_ptr<const dolfin::MultiMesh> multimesh): dolfin::MultiMeshFunctionSpace(multimesh)
  {
    // Create and add standard function spaces
    for (std::size_t part = 0; part < multimesh->num_parts(); part++)
    {
      std::shared_ptr<const dolfin::FunctionSpace> V(new Form_F_FunctionSpace_0(multimesh->part(part)));
      add(V);
    }

    // Build multimesh function space
    build();
  }

};

typedef CoefficientSpace_u Form_F_FunctionSpace_1;

typedef CoefficientSpace_u0 Form_F_FunctionSpace_2;

typedef CoefficientSpace_lmbda Form_F_FunctionSpace_3;

typedef CoefficientSpace_dt Form_F_FunctionSpace_4;

typedef CoefficientSpace_theta Form_F_FunctionSpace_5;

class Form_F: public dolfin::Form
{
public:

  // Constructor
  Form_F(std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 5), u(*this, 0), u0(*this, 1), lmbda(*this, 2), dt(*this, 3), theta(*this, 4)
  {
    _function_spaces[0] = V0;

    _ufc_form = std::make_shared<const cahnhilliard2d_form_0>();
  }

  // Constructor
  Form_F(std::shared_ptr<const dolfin::FunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> u, std::shared_ptr<const dolfin::GenericFunction> u0, std::shared_ptr<const dolfin::GenericFunction> lmbda, std::shared_ptr<const dolfin::GenericFunction> dt, std::shared_ptr<const dolfin::GenericFunction> theta):
    dolfin::Form(1, 5), u(*this, 0), u0(*this, 1), lmbda(*this, 2), dt(*this, 3), theta(*this, 4)
  {
    _function_spaces[0] = V0;

    this->u = u;
    this->u0 = u0;
    this->lmbda = lmbda;
    this->dt = dt;
    this->theta = theta;

    _ufc_form = std::make_shared<const cahnhilliard2d_form_0>();
  }

  // Destructor
  ~Form_F()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "u")
      return 0;
    else if (name == "u0")
      return 1;
    else if (name == "lmbda")
      return 2;
    else if (name == "dt")
      return 3;
    else if (name == "theta")
      return 4;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "u";
    case 1:
      return "u0";
    case 2:
      return "lmbda";
    case 3:
      return "dt";
    case 4:
      return "theta";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_F_FunctionSpace_0 TestSpace;
  typedef Form_F_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_F_FunctionSpace_1 CoefficientSpace_u;
  typedef Form_F_FunctionSpace_2 CoefficientSpace_u0;
  typedef Form_F_FunctionSpace_3 CoefficientSpace_lmbda;
  typedef Form_F_FunctionSpace_4 CoefficientSpace_dt;
  typedef Form_F_FunctionSpace_5 CoefficientSpace_theta;

  // Coefficients
  dolfin::CoefficientAssigner u;
  dolfin::CoefficientAssigner u0;
  dolfin::CoefficientAssigner lmbda;
  dolfin::CoefficientAssigner dt;
  dolfin::CoefficientAssigner theta;
};

class MultiMeshForm_F: public dolfin::MultiMeshForm
{
public:

  // Constructor
  MultiMeshForm_F(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0):
    dolfin::MultiMeshForm(V0), u(*this, 0), u0(*this, 1), lmbda(*this, 2), dt(*this, 3), theta(*this, 4)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<dolfin::Form> a(new Form_F(V0->part(part)));
    add(a);

    }
    // Build multimesh form
    build();

    /// Assign coefficients

  }

  // Constructor
  MultiMeshForm_F(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> u, std::shared_ptr<const dolfin::GenericFunction> u0, std::shared_ptr<const dolfin::GenericFunction> lmbda, std::shared_ptr<const dolfin::GenericFunction> dt, std::shared_ptr<const dolfin::GenericFunction> theta):
    dolfin::MultiMeshForm(V0), u(*this, 0), u0(*this, 1), lmbda(*this, 2), dt(*this, 3), theta(*this, 4)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<dolfin::Form> a(new Form_F(V0->part(part)));
    add(a);

    }
    // Build multimesh form
    build();

    /// Assign coefficients
    this->u = u;
    this->u0 = u0;
    this->lmbda = lmbda;
    this->dt = dt;
    this->theta = theta;

  }

  // Destructor
  ~MultiMeshForm_F()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "u")
      return 0;
    else if (name == "u0")
      return 1;
    else if (name == "lmbda")
      return 2;
    else if (name == "dt")
      return 3;
    else if (name == "theta")
      return 4;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "u";
    case 1:
      return "u0";
    case 2:
      return "lmbda";
    case 3:
      return "dt";
    case 4:
      return "theta";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_F_FunctionSpace_0 TestSpace;
  typedef Form_F_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_F_FunctionSpace_1 CoefficientSpace_u;
  typedef Form_F_FunctionSpace_2 CoefficientSpace_u0;
  typedef Form_F_FunctionSpace_3 CoefficientSpace_lmbda;
  typedef Form_F_FunctionSpace_4 CoefficientSpace_dt;
  typedef Form_F_FunctionSpace_5 CoefficientSpace_theta;

  // Coefficients
  dolfin::MultiMeshCoefficientAssigner u;
  dolfin::MultiMeshCoefficientAssigner u0;
  dolfin::MultiMeshCoefficientAssigner lmbda;
  dolfin::MultiMeshCoefficientAssigner dt;
  dolfin::MultiMeshCoefficientAssigner theta;
};

class Form_J_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_J_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<cahnhilliard2d_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<cahnhilliard2d_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_J_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<cahnhilliard2d_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<cahnhilliard2d_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_J_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_J_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<cahnhilliard2d_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<cahnhilliard2d_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_J_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<cahnhilliard2d_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<cahnhilliard2d_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_J_MultiMeshFunctionSpace_0: public dolfin::MultiMeshFunctionSpace
{
public:

  // Constructor for multimesh function space
  Form_J_MultiMeshFunctionSpace_0(std::shared_ptr<const dolfin::MultiMesh> multimesh): dolfin::MultiMeshFunctionSpace(multimesh)
  {
    // Create and add standard function spaces
    for (std::size_t part = 0; part < multimesh->num_parts(); part++)
    {
      std::shared_ptr<const dolfin::FunctionSpace> V(new Form_J_FunctionSpace_0(multimesh->part(part)));
      add(V);
    }

    // Build multimesh function space
    build();
  }

};

class Form_J_MultiMeshFunctionSpace_1: public dolfin::MultiMeshFunctionSpace
{
public:

  // Constructor for multimesh function space
  Form_J_MultiMeshFunctionSpace_1(std::shared_ptr<const dolfin::MultiMesh> multimesh): dolfin::MultiMeshFunctionSpace(multimesh)
  {
    // Create and add standard function spaces
    for (std::size_t part = 0; part < multimesh->num_parts(); part++)
    {
      std::shared_ptr<const dolfin::FunctionSpace> V(new Form_J_FunctionSpace_1(multimesh->part(part)));
      add(V);
    }

    // Build multimesh function space
    build();
  }

};

typedef CoefficientSpace_u Form_J_FunctionSpace_2;

typedef CoefficientSpace_lmbda Form_J_FunctionSpace_3;

typedef CoefficientSpace_dt Form_J_FunctionSpace_4;

typedef CoefficientSpace_theta Form_J_FunctionSpace_5;

class Form_J: public dolfin::Form
{
public:

  // Constructor
  Form_J(std::shared_ptr<const dolfin::FunctionSpace> V1, std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 4), u(*this, 0), lmbda(*this, 1), dt(*this, 2), theta(*this, 3)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = std::make_shared<const cahnhilliard2d_form_1>();
  }

  // Constructor
  Form_J(std::shared_ptr<const dolfin::FunctionSpace> V1, std::shared_ptr<const dolfin::FunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> u, std::shared_ptr<const dolfin::GenericFunction> lmbda, std::shared_ptr<const dolfin::GenericFunction> dt, std::shared_ptr<const dolfin::GenericFunction> theta):
    dolfin::Form(2, 4), u(*this, 0), lmbda(*this, 1), dt(*this, 2), theta(*this, 3)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    this->u = u;
    this->lmbda = lmbda;
    this->dt = dt;
    this->theta = theta;

    _ufc_form = std::make_shared<const cahnhilliard2d_form_1>();
  }

  // Destructor
  ~Form_J()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "u")
      return 0;
    else if (name == "lmbda")
      return 1;
    else if (name == "dt")
      return 2;
    else if (name == "theta")
      return 3;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "u";
    case 1:
      return "lmbda";
    case 2:
      return "dt";
    case 3:
      return "theta";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_J_FunctionSpace_0 TestSpace;
  typedef Form_J_FunctionSpace_1 TrialSpace;
  typedef Form_J_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_J_MultiMeshFunctionSpace_1 MultiMeshTrialSpace;
  typedef Form_J_FunctionSpace_2 CoefficientSpace_u;
  typedef Form_J_FunctionSpace_3 CoefficientSpace_lmbda;
  typedef Form_J_FunctionSpace_4 CoefficientSpace_dt;
  typedef Form_J_FunctionSpace_5 CoefficientSpace_theta;

  // Coefficients
  dolfin::CoefficientAssigner u;
  dolfin::CoefficientAssigner lmbda;
  dolfin::CoefficientAssigner dt;
  dolfin::CoefficientAssigner theta;
};

class MultiMeshForm_J: public dolfin::MultiMeshForm
{
public:

  // Constructor
  MultiMeshForm_J(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V1, std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0):
    dolfin::MultiMeshForm(V1, V0), u(*this, 0), lmbda(*this, 1), dt(*this, 2), theta(*this, 3)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<dolfin::Form> a(new Form_J(V1->part(part), V0->part(part)));
    add(a);

    }
    // Build multimesh form
    build();

    /// Assign coefficients

  }

  // Constructor
  MultiMeshForm_J(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V1, std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> u, std::shared_ptr<const dolfin::GenericFunction> lmbda, std::shared_ptr<const dolfin::GenericFunction> dt, std::shared_ptr<const dolfin::GenericFunction> theta):
    dolfin::MultiMeshForm(V1, V0), u(*this, 0), lmbda(*this, 1), dt(*this, 2), theta(*this, 3)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<dolfin::Form> a(new Form_J(V1->part(part), V0->part(part)));
    add(a);

    }
    // Build multimesh form
    build();

    /// Assign coefficients
    this->u = u;
    this->lmbda = lmbda;
    this->dt = dt;
    this->theta = theta;

  }

  // Destructor
  ~MultiMeshForm_J()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "u")
      return 0;
    else if (name == "lmbda")
      return 1;
    else if (name == "dt")
      return 2;
    else if (name == "theta")
      return 3;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "u";
    case 1:
      return "lmbda";
    case 2:
      return "dt";
    case 3:
      return "theta";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_J_FunctionSpace_0 TestSpace;
  typedef Form_J_FunctionSpace_1 TrialSpace;
  typedef Form_J_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_J_MultiMeshFunctionSpace_1 MultiMeshTrialSpace;
  typedef Form_J_FunctionSpace_2 CoefficientSpace_u;
  typedef Form_J_FunctionSpace_3 CoefficientSpace_lmbda;
  typedef Form_J_FunctionSpace_4 CoefficientSpace_dt;
  typedef Form_J_FunctionSpace_5 CoefficientSpace_theta;

  // Coefficients
  dolfin::MultiMeshCoefficientAssigner u;
  dolfin::MultiMeshCoefficientAssigner lmbda;
  dolfin::MultiMeshCoefficientAssigner dt;
  dolfin::MultiMeshCoefficientAssigner theta;
};

// Class typedefs
typedef Form_J BilinearForm;
typedef MultiMeshForm_J MultiMeshBilinearForm;
typedef Form_J JacobianForm;
typedef MultiMeshForm_J MultiMeshJacobianForm;
typedef Form_F LinearForm;
typedef MultiMeshForm_F MultiMeshLinearForm;
typedef Form_F ResidualForm;
typedef MultiMeshForm_F MultiMeshResidualForm;
typedef Form_F::TestSpace FunctionSpace;
typedef Form_F::MultiMeshTestSpace MultiMeshFunctionSpace;

}

#endif
