__author__ = "Anders Logg (logg@simula.no)"
__date__ = "2009-09-16 -- 2009-09-16"
__copyright__ = "Copyright (C) 2009 Anders Logg"
__license__  = "GNU LGPL Version 2.1"

# Modified by Johannes Ring, 2009.

from subprocess import Popen, PIPE, STDOUT

# These are taken from http://ivory.idyll.org/blog/mar-07/replacing-commands-with-subprocess

__all__ = ['getoutput', 'getstatusoutput']

def getoutput(cmd):
    "Replacement for commands.getoutput which does not work on Windows."
    pipe = Popen(cmd, shell=True, stdout=PIPE, stderr=STDOUT, bufsize=-1)
    r = pipe.wait()
    output, error = pipe.communicate()
    return output

def getstatusoutput(cmd, input=None, cwd=None, env=None):
    "Replacement for commands.getstatusoutput which does not work on Windows."
    pipe = Popen(cmd, shell=True, cwd=cwd, env=env, stdout=PIPE, stderr=STDOUT)
    output, error = pipe.communicate(input=input)
    assert not error
    status = pipe.returncode
    return status, output
