/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.Context;
import com.icl.saxon.expr.FragmentValue;
import com.icl.saxon.expr.NodeSetIntent;
import com.icl.saxon.expr.Value;
import com.icl.saxon.functions.Extensions;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import com.nwalsh.saxon.CalloutEmitter;
import com.nwalsh.saxon.FormatCallout;
import com.nwalsh.saxon.FormatGraphicCallout;
import com.nwalsh.saxon.FormatTextCallout;
import com.nwalsh.saxon.FormatUnicodeCallout;
import com.nwalsh.saxon.LineCountEmitter;
import com.nwalsh.saxon.NumberLinesEmitter;
import org.xml.sax.SAXException;

public class Verbatim {
    private static boolean foStylesheet = false;
    private static int modulus = 0;
    private static int width = 0;
    private static String separator = "";
    private static int defaultColumn = 60;
    private static FormatCallout fCallout = null;

    protected static String getVariable(Context context, String varName) {
        Value variable = null;
        String varString = null;
        try {
            variable = Extensions.evaluate((Context)context, (String)("$" + varName));
            varString = variable.asString();
            return varString;
        }
        catch (SAXException sAXException) {
            System.out.println("Undefined variable: " + varName);
            return "";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Undefined variable: " + varName);
            return "";
        }
    }

    public static FragmentValue insertCallouts(Context context, NodeSetIntent areaspecNodeSet, FragmentValue rtf) {
        Verbatim.setupCallouts(context);
        try {
            NamePool namePool = context.getController().getNamePool();
            CalloutEmitter cEmitter = new CalloutEmitter(namePool, defaultColumn, foStylesheet, fCallout);
            cEmitter.setupCallouts(areaspecNodeSet);
            rtf.replay((Emitter)cEmitter);
            return cEmitter.getResultTreeFragment();
        }
        catch (SAXException sAXException) {
            System.out.println("SAX Exception in insertCallouts");
            return rtf;
        }
    }

    public static FragmentValue numberLines(Context context, FragmentValue rtf) {
        Verbatim.setupLineNumbering(context);
        try {
            LineCountEmitter lcEmitter = new LineCountEmitter();
            rtf.replay((Emitter)lcEmitter);
            int numLines = lcEmitter.lineCount();
            int listingModulus = numLines < modulus ? 1 : modulus;
            double log10numLines = Math.log(numLines) / Math.log(10.0);
            int listingWidth = (double)width < log10numLines + 1.0 ? (int)Math.floor(log10numLines + 1.0) : width;
            NamePool namePool = context.getController().getNamePool();
            NumberLinesEmitter nlEmitter = new NumberLinesEmitter(namePool, listingModulus, listingWidth, separator, foStylesheet);
            rtf.replay((Emitter)nlEmitter);
            return nlEmitter.getResultTreeFragment();
        }
        catch (SAXException sAXException) {
            System.out.println("SAX Exception in numberLines");
            return rtf;
        }
    }

    private static void setupCallouts(Context context) {
        NamePool namePool = context.getController().getNamePool();
        boolean useGraphics = false;
        boolean useUnicode = false;
        defaultColumn = 60;
        foStylesheet = false;
        int unicodeStart = 48;
        int unicodeMax = 0;
        String graphicsPath = null;
        String graphicsExt = null;
        int graphicsMax = 0;
        Object variable = null;
        String varString = null;
        varString = Verbatim.getVariable(context, "stylesheet.result.type");
        foStylesheet = varString.equals("fo");
        varString = Verbatim.getVariable(context, "callout.defaultcolumn");
        try {
            defaultColumn = Integer.parseInt(varString);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("$callout.defaultcolumn is not a number: " + varString);
        }
        varString = Verbatim.getVariable(context, "callout.graphics");
        useGraphics = (varString.equals("0") || varString.equals("")) ^ true;
        varString = Verbatim.getVariable(context, "callout.unicode");
        useUnicode = (varString.equals("0") || varString.equals("")) ^ true;
        if (useGraphics) {
            graphicsPath = varString = Verbatim.getVariable(context, "callout.graphics.path");
            graphicsExt = varString = Verbatim.getVariable(context, "callout.graphics.extension");
            varString = Verbatim.getVariable(context, "callout.graphics.number.limit");
            try {
                graphicsMax = Integer.parseInt(varString);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("$callout.graphics.number.limit is not a number: " + varString);
                graphicsMax = 0;
            }
            fCallout = new FormatGraphicCallout(namePool, graphicsPath, graphicsExt, graphicsMax, foStylesheet);
        } else if (useUnicode) {
            varString = Verbatim.getVariable(context, "callout.unicode.start.character");
            try {
                unicodeStart = Integer.parseInt(varString);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("$callout.unicode.start.character is not a number: " + varString);
                unicodeStart = 48;
            }
            varString = Verbatim.getVariable(context, "callout.unicode.number.limit");
            try {
                unicodeMax = Integer.parseInt(varString);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("$callout.unicode.number.limit is not a number: " + varString);
                unicodeStart = 0;
            }
            fCallout = new FormatUnicodeCallout(namePool, unicodeStart, unicodeMax, foStylesheet);
        } else {
            fCallout = new FormatTextCallout(namePool, foStylesheet);
        }
    }

    private static void setupLineNumbering(Context context) {
        modulus = 5;
        width = 3;
        separator = " ";
        foStylesheet = false;
        String varString = null;
        varString = Verbatim.getVariable(context, "linenumbering.everyNth");
        try {
            modulus = Integer.parseInt(varString);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("$linenumbering.everyNth is not a number: " + varString);
        }
        varString = Verbatim.getVariable(context, "linenumbering.width");
        try {
            width = Integer.parseInt(varString);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("$linenumbering.width is not a number: " + varString);
        }
        separator = varString = Verbatim.getVariable(context, "linenumbering.separator");
        varString = Verbatim.getVariable(context, "stylesheet.result.type");
        foStylesheet = varString.equals("fo");
    }
}

