.\" Norme de hirarchie du systme de fichiers 2.0	-*- nroff -*-
.ig

Time-stamp: <97/10/26 01:18:57 quinlan>

Copyright (C) 1994, 1995, 1996, 1997 Daniel Quinlan

Voir ci-dessous (sous "Partie lgale") pour les conditions compltes de
copie.

Ce document est mis en page avec GNU groff 1.10 et les macros mm, et
pr-trait avec pic et tbl. Le site web de la FHS est situ 
<URL:http://www.pathname.com/fhs/>.

Notes pour crire ce document avec troff :

 * Utilisez toutes les chanes dfinies avec la commande ".ds".
 * Les noms de fichiers doivent tre mis en page en police de taille
   constante, mais n'incluez pas la ponctuation, par exemple
   \f(CWfichier\fP.
 * Les noms de fichiers contenant des tirets doivent tre prcds de
   \%, par exemple \f(CW\%/pub/liste-fichiers\fP.
 * Utilisez la langue dcrite dans la section "Conformit".

..
.\" -------------------------------------------------------------------
.\" Chanes prdfinies
.\" -------------------------------------------------------------------
.ds Date 1er fvrier 1998
.ds Fs FHS
.ds Ux UNIX
.ie n .ds Tx TeX
.el .ds Tx T\h'-.2m'\v'+.3m'E\h'-.0m'\v'-.3m'X
.\" -------------------------------------------------------------------
.\" Mise en page du document
.\" -------------------------------------------------------------------
.nr Cl 2
.nr Hu 3
.nr Hy 0
.PGNH
.PH "'Norme de hirarchie du systme de fichiers''\*[Date]"
.SA 0
.ie t \{\
.PGFORM 6i 10.5i 1.25i
.ds HF B B B B B B B
.ds HP 14 12 12 10 10 10 10
\}
.el \{\
.PGFORM 7.2i 11i
\}
.\" -------------------------------------------------------------------
.\" Page de couverture
.\" -------------------------------------------------------------------
.COVER ms
.TL
Norme de hirarchie du systme de fichiers \(em Version 2.0
.AF "\fIdite par Daniel Quinlan\fP"
.AU "\fRGroupe pour la norme de hirarchie du systme de fichiers\fP"
.AS 0 5
.nh
.P 1
Cette norme consiste en un ensemble d'exigences et de suggestions
concernant la disposition des fichiers et des rpertoires dans un
systme d'exploitation de type \*(Ux. Les suggestions servent 
faciliter l'interoprabilit des applications, des outils
d'administration systme, des outils de dveloppement et des scripts,
ainsi qu' avoir une documentation plus uniforme pour ces systmes.

.AE
.COVEND
.SK
.\" -------------------------------------------------------------------
.\" Partie lgale
.\" -------------------------------------------------------------------
.nh
.nr % 1
.af P i
.PF "''- \\\\nP -''"
Toutes les marques dposes et les copyrights appartiennent  leurs
propritaires, sauf notification spcifique. L'utilisation d'un terme
dans ce document ne devrait pas tre considre comme affectant la
validit de toute marque dpose ou marque de fabrique.

.BS
Copyright \(co 1994, 1995, 1996, 1997 Daniel Quinlan

Nous accordons la permission de faire et de distribuer des copies
exactes de cette norme  la condition que le copyright et cette note de
permission soient prserves sur toutes les copies.

.ig
Nous accordons la permission de faire traiter ce fichier par un outil de
mise en page (tel que troff) et d'imprimer le rsultat,  la condition
que le document imprim contienne une note de permission identique 
celle-ci mis  part l'omission de ce parapgraphe (ce paragraphe n'tant
pas pertinent dans le document imprim).

..
Nous accordons la permission de copier et distribuer des versions
modifies de cette norme sous les conditions de copie exacte, 
condition que la page de titre indique qu'elle a t modifie en
incluant une rfrence  la norme d'origine,  condition que soient
incluses les informations ncessaires  la recherche de la norme
d'origine, et  condition que le travail driv complet soit distribu
sous les termes d'une note de permission identique  celle-ci.

Nous accordons la permission de copier et de distribuer des traductions
de cette norme dans une autre langue, avec les conditions ci-dessus pour
les versions modifies,  part le fait que cette note de permission soit
donne dans une traduction approuve par le tenant du copyright.

.BE
.SK
.\" -------------------------------------------------------------------
.\" Corps du document
.\" -------------------------------------------------------------------
.BS
.BE
.nr % 1
.af P 1
.nr Hu 4
.H 1 "Introduction"
.\" J'aimerais en finir avec ces sous-sections dans l'introduction :
.\" (en dplaant certaines choses gnrales  cet endroit)
.\"
.\" Dclaration d'intrt gnral (ou est-ce le rsum ?)
.\"
.\" - Organisation
.\" - Documents de base, s'il y en a
.\" - Contexte (histoire)
.\" - Audience
.\" - But (objectifs)
.\"   - principes de base (possibilit d'avoir /usr en lecture seule,
.\"     etc.) comprenant : implmentable  grande chelle, changements
.\"     minimes par rapport aux implmentations historiques, changements
.\"     minimes par rapport aux implmentations existantes
.\" - Normes connexes

.H 2 "tat de la norme"
.P
Voici la version 2.0 de la norme de hirarchie du systme de fichiers
(FHS 2.0).

Les commentaires sur cette norme sont les bienvenus de la part des
personnes intresses. Les suggestions de modifications devraient tre
faites sous la forme d'une proposition de changement du texte,
accompagne de commentaires explicatifs appropris.

Les suggestions de cette norme sont sujettes  modification.
L'utilisation des informations incluses dans ce document se fait  vos
risques et prils.

.ig
Cette norme propose est distribue pour l'instant  des fins de tests
et de commentaires.

Les commentaires sur cette norme sont les bienvenus de la part des
personnes intresses. Les suggestions de changements devraient tre de
la forme d'une proposition de changement du texte, accompagne des
commentaires d'explication appropris.

Les suggestions de cette norme sont sujets  modification. L'utilisation
des informations incluses dans ce document se fait  vos propres
risques.
..

.H 2 "Organisation de la norme"
.P
Cette norme est divise entre les sections suivantes :

.AL 1
.LI
introduction ;
.LI
le systme de fichiers : tablissement de quelques principes cls ;
.LI
le rpertoire racine ;
.LI
la hirarchie \f(CW/usr\fP ;
.LI
la hirarchie \f(CW/var\fP ;
.LI
annexe spcifique au systme d'exploitation.
.LE

.H 2 "Conventions"
.P
.ie t \{\
Une police de taille fixe est utilise pour l'affichage des noms de
fichiers et de rpertoires.
\}
.el \{\
Nous recommandons que lisiez une version mise en pages de ce documents
plutt que la version texte. Dans la version mise en pages, les noms de
fichiers et de rpertoire sont affichs dans une police  taille fixe.
\}

Les parties variables des noms de fichiers sont reprsentes par une
description de leur contenu  l'intrieur des caractres chevrons
"\f(CW<\fP" et "\f(CW>\fP", \f(CW<ainsi>\fP. Les adresses de courrier
lectronique sont aussi entoures de chevrons "<" et ">" mais sont
indiques dans la police habituelle.

Les parties optionnelles des noms de fichiers sont entoures des
caractres crochet "\f(CW[\fP" et "\f(CW]\fP" et peuvent tre combines
avec la convention "\f(CW<\fP" et "\f(CW>\fP". Par exemple, si on
pouvait trouver un fichier existant avec ou sans extension, on pourrait
le reprsenter par \f(CW<nom de fichier>[.<extension>]\fP.

Les parties de chanes variables des noms de rpertoires et de fichiers
sont indiques par une toile : "\f(CW*\fP".

.SK
.H 2 "Historique de la \*(Fs"
.P
Le processus de dveloppement d'une hirarchie de systme de fichiers
standard a dbut en aot 1993 dans un effort de restructuration de la
structure de fichiers et de rpertoires de Linux. La FSSTND, norme pour
une hirarchie du systme de fichiers spcifique au systme
d'exploitation Linux, est sortie le 14 fvrier 1994. Des versions
successives sont sorties le 9 octobre 1994 et le 28 mars 1995.

Au dbut de 1995, avec l'aide de membres de la communaut de
dveloppement BSD, il a t dcid de dvelopper une version de FSSTND
plus complte pour englober non seulement Linux mais aussi les autres
systmes de type \*(Ux. En dfinitive, nous avons fait un effort
concert pour nous concentrer sur des problmes gnraux aux systmes de
type \*(Ux. En reconnaissance de cette ouverture, le nom de la norme a
t modifi pour devenir Norme de hirarchie du systme de fichiers ou
\*(Fs en abrg. (NDT : en anglais, FHS veut dire Filesystem Hierarchy
Standard.)

Les noms des volontaires qui ont contribu activement  cette norme sont
indiqus  la fin de ce document. Cette norme reprsente un consensus
entre les points de vue de ceux-ci et d'autres contributeurs.

.H 2 "tendue"
.P
Ce document spcifie une hirarchie de systme de fichiers standard pour
les systmes de fichiers \*(Fs en indiquant l'emplacement des fichiers
et rpertoires, et le contenu de certains fichiers systme.

Cette norme a t faite pour tre utilise par les intgrateurs de
systmes, les dveloppeurs de paquets et les administrateurs systme
dans la construction et la maintenance de systmes de fichiers se
conformant  \*(Fs. Elle est tout d'abord destine  servir de rfrence
et n'est pas un tutoriel sur la manire de grer une hirarchie de
systme de fichiers conforme.

La \*(Fs est base sur des travaux prliminaires sur FSSTND, une norme
d'organisation du systme de fichiers pour le systme d'exploitation
Linux. Elle est base sur la FSSTND pour pallier  des problmes
d'interoprabilit non seulement dans la communaut Linux mais dans un
horizon plus vaste comprenant les systmes d'exploitation bass sur
4.4BSD. Elle incorpore les leons concernant le support de plusieurs
architectures et les demandes en matire de rseaux htrognes, leons
apprises dans le monde BSD ou ailleurs.

Bien que cette norme soit plus complte que les tentatives prcdentes
sur la normalisation de la hirarchie de systmes de fichiers, des mises
 jour priodiques peuvent s'avrer ncessaires  mesure que les
demandes changent par rapport  la technologie mergeante. Il est aussi
possible que de meilleures solutions aux problmes voqus ici soient
dcouvertes ou que nos solutions ne soient plus les meilleures
possibles. Des brouillons supplmentaires pourront tre apports en plus
des mises  jour priodiques de ce document. Cependant, l'un des buts
suivis est la compatibilit ascendante entre une version de ce document
et la suivante.

Les commentaires relatifs  cette norme sont les bienvenus. Tout
commentaire ou suggestion de modification devraient tre adresss 
l'diteur de la \*(Fs (Daniel Quinlan <quinlan@pathname.com>), ou si
vous prfrez,  la liste de diffusion \*(Fs. Les commentaires de nature
typographique ou grammaticale doivent tre adresss directement 
l'diteur de la \*(Fs.

Nous vous demandons de contacter en premier l'diteur de la \*(Fs avant
d'envoyer un courrier  la liste de diffusion afin d'viter un nouveau
dbat sur des sujets anciens. Les messages mal conus ne seront pas bien
vus sur la liste de diffusion.

Des questions concernant l'interprtation des objets de ce document
peuvent se poser de temps en temps. Si vous avez besoin de prcisions,
veuillez contacter l'diteur de la \*(Fs. Puisque cette norme reprsente
le consensus de nombreux participants, il est important de s'assurer que
toute interprtation reprsente aussi l'opinion collective. Pour cette
raison, il peut ne pas tre possible de fournir une rponse immdiate
sauf si la demande a dj fait l'objet d'une discussion.

.H 2 "Indications gnrales"
.P
Voici quelques-unes des suggestions qui ont t utilises dans le
dveloppement de cette norme :

.BL
.LI
rsoudre des problmes techniques tout en limitant les difficults de la
transition ;
.LI
faire une spcification suffisamment stable ;
.LI
obtenir l'approbation des distributeurs, des dveloppeurs, et autres
dcideurs dans les groupes de dveloppement adquats et encourager leur
participation ;
.LI
fournir une norme attractive pour les implmenteurs des diffrents
systmes de type \*(Ux.
.LE

.H 2 "Audience vise"
.P
L'audience vise par cette norme comprend, mais n'est pas limite aux
groupes de personnes suivants :

.BL
.LI
dveloppeurs de systmes ;
.LI
intgrateurs et distributeurs de systmes ;
.LI
dveloppeurs d'applications ;
.LI
auteurs de documentations ;
.LI
administrateurs systme et autres personnes intresses ( des fins
d'information).
.LE

.H 2 "Conformit avec ce document"
.P
Cette section dfinit la signification des termes "conforme" et
"compatible" en ce qui concerne cette norme, et de conformit et
compatibilit "partielle".

Une "implmentation" fait ici rfrence  une distribution, un systme
install, un programme, un paquet (ou toute partie similaire d'un
logiciel ou de donnes), ou tout composant de ceux-ci.

Une implmentation est totalement conforme  cette norme si chaque
exigence de cette norme est satisfaite. Chaque fichier ou rpertoire
faisant partie de l'implmentation doit tre situ comme il est spcifi
dans ce document. Si le contenu d'un fichier est dcrit ici, le contenu
vritable doit correspondre  la description. L'implmentation doit
aussi tenter de trouver tout fichier ou rpertoire (extrieur 
elle-mme) en premier lieu ou exclusivement  l'endroit spcifi dans
cette norme.

.\" maladroit

Une implmentation est totalement compatible avec cette norme si chaque
fichier ou rpertoire qu'elle contient peut tre trouv en regardant 
l'endroit spcifi ici et sera trouv avec un contenu identique  ce qui
est spcifi ici, mme si ce n'est pas l'emplacement de base ou physique
du fichier ou du rpertoire en question. L'implmentation doit, quand
elle essaie de trouver un fichier ou un rpertoire n'en faisant pas
partie, le faire  l'endroit spcifi dans cette norme, bien qu'elle
puisse aussi tenter de le trouver  d'autres endroits (non standards).

Une implmentation est partiellement conforme ou compatible si elle est
conforme  ou compatible avec une partie significative de ce document.
La conformit ou compatibilit partielle n'est faite pour s'appliquer
qu'aux distributions et non  des programmes spars. L'expression "une
partie significative" est effectivement subjective, et dans les cas
limites, la personne concerne devrait contacter l'diteur de la \*(Fs.
Nous avons anticip le fait que des drapages soient tolrs dans les
cas limites.

Afin de se dfinir comme partiellement conforme  la \*(Fs ou
partiellement compatible avec la \*(Fs, une implmentation doit fournir
une liste de tous les endroits auxquels elle et le document \*(Fs
diffrent, en plus d'une courte explication de la raison de cette
diffrence. Cette liste sera fournie avec l'implmentation en question,
et aussi mise  disposition de la liste de diffusion \*(Fs ou de
l'diteur de la \*(Fs.

Les termes "doit", "devrait", "contient", "est" et ainsi de suite
doivent tre lus comme des exigences pour la conformit ou la
compatibilit.

Notez qu'une implmentation n'a pas besoin de contenir tous les fichiers
et rpertoires spcifis dans cette norme pour tre conforme ou
compatible. Il est simplement ncessaire que les fichiers qu'elle
contient soient placs correctement. Par exemple, si le systme de
fichiers minix n'est pas support par une distribution, les outils minix
n'ont pas besoin d'tre inclus, mme s'ils sont mentionns explicitement
dans la section sur \f(CW/sbin\fP.

De plus, certaines parties de ce document sont optionnelles. Dans ce
cas, ceci sera dit explicitement, ou indiqu  l'aide d'un ou plusieurs
mots parmi "peut", "recommande" ou "suggre". Les objets indiqus comme
optionnels n'ont pas de porte sur la conformit ou la compatibilit
d'une implmentation ; ce sont des suggestions faites pour encourager la
pratique courante, mais ils peuvent tre situs n'importe o au gr de
l'implmenteur.

.SK
.H 1 "Le systme de fichiers"
.P
Le systme de fichiers \*(Ux est caractris par :

.BL
.LI
une structure hirarchique ;
.LI
le traitement uniforme des fichiers de donnes ;
.LI
la protection des fichiers de donnes.
.LE
.P
Cette norme suppose que le systme d'exploitation sous-jacent  un
systme de fichiers conforme  la \*(Fs supporte les mmes possibilits
de scurit de base que l'on trouve dans la plupart des systmes de
fichiers \*(Ux. Notez que cette norme n'essaie pas d'tre en accord au
mieux possible avec une implmentation quelconque d'un systme \*(Ux.
Cependant, beaucoup d'aspects de cette norme sont bass sur des ides
que l'on trouve dans \*(Ux et autres systmes de type \*(Ux.

Ceci aprs une considration attentive d'autres facteurs, comprenant :

.BL
.LI
des pratiques courantes et saines dans les systmes de type \*(Ux ;
.LI
l'implmentation d'autres structures de systmes de fichiers ;
.LI
les normes applicables.
.LE
.P
On peut dfinir deux catgories orthogonales de fichiers : partageables
contre non partageables, et variables contre statiques.
.\" catgories/catgorisations and fichiers/fichiers de donnes

Les donnes partageables sont celles que l'on peut partager entre
plusieurs machines diffrentes ; non partageables, celles spcifiques 
une machine particulire. Par exemple, les rpertoires personnels des
utilisateurs sont des donnes partageables, mais les fichiers de verrou
de priphriques (locks), ne le sont pas.

Les donnes statiques comprennent les binaires, les bibliothques, la
documentation, et tout ce qui ne change pas sans l'intervention de
l'administrateur systme ; les donnes variables reprsentent tout le
reste qui change sans l'intervention de l'administrateur systme.

.\" Le texte donn prcdemment se rapportait aux "principes" sans les
.\" spcifier.  la place, il dcrivait quatre catgories de telle sorte
.\" que a *impliquait* un principe. Voici le principe.
Pour faciliter la sauvegarde, l'administration et le partage de fichiers
sur des rseaux de systmes htrognes, il est prfrable d'tablir une
correspondance simple et aisment comprhensible entre les rpertoires
(surtout les rpertoires considrs comment des points de montage
potentiels) et le type de donnes qu'ils contiennent.

 travers ce document, et dans tout systme de fichiers bien organis,
la comprhension de ce principe de base aidera  diriger la structure et
lui apporter une cohrence supplmentaire.

La distinction entre donnes partageables et non partageables est
ncessaire pour plusieurs raisons :

.BL
.LI
dans un environnement en rseau (par exemple, plus d'un hte par site),
une bonne partie des donnes peuvent tre partages entre diffrentes
machines pour conomiser de la place et faciliter la tche de
maintenance ;
.LI
dans un environnement en rseau, certains fichiers contiennent des
informations spcifiques  une seule machine. Par consquent ces
systmes de fichiers ne peuvent tre partags (sans prendre des mesures
spciales) ;
.LI
historiquement, certaines implmentations des systmes de fichiers de
type \*(Ux ont mlang des donnes partageables et non partageables dans
la mme hirarchie, rendant difficile le partage de grandes parties du
systme de fichiers.
.LE

La distinction "partageable" permet de supporter, par exemple :

.BL
.LI
une partition \f(CW/usr\fP (ou des composants de \f(CW/usr\fP) monts
(en lecture seule)  travers le rseau (en utilisant NFS) ;
.LI
une partition \f(CW/usr\fP (ou des composants de \f(CW/usr\fP) monts 
partir d'un support en lecture seule. Un CD-ROM peut tre considr
comme un systme de fichiers en lecture seule partag avec d'autres
systmes conformes  la \*(Fs, en utilisant le systme de courrier comme
un "rseau".
.LE
.P

La distinction "statique" contre "variable" affecte le systme de
fichiers de deux manires principales :

.BL
.LI
puisque \f(CW/\fP contient  la fois des donnes statiques et variables,
il doit tre mont en lecture-criture ;
.LI
puisque le traditionnel \f(CW/usr\fP contient  la fois des donnes
variables et statiques, et puisque nous voudrons le monter en lecture
seule (voir ci-dessus), il est ncessaire de fournir une mthode pour
monter \f(CW/usr\fP en lecture seule. Ceci est obtenu par la cration
d'une hirarchie \f(CW/var\fP qui est monte en lecture-criture (ou qui
fait partie d'une autre partition en lecture-criture, telle que
\f(CW/)\fP, qui remplace bien des fonctions traditionnelles de la
partition \f(CW/usr\fP.
.LE

Voici un tableau pour rsumer le tout. Puisque ce graphique contient des
exemples gnraliss, il peut ne pas s'appliquer  chaque implmentation
possible d'un systme conforme  la \*(Fs.

.TS
box,center;
l | l | l.
	partageable	non partageable
_
statique	/usr	/etc
	/opt	/boot
_
variable	/var/mail	/var/run
	/var/spool/news	/var/lock
.TE
.SK
.H 1 "Le rpertoire racine"
.P
Cette section dcrit la structure du rpertoire racine (root). Le
contenu du systme de fichiers racine doit tre adquat pour dmarrer,
reconstituer, rtablir et/ou rparer le systme :

.BL
.LI
pour dmarrer un systme, il doit y avoir suffisamment de choses sur la
partition racine pour monter d'autres systmes de fichiers. Ceci
comprend les utilitaires, la configuration, les informations du chargeur
de dmarrage, et d'autres donnes de dmarrage importantes.
\f(CW/usr\fP, \f(CW/opt\fP et \f(CW/var\fP sont faits pour pouvoir tre
situs sur d'autres systmes de fichiers ;
.LI
pour permettre le rtablissement et/ou la rparation d'un systme, les
utilitaires ncessaires au mainteneur expriment pour diagnostiquer et
reconstruire un systme endommag doivent tre prsents sur le systme
de fichiers racine ;
.LI
pour reconstituer un systme, les utilitaires ncessaires  la
reconstitution  partir des sauvegardes systme (sur disque, bande,
etc.) doivent tre prsents sur le systme de fichiers racine.
.LE
.P
Le principal argument utilis pour contrer ces considrations, qui
tendent  mettre beaucoup de choses sur le systme de fichiers racine,
est le but de garder la racine aussi petite que possible dans les
limites du raisonnable. Pour plusieurs raisons, il est souhaitable de
limiter la taille du systme de fichiers racine :

.BL
.LI
il est mont de temps en temps  partir d'un moyen de stockage trs
petit ;
.LI
le systme de fichiers racine contient beaucoup de fichiers de
configuration spcifiques au systme. Les exemples possibles comprennent
un noyau spcifique au systme, un nom d'hte diffrent, etc. Ceci veut
dire que le systme de fichiers racine n'est pas toujours partageable
entre des systmes en rseau. Limiter sa taille sur des systmes en
rseau minimise l'espace perdu en fichiers non-partageables sur les
serveurs. Cela permet aussi d'avoir des stations de travail avec des
disques durs locaux plus petits ;
.LI
bien que vous puissiez avoir un systme de fichiers racine sur une
grande partition, et pouvez le remplir  votre aise, il y aura des gens
avec des partitions plus petites. Si vous avez plus de fichiers
installs, vous pourrez trouver des incompatibilits avec d'autres
systmes qui utilisent des systmes de fichiers racine sur des
partitions plus petites. Si vous tes dveloppeur vous risquez de
changer votre hypothse en un problme pour un grand nombre
d'utilisateurs ;
.LI
les erreurs de disque qui corrompent les donnes sur le systme de
fichiers racine posent un problme plus important que les erreurs sur
tout autre partition. Un systme de fichiers racine petit est moins
sujet  la corruption  la suite d'un plantage systme ;
.LE
.P
les logiciels ne doivent jamais crer ou demander des fichiers spciaux
ou des sous-rpertoires dans le rpertoire racine. D'autres emplacements
dans la hirarchie \*(Fs fournissent plus de flexibilit qu'il n'en faut
pour tout paquet.

.HU "Raison d'tre"
.br
.P
Il y a plusieurs raisons pour lesquelles l'introduction d'un nouveau
rpertoire dans le systme de fichiers racine est interdit :
.BL
.LI
ceci demande de la place sur une partition racine que l'administrateur
systme veut garder petite et simple pour des raisons de performance ou
de scurit ;
.LI
ceci contredit toute logique que l'administrateur systme a pu mettre en
place pour distribuer des hirarchies de fichiers standards sur des
volumes montables.
.LE

.PS
copy "draft.pic"
dir(/,le rpertoire racine)
sub("bin","binaires des commandes importantes")
sub("boot","fichiers statiques du chargeur de dmarrage")
sub("dev","fichiers de priphriques")
sub("etc","configuration systme spcifique  la machine")
sub("home","rpertoires personnels des utilisateurs")
sub("lib","bibliothques partages importantes et modules du noyau")
sub("mnt","point de montage des partitions temporaires")
sub("opt","paquets de logiciels applicatifs supplmentaires")
sub("root","rpertoire personnel de l'utilisateur root")
sub("sbin","binaires systmes importants")
sub("tmp","fichiers temporaires")
sub("usr","hirarchie secondaire")
sub("var","donnes variables")
.PE

Chaque rpertoire list ci-dessus est spcifi en dtail dans des
sous-sections spares ci-dessous. \f(CW/usr\fP et \f(CW/var\fP ont
chacun une section complte dans ce document  cause de la complexit de
ces rpertoires.

L'image du noyau du systme d'exploitation doit tre situ soit dans
\f(CW/\fP, soit dans \f(CW/boot\fP. Les informations supplmentaires sur
l'emplacement du noyau se trouvent dans la section concernant
\f(CW/boot\fP ci-dessous.

.H 2 "/bin : binaires de commandes utilisateurs importantes (pour tous les utilisateurs)"
.P
\f(CW/bin\fP contient des commandes  l'usage  la fois de
l'administrateur systme et des utilisateurs, mais qui sont obligatoires
en mode utilisateur simple. Il peut aussi contenir des commandes
utilises indirectement par des scripts.

Il ne devrait pas y avoir de sous-rpertoires  l'intrieur de
\f(CW/bin\fP.

Les binaires des commandes qui ne sont pas suffisamment importantes pour
rester dans \f(CW/bin\fP doivent tre mises dans \f(CW/usr/bin\fP,  la
place. Les objets qui ne sont utiliss que par des utilisateurs non root
(\f(CWmail\fP, \f(CWchsh\fP, etc.) ne sont en gnral pas assez
importants pour tre placs dans la partition racine.


.HU "Fichiers obligatoires pour /bin :"
.BL
.LI
commandes gnrales :
.sp
Les commandes suivantes ont t incluses parce qu'elles sont
importantes. Certaines sont prsentes  cause de leur emplacement
traditionnel dans \f(CW/bin\fP.

.VL 2
.LI "\f(CW{"
cat, chgrp, chmod, chown, cp, date, dd, df, dmesg, echo, ed, false,
kill, ln, login, ls, mkdir, mknod, more, mount, mv, ps, pwd, rm, rmdir,
sed, setserial, sh, stty, su, sync, true, umount, uname }\fP
.LE
.P
Si \f(CW/bin/sh\fP est le Bash, alors \f(CW/bin/sh\fP devrait tre un
lien symbolique ou en dur vers \f(CW/bin/bash\fP puisque Bash se
comporte de manire diffrente quand il est appel en tant que
\f(CWsh\fP ou \f(CWbash\fP. \f(CWpdksh\fP, qui peut tre \f(CW/bin/sh\fP
sur certains disques d'installation, devrait tre arrang de la sorte,
\f(CW/bin/sh\fP pointant vers \f(CW/bin/ksh\fP. L'utilisation d'un lien
symbolique dans ces cas permet aux utilisateurs de voir aisment que
\f(CW/bin/sh\fP n'est pas un vrai shell de Bourne.

Puisque l'emplacement standard de facto du shell C est \f(CW/bin/csh\fP,
si et seulement si un shell C ou quivalent (comme \f(CWtcsh\fP) est
disponible sur le systme, il devrait tre disponible par le nom
\f(CW/bin/csh\fP. \f(CW/bin/csh\fP peut tre un lien symbolique vers
\f(CW/bin/tcsh\fP ou \f(CW/usr/bin/tcsh\fP.

.ft I
Note : les commandes \f(CW[\fP et \f(CWtest\fP sont intgres dans les
remplacements du shell de Bourne (\f(CW/bin/sh\fP) les plus couramment
utiliss. Ces deux commandes ne doivent pas tre places dans
\f(CW/bin\fP ; elles peuvent tre places dans \f(CW/usr/bin\fP. Elles
doivent tre incluses comme binaires spars sur tout systme \*(Ux ou
de type \*(Ux essayant de se conformer  la norme POSIX.2.
.ft R

.LI
commandes de remise en tat :
.sp
Ces commandes ont t ajoutes pour permettre la remise en tat d'un
systme (en supposant que \f(CW/\fP soit intact).
.VL 2
.LI "\f(CW{"
tar, gzip, gunzip \fR(lien vers gzip)\fP, zcat \fR(lien vers gzip)\fP }\fP
.LE
.P
Si les sauvegardes systme sont faites en utilisant des programmes
autres que \f(CWgzip\fP et \f(CWtar\fP, alors la partition racine
devrait contenir le minimum requis par les composants de remise en tat.
Par exemple, beaucoup de systmes devraient inclure \f(CWcpio\fP puisque
c'est l'utilitaire de sauvegarde le plus couramment utilis aprs
\f(CWtar\fP. Inversement, si l'on est sr de ne jamais faire aucune
remise en tat de la partition racine, on peut alors omettre ces
binaires (par exemple, une partition racine en ROM, montant \f(CW/usr\fP
en NFS). Si la remise en tat d'un systme est prvue  travers le
rseau, alors \f(CWftp\fP ou \f(CWtftp\fP (avec tout ce qui est
ncessaire  l'tablissement d'une connexion ftp) doit tre disponible
sur la partition racine.

Les commandes de remise en tat peuvent apparatre soit dans
\f(CW/bin\fP, soit dans \f(CW/usr/bin\fP sur des systmes diffrents.

.LI
commandes rseau :
.sp
Voici les seuls binaires ncessaires pour le rseau, autres que ceux de
\f(CW/usr/bin\fP ou \f(CW/usr/local/bin\fP, et que  la fois root et les
utilisateurs voudront ou auront besoin d'excuter.
.VL 2
.LI "\f(CW{"
domainname, hostname, netstat, ping }\fP
.LE
.LE

.H 2 "/boot : fichiers statiques du chargeur de dmarrage"
.P
Ce rpertoire contient tout ce qu'il faut pour le processus de dmarrage
 part les fichiers de configuration et l'installeur de carte. Ainsi,
\f(CW/boot\fP stocke les donnes utilises avant que le noyau ne
commence  excuter des programmes en mode utilisateur. Ceci peut
comprendre les secteurs de dmarrage principaux sauvegards, les
fichiers de cartes des secteurs, et tout autre donne qui n'est pas
directement dite  la main. Les programmes ncessaires  ce que le
chargeur de dmarrage soit capable de dmarrer sur un fichier doivent
tre placs dans \f(CW/sbin\fP. Les fichiers de configuration pour les
chargeurs de dmarrage doivent tre placs dans \f(CW/etc\fP.

Le noyau du systme d'exploitation doit tre situ soit dans \f(CW/\fP,
soit dans  \f(CW/boot\fP.

.ft I
Note : sur certaines machines i386, il peut tre ncessaire que
\f(CW/boot\fP soit situ sur une partition spare situe compltement
en-dessous du cylindre 1024 du priphrique de dmarrage  cause de
contraintes matrielles.

.ft P

.H 2 "/dev : fichiers de priphriques"
.P
Le rpertoire \f(CW/dev\fP est l'emplacement des fichiers spciaux ou de
priphriques.

S'il est possible que des priphriques dans \f(CW/dev\fP aient besoin
d'tre crs  la main, \f(CW/dev\fP contiendra une commande nomme
\f(CWMAKEDEV\fP, qui pourra crer les priphriques au besoin. Il peut
aussi disposer d'une commande \f(CWMAKEDEV.local\fP pour tout
priphrique local.

Au besoin, \f(CWMAKEDEV\fP doit avoir de quoi crer n'importe quel
priphrique qu'on pourrait trouver dans le systme, et non pas
simplement ceux qu'une implmentation particulire installe.

.H 2 "/etc : configuration systme spcifique  la machine"
.P
\f(CW/etc\fP contient les fichiers et les rpertoires de configuration
spcifiques au systme en cours.

Aucun binaire ne devrait tre situ dans \f(CW/etc\fP.

.PS
copy "draft.pic"
dir(/etc,configuration systme spcifique  la machine)
sub("X11","configuration pour le systme X Window")
sub("opt","configuration pour /opt")
.PE

La section suivante sert surtout  illustrer la description du contenu
de \f(CW/etc\fP avec un certain nombre d'exemples ; ce n'est surtout pas
une liste exhaustive.

.HU "Fichiers obligatoires pour /etc :"
.BL
.LI
fichiers gnraux :
.VL 2
.LI "\f(CW{"
adjtime, csh.login, disktab, fdprm, fstab, gettydefs, group, inittab,
confissue, ld.so.conf, lilo.conf, motd, mtab, mtools, passwd,
profile, securetty, shells, syslog.conf, ttytype }\fP
.LE

.LI
fichiers de rseau :
.VL 2
.LI "\f(CW{"
exports, ftpusers, gateways, host.conf, hosts, hosts.allow, hosts.deny,
hosts.equiv, hosts.lpd, inetd.conf, networks, printcap, protocols,
resolv.conf, rpc, services }\fP
.LE
.LE
.P
.ft I
Notes :

La mise en place des scripts de commandes invoqus au dmarrage peut
ressembler aux modles System V ou BSD. Des spcifications
supplmentaires dans ce domaine pourront tre ajoutes  une version
future de la norme.

Les systmes qui utilisent la suite shadow password auront des fichiers
de configuration supplmentaires dans \f(CW/etc\fP (\f(CW/etc/shadow\fP
et autres) et des programmes dans \f(CW/usr/sbin\fP (\f(CWuseradd\fP,
\f(CWusermod\fP, et autres).

.ft P

.H 3 "/etc/X11 : configuration du systme X Window"
.sp 0
.P
\f(CW/etc/X11\fP est l'emplacement recommand pour toute configuration
X11 spcifique  la machine. Ce rpertoire est ncessaire pour permettre
un contrle local si \f(CW/usr\fP est mont en lecture seule. Les
fichiers qui devraient tre dans ce rpertoire comprennent
\f(CWXconfig\fP (et/ou \f(CWXF86Config\fP) et \f(CWXmodmap\fP.

Les sous-rpertoires de \f(CW/etc/X11\fP peuvent inclure ceux pour
\f(CWxdm\fP et pour tout autre programme (certains gestionnaires de
fentres, par exemple) qui en a besoin. Nous recommandons que les
gestionnaires de fentres qui n'ont qu'un fichier de configuration par
dfaut \f(CW.*wmrc\fP le nomment \f(CWsystem.*wmrc\fP (sauf s'il existe
un nom de rechange largement reconnu) et n'utilisent pas de
sous-rpertoire. Tout sous-rpertoire de gestionnaire de fentres
devrait tre nomm du mme nom que le binaire rel du gestionnaire de
fentres.

\f(CW/etc/X11/xdm\fP contient les fichiers de configuration de
\f(CWxdm\fP. Ce sont la plupart des fichiers que l'on trouve
habituellement dans \f(CW/usr/lib/X11/xdm\fP. Certaines donnes
variables et locales pour \f(CWxdm\fP sont stockes dans
\f(CW/var/state/xdm\fP.

.H 3 "/etc/opt : fichiers de configuration pour /opt"
.sp 0
.P
Les fichiers de configuration spcifiques  la machine pour les paquets
des logiciels applicatifs supplmentaires seront installs dans le
rpertoire \f(CW/etc/opt/<paquet>\fP, o \f(CW<paquet>\fP est le nom du
sous-rpertoire de \f(CW/opt\fP o sont stockes les donnes statiques
de ce paquet. Aucune structure n'est impose sur la disposition interne
de \f(CW/etc/opt/<paquet>\fP.

Si un fichier de configuration doit rsider dans un endroit diffrent
pour que le paquet ou le systme fonctionne correctement, on peut le
placer dans un endroit diffrent de \f(CW/etc/opt/<paquet>\fP.

.HU "Raison d'tre :"
.br
.P
Voir la raison d'tre pour \f(CW/opt\fP.

.H 2 "/home : rpertoires personnels des utilisateurs (optionnel)"
.P
\f(CW/home\fP est un concept trs standard, mais c'est clairement un
systme de fichiers spcifique au site. Sa mise en place sera diffrente
d'une machine  l'autre. Cette section ne dcrit qu'un ordonnancement
suggr des rpertoires personnels des utilisateurs ; nanmoins nous
recommandons que toutes les distributions conformes  la \*(Fs
l'utilisent comme emplacement par dfaut des rpertoires utilisateurs.

Sur les petits systmes, chaque rpertoire utilisateur est en gnral
l'un des nombreux sous-rpertoires de \f(CW/home\fP comme
\f(CW/home/dupont\fP, \f(CW/home/torvalds\fP, \f(CW/home/admin\fP, etc.

Sur des grands systmes (surtout quand les rpertoires \f(CW/home\fP
sont partags entre beaucoup d'htes par NFS) il est utile de subdiviser
les rpertoires personnels des utilisateurs. Le partage peut se faire en
utilisant des sous-rpertoires comme \f(CW/home/equipe\fP,
\f(CW/home/invites\fP, \f(CW/home/eleves\fP, etc.

D'autres personnes prfrent placer les comptes utilisateurs  divers
autres endroits. Par consquent, aucun programme ne devrait se fier 
cet emplacement. Si vous voulez trouver le rpertoire personnel d'un
utilisateur, vous devriez utiliser la fonction de bibliothque
\f(CWgetpwent(3)\fP plutt que de compter sur \f(CW/etc/passwd\fP parce
que les informations sur les utilisateurs peuvent tre stockes 
distance en utilisant des systmes tels que NIS.

.H 2 "/lib : bibliothques partages importantes et modules du noyau"
.P

Le rpertoire \f(CW/lib\fP contient les images des bibliothques
partages ncessaires au dmarrage du systme et au lancement des
commandes du systme de fichiers racine.

.PS
copy "draft.pic"
dir(/lib,bibliothques partages importantes et modules du noyau)
sub("modules","modules chargeables du noyau")
.PE

Ceci comprend \f(CW/lib/libc.so.*\fP, \f(CW/lib/libm.so.*\fP, l'diteur
de liens dynamiques partags \f(CW/lib/ld.so\fP, et d'autres
bibliothques partages ncessaires aux binaires de \f(CW/bin\fP et
\f(CW/sbin\fP.

Les bibliothques partages ncessaires uniquement aux binaires de
\f(CW/usr\fP (comme n'importe quel binaire X Window) n'appartiennent pas
 \f(CW/lib\fP. Seules les bibliothques partages ncessaires au
fonctionnement des binaires de \f(CW/bin\fP et \f(CW/sbin\fP doivent se
trouver ici. La bibliothque \f(CWlibm.so.*\fP peut aussi se trouver
dans \f(CW/usr/lib\fP si elle n'est pas ncessaire dans \f(CW/bin\fP ou
\f(CW/sbin\fP.

Pour des raisons de compatibilit, \f(CW/lib/cpp\fP doit exister et se
rfrer au pr-processeur C install sur le systme. L'emplacement
traditionnel de ce binaire est
\f(CW\%/usr/lib/gcc-lib/<cible>/<version>/cpp\fP. \f(CW/lib/cpp\fP peut
pointer soit vers ce binaire, soit vers toute rfrence  ce binaire qui
existe dans le systme de fichiers. (Par exemple, on utilise souvent
\f(CW/usr/bin/cpp\fP.)

La spcification pour \f(CW/lib/modules\fP est en cours d'laboration.

.H 2 "/mnt : point de montage pour les systmes de fichiers monts temporairement"
.P
Ce rpertoire est fourni pour que l'administrateur systme puisse monter
de manire temporaire et au besoin des systmes de fichiers. Le contenu
de ce rpertoire est une affaire locale et ne devrait pas affecter la
manire dont n'importe quel programme est lanc.

Nous sommes opposs  l'utilisation de ce rpertoire par les programmes
d'installation, et nous suggrons qu'un rpertoire temporaire convenable
non utilis par le systme soit utilis  la place.

.H 2 "/opt : paquets de logiciels applicatifs supplmentaires"
.SP
.PS
copy "draft.pic"
dir(/opt,paquets de logiciels d'applications supplmentaires)
sub("<paquet>","objets statiques du paquet")
.PE
\f(CW/opt\fP est rserv  l'installation de paquets de logiciels
applicatifs supplmentaires.

Un paquet qui s'installe dans \f(CW/opt\fP devra mettre ses fichiers
statiques dans une arborescence \f(CW/opt/<paquet>\fP spare, o
\f(CW<paquet>\fP est un nom dcrivant le paquet logiciel.

Les programmes devant tre lancs par les utilisateurs seront situs
dans le rpertoire \f(CW/opt/<paquet>/bin\fP. Si le paquet comprend des
pages de manuel \*(Ux, elle seront situes dans
\f(CW/opt/<paquet>/man\fP et la mme structure que
\f(CW/usr/share/man\fP sera utilise.

Les rpertoires \f(CW/opt/bin\fP, \f(CW/opt/doc\fP,
\f(CW/opt/include\fP, \f(CW/opt/info\fP, \f(CW/opt/lib\fP et
\f(CW/opt/man\fP sont rservs  l'usage local de l'administrateur
systme. Les paquets peuvent fournir des fichiers de "lancement"
(front-end) faits pour qu'un administrateur systme local les place (en
faisant un lien ou en les copiant) dans ces rpertoires rservs, mais
ils devront fonctionner normalement en l'absence de ces rpertoires
rservs.

Les fichiers variables d'un paquet (qui changent pendant l'utilisation
normale) devraient tre installs dans \f(CW/var/opt\fP. Voyez la
section sur \f(CW/var/opt\fP pour plus d'informations.

Les fichiers de configuration spcifiques  la machine devraient tre
installs dans \f(CW/etc/opt\fP. Voyez la section sur \f(CW/etc/opt\fP
pour plus d'informations.

Aucun autre fichier de paquet ne devrait exister en dehors des
hirarchies \f(CW/opt\fP, \f(CW/var/opt\fP et \f(CW/etc/opt\fP sauf pour
les fichiers de paquet qui doivent rsider dans des endroits spcifiques
 l'intrieur de l'arborescence du systme de fichiers afin de
fonctionner correctement. Par exemple, les fichiers de verrou des
priphriques doivent tre placs dans \f(CW/var/lock\fP et les
priphriques dans \f(CW/dev\fP.

.HU "Raison d'tre"
.br
.P
L'utilisation de \f(CW/opt\fP pour les logiciels supplmentaires est une
pratique bien tablie dans la communaut \*(Ux. L'interface Binaire
d'Applications (ABI) System V [AT&T 1990], base sur la Dfinition
d'Interface System V (troisime dition) fournit une structure
\f(CW/opt\fP trs similaire  celle dcrite ici.

La Norme de Compatibilit Binaire Intel version 2 (iBCS2) fournit aussi
une structure similaire pour \f(CW/opt\fP.

En gnral, toutes les donnes ncessaires au support d'un paquet sur un
systme doivent tre prsentes dans \f(CW/opt/<paquet>\fP, y compris les
fichiers destins  tre copis dans \f(CW/etc/opt/<paquet>\fP et
\f(CW/var/opt/<paquet>\fP ainsi que dans les rpertoires rservs de
\f(CW/opt\fP.

.H 2 "/root : rpertoire personnel de l'utilisateur root (optionnel)"
.P
\f(CW/\fP est traditionnellement le rpertoire personnel du compte root
sur les systmes \*(Ux. \f(CW/root\fP est utilis sur de nombreux
systmes Linux et sur certains systmes \*(Ux (afin de rduire
l'encombrement du rpertoire \f(CW/\fP). Le rpertoire personnel du
compte root peut tre dtermin par une prfrence au niveau du
dveloppeur ou locale. Les possibilits videntes comprennent \f(CW/\fP,
\f(CW/root\fP et \f(CW/home/root\fP.

Si le rpertoire personnel du compte root n'est pas stock sur la
partition racine il sera ncessaire de s'assurer qu'il prendra la valeur
\f(CW/\fP par dfaut si on ne peut le trouver.

.ft I
Note : nous nous opposons  l'utilisation du compte root pour des choses
simples comme le courrier lectronique ou les forums de discussion, et
recommandons qu'il ne soit utilis qu'au titre de l'administration
systme. Pour cette raison, nous recommandons que les sous-rpertoires
tels que \f(CWMail\fP et \f(CWNews\fP n'apparaissent pas dans le
rpertoire personnel du compte root, et que le courrier  destination
des rles administratifs comme root, postmaster ou webmaster soient
redirigs vers un utilisateur appropri.
.ft P

.H 2 "/sbin : binaires systmes (qui se trouvaient autrefois dans /etc)"
.P
Les utilitaires utiliss pour l'administration systme (et autres
commandes faites uniquement pour le super-utilisateur) sont stocks dans
\f(CW/sbin\fP, \f(CW/usr/sbin\fP et \f(CW/usr/local/sbin\fP.
\f(CW/sbin\fP contient typiquement des binaires importants au dmarrage
du systme en plus des binaires de \f(CW/bin\fP. Tout ce qui est excut
aprs qu'il soit sr que \f(CW/usr\fP soit mont (quand il n'y a pas de
problmes) devrait aller dans \f(CW/usr/sbin\fP. Les binaires
d'administration systme spcifiques au systme devraient tre installs
dans \f(CW/usr/local/sbin\fP.

Dcider de ce qui va dans les rpertoires \f(CW"sbin"\fP est simple : si
un utilisateur normal (pas un administrateur systme) doit le lancer
directement, il devrait alors aller dans l'un des rpertoires
\f(CW"bin"\fP. Les utilisateurs ordinaires ne devraient mettre aucun des
rpertoires \f(CWsbin\fP dans leur chemin d'accs (path).

.ft I
Note : par exemple, les fichiers tels que \f(CWchfn\fP que les
utilisateurs n'utilisent que de temps en temps devraient quand mme tre
placs dans \f(CW/usr/bin\fP. \f(CWping\fP, bien qu'il ne soit
absolument ncessaire que pour root (remise en tat et diagnostic
rseau) est souvent utilis par les utilisateurs et pour cette raison
devrait exister dans \f(CW/bin\fP.
.ft R

Nous recommandons que les utilisateurs aient les permissions de lecture
et d'excution pour tout ce qui se trouve dans \f(CW/sbin\fP mis  part,
peut-tre, certains programmes setuid et setgid. La division entre
\f(CW/bin\fP et \f(CW/sbin\fP n'a pas t cre pour des raisons de
scurit ou pour empcher les utilisateurs de voir le systme
d'exploitation, mais pour fournir une bonne sparation entre les
binaires que tout le monde utilise et ceux qui sont tout d'abord
utiliss pour des tches d'administration. Il n'y a pas d'avantage
spcifique pour la scurit  rendre \f(CW/sbin\fP inaccessible aux
utilisateurs.

.HU "Fichiers obligatoires pour /sbin :"
.BL
.LI
commandes gnrales :
.VL 2
.LI "\f(CW{"
clock, getty, init, update, mkswap, swapon, swapoff, telinit }\fP
.LE

.LI
commandes d'extinction :
.VL 2
.LI "\f(CW{"
fastboot, fasthalt, halt, reboot, shutdown }\fP
.LE
.sp 0.5
(ou toute combinaison des fichiers ci-dessus, pourvu que
\f(CWshutdown\fP soit inclus.)

.LI
commandes de gestion du systme de fichiers :
.VL 2
.LI "\f(CW{"
fdisk, fsck, fsck.*, mkfs, mkfs.* }\fP
.LE
.sp 0.5
\f(CW*\fP = un ou plus parmi \f(CWext, ext2, minix, msdos, xia\fP et
peut-tre d'autres

.LI
commandes rseau :
.VL 2
.LI "\f(CW{"
ifconfig, route }\fP
.LE
.LE

.H 2 "/tmp : fichiers temporaires"
.P
Le rpertoire \f(CW/tmp\fP devra re mis  la disposition des programmes
qui ont besoin de crer des fichiers temporaires.

Bien que les donnes stockes dans \f(CW/tmp\fP puissent tre effaces
d'une manire spcifique  chaque site, il est recommand que les
fichiers et rpertoires situs dans \f(CW/tmp\fP soient effacs  chaque
dmarrage du systme.

Les programmes ne devront pas supposer que tout fichier ou rpertoire de
\f(CW/tmp\fP est prserv entre deux lancements de ces programmes.

.HU "Raison d'tre :"
.br
.P
La norme IEEE P1003.2 (POSIX, partie 2) donne des obligations similaires
 la section ci-dessus.

\*(Fs a ajout la recommandation du nettoyage de \f(CW/tmp\fP au
dmarrage sur la base de prcdents historiques et de pratique commune,
mais n'en a pas fait une obligation parce que l'administration systme
n'entre pas dans l'objectif de cette norme.
.SK

.H 1 "La hirarchie /usr"
.P
\f(CW/usr\fP est la deuxime grande partie du systme de fichiers.
\f(CW/usr\fP contient des donnes partageables, en lecture seule. Ceci
veut dire qu'on devrait pouvoir partager \f(CW/usr\fP entre plusieurs
machines diffrentes se conformant  la \*(Fs et on ne devrait pas y
crire. Toute information spcifique  la machine ou qui varie avec le
temps est stocke autre part.

Aucun grand paquet logiciel ne devrait utiliser un sous-rpertoire
direct sous la hirarchie \f(CW/usr\fP. Exception est faite du systme X
Window  cause d'un norme prcdent et d'une pratique largement suivie.
Cette section de la norme spcifie l'emplacement de la plupart de ces
paquets.

.PS
copy "draft.pic"
dir(/usr,hirarchie secondaire)
sub("X11R6","systme X Window, version 11 release 6")
sub("X386","systme X Window, version 11 release 5 sur des plates-formes x86")
sub("bin","la plupart des commandes utilisateurs")
.\" old placement
.\" sub("g++-include","GNU C++ include files")
sub("games","binaires de jeux et d'apprentissage")
sub("include","fichiers d'en-ttes inclus par les programmes C")
sub("lib","bibliothques")
sub("local","hirarchie locale (vide aprs l'installation principale)")
sub("sbin","binaires systmes non importants")
sub("share","donnes indpendantes de l'architecture")
sub("src","code source")
.PE

Les liens symboliques vers les rpertoires suivants peuvent exister.
Cette possibilit est base sur le besoin de prserver la compatibilit
avec les vieux systmes jusqu' ce qu'on soit sr que toutes les
implmentations utilisent la hirarchie \f(CW/var\fP.

.nf
.ft CW
    /usr/spool -> /var/spool
    /usr/tmp -> /var/tmp
    /usr/spool/locks -> /var/lock
.ft P
.fi

Une fois qu'un systme n'a plus besoin de l'un des liens symboliques
ci-dessus, le lien peut tre enlev si dsir.

.SK
.H 2 "/usr/X11R6 : systme X Window, version 11 release 6"
.P
Cette hirarchie est rserve au systme X Window, version 11 release 6,
et aux fichiers apparents.

Pour simplifier les choses et rendre XFree86 plus compatible avec le
systme X Window sur les autres systmes, les liens symboliques suivants
doivent tre prsents :

.nf
.ft CW
    /usr/bin/X11 -> /usr/X11R6/bin
    /usr/lib/X11 -> /usr/X11R6/lib/X11
    /usr/include/X11 -> /usr/X11R6/include/X11
.ft P
.fi
.P
En gnral, les logiciels ne devraient pas tre installs ou grs par
l'intermdiaire de ces liens symboliques. Ils ne sont destins qu' une
utilisation par les utilisateurs. La difficult est lie  la version de
sortie du systme X Window \(em dans les priodes de transition, il est
impossible de savoir quelle version de X11 est en cours d'utilisation.

Les donnes spcifiques  la machine dans \f(CW/usr/X11R6/lib/X11\fP
devraient tre considres comme des fichiers de dmonstration. Les
applications ayant besoin d'informations sur la machine courante (grce
 des fichiers comme \f(CWXconfig\fP, \f(CWXF86Config\fP ou
\f(CWsystem.twmrc\fP) doivent se rfrer  un fichier de configuration
dans \f(CW/etc/X11\fP, qui peut tre un lien vers un fichier de
\f(CW/usr/X11R6/lib\fP.

.H 2 "/usr/X386 : systme X Window, version 11 release 5, sur les plates-formes x86"
.P
Cette hirarchie est en gnral identique  \f(CW/usr/X11R6\fP ; les
liens symboliques de \f(CW/usr\fP pour X11 devraient pointer vers la
version du systme X Window dsire.

.H 2 "/usr/bin : la plupart des commandes utilisateurs"
.P
Voici le rpertoire principal des commandes excutables sur le systme.

.PS
copy "draft.pic"
dir(/usr/bin,binaires non ncessaires en mode utilisateur unique)
sub("mh","commandes pour le systme de gestion de courrier MH")
sub("X11","lien symbolique vers \f(CW/usr/X11R6/bin\fP")
.PE

Les interprteurs de scripts shell (qu'on lance avec \f(CW#!<chemin>\fP
sur la premire ligne d'un script shell) ne pouvant pas compter sur un
chemin, il est avantageux de normaliser leur emplacement. Les
interprteurs du shell de Bourne et du shell C sont dj fixs dans
\f(CW/bin\fP, mais on trouve souvent Perl, Python et Tcl dans maints
endroits diffrents. \f(CW/usr/bin/perl\fP, \f(CW/usr/bin/python\fP et
\f(CW/usr/bin/tcl\fP devraient faire rfrence respectivement aux
interprteurs de shell \f(CWperl\fP, \f(CWpython\fP et \f(CWtcl\fP. Il
peut y avoir des liens symboliques vers l'emplacement vritable des
interprteurs shell.

.SK
.H 2 "/usr/include : rpertoire pour les fichiers d'en-ttes standards."
.P
Voici l'endroit o tous les fichiers d'en-ttes  usage gnral pour les
langages de programmation C et C++ devraient tre placs.

.PS
copy "draft.pic"
dir(/usr/include,fichiers d'en-ttes)
sub("X11","lien symbolique vers \f(CW/usr/X11R6/include/X11\fP")
sub("bsd","fichiers d'en-ttes de compatibilit BSD (si ncessaire)")
sub("g++","fichiers d'en-ttes pour le GNU C++")
.PE

.H 2 "/usr/lib : bibliothques pour la programmation et les paquets"
.P
\f(CW/usr/lib\fP contient des fichiers objets, des bibliothques et des
binaires internes qui ne sont pas destins  tre excuts directement
par les utilisateurs ou les scripts shell.

Les applications peuvent utiliser un sous-rpertoire unique sous
\f(CW/usr/lib\fP. Si une application utilise un sous-rpertoire, toutes
les donnes dpendantes de l'architecture utilises exclusivement par
cette application devraient tre places dans ce sous-rpertoire. Par
exemple, le sous-rpertoire \f(CWperl5\fP pour les modules et les
bibliothques de Perl 5.

Les fichiers et rpertoires divers, statiques, indpendants de
l'architecure et spcifiques  une application devraient aller dans
\f(CW/usr/share\fP.

Certaines commandes excutables telles que \f(CWmakewhatis\fP et
\f(CWsendmail\fP ont aussi t places de manire traditionnelle dans
\f(CW/usr/lib\fP. \f(CWmakewhatis\fP est un binaire interne et devrait
tre plac dans un rpertoire de binaires ; les utilisateurs n'utilisent
que \f(CWcatman\fP. Les nouveaux binaires \f(CWsendmail\fP sont
maintenant placs par dfaut dans \f(CW/usr/sbin\fP ; un lien symbolique
devrait rester depuis \f(CW/usr/lib\fP. En plus, les systmes qui
utilisent Smail devraient placer Smail dans \f(CW/usr/sbin/smail\fP et
\f(CW/usr/sbin/sendmail\fP devrait tre un lien symbolique vers
celui-ci.

Un lien symbolique \f(CW/usr/lib/X11\fP pointant vers le rpertoire
\f(CWlib/X11\fP de la distribution X par dfaut est ncessaire si X est
install.

.\" XXX - Chris a effac ceci. Peut-tre le rduire  une phrase ?
.\"
.ft I
Note : aucune donne spcifique  la machine pour le systme X Window ne
devrait tre stock dans \f(CW/usr/lib/X11\fP. Les fichiers de
configuration spcifiques  la machine tels que \f(CWXconfig\fP ou
\f(CWXF86Config\fP devraient se trouver dans \f(CW/etc/X11\fP. Ceci
devrait comprendre les donnes de configuration tels que
\f(CWsystem.twmrc\fP mme si l'on n'en fait qu'un lien symbolique vers
un fichier de configuration plus global (probablement dans
\f(CW/usr/X11R6/lib/X11\fP).

.ft P

.H 2 "/usr/local : hirarchie locale"
.P
La hirarchie \f(CW/usr/local\fP est destine  l'usage de
l'administrateur systme quand il installe des logiciels localement. Il
doit tre mis  l'abri de tout crasement lors de la mise  jour du
logiciel systme. On peut l'utiliser pour des programmes et des donnes
qu'on peut partager parmi un groupe de machines, mais qu'on ne trouve
pas dans \f(CW/usr\fP.

.PS
copy "draft.pic"
dir(/usr/local,hirarchie locale)
sub("bin","binaires locaux")
sub("games","binaires de jeux locaux")
sub("include","fichiers d'en-ttes C locaux")
sub("lib","bibliothques locales")
sub("sbin","binaires systme locaux")
sub("share","hirarchie indpendante de la machine locale")
sub("src","code source local")
.PE

Ce rpertoire devrait toujours tre vide aprs la premire installation
d'un systme se conformant  la \*(Fs. Aucune exception  cette rgle ne
devrait tre faite  part les morceaux de rpertoires lists.

Un logiciel install localement devrait tre plac dans
\f(CW/usr/local\fP plutt que dans \f(CW/usr\fP sauf si on l'installe
pour remplacer ou mettre  jour un logiciel de \f(CW/usr\fP.

Notez que les logiciels placs dans \f(CW/\fP ou \f(CW/usr\fP peuvent
tre crass par les mises  jour systmes (bien que nous recommandons
que les distributions n'crasent pas les donnes de \f(CW/etc\fP dans
ces circonstances). Pour cette raison, les logiciels locaux ne devraient
pas se trouver en dehors de \f(CW/usr/local\fP sans une bonne raison.

.H 2 "/usr/sbin : binaires systmes normaux non importants"
.P
Ce rpertoire contient tous les binaires non importants utiliss
exclusivement par l'administrateur systme. Les programmes
d'administration systme ncessaires  la rparation du systme, sa
remise en route, le montage de \f(CW/usr\fP ou d'autres fonctions
importantes devraient plutt tre placs dans \f(CW/sbin\fP.

.\" XXX - Chris a barr les deux paragraphes suivants. Effacer ?
Typiquement, \f(CW/usr/sbin\fP contient les dmons rseau, tous les
outils d'administration non importants et les binaires pour les
programmes serveurs non critiques.

.\" Je ne suis pas sr de devoir recommander ce paragraphe -
.\" il semble hors de notre porte - iwj
Ces programmes serveurs sont utiliss pendant le passage  l'tat System
V connu sous le nom de "run level 2" (niveau d'excution, tat
multi-utilisateurs) et "run level 3" (niveau d'excution, tat en
rseau) ou dans l'tat BSD connu sous le nom de "mode
multi-utilisateurs".  ce point, le systme met certains services  la
disposition des utilisateurs (par exemple, les impressions) et 
d'autres machines (par exemple, l'exportation NFS).

Les programmes d'administration systme installs en local devraient se
trouver dans \f(CW/usr/local/sbin\fP.

.H 2 "/usr/share : donnes indpendantes de l'architecture"
.P

.PS
copy "draft.pic"
dir(/usr/share,donnes indpendantes de l'architecture)
sub("dict","listes de mots")
sub("doc","documentations diverses")
sub("games","fichiers de donnes statiques pour \f(CW/usr/games\fP")
sub("info","rpertoire principal du systme Info de GNU")
sub("locale","informations pour Locale")
sub("man","pages de manuel en ligne")
sub("nls","support pour la langue natale")
sub("misc","donnes diverses indpendantes de la machine")
sub("terminfo","rpertoires pour la base de donnes terminfo")
sub("tmac","macros troff non distribues avec groff")
sub("zoneinfo","information et configuration pour le fuseau horaire")
.PE

La hirarchie \f(CW/usr/share\fP contient tous les fichiers de donnes
indpendantes de l'architecture en lecture seule. La plupart de ces
donnes se trouvaient  l'origine dans \f(CW/usr\fP (\f(CWman\fP,
\f(CWdoc\fP) ou \f(CW/usr/lib\fP (\f(CWdict\fP, \f(CWterminfo\fP,
\f(CWzoneinfo\fP). Cette hirarchie est destine  tre partage entre
toutes les plates-formes et architectures d'un systme d'exploitation
donn ; ainsi, par exemple, un site avec des plates-formes i386, Alpha
et PPC peut maintenir un seul rpertoire \f(CW/usr/share\fP mont de
manire centrale. Notez, cependant, que \f(CW/usr/share\fP n'est en
gnral pas fait pour tre partag par des systmes d'exploitation
diffrents ou par diffrentes versions du mme systme d'exploitation.

Tout programme ou paquet qui contient ou ncessite des donnes ne
ncessitant pas de modification devrait stocker ces donnes dans
\f(CW/usr/share\fP (ou \f(CW/usr/local/share\fP en cas d'installation
locale). Il est recommand d'utiliser un sous-rpertoire de
\f(CW/usr/share\fP  cet effet.

Notez que Linux utilise pour le moment des fichiers de bases de donnes
au format DBM. Bien que ceux-ci ne soient pas indpendants de
l'architecture, ils sont autoriss dans \f(CW/usr/share\fP en
anticipation d'un passage au format DB 2.0 indpendant de
l'architecture. (NdT : il semble que la plupart des distributions aient
maintenant -- janvier 2000 -- inclus le format DB 2.0.)

Les donnes de jeux stockes dans \f(CW/usr/share/games\fP devraient
tre des donnes purement statiques. Tout fichier modifiable, comme les
fichiers de scores, les enregistrements de parties et ainsi de suite,
devraient se trouver dans \f(CW/var/games\fP.

Il est recommand que les rpertoire spcifiques  une application,
indpendants de l'architecture soient placs ici. De tels rpertoires
comprennent \f(CWgroff\fP, \f(CWperl\fP, \f(CWghostscript\fP,
\f(CWtexmf\fP et \f(CWkbd\fP (Linux) ou \f(CWsyscons\fP (BSD). On peut,
cependant, les placer dans \f(CW/usr/lib\fP pour des raisons de
compatibilit ascendante,  la discrtion du distributeur. De mme, on
peut utiliser une hirarchie \f(CW/usr/lib/games\fP en plus de la
hirarchie \f(CW/usr/share/games\fP si le distributeur dsire placer
quelques donnes de jeux  cet endroit.

.\"
.\" Note les fichiers de support de groff devraient tre installs dans
.\" /usr/share/groff pour simplifier la mise  jour de groff sur les
.\" systmes Linux, plutt que la distribution des fichiers groff que
.\" l'on trouve sur les systmes BSD actuels.

.H 3 "/usr/share/dict : listes de mots"
.sp
.HU "Fichiers recommands pour /usr/share/dict :"
.VL 2
.LI "\f(CW{"
words }\fP
.LE
.P
Traditionnellement, ce rpertoire ne contient que le fichier anglais
\f(CWwords\fP, utilis par \f(CWlook(1)\fP et divers programmes de
correction orthographique. \f(CWwords\fP peut utiliser l'orthographe
amricaine ou britannique. Les sites qui veulent les deux peuvent faire
un lien \f(CWwords\fP vers \f(CW\%/usr/share/dict/american-english\fP ou
\f(CW\%/usr/share/dict/british-english\fP.

On peut ajouter des listes de mots pour d'autres langues en utilisant le
nom anglais de cette langue, par exemple \f(CW/usr/share/dict/french\fP,
\f(CW/usr/share/dict/danish\fP, etc. Ils devraient, si possible,
utiliser un jeu de caractres ISO 8859 appropri  la langue en question
; si possible en utilisant le jeu de caractres Latin1 (ISO 8859-1) --
ce n'est souvent pas possible.

D'autres listes de mots, comme le "dictionnaire" \f(CWweb2\fP devraient
y tre inclus, s'ils existent.

.HU "Raison d'tre :"
.br
.P
La raison pour laquelle seules les listes de mots sont situes ici est
que ce sont les seuls fichiers communs  tous les correcteurs
d'orthographe.

.H 3 "/usr/share/man : pages de manuel"
.sp
Cette section parcourt en dtail l'organisation des pages de manuel pour
le systme entier, en incluant \f(CW/usr/share/man\fP. Reportez-vous
aussi  la section sur \f(CW/var/cache/man\fP.

Les pages de manuel sont stockes dans
\f(CW<manrep>/<locale>/man<section>/<arch>\fP. \f(CW<manrep>\fP,
\f(CW<locale>\fP, \f(CW<section>\fP et \f(CW<arch>\fP sont expliqus
ci-dessous.

.PS
copy "draft.pic"
dir(<manrep>/<locale>,hirarchie de pages de manuel)
sub("man1","programmes utilisateurs")
sub("man2","appels systme")
sub("man3","appels de bibliothque")
sub("man4","fichiers spciaux")
sub("man5","formats de fichiers")
sub("man6","jeux")
sub("man7","divers")
sub("man8","administration systme")
.PE
Le \f(CW<manrep>\fP principal du systme est \f(CW/usr/share/man\fP.
\f(CW/usr/share/man\fP contient des informations du manuel pour les
commandes et les donnes des systmes de fichiers \f(CW/\fP et
\f(CW/usr\fP. videmment, il n'y a pas de pages de manuel dans \f(CW/\fP
parce qu'elles ne sont pas utiles au dmarrage, ni dans les situations
d'urgence.

La \f(CW<section>\fP dcrit la section du manuel.

Il faut s'assurer de faire de la place dans la structure de
\f(CW/usr/share/man\fP pour supporter les pages de manuel crites en des
langues diffrentes (ou multiples). Cette place doit prendre en compte
le stockage et la rfrence  ces pages de manuel. Les facteurs
pertinents comprennent la langue (avec les diffrences gographiques),
et le codage des caractres.

Le nommage des sous-rpertoires spcifiques  la langue dans
\f(CW/usr/share/man\fP est bas sur l'annexe E de la norme POSIX 1003.1
qui dcrit la chane d'identification locale \(em la mthode la mieux
accepte pour dcrire un environnement culturel. La chane
\f(CW<locale>\fP est :

.P 1
\f(CW<langue>[_<territoire>][.<code_caractre>][,<version>]\fP

Le champ \f(CW<langue>\fP sera tir d'ISO 639 (un code de reprsentation
des noms de langues). Il sera constitu de deux caractres et spcifi
en lettres minuscules uniquement.

Le champ \f(CW<territoire>\fP sera le code  deux lettres d'ISO 3166
(spcification des reprsentations de pays) si possible. (La plupart des
personnes sont familires avec les codes  deux lettres utiliss pour
les codes de pays des adresses lectroniques\*F.) Il sera constitu de
deux caractres spcifis en lettres majuscules uniquement.
.FS
Une exception majeure  cette rgle est le Royaume-Uni, qui est `GB'
dans ISO 3166, mais `UK' pour la plupart des adresses lectroniques.
.FE

Le champ \f(CW<code_caractre>\fP devrait reprsenter la norme dcrivant
le code de caractres. Si le champ \f(CW\%<code_caractre>\fP est une
simple indication numrique, le nombre reprsente le numro de la norme
internationale dcrivant le code de caractres. Il est recommand que ce
soit une reprsentation numrique si possible (surtout pour les normes
ISO), qu'il n'inclue pas de symboles de ponctuation supplmentaires et
que toute lettre soit en minuscule.

Un paramtre spcifiant la \f(CW<version>\fP du profil peut tre plac
aprs le champ \f(CW\%<code_caractre>\fP, spar par une virgule. Ceci
peut servir  diffrencier plusieurs besoins culturels ; par exemple,
l'ordre du dictionnaire compar  un ordre d'assemblage plus orient
systme. Cette norme recommande de ne pas utiliser le champ
\f(CW<version>\fP, sauf si c'est ncessaire.

Les systmes utilisant une langue et un code de caractres uniques pour
toutes les pages de manuel peuvent omettre la sous-chane
\f(CW<locale>\fP et stocker toutes les pages de manuel dans
\f(CW<manrep>\fP. Par exemple, les systmes qui n'ont que les pages de
manuel en anglais codes en ASCII peuvent stocker ces pages (les
rpertoires \f(CWman<section>\fP) directement dans
\f(CW/usr/share/man\fP. (Ce qui reprsente, en fait, la disposition et
les circonstances habituelles.)

Les pays pour lesquels existe un ensemble de codes de caractres
standard bien accept peuvent omettre le champ
\f(CW\%<code_caractre>\fP, mais il est fortement recommand de
l'inclure, surtout pour les pays ayant plusieurs normes en comptition.

Quelques exemples :

.TS
l l l l
l l l lfCW.
langue	territoire	code de caractre	rpertoire
_
Anglais	\(em	ASCII	/usr/share/man/en
Anglais	Royaume Uni	ASCII	/usr/share/man/en_GB
Anglais	tats-Unis	ASCII	/usr/share/man/en_US
Franais	Canada	ISO 8859-1	/usr/share/man/fr_CA
Franais	France	ISO 8859-1	/usr/share/man/fr_FR
Allemand	Allemagne	ISO 646	/usr/share/man/de_DE.646
Allemand	Allemagne	ISO 6937	/usr/share/man/de_DE.6937
Allemand	Allemagne	ISO 8859-1	/usr/share/man/de_DE.88591
Allemand	Suisse	ISO 646	/usr/share/man/de_CH.646
Japonais	Japon	JIS	/usr/share/man/ja_JP.jis
Japonais	Japon	SJIS	/usr/share/man/ja_JP.sjis
Japonais	Japon	UJIS (ou EUC-J)	/usr/share/man/ja_JP.ujis
.TE

De mme, il faut faire de la place pour les pages de manuel dpendant de
l'architecture, comme la documentation sur les pilotes de priphriques
ou les commandes d'administration systme de bas niveau. Elles devraient
tre places dans un rpertoire \f(CW<arch>\fP dans le rpertoire
\f(CWman<section>\fP appropri ; par exemple, une page de manuel pour la
commande i386 ctrlaltdel(8) peut tre place dans
\f(CW/usr/share/man/<locale>/man8/i386/ctrlaltdel.8\fP.

Les pages de manuel pour les commandes et les donnes de
\f(CW/usr/local\fP sont stockes dans \f(CW/usr/local/man\fP. Les pages
de manuel pour X11R6 sont stockes dans \f(CW/usr/X11R6/man\fP. Il
s'ensuit que toutes les hirarchies de pages de manuel du systme
devraient avoir la mme structure que \f(CW/usr/share/man\fP. Les
rpertoires vides peuvent tre exclus d'une hirarchie de pages de
manuel. Par exemple, si \f(CW/usr/local/man\fP n'a pas de page de manuel
pour la section 4 (priphriques), alors on peut omettre
\f(CW/usr/local/man/man4\fP.

Les sections de pages cat (\f(CWcat<section>\fP) contenant des entres
de pages de manuel formates se trouvent aussi dans les sous-rpertoires
de \f(CW<manrep>/<locale>\fP, mais ne sont pas obligatoires ni ne
devraient tre distribues  la place des pages de manuel en source
nroff.
.\" d'autres sous-rpertoires, ps<section>, dvi<section>, html<section>
.\" pourront y tre ajouts
.\"  revoir

Les sections numrotes "1"  "8" sont dfinies de manire
traditionnelle. En gnral, le nom de fichier des pages de manuel
situes dans une section particulire se termine par \f(CW.<section>\fP.

De plus, certains grands ensembles de pages de manuel spcifiques  une
application possdent un suffixe supplmentaire accol au nom de fichier
de la page de manuel. Par exemple, les pages de manuel du systme de
gestion de courrier MH devraient avoir \f(CWmh\fP accol  toutes les
pages de manuel de MH. Toutes les pages de manuel du systme X Window
devraient avoir un \f(CWx\fP accol au nom de fichier.

La pratique de placer les pages de manuel de diverses langues dans les
sous-rpertoires appropris de \f(CW/usr/share/man\fP s'applique aussi
aux autres hirarchies de pages de manuel, comme \f(CW/usr/local/man\fP
et \f(CW/usr/X11R6/man\fP. (Cette partie de la norme s'appliquera aussi
plus loin dans la section sur la structure optionnelle
\f(CW/var/cache/man\fP.)

Voici une description de chaque section :

.BL
.LI
\f(CWman1\fP : programmes utilisateurs
.br
Les pages de manuel dcrivant les commandes accessibles  tous se
trouvent dans ce chapitre. La majeure partie de la documentation sur les
programmes dont aura jamais besoin un utilisateur se trouve ici.
.LI
\f(CWman2\fP : appels systme
.br
Cette section dcrit tous les appels systmes (requtes au noyau pour
effectuer des oprations).
.\" enlever la remarque entre parenthses ? supposer les connaissances
.\" techniques ?
.LI
\f(CWman3\fP : fonctions et routines de la bibliothque
.br
La section 3 dcrit les routines de bibliothque des programmes qui ne
sont pas des appels directs aux services du noyau. Ceci ainsi que le
chapitre 2 n'intressent vraiment que les programmeurs.
.LI
\f(CWman4\fP : fichiers spciaux
.br
La section 4 dcrit les fichiers spciaux, les fonctions spcifiques aux
pilotes et le support rseau disponible sur le systme. On y trouve
typiquement les fichiers de priphriques de \f(CW/dev\fP et l'interface
noyau pour le support des protocoles rseau.
.LI
\f(CWman5\fP : formats de fichiers
.br
Le format de nombreux fichiers de donnes non intuitifs est document
dans la section 5. Ceci comprend divers fichiers d'en-ttes, les
fichiers de rsultats de programmes et les fichiers systmes.
.LI
\f(CWman6\fP : jeux
.br
Ce chapitre documente les jeux, les dmonstrations et des programmes en
gnral triviaux. Des personnes diffrentes ont des notions varies sur
l'opportunit de cette partie.
.LI
\f(CWman7\fP : divers
.br
Les pages de manuel difficiles  classer sont places dans la section 7.
Les paquets de macros pour troff et autres processeurs de texte se
trouvent ici.
.LI
\f(CWman8\fP : administration systme
.br
La documentation pour les programmes utiliss par les administrateurs
systme pour la bonne marche du systme et sa maintenance se trouve ici.
Certains de ces programmes sont aussi utiles de temps  autre pour les
utilisateurs normaux.
.LE

.H 3 "/usr/share/misc : diverses donnes indpendantes de l'architecture"
.sp
.P
Ce rpertoire contient divers fichiers indpendants de l'architecture
qui ne ncessitent pas un sous-rpertoire spar dans
\f(CW/usr/share\fP. C'est un rpertoire obligatoire de
\f(CW/usr/share\fP.

Les fichiers suivants, s'ils sont prsents, devraient se trouver dans
\f(CW/usr/share/misc\fP :

.VL 2
.LI "\f(CW{"
ascii, magic, termcap, termcap.db }\fP
.LE

D'autres fichiers (spcifiques  une application) peuvent apparatre
ici, mais un intgrateur peut les placer dans \f(CW/usr/lib\fP  sa
discrtion. De tels fichiers comprennent :

.VL 2
.LI "\f(CW{"
airport, birthtoken, eqnchar, getopt, gprof.callg, gprof.flat,
inter.phone, ipfw.samp.filters, ipfw.samp.scripts, keycap.pcvt,
mail.help, mail.tildehelp, man.template, map3270, mdoc.template,
more.help, na.phone, nslookup.help, operator, scsi_modes, sendmail.hf,
style, units.lib, vgrindefs, vgrindefs.db, zipcodes }\fP
.LE

.H 2 "/usr/src : code source"
.P
Tout code source non local devrait tre plac dans ce sous-rpertoire.

.SK
.H 1 "La hirarchie /var"
.PS
copy "draft.pic"
dir(/var,donnes variables)
sub("account","historique de la comptabilit des processus (si support)")
sub("cache","donnes de cache des applications")
sub("crash","donnes brutes des plantages systme (si support)")
sub("games","donnes variables des jeux")
sub("lock","fichiers de verrous")
sub("log","fichiers et rpertoires d'historique")
sub("mail","fichiers de botes aux lettres des utilisateurs")
sub("opt","donnes variables de /opt")
sub("run","fichiers relatifs aux processus en cours")
sub("spool","donnes en attente pour les applications")
sub("state","informations variables d'tat")
sub("tmp","fichiers temporaires prservs entre les redmarrages du systme")
sub("yp","fichiers de base de donnes de NIS (Network Information Service)")
.PE
.P
\f(CW/var\fP contient des fichiers de donnes variables. Ceci comprend
les rpertoires et fichiers en attente (spool), les donnes
administratives et d'historique, et les fichiers transitoires et
temporaires.

Certaines parties de \f(CW/var\fP ne sont pas partageables entre des
systmes diffrents. Par exemple, \f(CW/var/log\fP, \f(CW/var/lock\fP et
\f(CW/var/run\fP. D'autres parties peuvent tre partages, comme
notamment \f(CW/var/mail\fP, \f(CW/var/cache/man\fP,
\f(CW/var/cache/fonts\fP et \f(CW/var/spool/news\fP.

\f(CW/var\fP est ici spcifi afin de rendre possible le montage de
\f(CW/usr\fP en lecture seule. Tout ce qui allait auparavant dans
\f(CW/usr\fP et sur lequel on crivait pendant la marche du systme (au
contraire de l'installation et de la maintenance logicielle) doit aller
dans \f(CW/var\fP.

Si on ne peut pas faire de \f(CW/var\fP une partition spare, il est
souvent prfrable de dplacer \f(CW/var\fP hors de la partition racine
 l'intrieur de la partition \f(CW/usr\fP. (On fait parfois ceci pour
rduire la taille de la partition racine ou quand l'espace se rduit
dans la partition racine.) Cependant, \f(CW/var\fP ne devrait pas tre
un lien vers \f(CW/usr\fP parce que cela rend la sparation de
\f(CW/usr\fP et \f(CW/var\fP plus difficile et rend plus probable la
cration d'un conflit de noms.  la place, faites un lien de
\f(CW/var\fP vers \f(CW/usr/var\fP.

Les applications ne devraient en gnral pas ajouter de rpertoire au
niveau suprieur de \f(CW/var\fP. De tels rpertoires ne devraient tre
ajouts que s'ils concernent le systme en entier, et en consultant la
liste de diffusion \*(Fs.

Les rpertoires \f(CWcache\fP, \f(CWlock\fP, \f(CWlog\fP, \f(CWrun\fP,
\f(CWspool\fP, \f(CWstate\fP et \f(CWtmp\fP doivent tre inclus et
utiliss dans toutes les distributions ; les rpertoires
\f(CWaccount\fP, \f(CWcrash\fP, \f(CWgames\fP, \f(CWmail\fP et
\f(CWyp\fP doivent tre inclus et utiliss si les applications ou
possibilits correspondantes sont fournies dans la distribution.

Les versions prcdentes de la FSSTND incluaient une hirarchie
\f(CW/var/lib\fP. Pour plus d'informations, voir la section sur
\f(CW/var/state\fP.

Plusieurs rpertoires sont `rservs' dans le sens o une application
nouvelle ne devrait pas les utiliser de faon arbitraire, puisqu'ils
entreraient en conflit avec une pratique historique et/ou locale. Ce
sont :

.nf
.ft CW
    /var/backups
    /var/cron
    /var/lib
    /var/local
    /var/msgs
    /var/preserve
.ft P
.fi

.H 2 "/var/account : historique de la comptabilit des processus (si support)"
.P
Ce rpertoire contient l'historique en cours de la comptabilit des
processus et les donnes consolides d'utilisation des processus
(utiliss dans certains systmes de type \*(Ux par \f(CWlastcomm\fP et
\f(CWsa\fP).

.H 2 "/var/cache : donnes de cache des applications"
.P
.PS
copy "draft.pic"
dir(/var/cache,rpertoires de cache)
sub("fonts","fontes gnres en local")
sub("man","pages de manuel formates en local")
sub("www","donnes de cache ou de proxy WWW")
sub("<paquet>","donnes de cache spcifiques  paquet")
.PE

\f(CW/var/cache\fP est fait pour les donnes de cache des applications.
De telles donnes sont gnres localement comme rsultat
d'entres-sorties ou de calculs qui prennent du temps. L'application
doit tre capable de regnrer ou de retrouver les donnes.  la
diffrence de \f(CW/var/spool\fP, les fichiers cachs peuvent tre
effacs sans perte de donnes. Les donnes doivent rester valides entre
deux lancements de l'application et aprs le redmarrage du systme.

Les fichiers situs dans /var/cache peuvent expirer d'une manire
spcifique  l'application, par l'administrateur systme ou des deux
manires. L'application devrait toujours tre capable de s'en remettre
suite  un effacement manuel des fichiers (gnralement  cause d'un
manque d'espace disque). Aucune autre obligation n'est faite concernant
le format des donnes dans les rpertoires de cache.

.HU "Raison d'tre :"
.br
.P
L'existence d'un rpertoire spar pour les donnes de cache permet aux
administrateurs systme d'attribuer des politiques de disque et de
sauvegarde diffrentes des autres rpertoires de \f(CW/var\fP.

.H 3 "/var/cache/fonts : fontes gnres en local"
.sp
.P
Le rpertoire \f(CW/var/cache/fonts\fP devrait re utilis pour stocker
toute fonte cre de manire dynamique. En particulier,
\f(CW/var/cache/fonts/pk\fP stockera toutes les fontes automatiquement
gnres par \f(CWMakeTeXPK\fP.

Il devrait y avoir un lien de \f(CW/usr/lib/texmf/fonts/tmp\fP vers
\f(CW/var/cache/fonts\fP. Ce lien permet aux utilisateurs d'utiliser le
chemin unique \f(CW/usr/lib/texmf/fonts/tfm\fP quand ils font des
modifications  leur variable d'environnement TEXFONTS. (Ceci est le
chemin par dfaut pour les outils \*(Tx de Karl Berry, distribus sur
\f(CWftp.cs.umb.edu:/pub/tex\fP\*F.
.FS
La raison pour laquelle les outils de Karl Berry sont mentionns est
qu'ils sont le standard de-facto pour les installations \*(Ux de \*(Tx.
Ces outils sont largement utiliss dans la communaut \*(Ux libre.
.FE
Si on utilise une autre distribution \*(Tx, on devrait faire un lien du
rpertoire de fontes appropri vers \f(CW/var/cache/fonts\fP.)

Le \f(CWMakeTeXPK\fP distribu avec \f(CWdvipsk\fP placera les fichiers
\f(CW.pk\fP dans \f(CWfonts/pk/<priphrique>/<nom_fonte>\fP (par
exemple, \f(CWfonts/pk/CanonCX/cmr10.300pk\fP). Les fichiers \f(CW.pk\fP
peuvent tre purgs rgulirement de l'arborescence
\f(CW/var/cache/fonts\fP ou peuvent tre dplacs dans l'arborescence
\f(CW/usr/lib/texmf\fP. Si on utilise des gnrateurs automatiques de
\f(CW.mf\fP ou \f(CW.tfm\fP, ils devraient placer leurs donnes dans les
sous-rpertoires \f(CWmf\fP ou \f(CWtfm\fP de \f(CW/var/cache/fonts\fP.

D'autres fontes cres dynamiquement peuvent aussi se trouver dans cette
arborescence, dans des sous-rpertoires de \f(CW/var/cache/fonts\fP
nomms de manire adquate.

.H 3 "/var/cache/man : pages de manuel formates en local (optionnel)"
.sp
.P
Ce rpertoire fournit un emplacement standard pour les sites qui
possdent une partition \f(CW/usr\fP en lecture seule, mais qui veulent
permettre le cache des pages de manuel formates en local. Les sites qui
montent \f(CW/usr\fP en criture (par exemple, les installations en
utilisateur unique) peuvent choisir de ne pas utiliser
\f(CW/var/cache/man\fP et peuvent crire les pages de manuel formates
dans les rpertoires \f(CWcat<section>\fP directement dans
\f(CW/usr/share/man\fP. Nous recommandons que la plupart des sites
utilisent plutt l'une des options suivantes :

.BL
.LI
prformater toutes les pages de manuel  ct des versions non formates
;
.LI
ne permettre aucun cache des pages de manuel formates et obliger 
refaire le formatage  chaque utilisation d'une page de manuel ;
.LI
permettre le cache local des pages de manuel formates dans
\f(CW/var/cache/man\fP.
.LE
.P
La structure de \f(CW/var/cache/man\fP ncessite de reflter  la fois
les hirarchies multiples de pages de manuel et la possibilit d'un
support multilingue.

tant donne une page de manuel non formate qui apparat normalement
dans \f(CW<chemin>/man/<locale>/man<section>\fP, le rpertoire pour
placer les pages de manuel formates s'appelle
\f(CW/var/cache/man/<chemin_cat>/<locale>/cat<section>\fP, o
\f(CW<chemin_cat>\fP s'inspire de \f(CW<chemin>\fP en enlevant toute
composante de nom de chemin \f(CWusr\fP au dbut et/ou \f(CWshare\fP 
la fin. (Notez que la composante \f(CW<locale>\fP peut ne pas tre
prsente.)

.\" Notez que /usr/local/man et /local/man entreront en conflit si un
.\" administrateur systme est assez timbr pour utiliser les deux pour
.\" des choses diffrentes.
Par exemple, \f(CW/usr/share/man/man1/ls.1\fP sera formate en
\f(CW/var/cache/man/cat1/ls.1\fP et
\f(CW/usr/X11R6/man/<locale>/man3/XtClass.3x\fP en
\f(CW/var/cache/man/X11R6/<locale>/cat3/XtClass.3x\fP.

Les pages de manuel crites dans \f(CW/var/cache/man\fP peuvent  la fin
tre transfres vers les rpertoires prformats appropris dans la
hirarchie source \f(CWman\fP ou bien expirer ; de mme, les pages de
manuel formates dans la hirarchie des sources \f(CWman\fP peuvent tre
expires si personne n'y a accd pendant une certaine priode de temps.

Si les pages de manuel prformates sont distribues avec un systme sur
des supports en lecture seule (un CD-ROM, par exemple), elles seront
installes dans la hirarchie des sources \f(CWman\fP (par exemple
\f(CW/usr/share/man/cat<section>\fP). \f(CW/var/cache/man\fP est rserv
comme cache dans lequel on peut crire les pages de manuel formates.

.HU "Raison d'tre :"
.br
.P
La version 1.2 de la norme spcifiait \f(CW/var/catman\fP pour cette
hirarchie. Le chemin a t modifi en \f(CW/var/cache\fP pour mieux
reflter la nature dynamique des pages de manuel formates. Le nom du
rpertoire a t modifi en \f(CWman\fP pour permettre l'agrandissement
de la hirarchie et inclure des formats traits autres que "cat", comme
PostScript, HTML ou DVI.

.H 2 "/var/crash : donnes brutes des plantages systme (si support)"
.P
Ce rpertoire contient des donnes brutes (dump) des plantages systme.
 la date de la sortie de cette norme, les donnes brutes de plantage
systme n'taient pas supportes par Linux.

.H 2 "/var/games : donnes variables des jeux"
.P
Toute donne variable concernant les jeux de \f(CW/usr\fP devrait tre
place ici. \f(CW/var/games\fP devrait contenir les donnes variables
qu'on trouvait auparavant dans \f(CW/usr\fP ; Les donnes statiques
telles que les textes d'aide, les descriptions de niveaux et ainsi de
suite devraient rester autre part, comme dans \f(CW/usr/share/games\fP.

Comme pour \f(CW/var/state\fP, les donnes variables des jeux peuvent
tre places dans \f(CW/var/lib\fP en tant que mesure de transition
obsolte. Cependant, cette permission sera leve dans une version future
de la norme.

.HU "Raison d'tre :"
.br
.P
On a donn une hirarchie \f(CW/var/games\fP  part entire, plutt que
de le laisser mlang avec l'ancien \f(CW/var/lib\fP comme dans la
version 1.2. La sparation permet un contrle local des stratgies de
sauvegarde, permissions et utilisation des disques, ainsi que de
permettre un partage inter-machines et de rduire l'encombrement de
\f(CW/var/state\fP. De plus, \f(CW/var/games\fP est le chemin utilis
traditionnellement par BSD.

.H 2 "/var/lock : fichiers de verrous"
.P
Les fichiers de verrous devraient tre stocks dans la structure de
rpertoires \f(CW/var/lock\fP.

Les fichiers de verrous de priphriques, tels les fichiers de verrous
du priphrique srie qu'on trouvait d'habitude, soit dans
\f(CW/usr/spool/locks\fP, soit dans \f(CW/usr/spool/uucp\fP doivent
maintenant tre stocks dans \f(CW/var/lock\fP. La convention de nommage
 utiliser est
.ie t \{\
\f(CWLCK..\fP suivi du nom de base du priphrique. Par exemple, pour
verrouiller \f(CW/dev/cua0\fP le fichier \f(CWLCK..cua0\fP serait cr.
\}
.el \{\
"LCK.." suivi du nom de base du priphrique. Par exemple, pour
verrouiller /dev/cua0 le fichier "LCK..cua0" serait cr.
\}

Le format utilis pour les fichiers de verrous de priphrique doit tre
le format de fichier de verrou HDB UUCP. Le format HDB permet de stocker
l'identificateur du processus (PID) comme un nombre dcimal ASCII sur
dix octets, avec un signe nouvelle ligne  la fin. Par exemple, si le
processus 1230 tenait un fichier de verrou, ce dernier contiendrait les
onze caractres : espace, espace, espace, espace, espace, espace, un,
deux, trois, zro et nouvelle ligne.

.\" Certaines versions d'UUCP ajoutent une deuxime ligne indiquant quel
.\" programme a cr le verrou (uucp, cu ou getty).
.\" Alors, tout ce qui voudrait utiliser \f(CW/dev/cua0\fP peut lire le
.\" fichier de verrou et agir en consquence (tous les verrous de
.\" \f(CW/var/lock\fP devraient tre lisibles par tout le monde).

.H 2 "/var/log : fichiers et rpertoires d'historique"
.P
Le rpertoire contient divers fichiers d'historique (log). La plupart
des historiques devraient tre crits dans ce rpertoire ou dans un
sous-rpertoire appropri.
.TS
tab(@);
lfCW l.
lastlog@enregistrement du dernier login de chaque utilisateur
messages@messages systme de \f(CWsyslogd\fP
wtmp@enregistrement de chaque login et logout
.TE

.H 2 "/var/mail : fichiers de botes aux lettres utilisateurs"
.P
Ce rpertoire contient les fichiers de botes aux lettres utilisateurs
stocks dans le format de botes aux lettres \*(Ux standard.

.HU "Raison d'tre :"
.br
.P
Ce rpertoire a t relog de \f(CW/var/spool/mail\fP pour amener \*(Fs
en accord avec la plupart des implmentations \*(Ux. Ce changement est
important pour l'interoprabilit puisqu'un \f(CW/var/mail\fP unique est
souvent partag entre plusieurs machines et plusieurs implmentations
d'\*(Ux (malgr les problmes de verrouillage NFS).

.H 2 "/var/opt : donnes variables de /opt"
.P
Les donnes variables devraient tre installes dans
\f(CW/var/opt/<paquet>\fP, o \f(CW<paquet>\fP est le nom de la
sous-arborescence de \f(CW/opt\fP o sont stockes les donnes statiques
de tout paquet logiciel supplmentaire, sauf quand elles sont
supplantes par un autre fichier dans \f(CW/etc\fP. Aucune structure
n'est impose sur la disposition interne de \f(CW/var/opt/<paquet>\fP.

.HU "Raison d'tre :"
.br
.P
Voir la raison d'tre pour \f(CW/opt\fP.

.H 2 "/var/run : fichiers variables d'excution"
.P
Ce rpertoire contient des fichiers d'information systme dcrivant le
systme depuis qu'il a dmarr. Les fichiers de ce rpertoire devraient
tre nettoys (enlevs ou tronqus selon le cas) au dbut du processus
de dmarrage.

Les fichiers d'identification de processus (PID), qui taient placs 
l'origine dans \f(CW/etc\fP, devraient tre placs dans
\f(CW/var/run\fP. La convention de nommage des fichiers PID est
\f(CW<nom_programme>.pid\fP. Par exemple, le fichier PID de
\f(CWcrond\fP est nomm \f(CW/var/run/crond.pid\fP.

Le format interne des fichiers PID reste inchang. Le fichier consiste
en un identificateur de processus en dcimal cod ASCII, suivi d'un
caractre nouvelle ligne. Par exemple, si \f(CWcrond\fP tait le
processus numro 25, \f(CW/var/run/crond.pid\fP contiendrait trois
caractres : deux, cinq et nouvelle ligne.

Les programmes qui lisent les fichiers PID devraient tre assez souples
dans ce qu'ils acceptent ; par exemple, ils devraient ignorer les
espaces blancs supplmentaires, les zros au dbut, l'absence d'une
nouvelle ligne  la fin ou les lignes supplmentaires dans le fichier
PID. Les programmes qui crent des fichiers PID devraient utiliser la
spcification simple situe dans le paragraphe ci-dessus.

Le fichier \f(CWutmp\fP, qui stocke les informations sur qui est en
train d'utiliser le systme, est plac dans ce rpertoire.

Les programmes qui gardent des sockets du domaine \*(Ux temporaires
devraient les placer dans ce rpertoire.

.H 2 "/var/spool : donnes en attente pour les applications"
.PS
copy "draft.pic"
dir(/var/spool,rpertoires d'attente)
sub("lpd","rpertoire d'attente de l'imprimante")
sub("mqueue","file d'attente du courrier  l'expdition")
sub("news","rpertoire d'attente des news")
sub("rwho","fichiers rwhod")
sub("smail","rpertoire d'attente pour smail")
sub("uucp","rpertoire d'attente pour UUCP")
.PE
\f(CW/var/spool\fP contient des donnes en attente d'un traitement
ultrieur. Les donnes de \f(CW/var/spool\fP reprsentent un travail 
faire dans le futur (par un programme, un utilisateur ou un
administrateur) ; les donnes sont souvent effaces aprs avoir t
traites.

.ig
\f(CW/var/spool\fP est fait pour les donnes `en attente' des
applications. De telles donnes restent valides mme si l'application
qui les a cres s'arrte et redmarre. Quelque temps aprs avoir t
cres, les donnes sont enleves automatiquement, d'une manire
spcifique  l'application ; cela arrive typiquement quand un vnement
quelconque se produit (par exemple, lpd imprime le fichier, ou sendmail
l'envoie) ou quand une limite de temps parvient  sa fin (par exemple,
un article de news). Les donnes de \f(CW/var/spool\fP sont en gnral
intressantes pour l'utilisateur en soi et pour soi,  la diffrence des
donnes de \f(CW/var/state\fP, qui n'ont gnralement d'intrt
qu'indirectement.
..
Les fichiers de verrou UUCP doivent tre placs dans \f(CW/var/lock\fP.
Voir la section ci-dessus  propos de \f(CW/var/lock\fP.

.H 3 "/var/spool/lpd : file d'impression du dmon de l'imprimante ligne"
.PS
copy "draft.pic"
dir(/var/spool/lpd,rpertoire d'attente de l'imprimante)
sub("<imprimante>","file d'attente d'une imprimante spcifique (optionnel)")
.PE

Le fichier de verrou de \f(CWlpd\fP, \f(CWlpd.lock\fP, devrait tre
plac dans \f(CW/var/spool/lpd\fP. Nous suggrons que le fichier de
verrou de chaque imprimante soit plac dans le rpertoire d'attente
spcifique  cette imprimante et soit nomm \f(CWlock\fP.

.H 3 "/var/spool/rwho : fichiers rwhod"
.sp
Ce rpertoire contient les informations rwhod d'autres systmes sur le
rseau local.

.HU "Raison d'tre :"
.br
.P
Certaines versions de BSD utilisent \f(CW/var/rwho\fP pour ces donnes ;
tant donn leur emplacement historique dans \f(CW/var/spool\fP sur
d'autres systmes et sa convenance approximative  la dfinition de
donnes `en attente', cet emplacement a t estim plus appropri.

.H 2 "/var/state : informations variables d'tat"

.PS
copy "draft.pic"
dir(/var/state,informations variables d'tat)
sub("<diteur>","fichiers de sauvegarde et tat d'diteurs")
.\" sub("elvis","saved files after crash or hang-up from elvis")
.\" sub("emacs","state directory for Emacs")
sub("misc","diverses donnes d'tat")
.\" sub("news","Fichiers variables pour Cnews/INN")
.\" sub("nvi","Fichiers sauvegards apres le plantage ou le bloquage de nvi")
sub("xdm","donnes variables du gestionnaire d'affichage X xdm")
sub("<pkgtool>","fichiers d'aide au paquet")
sub("<paquet>","donnes d'tat pour les paquets et les sous-systmes")
.PE

Cette hirarchie contient des informations d'tat se rapportant  une
application ou au systme. Les informations d'tat sont des donnes que
les programmes modifient au cours de leur excution, relatives  une
machine spcifique. Les utilisateurs ne devraient jamais avoir besoin de
modifier des fichiers dans \f(CW/var/state\fP pour configurer la bonne
marche d'un paquet.

Les informations d'tat sont utilises en gnral pour prserver
l'environnement d'une application (ou d'un groupe d'applications lies
entre elles) entre plusieurs lancements et entre plusieurs instances de
la mme application. Les informations d'tat devraient en gnral rester
valides aprs un redmarrage, ne devraient pas garder l'historique de
sortie d'un programme et ne devraient pas tre des donnes en attente.
.\" (mais notez que emacs/lock en est une exception),

Une application (ou un groupe d'applications lies) devrait utiliser un
sous-rpertoire de \f(CW/var/state\fP pour ses donnes. Il y a un
sous-rpertoire obligatoire, \f(CW/var/state/misc\fP, fait pour les
fichiers d'tat qui n'ont pas besoin de sous-rpertoire ; les autres
sous-rpertoires ne devraient tre prsents que si l'application en
question est incluse dans la distribution.

\f(CW/var/state/<nom>\fP est l'endroit  utiliser pour tout le support
de paquet de la distribution. Des distributions diffrentes peuvent
videmment utiliser des noms diffrents.

Les versions prcdentes de cette norme utilisaient le nom
\f(CW/var/lib\fP pour cette hirarchie. \f(CW/var/lib\fP est obsolte,
mais peut tre utilis en parallle avec la hirarchie obligatoire
\f(CW/var/state\fP, comme mesure transitoire pour les donnes
spcifiques aux applications. Notez cependant que cette permission sera
retire dans une version future de la norme. Par contre, vous pouvez
faire un lien symbolique de \f(CW/var/lib\fP vers \f(CW/var/state\fP.

.HU "Raison d'tre :"
.br
.P
\f(CW/usr/lib\fP est de plus en plus utilis uniquement pour les
fichiers objets ou leurs archives ; ceci est vrai pour les variantes BSD
\*(Ux actuelles ainsi que les paquets GNU actuels. Dans le mme ordre
d'ides, le nom \f(CW/var/lib\fP semblait inappropri.

BSD utilise le nom \f(CW/var/db\fP pour un rpertoire similaire. Ce nom
semblait trop restrictif, puisqu'il impliquait une structure de
rpertoires faite tout d'abord pour les fichiers de base de donnes
(\f(CW.db\fP).

.H 3 "/var/state/<diteur> : fichiers de sauvegarde et tat d'un diteur"
.sp
Ces rpertoires contiennent des fichiers sauvegards par toute fin
inattendue d'un diteur (par exemple elvis, jove, nvi).

D'autres diteurs peuvent ne pas ncessiter de rpertoire pour les
fichiers de sauvegarde de plantage, mais peuvent ncessiter un endroit
bien dfini pour stocker d'autres informations pendant que l'diteur
fonctionne. Ces informations devraient tre stockes dans un
sous-rpertoire de \f(CW/var/state\fP (par exemple, GNU Emacs placerait
ses fichiers de verrou dans \f(CW/var/state/emacs/lock\fP).

Des diteurs futurs pourront avoir besoin d'informations d'tat
supplmentaires au-del des fichiers de sauvegarde de plantage et des
fichiers de verrou -- ces informations devraient aussi tre places dans
\f(CW/var/state/<diteur>\fP.

.HU "Raison d'tre :"
.br
.P
Les versions prcdentes de Linux, ainsi que tous les distributeurs du
commerce, utilisaient \f(CW/var/preserve\fP pour vi et ses clones.
Cependant, chaque diteur utilise son propre format pour ces fichiers de
sauvegarde de plantage, c'est pourquoi un rpertoire spar est
ncessaire  chaque diteur.

Les fichiers de verrous spcifiques  chaque diteur sont en gnral
assez diffrents des fichiers de verrous de priphrique ou de
ressources stocks dans \f(CW/var/lock\fP et de ce fait sont stocks
dans \f(CW/var/state\fP.

.H 3 "/var/state/misc : diverses donnes variables"
.SP
Ce rpertoire contient des donnes variables qui ne sont pas places
dans un sous-rpertoire de \f(CW/var/state\fP. Il serait judicieux
d'utiliser dans la mesure du possible des noms uniques dans ce
rpertoire pour viter les conflits de noms.

Notez que cette hirarchie devrait contenir les fichiers de
\f(CW/var/db\fP des versions actuelles de BSD. Celles-ci comprennent
\f(CWlocate.database\fP et \f(CWmountdtab\fP, et la (les) base(s) de
donnes des symboles du noyau.

.H 2 "/var/tmp : fichiers temporaires prservs entre les redmarrages du systme"
.P
Le rpertoire \f(CW/var/tmp\fP est mis  la disposition des programmes
qui ont besoin de fichiers ou de rpertoires temporaires prservs entre
les redmarrages du systme. Par consquent, les donnes stockes dans
\f(CW/var/tmp\fP restent plus longtemps que les donnes de \f(CW/tmp\fP.

Les fichiers et rpertoires situs dans \f(CW/var/tmp\fP ne doivent pas
tre effacs quand le systme dmarre. Bien que les donnes stockes
dans \f(CW/var/tmp\fP soient typiquement effaces d'une manire
spcifique au site, il est recommand que l'effacement se fasse dans un
intervalle plus long que pour \f(CW/tmp\fP.

.ig
Un lien symbolique \f(CW/var/tmp/vi.recover\fP vers
\f(CW/var/state/nvi\fP est permis pour supporter les versions de nvi
compiles sans le nom de chemin suggr dans la norme.

Les programmes ne doivent pas supposer que tout fichier ou rpertoire
est prserv entre deux appels du programme.
..
.\" XXX - Pourquoi le deuxime paragraphe a t mis en commentaire ?

.H 2 "/var/yp : fichiers de base de donnes NIS (Network Information Service)"
.P
Les donnes variables du Service d'Information Rseau (NIS ou Network
Information Service), qu'on appelait auparavant Pages Jaunes Sun (YP ou
Sun Yellow Pages), seront places dans ce rpertoire.

.HU "Raison d'tre :"
.br
.P
\f(CW/var/yp\fP est le rpertoire normal des donnes NIS (YP) et est
utilis presque exclusivement dans la documentation et les systmes NIS.

Il ne faut pas confondre NIS et Sun NIS+, qui utilise un rpertoire
diffrent, \f(CW/var/nis\fP.

.SK
.H 1 "Annexe spcifique aux systmes d'exploitation"
.P
Cette section contient des obligations et recommandations
supplmentaires qui ne s'appliquent qu' un systme d'exploitation
spcifique. Les principes de cette section ne devraient jamais entrer en
conflit avec la norme de base.

.H 2 "Linux"
.P
Voici l'annexe pour le systme d'exploitation Linux.

.H 3 "/ : rpertoire racine"
.sp
Sur les systmes Linux, si le noyau est situ dans \f(CW/\fP, nous
recommandons d'utiliser les noms \f(CWvmlinux\fP ou \f(CWvmlinuz\fP, qui
sont utiliss dans les paquets rcents de sources du noyau Linux.

.H 3 "/dev : fichiers de priphriques et fichiers spciaux"
.sp
Tous les fichiers de priphriques et fichiers spciaux de \f(CW/dev\fP
devraient se conformer au document \fILinux Allocated Devices\fP
(priphriques allous dans Linux), que l'on trouve dans les sources du
noyau Linux. Il est maintenu par H. Peter Anvin <hpa@zytor.com>.

Les liens symboliques de \f(CW/dev\fP ne devraient pas tre distribus
avec des systmes Linux sauf s'ils sont fournis dans le document
\fILinux Allocated Devices\fP.

.HU "Raison d'tre :"
.br
.P
L'obligation de ne pas faire de liens symboliques au hasard est donne
parce que la configuration locale diffre souvent de celle de la machine
de dveloppement du distributeur. De plus, si un script d'installation
de distribution configure les liens symboliques au moment de
l'installation, ces liens symboliques ne seront souvent pas mis  jour
si des changements locaux ont lieu sur le matriel. De manire
responsable et  un niveau local, cependant, on peut les utiliser  bon
escient.

.H 3 "/proc : systme de fichiers virtuel d'informations sur le noyau et les processus"
.sp
Le systme de fichiers proc devient la mthode standard de-facto sur
Linux pour manipuler les processus et les informations du systme,
plutt que par \f(CW/dev/kmem\fP et autres mthodes similaires. Nous
encourageons fortement ce principe pour le stockage et l'obtention
d'informations sur les processus ainsi que d'autres informations sur le
noyau et la mmoire.

.H 3 "/sbin : binaires systmes importants"
.sp
Les systmes Linux placent ces fichiers supplmentaires dans
\f(CW/sbin\fP :

.BL
.LI
commandes du systme de fichiers tendu deuxime version (ext2 --
optionnel) :
.VL 2
.LI "\f(CW{"
badblocks, dumpe2fs, e2fsck, mke2fs, mklost+found, tune2fs }\fP
.LE

.LI
installateur de carte du chargeur de dmarrage :
.VL 2
.LI "\f(CW{"
lilo }\fP
.LE

.HU "Fichiers optionnels de /sbin :"
.BL
.LI
binaires statiques :
.SP
.VL 2
.LI "\f(CW{"
ldconfig, sln, ssync }\fP
.LE
.P
Les binaires statiques \f(CWln\fP (\f(CWsln\fP) et \f(CWsync\fP
(\f(CWssync\fP) sont utiles quand quelque chose va mal. L'utilisation
principale de \f(CWsln\fP (pour rparer les liens symboliques incorrects
dans \f(CW/lib\fP aprs une mise  jour mal faite) n'est plus d'une
importance cruciale maintenant que le programme \f(CWldconfig\fP (situ
gnralement dans \f(CW/usr/sbin\fP) existe et peut agir comme guide
pendant la mise  jour des bibliothques. sync en statique est utile
dans certaines situations d'urgence. Notez qu'ils ne doivent pas
forcment tre des versions lies en statique des commandes normales
\f(CWln\fP et \f(CWsync\fP, mais elle peuvent l'tre.

Le binaire \f(CWldconfig\fP est optionnel dans \f(CW/sbin\fP puisqu'un
site peut choisir de lancer \f(CWldconfig\fP au dmarrage plutt qu' la
mise  jour des bibliothques partages. (Il n'est pas clair qu'il soit
avantageux de lancer \f(CWldconfig\fP  chaque dmarrage.) Mme ainsi,
certaines personnes aiment avoir \f(CWldconfig\fP  porte de clavier
pour les situations suivantes (toutes trop frquentes) :

.LB 8 4 " " 3
.LI
je viens d'enlever \f(CW/lib/<fichier>\fP ;
.LI
je ne peux pas trouver le nom de la bibliothque parce que \f(CWls\fP
est li en dynamique, j'utilise un shell qui n'a pas \f(CWls\fP intgr
et je ne sais pas utiliser "\f(CWecho *\fP"  la place ;
.LI
j'ai un \f(CWsln\fP en statique, mais je ne sais pas comment nommer le
lien.
.LE
.LI
divers :
.SP
.VL 2
.LI "\f(CW{"
ctrlaltdel, kbdrate }\fP
.LE
.P
Pour pallier au fait que certains claviers sont livrs avec une
frquence de rptition si grande qu'ils en sont inutilisables,
\f(CWkbdrate\fP peut tre install dans \f(CW/sbin\fP sur certains
systmes.
.\" devons-nous conseiller d'installer ceci ?

Puisque l'action par dfaut dans le noyau pour la combinaison de touches
Ctrl-Alt-Del est un redmarrage brutal instantan, il est recommandable
de dsactiver ce comportement avant de monter le systme de fichiers
racine en mode lecture/criture. Certaines versions d'\f(CWinit\fP sont
capables de dsactiver Ctrl-Alt-Del, mais d'autres ncessitent le
programme \f(CWctrlaltdel\fP qui peut tre install dans \f(CW/sbin\fP
sur ces systmes.

.LE

.H 3 "/usr/include : fichiers d'en-tte inclus par les programmes C"
.sp
Les liens symboliques suivants sont ncessaires si un compilateur C ou
C++ est install.

.nf
.ft CW
    /usr/include/asm -> /usr/src/linux/include/asm-<arch>
    /usr/include/linux -> /usr/src/linux/include/linux
.ft P
.fi

.H 3 "/usr/src : code source"
.sp
Le seul code source qui doit tre plac dans un endroit spcifique est
le code source du noyau Linux. Il est situ dans \f(CW/usr/src/linux\fP.

Si un compilateur C ou C++ est install, mais que le code source complet
du noyau Linux n'est pas install, les fichiers d'en-tte du code source
du noyau devront tre situs dans ces rpertoires :

.nf
.ft CW
    /usr/src/linux/include/asm-<arch>
    /usr/src/linux/include/linux
.ft P
.fi

\f(CW<arch>\fP est le nom de l'architecture du systme.

.ft I
Note : \f(CW/usr/src/linux\fP peut tre un lien symbolique vers
l'arborescence relle du code source du noyau.

.ft P

.HU "Raison d'tre :"
.br
.P
Il est important que les fichiers d'en-ttes du noyau soient situs dans
\f(CW/usr/src/linux\fP et non dans \f(CW/usr/include\fP pour qu'il n'y
ait pas de problemes quand les administrateurs systme mettent  jour la
version du noyau pour la premire fois.

.H 3 "/var/spool/cron : travaux cron et at"
.sp
.P
Ce rpertoire contient les donnes variables pour les programmes cron et
at.

.SK
.\" -------------------------------------------------------------------
.\" Partie finale
.\" -------------------------------------------------------------------
.nr Hu 3
.HU "La liste de diffusion \*(Fs"
.P
La liste de diffusion \*(Fs est situe  <fhs-discuss@ucsd.edu>. Pour
vous abonner  la liste envoyez un courrier  <listserv@ucsd.edu> avec
dans le corps du message "\f(CWADD fhs-discuss\fP".

Merci au service rseau de l'universit de Californie  San Diego qui
nous a autoriss  utiliser leur super serveur de listes de
distribution.

Comme il est indiqu dans l'introduction, veuillez ne pas envoyer de
courrier  la liste de diffusion sans d'abord contacter l'diteur de la
\*(Fs ou un contributeur list.

.HU "Remerciements"
.sp
.P
Les dveloppeurs de la \*(Fs souhaitent remercier les dveloppeurs,
administrateurs systme et utilisateurs dont l'avis a t essentiel 
cette norme. Nous souhaitons remercier chacun des contributeurs qui ont
aid  crire, compiler et composer cette norme.

Le groupe \*(Fs souhaite aussi remercier les dveloppeurs Linux qui ont
support la FSSTND, prdcesseur de cette norme. S'ils n'avaient pas
dmontr le bnfice apport par la FSSTND, la \*(Fs n'aurait jamais pu
voluer.

.HU "Contributeurs"
.P
.TS
l l.
Brandon S. Allbery	<bsa@kf8nh.wariat.org>
Keith Bostic	<bostic@cs.berkeley.edu>
Drew Eckhardt	<drew@colorado.edu>
Rik Faith	<faith@cs.unc.edu>
Stephen Harris	<sweh@spuddy.mew.co.uk>
Ian Jackson	<ijackson@cus.cam.ac.uk>
John A. Martin	<jmartin@acm.org>
Ian McCloghrie	<ian@ucsd.edu>
Chris Metcalf	<metcalf@lcs.mit.edu>
Ian Murdock	<imurdock@debian.org>
David C. Niemi	<niemidc@clark.net>
Daniel Quinlan	<quinlan@pathname.com>
Eric S. Raymond	<esr@thyrsus.com>
Mike Sangrey	<mike@sojurn.lns.pa.us>
David H. Silber	<dhs@glowworm.firefly.com>
Theodore Ts'o	<tytso@athena.mit.edu>
Stephen Tweedie	<sct@dcs.ed.ac.uk>
Fred N. van Kempen	<waltje@infomagic.com>

.HU "Traduction :"
.P

La traduction franaise a t ralise par Olivier Tharan,
<olive@minet.net>. Tous les commentaires sont accepts. La relecture a
t effectue le 16/01/2000.
.TE
.TC
.\" Local Variables:
.\" fill-column:72
.\" font-lock-maximum-size:0
.\" hilit-auto-highlight-maxout:100000
.\" End:
