/*  phone
 *  Copyright (C) 1999 P.J. Caulfield
 *
 *  PJC: Quite a lot of this code was generated by GLADE a GUI builder
 *       for GTK+
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <X11/Xlib.h>
#include <gtk/gtk.h>
#include <ctype.h>
#include <stdio.h>
#include "gtkphonesrc.h"
#include "gtkphonesig.h"
#include "phone.h"
#include "backend.h"
#include "phone_gtk.h"

#ifndef BINARY_PREFIX
#define BINARY_PREFIX="/usr/local"
#endif

GtkWidget *MainWindow;

int
gtk_phone_init(int argc, char *argv[])
{
/* When will people EVER LEARN!
   gtk just aborts if it can't open the display and it does so with a
   disgusting error message. We want it to fail gracefully as all good
   software should.
   Bah - Xt is just as bad. Bastards.
   Is it really so unreasonable to have a fallback terminal interface ?
   Is it? Really? Bastards!

   So we open an X Display and if that works we proceed with gtk and hope
   it can cope.
   If it can't then we return false and let phone proceed with the ncurses
   display.
*/
    Display *d = XOpenDisplay(0);
    if (!d) return 0;
    
    XCloseDisplay(d);
    gtk_set_locale ();
    gtk_init (&argc, &argv);

    add_pixmap_directory( BINARY_PREFIX "/X11/pixmaps/phone" );
    
    return 1;
}

gint
init_command(gpointer *cmd)
{
    do_command((char *)cmd);
    return FALSE;
}

int
gtk_phone_run(char *cmd)
{
  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  MainWindow = create_MainWindow ();
  gtkphone_backend_init();
  gtk_widget_show (MainWindow);

  if (cmd) gtk_idle_add((GtkFunction)init_command, cmd);
  
  gtk_main ();
  return 0;
}


void
on_Quit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    do_command("exit");
}


void
on_Dial_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    static int dialling = FALSE;
    GtkWidget *dial_dialog;

    if (dialling)
    {
	cancel_dial();
	dialling = FALSE;
	return;
    }
    else
    {
	GtkWidget *dial_dialog = create_DialDialog();
	gtk_window_set_transient_for(GTK_WINDOW(dial_dialog),
				     GTK_WINDOW(MainWindow));
	gtk_grab_add(dial_dialog);
	gtk_widget_show (dial_dialog);
	dialling = TRUE;
    }
}


void
on_Answer_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    do_command("answer");
}


void
on_Reject_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    do_command("reject");
}

void
on_Hangup_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    do_command("hangup");
}


void
on_Hold_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    static int held=0;
    
    if (held)
    {
	do_command("unhold");
    }
    else
    {
	do_command("hold");
    }
    held = !held;
}


void
on_Directory_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget *dir_dialog = create_DirDialog();
    gtk_window_set_transient_for(GTK_WINDOW(dir_dialog),
				 GTK_WINDOW(MainWindow));
    gtk_grab_add(dir_dialog);
    gtk_widget_show (dir_dialog);
}


void
on_Commands_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    do_command("help");
}


void
on_About_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget *about_dialog = create_AboutDialog();
    gtk_window_set_transient_for(GTK_WINDOW(about_dialog),
				 GTK_WINDOW(MainWindow));
    gtk_grab_add(about_dialog);
    gtk_widget_show (about_dialog);
}


void
on_Facsimile_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget *fac_dialog = create_FacsimileDialog();
    gtk_window_set_transient_for(GTK_WINDOW(fac_dialog),
				 GTK_WINDOW(MainWindow));
    gtk_grab_add(fac_dialog);
    gtk_widget_show (fac_dialog);
}


gboolean
on_LocalText_key_press_event           (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
    char key[2];

    key[0] = event->keyval;
    key[1] = '\0';
    
    /* Check for ^L */
    if (event->state == 4 && event->keyval == 'l')
	key[0] = 014;

    if (event->keyval == 65293) // CR
	key[0] = '\r';

    if (event->keyval == 65288) // Delete
	key[0] = 127;
    
    if (isprint(key[0]) ||
	key[0] == '\r' || key[0] == 014 || key[0] == 127)
    {
	write_typed_text(key);
    }
    return FALSE;
}

void
on_DialOK_activate                       (GtkMenuItem     *menuitem,
					  gpointer         user_data)
{
    gchar *nodename, *username;
    GtkWidget *node, *user;
    char cmd[256];

    user = get_widget(GTK_WIDGET(user_data),"entry2");
    node = get_widget(GTK_WIDGET(user_data),"combo4");

    nodename = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(node)->entry) );
    username = gtk_entry_get_text(GTK_ENTRY(user));

    sprintf(cmd, "dial %s::%s", nodename, username);

    gtk_object_destroy(GTK_OBJECT(user_data));
    do_command(cmd);
}

void
on_DirOK_activate                       (GtkMenuItem     *menuitem,
					  gpointer         user_data)
{
    gchar *nodename;
    GtkWidget *node;
    char cmd[256];

    node = get_widget(GTK_WIDGET(user_data),"combo4");

    nodename = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(node)->entry) );

    sprintf(cmd, "dir %s", nodename);

    gtk_object_destroy(GTK_OBJECT(user_data));
    do_command(cmd);
}

void
on_DialCancel_activate                       (GtkMenuItem     *menuitem,
					      gpointer         user_data)
{
    gtk_object_destroy(GTK_OBJECT(user_data));
}

void
on_FacsimileOK_activate                  (GtkMenuItem     *menuitem,
					  gpointer         user_data)
{
    gchar *file;
    char cmd[PATH_MAX+5];

    file = gtk_file_selection_get_filename (GTK_FILE_SELECTION (user_data));

    sprintf(cmd, "fac %s", file);

    gtk_object_destroy(GTK_OBJECT(user_data));
    do_command(cmd);
}

extern GtkWidget *Display_Widget;

void
on_DisplayOK_activate                       (GtkMenuItem     *menuitem,
					     gpointer         user_data)
{
    gtk_object_destroy(GTK_OBJECT(user_data));
    Display_Widget = NULL;
}
