#!/usr/bin/perl

package Debbugs::DMBT::GUI;

$VERSION="0.1.3";

@ISA = ('Gnome::App');

use Gnome;
use Gtk;
use Debbugs::DMBT;

sub new {
  my $proto = shift;
  my $class = ref($proto) || $proto;
  my ($statefile) = @_;

  my $self  = $class->SUPER::new( "DMBT", "DMBT: " . $statefile);
  
  # FIXME: workaround till I understand how to add user_data to menu item callback
  $thegui = $self;

  $self->{DMBT} = new Debbugs::DMBT ($statefile);

  # ScrolledWindow to hold the list
  my $scrolled = new Gtk::ScrolledWindow(undef, undef);
  $scrolled->set_policy('automatic', 'automatic');

  $self->set_contents ($scrolled);

  # The list itself
  $self->{LIST} = new Gtk::List;
  $self->{LIST}->set_selection_mode(-extended);

  $scrolled->add_with_viewport($self->{LIST});

  # The menus
  $self->create_menus(
		      {type => 'subtree',
		       label => '_File',
		       subtree => [
				   {type => 'item',
				    label => '_Open...',
				    pixmap_type => 'stock',
				    pixmap_info => 'Menu_Open',
				    callback => \&_load_file_interactive,
				    user_data => $self,
				   },
				   {type => 'item',
				    label => '_Save',
				    pixmap_type => 'stock',
				    pixmap_info => 'Menu_Save',
				    callback => sub {
				      my ($widget, $gui) = @_;
				      $gui = $thegui; # FIXME
				      if (defined $gui->{DMBT}->{STATEFILE}) {
					$self->{DMBT}->save_xml;
				      } else {
					_save_file_interactive ($widget, $gui);
				      }
				    },
				    user_data => $self,
				   },
				   {type => 'item',
				    label => 'Save _As...',
				    pixmap_type => 'stock',
				    pixmap_info => 'Menu_Save As',
				    callback => \&_save_file_interactive,
				    user_data => $self,
				   },
				   {type => 'item',
				    label => '_Close',
				    pixmap_type => 'stock',
				    pixmap_info => 'Menu_Quit',
				    callback => sub { Gtk->main_quit },
				   },
				  ]},
		      {type => 'subtree',
		       label => '_Import',
		       subtree => [
				   {type => 'item',
				    label => 'Bug by _Id',
				    callback => sub {
				      my $win = _create_entry("Bug ID", $thegui, 
							      \&_fetch_bugid);
				      show_all $win;
				    },
				   },
				   # 				      {type => 'item',
				   # 				       label => 'Bug by _Subject',
				   # 				       callback => sub {
				   # 					 my $win = _create_entry("Subject substring", $thegui, 
				   # 								 \&_fetch_bugsubject);
				   # 					 show_all $win;
				   # 				       },
				   # 				      },
				   {type => 'item',
				    label => '_Package',
				    callback => sub {
				      my ($widget, $gui) = @_;
				      my $win = _create_entry("Package", $thegui, 
							      \&_fetch_package);
				      show_all $win;
				    },
				   },
				   # 				      {type => 'item',
				   # 				       label => '_Maintainer',
				   # 				       callback => sub {
				   # 					 my $win = _create_entry("Package maintainer", $thegui, 
				   # 								 \&_fetch_maintainer);
				   # 					 show_all $win;
				   # 				       },
				   # 				      },
				  ]},
		      {type => 'subtree',
		       label => '_Help',
		       subtree => [
				   {type => 'item',
				    label => '_About...',
				    pixmap_type => 'stock',
				    pixmap_info => 'Menu_About',
				    callback => sub {
				      my $about = new Gnome::About "DMBT",
				      $VERSION, "(C) 2000 by Y. Dirson", ["Yann Dirson"], 
				      "The Debian Maintainer Bug Tool";
				      
				      show $about;
				    },
				   },
				  ]},
		     );

  bless ($self, $class);
  return $self;
}


sub _bug_item {
  my $bug = shift;
  return sprintf ("%6u	%20s	%s", 
		  $bug->{BTSATTRIBS}->{bugid},
		  $bug->{BTSATTRIBS}->{package},
		  $bug->{BTSATTRIBS}->{subject},
		  );
}

#
# Callbacks
#

sub _load_file_interactive {
  my ($widget, $gui) = @_;
  
  $gui = $thegui; # FIXME

  my $fs = new Gtk::FileSelection "Open file...";
  $fs->position(-mouse);
  $fs->set_filename ($gui->{DMBT}->{STATEFILE});
  $fs->signal_connect("destroy", \&_destroy_window, \$fs);
  $fs->signal_connect("delete_event", \&_destroy_window, \$fs);
  $fs->ok_button->signal_connect("clicked", \&_load_file_selectorcallback, [ $gui, $fs ]);
  $fs->cancel_button->signal_connect("clicked", sub { destroy $fs });

  show $fs;
}

sub _save_file_interactive {
  my ($widget, $gui) = @_;
  
  $gui = $thegui; # FIXME

  my $fs = new Gtk::FileSelection "Save file as...";
  $fs->position(-mouse);
  $fs->set_filename ($gui->{DMBT}->{STATEFILE});
  $fs->signal_connect("destroy", \&_destroy_window, \$fs);
  $fs->signal_connect("delete_event", \&_destroy_window, \$fs);
  $fs->ok_button->signal_connect("clicked", \&_save_file_selectorcallback, [ $gui, $fs ]);
  $fs->cancel_button->signal_connect("clicked", sub { destroy $fs });

  show $fs;
}

sub _load_file_selectorcallback {
  my ($widget, $data) = @_;
  my ($gui, $fs) = @{$data};

  $gui->{DMBT}->{STATEFILE} = $fs->get_filename;
  destroy $fs;

  $gui->{DMBT}->clear_bugs;
  $gui->{DMBT}->load_xml;
  _redraw_list ($gui);
}

sub _save_file_selectorcallback {
  my ($widget, $data) = @_;
  my ($gui, $fs) = @{$data};

  $gui->{DMBT}->{STATEFILE} = $fs->get_filename;
  destroy $fs;

  $gui->{DMBT}->save_xml;
}

sub _fetch_package {
  my ($widget, $data) = @_;
  my ($gui, $win, $entry) = @{$data};

  my $package = $entry->get_text;

  $gui->{DMBT}->import_package ($package);
  destroy $win;
  _redraw_list ($gui);
}

sub _fetch_bugid {
  my ($widget, $data) = @_;
  my ($gui, $win, $entry) = @{$data};

  my $bugid = $entry->get_text;

  $gui->{DMBT}->import_bug ($bugid);
  destroy $win;
  _redraw_list ($gui);
}

sub _destroy_window {
  my($widget, $windowref, $w2) = @_;
  $$windowref = undef;
  $w2 = undef if defined $w2;
  0;
}


#
# Non-callback functions
#

sub _create_entry {
  my ($title, $gui, $callback) = @_;
  my ($win, $button, $entry, $label);

  $win = new Gtk::Dialog;
  $win->signal_connect("destroy", \&_destroy_window, \$win);
  $win->signal_connect("delete_event", \&_destroy_window, \$win);
  $win->set_title($title);
#  $win->border_width(0);

  $thedialog = $win; # FIXME

  $label = new Gtk::Label;
  $label->set_text ($title . " to look for:");
  $win->vbox->pack_start($label, 1, 1, 0);

  $entry = new Gtk::Entry;
  $win->vbox->pack_start($entry, 1, 1, 0);
  
  $button = new Gtk::Button "Fetch";
  $button->signal_connect("clicked", $callback, [ $gui, $win, $entry ]);
  $theentry = $entry; # FIXME
  $button->can_default(1);
  $button->grab_default;
  $win->action_area->pack_start($button, 1, 1, 0);
  
  $button = new Gtk::Button "Cancel";
  $button->signal_connect("clicked", sub {destroy $win});
  $button->can_default(1);
  $win->action_area->pack_start($button, 1, 1, 0);
  
  return $win;
}

sub _redraw_list {
  my ($gui) = @_;

  $gui->{LIST}->clear_items (0, -1); # FIXME: not sure about -1 but it seems to work
  foreach my $bug ($gui->{DMBT}->bugs) {
    my $list_item = new Gtk::ListItem(_bug_item ($bug));
    $gui->{LIST}->add($list_item);
    $list_item->show;
  }
}

TRUE;
