/*
 *  dmachinemon / a distributed machine monitor by dancer.
 *  Copyright (C) 2001 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * node info : Checks node information on system, and gives back the 
 * system information to the file stream.
 *
 *$Id: dmachinemon-libnodeinfo.c,v 1.11 2002/03/14 11:32:15 dancer Exp $
 */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <pthread.h>
#include "dmachinemon/libsocket.h"
#include "dmachinemon/dmachinemon-libdatabase.h"
#include "dmachinemon/dmachinemon-commandlineparser.h"
#include "config.h"

static void
read_machineload(FILE*out, const dm_commandoption * cdat)
{
#ifdef HAVE_GETLOADAVG
  double lav[3];
  if (getloadavg(lav, 3) == -1)
    return;

  fprintf(out, "load1: %f\n", lav[1]);
  fprintf(out, "load2: %f\n", lav[2]);
  fprintf(out, "load3: %f\n", lav[3]);

  if (cdat->dieonload_flag && (cdat ->dieonload < lav[1] ))
    {
      /* load average is higher than limit. */
      fprintf (stderr, "DEBUG: This node is going to die, because load average [%f] is higher than limit [%f]\n",
	       lav[1], cdat->dieonload);
      exit (1);
    }  
#else
  /* it probably needs the LINUX way */
  FILE*in = fopen ("/proc/loadavg", "r");
  float lav1, lav2, lav3;  
  if(!in) return ;
  fscanf(in, "%f%f%f", &lav1, &lav2, &lav3);
  fprintf(out, "load1: %f\n", lav1);
  fprintf(out, "load2: %f\n", lav2);
  fprintf(out, "load3: %f\n", lav3);
  if (cdat->dieonload_flag && (cdat ->dieonload < lav1 ))
    {
      /* load average is higher than limit. */
      fprintf (stderr, "DEBUG: This node is going to die, because load average [%f] is higher than limit [%f]\n",
	       lav1, cdat->dieonload);
      exit (1);
    }  
  fclose(in);
#endif
}

static void
read_machinemem(FILE*out)
{
  FILE*in = fopen ("/proc/meminfo", "r");
  int total, used, free, shared, buffers, cached;  
  if(!in) return ;
  fscanf(in, "        total:    used:    free:  shared: buffers:  cached:\nMem:%i%i%i%i%i%i", &total, &used, &free, &shared, &buffers, &cached);
  fprintf(out, "memtotal: %i\n", total);
  fprintf(out, "memused: %i\n", used);
  fprintf(out, "memfree: %i\n", free);
  fprintf(out, "memshared: %i\n", shared);
  fprintf(out, "membuffers: %i\n", buffers);
  fprintf(out, "memcached: %i\n", cached);  
  fclose(in);
}

static void
read_topuser(FILE*out)
{
  /* this portion of code is Linux specific, using linux "ps", and fread. */
  /* FIXME: Linux specific */
  char* buf =NULL;  
  FILE*in = popen ("ps aux --no-headers | sort -k 3,3nr | head -1 | cut -b 64-
", "r");
  fscanf(in, "%as", &buf);
  fprintf(out, "topprocess: %s\n", buf);
  free(buf);  
  pclose(in);  
  in = popen ("ps aux --no-headers | sort -k 3,3nr | head -1 | cut -d' ' -f1", "r");
  fscanf(in, "%as", &buf);
  fprintf(out, "topuser: %s\n", buf);
  free(buf);  
  pclose(in);  
}


static void
write_currenttime(FILE*out)
{
  time_t t ;

  t=time(NULL);
  fprintf(out, "time: %li\n", (long)t);
}

/**
   Command to write out current system's status to uplink.
   This command is slightly obsolete, and it is most likely to be removed from
   future versions of libdmachinemon.

   @deprecated Please do not use this function from external programs. This function is rather unusable and has a very unstable interface. -- this function has been removed since version 0.6, soname 1.
   @version 0.6, soname 1 has different interface from older versions, it has an extra dm_commandoption parameter added. Incompatible with previous versions.
 */
void 
dm_nodeinfo_write_out (FILE* f, /// the file stream to the uplink. 
		       const dm_commandoption * cdat /// the command-line option parameters data
		       )
{
  char * c = dm_gethostname_versatile();
  if (!c)
    fprintf(stderr, "dmachinemon: gethostname_versatile failed, expect something fatal\n");
  fprintf(f, ":%s:\n", c);
  fprintf(f, "machine: %s\n", c);
  fprintf(f, SEEN_BY ": %s\n", c);
  read_machineload(f, cdat);
  read_machinemem(f);
  read_topuser(f);
  write_currenttime(f);
  free (c);
  fflush(f);
}

